:
##########################################################################
# Shellscript:	base.sh - ڸ ٸ  (Bourne Shell)
# Author     :	Heiner Steven (heiner.steven@odn.de)
# Date       :	07-03-95
# Category   :	Desktop
# $Id: base.sh,v 1.2 2000/02/06 19:55:35 heiner Exp $
##########################################################################
# Description
#
# Changes
# 21-03-95 stv	Է 0xb     ħ(0.2)
##########################################################################

# ==> ũƮ  Ͽ .
# ==>  ǥô   ڰ ּ  .

NOARGS=65
PN=`basename "$0"`			       # α׷ ̸
VER=`echo '$Revision: 1.2 $' | cut -d' ' -f2`  # ==> VER=1.2

Usage () {
    echo "$PN - ڸ ٸ  , $VER (stv '95)
: $PN [ ...]

ڸ ˷  ǥ Է¿ нϴ.
 ڷδ
    2 		0b  (, 0b1100)
    8 		0  (, 014)
    16 		0x  (, 0xc)
    10 		 (, 12)" >&2
    exit $NOARGS 
}   # ==>  ˷ ִ Լ.

Msg () {
    for i   # ==> in [list]   ֽϴ.
    do echo "$PN: $i" >&2
    done
}

Fatal () { Msg "$@"; exit 66; }

PrintBases () {
    #   .
    for i      # ==> in [list]   ־...
    do         # ==> ɾ () ؼ .
	case "$i" in
	    0b*)		ibase=2;;	# 2
	    0x*|[a-f]*|[A-F]*)	ibase=16;;	# 16
	    0*)			ibase=8;;	# 8
	    [1-9]*)		ibase=10;;	# 10
	    *)
		Msg " ($i) մϴ."
		continue;;
	esac

	# λ縦 ϰ, 16 빮ڷ ȯ(bc ʿ).
	number=`echo "$i" | sed -e 's:^0[bBxX]::' | tr '[a-f]' '[A-F]'`
	# ==> sed ڷ "/" ƴ ":" ׿.

	# ϴ 10 ȯ
	dec=`echo "ibase=$ibase; $number" | bc`  # ==> 'bc'   ƿƼ.
	case "$dec" in
	    [0-9]*)	;;			 # Ʊ.
	    *)		continue;;		 # ׿. մϴ.
	esac

	# ȯ ڵ  ٷ մϴ.
	# ==> 'here document'  ɾ  'bc' Է½ ݴϴ.
	echo `bc <<!
	    obase=16; "hex="; $dec
	    obase=10; "dec="; $dec
	    obase=8;  "oct="; $dec
	    obase=2;  "bin="; $dec
!
    ` | sed -e 's: :	:g'

    done
}

while [ $# -gt 0 ]
do
    case "$1" in
	--)	shift; break;;
	-h)	Usage;;                 # ==> .
	-*)	Usage;;
	*)	break;;			# ù° .
    esac   # ==> Է¿ ؼ  üũ  ϸ   ϰ    ̴ϴ.
    shift
done

if [ $# -gt 0 ]
then
    PrintBases "$@"
else					# ǥԷ¿ б.
    while read line
    do
	PrintBases $line
    done
fi
