/* Copyright (C) 2008 Xavier Pujol.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#ifndef VECT_H
#define VECT_H

#include "nr.h"

#define Vect vector

// Resizes a vector and fills it with zeros
template<class T>
void zeroVect(Vect<T>& v, unsigned int size) {
  v.resize(size);
  for (unsigned int i = 0; i < v.size(); i++) {
    v[i] = 0;
  }
}

// Prints a vector on stdout or stderr
template<class T>
ostream& operator<<(ostream& os, const Vect<T>& v) {
  os << "[";
  if (v.size() > 0) {
    os << v[0];
    for (unsigned int i = 1; i < v.size(); i++)
      os << " " << v[i];
  }
  os << "]";
  return os;
}

#endif
