/* Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.
Copyright (C) 2008 Xavier Pujol.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef MAIN_H
#define MAIN_H

#include <cstring>
#include "lexer.h"
#include "fplll.h"
#include "kfp.h"

enum zt_enum {ZMPZ, ZINT, ZDOUBLE};                 // Integers types
enum ft_enum {FDPE, FDOUBLE, FMPFR, FUNSPECIFIED};                // Floating-point types
enum m_enum {MPROVED, MHEURISTIC, MFASTEARLY,       // LLL methods
        MFAST, MWRAPPER, MHEUREARLY};
enum action_enum {ALLL, AHKZ, ABKZ, ASVP, ACVP};

struct Options {
  Options() : z(ZMPZ), f(FUNSPECIFIED), m(MWRAPPER), action(ALLL), r(0), c(0), pr(0),
          siegel(0), eta(0.51), delta(0.99), inputFile(NULL) {}

  zt_enum z;            // Integer type
  ft_enum f;            // Floating-point type
  m_enum m;             // Method
  action_enum action;
  int r, c, pr, siegel;
  double eta, delta;
  const char* inputFile;
};

template<class ZT> void lll(Options& o, ZZ_mat<ZT>& m, bool print = true);
template<class ZT> void hkz(Options& o, ZZ_mat<ZT>& m, bool print = true);
template<class ZT> void svp(Options& o, ZZ_mat<ZT>& m);
template<class ZT> void cvp(Options& o, ZZ_mat<ZT>& m, Vect< Z_NR<ZT> >& target);

void read_options(int argc, char** argv, Options& o);

#endif
