/* Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#ifndef FAST_H
#define FAST_H


template<class ZT, class FT>
class fast//:public LLLmethod<ZT,FT>
{
protected:
  int shift;
  int prec;
  int kappa;
  ZZ_mat<ZT>*G;
  ZZ_mat<ZT>*B;
  ZZ_mat<ZT>*U;
  FT**mu;
  FT**r;
  FT*s;
  FT**appB;
  int*expo;
  FT**appSP;
  
  double eta,delta;
  FT halfplus, onedotfive, ctt;

  virtual inline double GSO(int a, int zeros, int kappamax, int n,Z_NR<ZT>& ztmp,int aa,int rel);
  virtual inline int BabaiCall(int*alpha,int zeros,int kappamax,int var_k,Z_NR<ZT>&ztmp,int& newvec,int& newvecmax,int n);
 

public:
  virtual int Babai (int, int, int, int, 
	     Z_NR<ZT>&, int);
  int LLL ();
  fast(ZZ_mat<ZT>*B,int precision=0,double eta=0.51,double delta=0.99);

  ZZ_mat<ZT>* GetBase();
  virtual ~fast();
};

#include "fast.cpp"

#endif
