/* 
Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef DEFS_H
#define DEFS_H

#include <iostream>
#include <cstring>
#include <cstdio>
#include <limits>
#include <vector>
#include <algorithm>
#include <cstdlib>
#include <cmath>

#include <gmp.h>
#include <mpfr.h>
#include "dpe.h"

#define ABORT_MSG(y) {std::cerr << y << std::endl; exit(1);}
#define CHECK(x, y) if (!(x)) ABORT_MSG(y)
#define STD_CHECK(x, y) CHECK(x, "Error: " << y)
#define INTERNAL_CHECK(x, y) CHECK(x, "Internal error: " << y)

#ifdef VERBOSE
  #define INFO(x) std::cout << "INFO: " << x << std::endl
#else
  #define INFO(x)
#endif

#ifdef DEBUG
  #define BOUND_CHECK(x, y) CHECK(x, "Bound check error: " << y)
  #define TRACE(x) std::cout << "TRACE: " << x << std::endl
#else
  #define BOUND_CHECK(x, y)
  #define TRACE(x)
#endif

#endif
