##################################################
#
# author: graebe
# createdAt: 2006-03-03

# purpose: transform INTPS records to the new Data structure

my $SD_HOME = $ENV{'SD_HOME'};
die "Environment variable SD_HOME not set" unless $SD_HOME;
use lib "$ENV{'SD_HOME'}/Scripts/perl";

use XML::DOM;
use XML;
use strict;

my $parser=new XML::DOM::Parser;
my $xmldir="$SD_HOME/NewData/XMLResources/INTPS";
my $owldir="$SD_HOME/NewData/OWLResources/INTPSAnnotation";
my $idealdir="$SD_HOME/NewData/OWLResources/Ideal";

map action($_), @ARGV;

sub action {
  my $fn=shift;
# get the old XML item
  my $doc=$parser->parsefile($fn) or die;
# fix the id
  my $oldid=$doc->getDocumentElement->getAttribute("id");
  my $id=fixId($oldid);
  my $xmldoc=createXMLSource($doc,$fn,$id);
  my $owldoc=createOWLSource($doc,$fn,$id);
  my $idealdoc=createIdealSource($doc,$fn,$id);

# add ChangeLog entry 
  XML::addToChangeLog($idealdoc,"graebe","2006-03-03",
		      "compiled from XMLData $oldid") ;
  XML::addToChangeLog($xmldoc,"graebe","2006-03-03",
		      "compiled from XMLData $oldid") ;
  XML::addToChangeLog($owldoc,"graebe","2006-03-03",
		      "compiled from XMLData $oldid") ;
  XML::addToChangeLog($owldoc,"graebe","2006-03-03",
      "TODO:theDegreeList and theLengthsList have to be fixed") 
      if XML::getTagValue($doc,"parameters");

  return map XML::showDocument($_), ($xmldoc, $owldoc, $idealdoc);

  XML::saveOWLFile($xmldoc,$xmldir);
  XML::saveOWLFile($owldoc,$owldir);
  XML::saveOWLFile($idealdoc,$idealdir);

}

sub createXMLSource { # compile the XML resource
  my ($src,$fn,$id)=@_;
  my $doc=XML::getEmptyCopy($fn);
  my $root=$doc->getDocumentElement;
  $root->setAttribute("id",$id);

  my $hash;
  my $uhu=XML::getTagValue($src,"vars");
  $uhu.=" ".XML::getTagValue($src,"parameters");
  $hash->{"vars"}=fixVarList($uhu);
  $hash->{"basis"}=XML::getTagValue($src,"basis");
  $hash->{"ChangeLog"}=XML::getTagValue($src,"ChangeLog");

# build up the DOM 
  XML::appendNode($doc,"vars",$hash->{"vars"});
  XML::appendNode($doc,"basis",$hash->{"basis"});
  XML::appendNode($doc,"Comment",$hash->{"Comment"});
  XML::appendNode($doc,"ChangeLog",$hash->{"ChangeLog"});
  return $doc;
}

sub createOWLSource { # compile the OWL resource
  my ($src,$fn,$id)=@_;
  my $doc=XML::getEmptyCopy($fn);
  my $root=$doc->getDocumentElement;
  $root->setAttribute("id",$id);

  my $hash;
  $hash->{"theDegreeList"}=XML::getTagValue($src,"dlist");
  $hash->{"theLengthsList"}=XML::getTagValue($src,"llist");
  $hash->{"thePolynomialSystem"}=<<EOT;
<XML resource="sdxml:$id" XMLType="IntegerPolynomialSystem"/>
EOT

  map {
    XML::appendNode($doc,$_,$hash->{$_}) if $hash->{$_};
  } (sort keys %$hash);

  $hash->{"Comment"}=XML::getTagValue($src,"Comment");
  $hash->{"ChangeLog"}=XML::getTagValue($src,"ChangeLog");
  XML::appendNode($doc,"Comment",$hash->{"Comment"});
  XML::appendNode($doc,"ChangeLog",$hash->{"ChangeLog"});
  return $doc;
}

sub createIdealSource { # compile the Ideal resource
  my ($src,$fn,$id)=@_;
  my $doc=XML::getEmptyCopy($fn);
  my $root=$doc->getDocumentElement;
  $root->setAttribute("id",$id);

  my $hash;
  my $uhu;
  $uhu=XML::getTagValue($src,"isHomog");
  $hash->{"hasProperty"}="isHomogeneous" if $uhu==1;
  $hash->{"theDimension"}=XML::getTagValue($src,"dim");
  $hash->{"theDegree"}=XML::getTagValue($src,"degree");
  $hash->{"hasIsolatedPrimeDegrees"}=XML::getTagValue($src,"isoPrimeDegrees");
  $hash->{"hasIsolatedPrimeDimensions"}=XML::getTagValue($src,"isoPrimeDims");

  $hash->{"theBaseDomain"}="Z";
  $hash->{"theGenerators"}=<<EOT;
<OWL xref="$id" class="IntegerPolynomialSystem"/>
EOT
  $hash->{"theParameterList"}=
    fixVarList(XML::getTagValue($src,"parameters"));
  $hash->{"theVariableList"}=
    fixVarList(XML::getTagValue($src,"vars"));

  $hash->{"theDimension"}="Zero" if $hash->{"theDegree"}>0 
    and not defined $hash->{"theDimension"};

  map {
    XML::appendNode($doc,$_,$hash->{$_}) if $hash->{$_};
  } (sort keys %$hash);

  $hash->{"ChangeLog"}=XML::getTagValue($src,"ChangeLog");
  XML::appendNode($doc,"Comment",$hash->{"Comment"});
  XML::appendNode($doc,"ChangeLog",$hash->{"ChangeLog"});

  $root->setTagName("Ideal");
  return $doc;
}

sub fixId {
  local $_=shift;
  s.INTPS/..;
  s|/|.|g;
  s/PoSSo.Cyclic_9/Cyclic_9/;
  s/Robotic\./Robot-/;
  s/Curves.Graphs/Curves/;
  return $_;
}

sub fixVarList { # convert it to comma separated list
  local $_=shift;
  s/^\s+//g;
  s/\s+$//g;
  s/\s+/,/g;
  return $_;
}
