##################################################
#
# author: graebe
# createdAt: 2006-03-03

# purpose: transform PROBLEM records. 

my $SD_HOME = $ENV{'SD_HOME'};
die "Environment variable SD_HOME not set" unless $SD_HOME;
use lib "$ENV{'SD_HOME'}/Scripts/perl";

use XML::DOM;
use XML;
use strict;

my $parser=new XML::DOM::Parser;
my $dir="$SD_HOME/NewData/OWLResources";

map action($_), @ARGV;

sub action {
  my $fn=shift;
# get the old XML item
  my $doc=$parser->parsefile($fn) or die;

# fix the id
  my $oldid=$doc->getDocumentElement->getAttribute("id");
  my $id=fixId($oldid);
  my $new=createAnnotation($doc,$fn,$id);

  XML::addToChangeLog($new,"graebe","2006-03-04",
		      "compiled from XMLData $oldid") ;

  #return XML::showDocument($new);
  XML::saveOWLFile($new);

}

sub createAnnotation { 
  my ($src,$fn,$id)=@_;
  my $doc=getEmptyCopy($fn);
  my $root=$doc->getDocumentElement;
  $root->setAttribute("id",$id);
  $root->setTagName("Annotation");
  
  my $out;
  $out.=XML::getTagValue($src,"problem")."\n";
  my $u=XML::getTagValue($src,"code");
  $out.=<<EOT if $u;

It can be generated by the following code:
\\begin{verbatim}
$u
\\end{verbatim}
EOT
  my $u=XML::getTagValue($src,"keywords");
  $out.=<<EOT if $u;

\\begin{keywords}
$u
\\end{keywords}
EOT

  $u=$parser->parse(<<EOT);
<note>
A problem posed at International Mathematical Olympiad:

$out</note>
EOT
  $u=$u->getDocumentElement;
  $u->setOwnerDocument($doc);
  $root->appendChild($u);

  my $hash;
  $hash->{"Comment"}=XML::getTagValue($src,"Comment");
  $hash->{"ChangeLog"}=XML::getTagValue($src,"ChangeLog");
  XML::appendNode($doc,"Comment",$hash->{"Comment"});
  XML::appendNode($doc,"ChangeLog",$hash->{"ChangeLog"});

  return $doc;
}

sub fixId {
  local $_=shift;
  s.PROBLEMS/..;
  s./.\..g;
  return $_;
}

