/*	PiSynF.c - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-99 Grammar Engine, Inc.
	All rights reserved

	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - PROMICE/functions called from the parser
	global variables are initialized by the parser
*/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#ifndef UNIX
#include <io.h>
#include <conio.h>
#include <process.h>
#endif
#include <stdlib.h>

#include "piconfig.h"
#include "piscript.h"
#include "pistruct.h"
#include "pierror.h"
#include "pidriver.h"
#include "pidata.h"
#include "pihelp.h"
#include "pisyn.h"

void pcexit(void);
void pi_kbd(void);
extern void pifile(long map);
extern void (*psynf[])(void);
extern void piconfig(short cd);
extern void picline(void);
extern void pidohlp(void);
extern void pifixcfg(void);
extern void piinitf(void);
extern void piread(void);
extern void piwrite(void);
extern void pcdump(void);
extern void pcedit(void);
extern void pcfill(void);
extern void pcxfill(void);
extern void pcksum(void);
extern void pcxksum(void);
extern void pcinit(void);
extern void pcmove(void);
extern void pcsave(void);
extern void pcfind(void);
extern	void pcstring(void);
extern void pcrstt(short id, short time);
extern void pilod(void);
extern void piemu(void);
extern void firexit(short id);
extern	void fienb(short id);
extern void pi_put(char data);
extern long pi_get(char *dp);
extern void fishows(char sn);
extern void fishowc(void);
extern void pi_sleep(short time);
extern void pitraceit(void);
extern void pitrtest(long test);
extern void pitrread(long a, long b, long c);
extern void pitrwrite(long a, long b, long c, long d);
extern void pitrsave(char *str,long a, long b);
extern void pitrinit(long a);
extern void pixmdoit(void);
extern void pitrstatus(void);
extern void pixmtest(long test);
extern void pixmread(long a, long b, long c, long d);
extern void pixmwrite(long a, long b, long c, long d, long e);
extern void pixmsave(char *str, long a, long b, long c);
extern void pitrfind(long a, long b, long c);
static void geitest(void);
static void filler(short code);
static PICONFIG *pigetcfg(void);
static void piload(void);
static void pifname(void);
static void pifmore(PIFILE *cf);
static void firead(void);

long trrstart=0, trrstop=0;
extern long pxmaxt;

short pftype = PFHEX;
static PICONFIG *pftcfg;
extern char *liver;

/* `pcload` - down load user data files */

void pcload(void)
	{
	if ((!(pxflags&POCP)) && (piflags&PiFM)) /* if not comparing and do fill */
		pcfill();
	if (pxerror)
		return;
	for (pxcfile=0,pxdlc=0; pxcfile<pxnfile; pxcfile++)	/* load all files */
		{
		pifile(0);
		if (pxerror)
			{
			if (pxerror == PGE_OPN && pxnfile == 1 && piflags & PiiX)
				pxnfile = 0;							
			break;
			}
		}
	if (!pxerror)
		{
		pxcfg = pxpcfg;
		if ((!(pxflags&POCP)) && (piflags&PiEL))
			pcedit();		/* if not comparing and have an edit list */
		if (pxdisp&PXHI)
			{
			if (pxflags&POCP)
				printf("\nVerified");
			else
				printf("\nTransferred");
			printf(" %ld (0x%lx) data bytes",pxdlc,pxdlc);
			}
		if (!(pxflags&POCP) && piflags&PiCK)
			if (pxflags&POKR)
				pcxksum();
			else
				if (pxflags&POKC)
					pcksum();
		}
	}

/* `piailoc` - 1 - set ailoc address */

static void piailoc(void)
	{
	short i;
	char id=0;

	if (pxdisp&PXMH)
		printf(" >PiAiloc()");
	if (ps_id>=0)
	{
		id = (char)ps_id;
		pxflags |= POAI;
	}
	else
		pxflags &= ~POAI;

	if (ps_i<2)
		{
		pxerror = PGE_BAA;
		return;
		}
	pxailoc = ps_num[0];
	pxaiid = id;
	piflags |= PiAI;		/* so we know */
	pxaibr = ps_num[1];
	pxaiws = 0;
	pxaibrc = 0;
	switch(ps_num[1])
		{
		case 0:
			piflags |= PiXP;
			pxaibrc = 0xff;
			break;
		default:
			for (i=0; pxbauds[i]; i+=2)	/* look for baud rate */
				{
				if (pxaibr == pxbauds[i])
					{
					pxaibrc = pxbauds[i+1];
					break;
					}
				}	
			if (!pxaibrc)			/* did not find it */
				pxerror = PGE_BRT;
			piflags &= ~PiXP;
			break;
		}
	ps_i -= 2;
	if (ps_i)		/* if more arguments then its a break character */
		{
		ps_i--;
		if (ps_num[2] >= 0)
			{
			piflags |= PiBC;
			pxaibchr = (char)ps_num[2];
			}
		}
	else
		{
		piflags &= ~PiBC;
		pxaibchr = 0;
		}
	if (ps_i)		/* yet more is number of reset intterrupt to ignore */
		pxhints = (char)ps_num[3];
	else
		pxhints = (char)0xff;
	}

/* `pibrate` - 2 - set baud rate */

static void pibrate(void)
	{
	short i;
	
	if (pxdisp&PXMH)
		printf(" >PiBrate()");
	pxlink.brate = 0;
	for (i=0; pxbauds[i]; i+=2)
		{
		if (ps_num[0] == pxbauds[i])
			{
			pxlink.brate = ps_num[0];
			break;
			}
		}
	if (!pxlink.brate)
		pxerror = PGE_BRT;
	}

/* `picompare` - 3 - compare PROMICE data */

static void picompare(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiCompare()");
	if (piflags&PiMU && !(pxflags&PORQ))
		pxerror = PGE_EMU;
	else
		{
		pxflags |= POCP;		/* set the compare flag and do load */
		piload();
		pxflags &= ~POCP;		/* clear the flag now */
		}
	}

/* `pidump` - 4 - dump PROMICE contents */

static void pidump(void)
	{
	long tmp;

	if (pxdisp&PXMH)
		printf(" >PiDump()");
	
	if (piflags&PiCR)			/* if just CR typed then dump next range */
		{
		if (!(piflags&PiDF))
			{
			tmp = pxdend - pxdstart;
			pxdstart = pxdend + 1;
			pxdend = pxdstart + tmp;
			if (pxdend > pxmax)
				pxdend = pxmax;
			}
		}
	else	/* depending on the number the arguments vary */
		{
		if (ps_li--)
			{
			pxdstart = ps_numl[0];
			if (ps_li)
				{
				pxdend = ps_numl[1];
				if (pxdend < pxdstart)
					pxdend += pxdstart;
				}
			else
				{
				pxdend = pxdstart + PIC_DS;
				if (pxdend > pxmax)
					pxdend = pxmax;
				}
			}
		else
			{
			pxdstart = 0;
			pxdend = PIC_DS;
			}
		}
	if (piflags&PiMU && !(pxflags&PORQ))		/* hey! we are emulating */
		{
		pxerror = PGE_EMU;
		piflags |= PiDF;
		}
	else
		{
		if (pigetcfg())		/* set up the config to dump from */
			{
			pcdump();		/* dump - in PICORE */
			pxcfg = pftcfg;	/* restore config */
			pifixcfg();
			}
		}
	}

/* `piedit` - 5 - edit PROMICE or IMAGE contents */

static void piedit(void)
	{
	short i;

	if (ps_bchrc != ' ' && ps_bchrc != '\0')
		{
		pxerror = PGE_CMD;
		return;	
		}
	if (pxdisp&PXMH)
		printf(" >PiEdit()");
	if (ps_i)					/* if data already given */
		{
		pxestart = ps_num[0];
		for (i=0; i<ps_li; i++)
			pxelist[i] = ps_numl[i];
		pxelcnt = ps_li;
		}
	else
		{
		pxestart = 0;
		pxelcnt = 0;
		}
	if (piflags&(PiiX|PiII))	/* if in dialog mode or '.' in 'ini' */
		{
		if (piflags&PiMU && !(pxflags&PORQ))		/* emulating? */
			pxerror = PGE_EMU;
		else
			{
			if (pigetcfg())
				pcedit();		/* go to editor */
			pxcfg = pftcfg;
			pifixcfg();
			}
		}
	else
		piflags |= PiEL;		/* not interactive - edit after load */
	}

/*	`xmaskx` - 6 - set extended mask */

static void xmaskx(void)
	{
	long i;

	if (pxdisp&PXMH)
		printf(" >xMaskX()");

	if (!ps_i)
		ps_num[0] = 0xff;

	if (ps_id >= 0)
	{
		pxrom[ps_id].xmask = (char)ps_num[0];
		pxrom[ps_id].flags |= PRXM;
	}
	else
		for (i=0; i<PIC_NR; i++)
		{
			pxrom[i].xmask = (char)ps_num[0];
			pxrom[i].flags |= PRXM;
		}
	pxflags |= POXM;
	}

/* `pifill` - 7  - fill ROM space */

static void pifill(void)
	{
	PIROM *rp;

	if (pxdisp&PXMH)
		printf(" >PiFill()");

	if (ps_id >= 0)				/* if ID given */
		{
		if (ps_id >= PIC_NR)
			{
			pxerror = PGE_BIG;
			return;
			}
		rp = &pxrom[ps_id];
		switch (ps_li)			/* number or args determine their type */
			{
			case 0:
				break;
			case 1:
				rp->fdata = ps_numl[0];
				break;
			case 2:
				rp->fstart = ps_numl[0];
				rp->fend = ps_numl[1];
				break;
			case 3:
				rp->fstart = ps_numl[0];
				rp->fend = ps_numl[1];
				rp->fdata = ps_numl[2];
				break;
			case 4:
				rp->fstart = ps_numl[0];
				rp->fend = ps_numl[1];
				rp->fdata = ps_numl[2];
				rp->fsize = ps_numl[3];
				break;
			case 5:
				rp->fstart = ps_numl[0];
				rp->fend = ps_numl[1];
				rp->fdata = ps_numl[2];
				rp->fdata2 = ps_numl[3];
				rp->fsize = ps_numl[4];
				break;
			default:
				pxerror = PGE_NUM;
				break;
			}
		rp->flags |= PRFL;
		pxflags |= POFR;
		pxflags &= ~POFC;
		}
	else
		{
		if (pigetcfg())	/* setup config - sets pxmax */
			{
			pxfstart = pxcfg->start;
			pxfend = pxmax;
			pxfdata = 0xffffffff;
			pxfsize = pxcfg->words;
			pxcfg->flags |= PCFL;
			}
		else
			{
			pxerror = PGE_BAF;
			return;
			}
		switch (ps_li)			/* number or args determine their type */
			{
			case 0:
				pxfdata = pxrom[0].fdata;
				break;
			case 1:
				pxfdata = ps_numl[0];
				break;
			case 2:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				break;
			case 3:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				pxfdata = ps_numl[2];
				break;
			case 4:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				pxfdata = ps_numl[2];
				pxfsize = ps_numl[3];
				break;
			case 5:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				pxfdata = ps_numl[2];
				pxfdata2 = ps_numl[3];
				pxfsize = ps_numl[4];
				break;

			default:
				pxerror = PGE_NUM;
				break;
			}
		pxflags |= POFC;
		pxflags &= ~POFR;
		}
	pxflags &= ~POFA;
	if (!pxerror && piflags&(PiII|PiiX))
		{
		if (pigetcfg())
			{
			if (piflags&PiMU && !(pxflags&PORQ))		/* if not emulating */
				pxerror = PGE_EMU;
			else
				{
				pcfill();
				}
			pxcfg = pftcfg;	/* restore config */
			pifixcfg();
			}
		}
	else
		piflags |= PiFM;
	}

/* `pihighx` - 8  - high speed response */

static void pihigh(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiHigh()");
	pxlink.flags |= PLHI;
	pxlink.flags &= ~PLOW;
	if (piflags&(PiII|PiiX))
		{
		if (pxrom[0].ver[0] < '7')
			pxmode1 |= MO_FAST;
		else
			pxmode1 &= ~MO_SLOW;
		}
	piflags |= PiMO;
	}

/* `pihso` - 9 - set HSO polarity */

static void pihso(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiHso()");
	piflags |= PiHO;
	if (ps_i--)
		{
		pxhso = (char)ps_num[0];
		if (ps_i--)
			{
			piflags |= PiRQ;
			pxreq = (char)ps_num[1];
			if (ps_i)
				pxack = (char)ps_num[2];
			}
		}
	}

/* `pisearch` - 10 - find something */

static void pisearch(void)
	{
	long i;

	if (pxdisp&PXMH)
		printf(" >PiSearch()");
	
	if (piflags&PiMU)
		{
		pxerror = PGE_EMU;
		return;
		}
	if (pigetcfg())
		{
		pxlstart = pxcfg->start;
		pxlend = pxmax;

		if (ps_str)			/* searching for a string */
			{
			if (ps_i--)
				pxlstart = ps_num[0];
			if (ps_i)
				pxlend = ps_num[1];
			if ((pxlstart == 0) && (pxlend == 0))
				{
				pxlstart = pxcfg->start;
				pxlend = pxmax;
				}
			piflags |= PiSS;
			pxlstr = ps_str;
			if (pxlend < pxlstart)
				pxerror = PGE_BAA;
			else
				pcstring();
			}
		else				/* else binary search */
			{
			piflags &= ~PiSS;
			if (ps_i<3)
				pxerror = PGE_BAA;
			else
				{
				pxlstart = ps_num[0];
				pxlend = ps_num[1];
				pxlsize = ps_num[2];
				if ((pxlstart == 0) && (pxlend == 0))
					{
					pxlstart = pxcfg->start;
					pxlend = pxmax;
					}
				if ((pxlend < pxlstart) || (ps_li < pxlsize)
										|| (pxlsize > PIC_SS))
					pxerror = PGE_BAA;
				else
					{
					for (i=0; i<pxlsize; i++)
						pxldata[i] = (char)ps_numl[i];
					pcfind();
					}
				}
			}
		}
	pxcfg = pftcfg;
	pifixcfg();
	}

/* `pichksum` - 11 - compute checksum */

static void pichksum(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiChksum()");
	if (ps_i<3)
		{
		pxerror = PGE_BAA;
		return;
		}
	else
		if (ps_i>3)
			if(ps_num[3]<8 || ps_num[3]>32 || ps_num[3]%8)
				{
				pxerror = PGE_BAA;
				return;	
				}
	if (ps_id>=0)			/* one ROM */
		{
		if (ps_id >= PIC_NR)
			{
			pxerror = PGE_BIG;
			return;
			}
		pxrom[ps_id].kstart = ps_num[0];
		pxrom[ps_id].kend = ps_num[1];
		pxrom[ps_id].kstore = ps_num[2];
		if (ps_i>3)
			pxrom[ps_id].ksize = ps_num[3]/8;
		else
			pxrom[ps_id].ksize = 1;
		pxrom[ps_id].flags |= PRCK;
		switch (ps_char)
			{
			case 'a':
				pxrom[ps_id].flags |= PRKA;
				pxrom[ps_id].flags &= ~PRK1;
				break;
			case 'A':
				pxrom[ps_id].flags |= PRKA|PRK1;
				break;
			case 'X':
				pxrom[ps_id].flags &= ~PRKA;
				pxrom[ps_id].flags |= PRK1;
				break;
			default: /* 'x' */
				pxrom[ps_id].flags &= ~(PRKA|PRK1);
				break;
			}
		if (ps_i == 5)
			{
			if (ps_num[4])
				pxrom[ps_id].flags |= PRKO;
			else
				pxrom[ps_id].flags &= ~PRKO;
			}
		else
			pxrom[ps_id].flags &= ~PRKO;
		pxflags |= POKR;	/* checksum ROMs later */
		pxflags &= ~POKC;	/* no checksumming config */
		}
	else
		{
		pxkstart = ps_num[0];
		pxkend = ps_num[1];
		pxkstore = ps_num[2];
		if (ps_i>3)
			pxksize = ps_num[3]/8;
		else
			pxksize = 1;
		switch (ps_char)
			{
			case 'a':
				pxflags |= POKA;
				pxflags &= ~POK1;
				break;
			case 'A':
				pxflags |= POKA|POK1;
				break;
			case 'X':
				pxflags &= ~POKA;
				pxflags |= POK1;
				break;
			default:   /* 'x' */
				pxflags &= ~(POKA|POK1);
				break;
			}
		if (ps_i == 5)
			{
			if (ps_num[4])
				pxflags |= POKO;
			else
				pxflags &= ~POKO;
			}
		else
			pxflags &= ~POKO;
		pxflags |= POKC;	/* checksum config later */
		pxflags &= ~POKR;	/* no cheksum indvidual ROMs */
		}
	if (piflags&(PiiX|PiII))	/* right away */
		{
		if (pxflags&POKR)
			pcxksum();
		else
			{
			if (pigetcfg())
				{
				if (piflags&PiMU && !(pxflags&PORQ))
					pxerror = PGE_EMU;
				else
					pcksum();
				pxcfg = pftcfg;
				pifixcfg();
				}
			}
		}
	else
		piflags |= PiCK;
	}


/* `piload` - 12  - load PROMICE */

static void piload(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiLoad()");
	if (ps_str)					/* file name is given with command */
		{
		piflags |= PiII;
		pifname();				/* do file name processing */
		piflags &= ~PiII;
		}
	if (!pxerror)
		{
		if (piflags&(PiiX|PiII))
			{
			if (!pxprom)		/* if link is not up */
				{
				pcinit();		/* initilize the link */
				if (!pxerror)
					pilod();		/* put units in load mode */
				}
			if (!pxerror)
				{
				if (piflags&PiII)	/* from 'ini' file '.' command */
					pcload();
				else				/* from dialog mode */
					{
					if (piflags&PiMU && !(pxflags&PORQ))
						pxerror = PGE_EMU;
					else
						pcload();
					}
				}
			}
		else
			{
			pxflags |= POLO;		/* else load later */
			}
		}
	}

/* `pimove` - 13 - move image data around */

static void pimove(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiMove()");

	if (piflags&PiMU && !(pxflags&PORQ))
		pxerror = PGE_EMU;
	else
		{
		if (ps_i > 2)
			{
			if (pigetcfg())
				{
				pxmstart = ps_num[0];
				pxmend = ps_num[1];
				pxmdest = ps_num[2];
				pcmove();
				pxcfg = pftcfg;
				pifixcfg();
				}
			}
		else
			pxerror = PGE_BAA;
		}
	}

/* `pinumber` - 14  - set number of PROMICE units */

static void pinumber(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNumber()");
	if (ps_i)
		pxnpiu = (short)ps_num[0];
	}

/* `piouput` - 15  - set output serial port */

static void piouput(void)
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiOuput()");
#ifndef UNIX
	switch (ps_emb)
	{
	case 1:
		ps_str = "COM1";
		break;
	case 2:
		ps_str = "COM2";
		break;
	case 3:
		ps_str = "COM3";
		break;
	case 4:
		ps_str = "COM4";
		break;
	default:
		pxerror = PGE_BAA;
		return;
	}
#endif
	l = strlen(ps_str);	/* for others its device name */
	if (l < PIC_SN)
		strcpy(pxlink.name,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)			/* port address is also given */
		{
		pxlink.saddr = (int)ps_num[0];
		pxlink.flags |= PLSU;
		}
	pxlink.flags &= ~PLPQ;	/* definitely not pponly */
	if (piflags&PiNE)
		{
		piflags &= ~PiNE;
		pxlink.flags &= ~(PLPP|PLPB);
		}
	pxlink.flags |= PLSE;
	pxsflags |= SuHOST;
	}

/* `pistdpp` - 16  - set standard parallel port */

static void pistdpp(void)
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiStdpp()");
#ifndef UNIX
	switch (ps_emb)
	{
	case 1:
		ps_str = "LPT1";
		break;
	case 2:
		ps_str = "LPT2";
		break;
	case 3:
		ps_str = "LPT3";
		break;
	case 4:
		ps_str = "LPT4";
		break;
	default:
		pxerror = PGE_BAA;
		return;
	}
#endif
	l = strlen(ps_str);
	if (l < PIC_SN)
		strcpy(pxlink.pname,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)				/* port address given */
		{
		pxlink.paddr = (int)ps_num[0];
		pxlink.flags |= PLPU;
		}
	pxlink.flags |= PLPP;
	}

/* `pibidipp` - 17  - set bidirectional parallel port */

static void pibidipp(void)
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiBidipp()");
#ifndef UNIX
	switch (ps_emb)
	{
	case 1:
		ps_str = "LPT1";
		break;
	case 2:
		ps_str = "LPT2";
		break;
	case 3:
		ps_str = "LPT3";
		break;
	case 4:
		ps_str = "LPT4";
		break;
	default:
		pxerror = PGE_BAA;
		return;
	}
#endif
	l = strlen(ps_str);
	if (l < PIC_SN)
		strcpy(pxlink.pname,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)				/* port address */
		{
		pxlink.paddr = (int)ps_num[0];
		pxlink.flags |= PLPU;
		}
	pxlink.flags |= PLPQ;
	pxsflags |= SuHOST;
	}

/* `piromsize` - 18  - set emulation ROM size */

static void piromsize(void)
	{
	PICONFIG *tcfg;
	register short i;

	if (pxdisp&PXMH)
		printf(" >PiRomsize()");

	if (ps_1bchr == 'k' || ps_1bchr == 'K')
		ps_emb = ps_emb * 1024;
	if (ps_1bchr == 'm' || ps_1bchr == 'M')
		ps_emb = ps_emb * 1024 * 1024;

	for (i=0; pxromx[i]; i+=2)		/* look for a valid size */
		{
		if (ps_emb == pxromx[i])
			{
			ps_emb = pxromx[i+1];
			break;
			}
		}
	if (!pxromx[i])					/* none found */
		pxerror = PGE_ROM;
	else
		{
		if (ps_id >= 0)				/* only for one unit */
			{
			if (pxrom[ps_id].size && pxrom[ps_id].size < ps_emb)
				{
				pxerror = PGE_SIZ;
				return;
				}
			pxrom[ps_id].esize = ps_emb;
			if (!(piflags&PiSK))
				pxrom[ps_id].ssize = ps_emb;
			if (ps_emb == 524288)
				{
				pxflash[ps_id].fictl |= FIC_F040;
				pxflash[ps_id].fiman = (char)0x01;
				pxflash[ps_id].fidev = (char)0xA4;
				}
			else
				{
				pxflash[ps_id].fictl &= ~FIC_F040;
				pxflash[ps_id].fiman = (char)0x01;
				pxflash[ps_id].fidev = (char)0x20;
				}
			}
		else
			{
			for (i=0; i<PIC_NR; i++)	/* for all units */
				{
				if (pxrom[i].size && pxrom[i].size < ps_emb)
					{
					pxerror = PGE_SIZ;
					return;
					}
				pxrom[i].esize = ps_emb;
				if (!(piflags&PiSK))
					pxrom[i].ssize = ps_emb;
				if (ps_emb == 524288)
					{
					pxflash[i].fictl |= FIC_F040;
					pxflash[i].fiman = (char)0x01;
					pxflash[i].fidev = (char)0xA4;
					}
				else
					{
					pxflash[i].fictl &= ~FIC_F040;
					pxflash[i].fiman = (char)0x01;
					pxflash[i].fidev = (char)0x20;
					}
				}
			}
		}
	if (pxcfg)		/* if a current config */
		pifixcfg();	/* fix up config parameters */
	tcfg = pxcfg;
	for (i=0; i<(short)pxnfile; i++)	/* also if any file configs */
		{
		pxcfg = pxfile[i].pfcfg;
		if (pxcfg)
			pifixcfg();
		}
	pxcfg = tcfg;
	pxsflags |= SuROM;
	}

/* `pistop` - 19 - stop emulation */

static void pistop(void)
	{
	static short once=0;

	if (pxdisp&PXMH)
		printf(" >PiStop()");
	pilod();
	if (!pxerror)
		{
		if (pxdisp&PXHI)
			printf("\nNow in Load Mode!");
		if (!once)			/* tell user first time only */
			{
			once = 1;
			printf("\nUse 'go' later to emulate");
			}
		}
	}

/* `pitest` - 20  - test unit */

static void pitest(void)
	{
	short id=0,ct=1,cct=1,ccct=1;
	long ad;

	if (pxdisp&PXMH)
		printf(" >PiTest()");
	
	if (piflags&PiMU)	/* not if emulating */
		{
		pxerror = PGE_EMU;
		return;
		}
	if (!ps_str)
		{
		if (ps_id >= 0)		/* unit ID given */
			{
			id = ps_id;
			if (ps_i)		/* pass count also */
				ct = (short)ps_num[0];
			}
		else
			{
			if (ps_i--)		/* no : but a number is an ID */
				{
				id = (short)ps_num[0];
				if (ps_i)	/* and may be a passcout too */
					ct = (short)ps_num[1];
				}
			}
		if (id >= pxnrom)
			{
			pxerror = PGE_BIG;
			return;
			}
		piflags |= PiNT;		/* don't timeout */
		printf("\nTesting unit %d - %d passes",id, ct);
		picmd((char)id,PI_TS,1,(char)ct,0,0,0,0);
		piflags &= ~PiNT;
		if (pxrsp[PICT] != 1)
			{
			ad = ~pxrom[id].amask & 
				(((long)(pxrsp[PIDT]&0xFF)<<16)|((long)(pxrsp[PIDT+1]&0xFF)<<8)
												|((long)(pxrsp[PIDT+2]&0xFF)));
			printf("\n Unit %d failed test @loc %lX",id,ad);
			}
		else
			printf("\n Unit %d passes test",id);
		}
	else
		{
		if (ps_i)
			cct = (short)ps_num[0];
		printf("\nTesting Current Configuration with non-repeating pattern");
		while (cct--)
			{
			geitest();
			printf("\n Test complete - pass %d",ccct++);
			}
		}
	}

/* `geitest` - test the PROMICE via GEItester */

static void geitest(void)
	{
	pilod();
	if (!pxerror)
		{
		printf("\nDown loading pattern:");
		filler(0);
		}
	if (pxerror)
		return;

	if (!pxerror)
		{
		printf("\nUploading & checking:");
		filler(1);
		}
	}

static void filler(short code)
	{
	unsigned long spat = 0x51237D1F;
	unsigned long pinc = 0xBAD1FEED;
	long tct = pxmax + 1;
	unsigned long tvalue;
	long *pats;
	long i;

	if (code)
		{
		pxyloc = 0;
		while (tct && !pxerror)
			{
			pxybc = PIC_BS;
			piread();
			if (pxerror)
				break;
			pats = (long *)&pxybf[0];
			for (i=0; i<PIC_BS; i+=4)
				{
				tvalue = *pats++;
				if (tvalue != spat)
					{
					printf("\nError @ %06lX Got-%08lX Want-%08lX XOR-%08lX",
						pxyloc+i,tvalue,spat,tvalue^spat);
					}
				spat += pinc;
				}
			pxyloc += PIC_BS;
			tct -= PIC_BS;
			pi_kbd();
			}
		return;
		}

	pxxloc = 0;
	while(tct && !pxerror)
		{
		pats = (long *)&pxxbf[0];
		for (i=0; i<PIC_BS; i+=4)
			{
			*pats++ = spat;
			spat += pinc;
			}
		pxxbc = PIC_BS;
		piwrite();
		pxxloc += PIC_BS;
		tct -= PIC_BS;
		}
	}

/* `piserial` - 21 - return serial# */

static void piserial(void)
	{
	short id;

	if (pxdisp&PXMH)
		printf(" >PiSerial()");
	if (ps_id >= 0)
		id = ps_id;
	else
		{
		if (ps_i)
			id = (short)ps_num[0];
		else
			id = 0;
		}
	if (id >= pxprom)
		pxerror = PGE_BIG;
	else					/* modified version command */
		{
		picmd((char)id,PI_VS| CM_SERN,1,0,0,0,0,0);		
		printf("\nserial#=%02X%02X%02X%02X",
		 pxrsp[PIDT]&0x0FF,pxrsp[PIDT+1]&0x0FF,
		 pxrsp[PIDT+2]&0x0FF,pxrsp[PIDT+3]&0x0FF);
		}
	}

/* `piverify` - 22 - set verify option */

static void piverify(void)
	{
	short f=0;

	if (pxdisp&PXMH)
		printf(" >PiVerify()");
	if (ps_i)
		f = (short)ps_num[0];
	if (f)
		pxflags |= POVF;
	else
		pxflags &= ~POVF;
	if (piflags&PiiX && pxflags&PXHI)
		{
		if (pxflags&POVF)
			printf("\n Verifying down-load data");
		else
			printf("\n Not verifying down-load data");
		}
	}

/* `piword` - 23 - set word size */

static void piword(void)
	{
	PICONFIG *cx,*cy;
	short u,w,b,n;

	if (pxdisp&PXMH)
		printf(" >PiWord()");
	if (!ps_i)			/* if no args then 8-bit */
		ps_num[0] = 8;
	if (!(ps_num[0]%8))	/* better be multiple of 8 */
		{
		w = (short)ps_num[0]/8;	/* word size in bytes */
		if (ps_li)				/* if ID list given */
			{
			if (ps_li%w)		/* better be right number of units */
				pxerror = PGE_IDL;
			}
		else					/* no ID list given */
			{
			n = pxnrom;
			if ((!n) || (!pxprom))	/* link is not up so assume unit count */
				{
				n = w;
				pxnrom = w;
				piflags |= PiNL;
				}
			else
				{
				if (n<w)			/* else enough ROMs to do the word? */
					{
					pxerror = PGE_BCF;
					return;
					}
				}
			for (b=0; b<(n/w); b++) /* no ID list so make it up */
				{
				for (u=w*b; u<(w*(b+1)); u++)
					ps_numl[u] = u;
				}
			ps_li = n;
			}
		if (piflags&(PiII|PiiX))
			{
			for (b=0; b<ps_li; b++)
				if (ps_numl[b] >= pxnrom)
					pxerror = PGE_BIG;
			}
		if (!pxerror)		/* if no errors then build config */
			{
			b = ps_li/w;	/* number of banks */
			cx = pxpcfg;
			cy = (PICONFIG *)0;
			if (cx)	/* free any previous configs */
				{
				while (cx->next)
					cx = cx->next;
				cx->next = pxfcfg;
				pxfcfg = pxpcfg;
				pxpcfg = (PICONFIG *)0;
				}
			for (u=0; u<b; u++)
				{
				cx = pxfcfg;	/* get a free config structure */
				if (!pxpcfg)	/* if no physical config set */
					{
					pxpcfg = cx;
					pxcfg = cx;
					}
				if (cx)			/* got one */
					{
					pxfcfg = cx->next;	/* remove from freeList */
					cx->next = (PICONFIG *)0;
					cx->words = w;		/* set word size */
					for (n=0; n<w; n++)	/* and ID list */
						cx->uid[n] = (short)ps_numl[w*u+n];
					if (cy)				/* if chaining banks */
						cy->next = cx;
					cy = cx;
					}
				else			/* no config structures left?!! */
					{
					pxerror = PGE_CFG;
					break;
					}
				}
			pifixcfg();	/* fix all config parameters */
			}
		if (piflags&PiiX && pxdisp&PXHI)
			printf("\n Done");
		}
	else
		pxerror = PGE_WDS;
	}

/* `pinocksm` - 24 - no-check checksum */

static void pinocksm(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNoCksm()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags |= PODK;
		else
			pxflags &= ~PODK;
		}
	pxflags |= PONK;
	}

/* `delay` - 25 - set delay time out */

static void pidelay(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiDelay()");

	pxnotot = 0;
	if (ps_i)
		{
		if (ps_num[0])
			pxdelay = ps_num[0];
		else
			pxnotot = 1;
		}
	else
		{
		pxdelay = 1;
		}
	}

/* `pinoadder` - 26 - set to ignore address errors */

static void pinoaddr(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNoaddr()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags |= PODO;
		else
			pxflags &= ~PODO;
		}
	pxflags |= PONO;
	if (piflags&PiiX && pxdisp&PXHI)
		printf("\n No address error is SET");
	}

/* `piaisw` - 27 - LoadICE is talking through the AISwitch */

static void piaisw(void)
	{
	extern char *pxaicstr;

	if (pxdisp&PXMH)
		printf(" >PiAisw()");

	if ((!ps_i) || (ps_num[0] < 0))
		{
		pxerror = PGE_BAA;
		return;
		}
	if (ps_num[0] > PIC_NR)
		pxerror = PGE_BIG;
	else					/* store Switch port# in connect string */
		{
		*(pxaicstr+9) = (char)((char)(ps_num[0]/100)+'0');
		*(pxaicstr+10) = (char)((char)((char)((ps_num[0]%100)/10)+'0'));
		*(pxaicstr+11) = (char)((char)((char)((ps_num[0]%100)%10)+'0'));
		}
	piflags |= PiSW|PiPH;	/* remember the Switch */
	}

/* `piaitty` - 28 - operate transparent tty mode - does not work */

static void piaitty(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAITTY()");

	if (pxrom[pxaiid].res&TRACE)
		{

		picmd(pxaiid,TR_RX|CM_NORSP,2,MG_CONTROL,MGD_AI,0,0,0);
		picmd(pxaiid,TR_RX|CM_NORSP,2,A2_CONTROL,AIC_AISON|AIC_AIROC,0,0,0);
		pxflags |= POTY;
		if (!pxatrace)
			{
			picmd(pxaiid,PI_MO|CM_NORSP,2,(char)(pxmode1|MO_MORE),(char)(pxmode2|MO_MORE),0,0,0);
			pcexit();
			pxatrace++;
			}
		else
			picmd((char)pxaiid,PI_RS | CM_NORSP,1,0,0,0,0,0);

		if (pxlink.flags&(PLPP|PLPB))
			{
			pxlink.flags &= ~(PLPP|PLPB);
			pxlink.flags |= PLPQ;
			piflags &= ~PiSO;
			pxppflag++;
			}
		if (piflags&PiiX && pxdisp&PXHI)
			printf("\n Transparant mode set");
		}

	}
	
/* `pidiscfg` - 29 - display configuration */

static void pidiscfg(void)
	{
	short cd;
	
	if (pxdisp&PXMH)
		printf(" >PiDisCfg()");
	if (ps_str == NULL)
		ps_str = "a";
	switch (*ps_str)
		{
		case 'a':
			cd = PcALL;
			break;
		case 'l':
			cd = PcLNK;
			break;
		case 'f':
			cd = PcFLE;
			break;
		case 'r':
			cd = PcROM;
			break;
		case 'p':
			cd = PcPCF;
			break;
		case 'c':
			cd = PcCFG;
			break;
		case 'm':
			cd = PcMAP;
			break;
		default:
			printf("Unknown config type - doing all");
			cd = PcALL;
		}
	piconfig(cd);
	}

/* `pidisply` - 30 - change display level */

static void pidisply(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiDisply()");
	if (ps_i)
		pxdisp = (short)ps_num[0];
	else
		pxdisp = 0xC0;
	if (piflags&PiiX && pxdisp&PXHI)
		printf("\n New display mode set");
	}

/* `pisystem` - 31 - escape command to system */

static void pisystem(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiSystem()");
	(void)system(ps_str);
	}

/* `pifname` - 32 - specifies file name - do whole buch of stuff */

static void pifname(void)
	{
	PICONFIG *cx;
	PIFILE *cf;
	int ref,l;
	char htype=0;
	
	if (pxdisp&PXMH)
		printf(" >PiFname()");
	if (!ps_str)
		{
		pxerror = PGE_BAA;
		return;
		}
	if (pftype != PFBIN)
		{
#ifndef UNIX
		if ((ref = open(ps_str,O_RDONLY | O_BINARY)) >= 0)
#else
		if ((ref = open(ps_str,O_RDONLY)) >= 0)
#endif
			{
			(void)read(ref,&htype,1);
			(void)close(ref);
			pftype = PFHEX;
			switch (htype)
				{
				case ':':		/* intel hex */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nIntel Hex file");
					break;
				case 's':		/* motorola hex */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nMotorola S record Hex file");
					break;
				case 'S':
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nMotorola S record Hex file");
					break;
				case '$':		/* motorola hex comment record */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nMotorola S record Hex file");
					break;
				case '/':		/* standard tektronix hex */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nTextronics Standard Hex file");
					break;
				case '%':		/* extended tektronics hex */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nTektronix Extended Hex file");
					break;
				case '_':		/* funky DSP format */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nDSP Hex file");
					break;
				case ';':		/* defunct mostek format */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nMostek Hex file");
					break;
				case '?':		/* possible archaic rca format */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nRCA Paper Tape Hex file");
					break;
				case '!':
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nRCA Paper Tape Hex file");
					break;
				default:		/* must be bin */
					if (piflags&PiiX && pxdisp&PXHI)
						printf("\nNot a HEX file: Assuming Binary image file");
					pftype = PFBIN;
					break;
				}
			}
		else
			htype = 'h';			/* generic */
		}
	if (piflags&PiII)		/* 'ini' '.' command */
		pxnfile = 0;
	pxcfile = pxnfile;
	piinitf();				/* clear out file structure */
	cf = &pxfile[pxnfile];	/* start filling in stuff */
	cf->type = pftype;
	cf->htype = htype;
	l = strlen(ps_str);
	if (l < PIC_FN)			/* if name not too long */
		{
		strcpy(cf->name,ps_str);
		if (pftype == PFBIN)
			{
			if (ps_i)
				{
				ps_i--;
				cf->skip = ps_num[0];
				}
			if (ps_i)
				cf->offset = ps_num[1];
			}
		else
			{
			if (ps_i)
				{
				ps_i--;
				cf->offset = ps_num[0];
				if (ps_i)
					cf->offset = ps_num[1] - ps_num[0];
				}
			else
				{
				if (pxfoff)
					cf->offset = -pxfoff;
				}
			}
		cx = cf->pfcfg;
		if (cx && (cx != pxpcfg))	/* free any previous file configs */
			{
			while (cx->next)
				cx = cx->next;
			cx->next = pxfcfg;
			pxfcfg = cf->pfcfg;
			}
		cf->pfcfg = (PICONFIG *)0;
		pifmore(cf);				/* split for stupid optimizer */
		}
	else
		pxerror = PGE_NTL;
	}
static void pifmore(PIFILE *cf)
	{
	PICONFIG *cx,*cy=0;
	short u,w,b,n;

	if (ps_li)	/* if we have a config */
		{
		ps_li--;
		if (ps_numl[0]%8)
			{
			pxerror = PGE_IDL;
			return;	
			}
		w = (short)ps_numl[0]/8;	/* word size */
		if (ps_li && !(ps_li%w) && (ps_li <= PIC_NR))
			{
			b = ps_li/w;	/* number of banks */
			if (b<=0)
				b = 1;
			for (u=0; u<b; u++)
				{
				cx = pxfcfg;
				if (!cf->pfcfg)
					cf->pfcfg = cx;
				if (cx)
					{
					pxfcfg = cx->next;
					cx->next = (PICONFIG *)0;
					cx->words = w;
					for (n=0; n<w; n++)
						if (ps_li)
							cx->uid[n] = (short)ps_numl[u*w+n+1];
						else
							cx->uid[n] = ps_id++;
					if (cy)
						cy->next = cx;
					cy = cx;
					}
				else
					{
					pxerror = PGE_CFG;
					break;
					}
				}
			}
		else
			pxerror = PGE_IDL;
		ps_li++;
		}
	else	/* no config given */
		{
		if (ps_id >= 0)
			{
			cx = pxpcfg;	/* check if existing one would work */
			while (cx)		/* feature disabled */
				{
				if (cx->uid[0] == ps_id)
					{
					cf->pfcfg = cx;
					break;
					}
				cx = cx->next;
				}
			if (!cx)	/* if none found make a 8-bit config */
				{
				cx = pxfcfg;
				cf->pfcfg = cx;
				if (cx)
					{
					pxfcfg = cx->next;
					cx->next = 0;
					cx->words = 1;
					cx->uid[0] = ps_id;
					}
				}
			}
		}
		
	if (ps_sli && !pxerror)	/* partial transfer addresses */
		{
		if (!(ps_sli%2))
			{
			cf->saddr = ps_numl[ps_li++]; /* + cf->offset; */
			cf->eaddr = ps_numl[ps_li]; /* + cf->offset; */
			cf->flags |= PFPL;
			if (cf->saddr > cf->eaddr)
				pxerror = PGE_BAA;
			}
		else
			pxerror = PGE_INP;
		}
	if (!pxerror && pxprom)		/* if link is up then update config data */
		{
		if (cf->pfcfg)
			{
			pxcfg = cf->pfcfg;
			pifixcfg();
			}
		}
	if (!pxerror)
		pxnfile++;
	if (pxprom)
		{
		pxcfg = pxpcfg;
		pifixcfg();
		}
	}

/* `pigo` - 33 - unitinandoutofemulation */

static void pigo(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiGo()");
	piemu();
	if (!pxerror)
		if (pxdisp&PXHI)
			printf("\nNow Emulating!");
	}

/* `pihelp` - 34 - display help file */

static void pihelp(void)
	{
	char *is,*ts,*t,**hs;
	PIHELP *h;
	
	is = ps_str;
	if (is == NULL)
		is = "?";
	while (*is == ' ' || *is == '\t')
		is++;
	h = pxhelp;
	while (h->topic)
		{
		t = h->topic;
		ts = is;
		while (*ts)
			{
			if (*ts++ == *t++)
				continue;
			else
				{
				h++;
				--ts;
				break;
				}
			}
		if (!*ts)
			break;
		}
	if (h->topic)
		{
		hs = h->help;
		while (*hs)
			{
			printf("\n%s",*hs);
			hs++;
			}
		}
	else
		printf("\nNo help available on topic '%s'",is);
	}

/* `piimage` - 35  - binary file specification */

static void piimage(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiImage()");
	pftype = PFBIN;
	pifname();
	pftype = PFHEX;
	}

/* `pisocket` - 36  - set rom socket size */

static void pisocket(void)
	{
	register short i;

	if (pxdisp&PXMH)
		printf(" >PiSocket()");

	for (i=0; pxromx[i]; i+=2)		/* look for a valid size */
		{
		if (ps_emb == pxromx[i])
			{
			ps_emb = pxromx[i+1];
			break;
			}
		}
	if (!pxromx[i])					/* none found */
		pxerror = PGE_ROM;
	else
		{
		if (ps_id >= 0)				/* only for one unit */
			{
			pxrom[ps_id].ssize = ps_emb;
			}
		else
			{
			for (i=0; i<PIC_NR; i++)	/* for all units */
				{
				pxrom[i].ssize = ps_emb;
				}
			}
		piflags |= PiSK;
		}
	if (piflags&PiiX && pxdisp&PXHI)
		printf("\n Socket size set");
	}

/* `pifkeys` - 37 - assign function keys */

static void pifkeys(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiFkeys()");
	if (!ps_i)
		pxerror = PGE_BAA;
	else
		{
		if (ps_str == NULL)
			pxerror = PGE_BAA;
		else
			{
			ps_num[0]--;
			pxkeys[ps_num[0]] = (char *)calloc(strlen(ps_str)+1,1);
			if (pxkeys[ps_num[0]])
				strcpy(pxkeys[ps_num[0]],ps_str);
			if (piflags&PiiX && pxdisp&PXHI)
				printf("\n Key assigned");
			}
		}
	}
			
/* `piiload` - 38  - load binary file */

static void piiload(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiiLoad()");
	if (piflags&PiMU && !(pxflags&PORQ))
		{
		pxerror = PGE_EMU;
		return;
		}
	if (ps_str)
		{
		piflags |= PiII;
		pftype = PFBIN;
		pifname();
		pftype = PFHEX;
		piflags &= ~PiII;
		}
	if (!pxerror)
		{
		if (!pxprom)
			pcinit();
		if (!pxerror)
			pcload();
		}
	}

/* `piulock` - 39 - set flag for locked units (only when talking directly) */

static void piulock(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiUlock()");
	piflags |= PiPH;
	}

/* `pinofil` - 40 - don't do filling */

static void pinofil(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNofil()");
	piflags &= ~PiFM;
	}

/* `pimemap` - 41 - change memory map display */

static void pimemap(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiMeMap()");
	if (ps_i)
		{
		if (ps_num[0])
			{
			pxflags |= POMP;
			if (piflags&PiiX && pxdisp&PXHI)
				printf("\n Data map is ON");
			}
		}
	else
		{
		pxflags &= ~POMP;
		if (piflags&PiiX && pxdisp&PXHI)
			printf("\n Data map is OFF");
		}
	}

/* `pirecover` - 42 - restart the link */

static void pirecover(void)
	{
	long i;

	if (pxdisp&PXMH)
		printf(" >PiRecover()");

	pxprom = 0;
	pxatrace = 0;
	piflags &= ~PiUP;
	if (pxppflag)
	{
		pxlink.flags &= ~PLPQ;
		pxlink.flags |= PLPP|PLPB;
		for (i=0; i<PIC_NR; i++)
			pxrom[i].flags &= ~PRPP;
	}
	if (pxflags&POTY)
		pxflags &= ~POTY;
	else
		pcexit();
	pcinit();
	pxppflag = 0;
	}
	
/* `pireset` - 43 - reset the target */

static void pireset(void)
	{
	char id, dt;

	if (pxdisp&PXMH)
		printf(" >PiReset()");
	if (ps_i)			/* time period specified */
		{
		dt = (char)ps_num[0]/9;
		}
	else
		{
		dt = pxrtime;
		}
	id = (ps_id <0) ? 0 : ps_id;
	if (piflags&(PiiX|PiII))
		pcrstt(id,dt);
	pxrtime = dt;
	if (piflags&PiiX && pxdisp&PXHI)
		printf("\n Reset completed");
	}

/* `pisave` - 45 - save PROMICE contents to a file */

static void pisave(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiSave()");
	if (ps_bchrc != ' ' && ps_bchrc != '\0')
		{
		pxerror = PGE_CMD;
		return;
		}
	if (piflags&PiMU && !(pxflags&PORQ))
		{
		pxerror = PGE_EMU;
		return;
		}
	if (pigetcfg())
		{
		pxsstart = pxcfg->start;
		pxsend = pxmax;
		if (ps_li--)
			{
			pxsstart = ps_numl[0];
			if (ps_li)
				pxsend = ps_numl[1];
			else
				pxsend = pxmax;
			}
		pcsave();
		pxcfg = pftcfg;
		pifixcfg();
		}
	}

/* `pippmode` - 46 - set parallel fast transfer */

static void pippmode(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiPpmode()");
	if (ps_i)
		{
		switch (ps_num[0])
			{
			case 0:
				pxflags |= POSP;
				break;
			case 1:
				pxflags &= ~POSP;
				break;
			case 2:
				pxflags &= ~(POSP|POVF);
				break;
			default:
				pxerror = PGE_BAA;
			}
		}
	else
		pxflags |= POSP;
	}	

/* `piautor` - 47 - recover from error automatically */

static void piautor(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAutoRecover()");

	if (!ps_i)
		pxflags &= ~POAR;
	else
		if (ps_num[0])
			pxflags |= POAR;
		else
			pxflags &= ~POAR;
	}

/* `piversion` - 48 - report PROMICE uC version# */

static void piversion(void)
	{
	short id;
	char *emu = "PromICE";

	if (pxdisp&PXMH)
		printf(" >PiVersion()");
	if (ps_id >= 0)
		{
		id = ps_id;
		}
	else
		{
		if (ps_i)
			{
			id = (short)ps_num[0];
			}
		else
			{
			id = 0;
			}
		}
	if (id >= pxprom)
		pxerror = PGE_BIG;
	else
		{
		if (pxrom[id].flags&PRRB)
			emu = "ROMboy";
		if (pxrom[id].flags&PRFI)
			emu = "FlashICE";
		printf("\n%s\n%s microCode version %s",liver, emu, pxrom[id].ver);
		}
	}

/* `piwrenb` - 49 - enable write from target (only on some units) */

static void piwrenb(void)
	{

	if (pxdisp&PXMH)
		printf(" >PiWrenb()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(AIS31|TRACE)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		pxwrite = (char)ps_num[0];
		}
	else
		pxerror = PGE_BAA;
	if (pxwrite < 0 || pxwrite > 3)
		pxerror = PGE_BAA;
	if (!pxerror)
		piflags |= PiAB;
	}

/* `piexit` - 50 - Set Exit Code */

static void piexit(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiExit()");
	pxflags |= POXX;
	if (ps_i)
		pxcode = ps_num[0];
	pxexitv = (int)pxcode;
	}

/* `pifast` - 51 - fast host */

static void pifast(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiFast()");
	piflags |= PiZZ;
	if (ps_li)
		ppxdl0 = (short)ps_numl[0];
	if (ps_li>1)
		ppxdl1 = (short)ps_numl[1];
	else
		ppxdl1 = (short)ppxdl0;
	if (ps_li>2)
		ppxdl2 = (short)ps_numl[2];
	else
		ppxdl2 = ppxdl0;
	}

/* `pidialog` - 52 - enter dialog mode */

static void pidialog(void)
	{
	extern long addialog;

	if (pxdisp&PXMH)
		printf(" >PiDialog()");
	pxflags |= POIX;
	addialog++;
	if (ps_str)
		if (*ps_str == 'n')
			pcinit();
	if (*pi_eloc == 'b')
		pcinit();
	}

/* `pippbus` - 53 - parallel port is bussed */

static void pippbus(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >PiBus()");
#ifndef UNIX
	switch (ps_emb)
	{
	case 1:
		ps_str = "LPT1";
		break;
	case 2:
		ps_str = "LPT2";
		break;
	case 3:
		ps_str = "LPT3";
		break;
	case 4:
		ps_str = "LPT4";
		break;
	default:
		pxerror = PGE_BAA;
		return;
	}
#endif
	l = strlen(ps_str);
	if (l < PIC_SN)
		strcpy(pxlink.pname,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)				/* port address */
		{
		pxlink.paddr = (int)ps_num[0];
		pxlink.flags |= PLPU;
		}
	pxlink.flags |= PLPB | PLPP;
	if (pxnpiu<2)
		pxnpiu = 2;
	}	

/* `pislows` - 54 - set  the serial port to respond slowly */

static void pislows(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiSlow()");
	pxlink.flags |= PLOW;
	pxlink.flags &= ~PLHI;
	if (piflags&(PiII|PiiX))
		{
		if (pxrom[0].ver[0] < '7')
			pxmode1 &= ~MO_FAST;
		else
			pxmode1 |= MO_SLOW;
		}
	piflags |= PiMO;
	}

/* `pirlink` - 55 - establish link with remote */

static void pirlink(void)
	{
	pxerror = PGE_NYI;
	}

/* `picurse` - 56 - show or hide the spinning cursor */

static void picurse(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiCursor()");
	if (ps_i)
		{
		pxcurse = (short)ps_num[0];
		if (ps_num[0] == 1)
			piflags &= ~PiHC;
		else
			piflags |= PiHC;
		}
	else
		piflags |= PiHC;
	}
/* `pilite` - 57 - turn off lights blinking */

static void pilite(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiLite()");
	if (piflags&PiiX)
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_LIGHT;
		else
			pxmode2 &= ~M2_LIGHT;
		}
	else
		pxmode2 |= M2_LIGHT;
	piflags |= PiMO;
	}

/* `pitimer` - 58 - disable PromICE timer */

static void pitimer(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiTimer()");
	if (piflags&PiiX)
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_NOTIM;
		else
			pxmode2 &= ~M2_NOTIM;
		}
	else
		pxmode2 |= M2_NOTIM;
	piflags |= PiMO;
	}

/* `pistatus` - 59 - report target status */

static void pistatus(void)
	{
	char c;
	if (pxdisp&PXMH)
		printf(" >PiStatus()");
	if (piflags&PiiX)
		if ((piflags&PiLO) && !(pxrom[0].flags&PRB2))
			{
			pxerror = PGE_UNF;
			return;
			}
#ifndef UNIX
	while (!kbhit())
		{
#endif
		if (piflags&PiMU)
			{
			picmd(0,PI_VS,1,0,0,0,0,0);
			printf("\nTARGET STATUS:  Power is ");
			if (pxrsp[PICM]&CM_TPOW)
				{
				printf("ON");
				printf (" - Target is ");
				if (!(pxrsp[PICM]&CM_TACT))
					printf("NOT ");
				printf("accessing ROM");
				}
			else
				{
				printf("OFF");
				}
			}
		else
			printf("\nTARGET STATUS: Unit(s) in LOAD mode");
		if (pxrom[0].res&TRACE)
			pitrstatus();
#ifndef UNIX
		if (ps_i <= 0)
			break;
		pi_sleep(10);
		}
	if (kbhit())
		c = getch();
#endif
	}

/* `pinet` - 60 - fastport network */

static void pinet(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >PiNet()");

	if (ps_str == NULL)
		{
		pxerror = PGE_BAA;
		return;
		}


	l = strlen(ps_str);
	if (l < PIC_HN)
		{
		strcpy(pxhost,ps_str);
		piflags |= PiNE;
		pxsflags |= SuHOST;
		}
	else
		{
		pxerror = PGE_NTL;
		return;
		}
	pxhostcs = 2002;
	pxhostss = 2001;
	pxhostps = 2000;
	if (ps_i--)
		{
		pxhostss = (short)ps_num[0];
		if (ps_i)
			pxhostps = (short)ps_num[1];
		}
	}

/* `pitint`- 61 - int target on hostint */

static void pitint(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiTaint()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&AIS31))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_TAINT;
		else
			pxmode2 &= ~M2_TAINT;
		}
	else
		pxmode2 |= M2_TAINT;
	piflags |= PiMO;
	}

/* `pitrst` - 62 - reset target on hostint */

static void pitrst(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiTarst()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&AIS31))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_TARST;
		else
			pxmode2 &= ~M2_TARST;
		}
	else
		pxmode2 |= M2_TARST;
	piflags |= PiMO;
	}

/* `piairst` - 63 - reset aitty on hostint */

static void piairst(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAirst()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&AIS31))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_AIRST;
		else
			pxmode2 &= ~M2_AIRST;
		}
	else
		pxmode2 |= M2_AIRST;
	piflags |= PiMO;
	}

/* `piaifst` - 64 - use aitty fast mode */

static void piaifst(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAifast()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&AIS31))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_AIGOF;
		else
			pxmode2 &= ~M2_AIGOF;
		}
	else
		pxmode2 |= M2_AIGOF;
	piflags |= PiMO;
	}

/* `pinorci` - 65 - no rcv char int on aitty */

static void pinorci(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAinorci()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(TRACE|AIS31)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			{
			pxaictl |= AIC_AIROC;
			pxmode2 &= ~M2_AIRCI;
			}
		else
			{
			pxaictl &= ~AIC_AIROC;
			pxmode2 |= M2_AIRCI;
			}
		}
	else
		{
		pxaictl |= AIC_AIROC;
		pxmode2 &= ~M2_AIRCI;
		}
	piflags |= PiMO;
	piflags |= PiAB;
	}

/* `piairci` - 66 - rcv char int on ai (non-tty) */

static void piairci(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAirci()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&AIS31))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxcmode |= MC_AIRCI;
		else
			pxcmode &= ~MC_AIRCI;
		}
	else
		pxcmode |= MC_AIRCI;
	piflags |= PiRQ;
	}

/* `pitintl` - 67 - set traget int length */

static void pitintl(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiTintl()");
	if (ps_i)
		pxtintl = (char)ps_num[0];
	pxcmode |= MC_EXINL;
	piflags |= PiRQ;
	}

/* `pigasrd` - 68 - set global async read (AiCOM or PiCOM) */

static void pigasrd(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiGasrd()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxcmode |= MC_ASYNC;
		else
			pxcmode &= ~MC_ASYNC;
		}
	else
		pxcmode |= MC_ASYNC;
	piflags |= PiRQ;
	}

/* `pigxint` - 69 - set global command completion int */

static void pigxint(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiGxint()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxcmode |= MC_GXINT;
		else
			pxcmode &= ~MC_GXINT;
		}
	else
		pxcmode |= MC_GXINT;
	piflags |= PiRQ;
	}

/* `pilog` - 70 - open a log file for all command traffic */

static void pilog(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >PiLog()");
	if (ps_str != NULL || pclog<0)
		{
		if (ps_str)
			{
			l = strlen(ps_str);
			if (l < PIC_FN)
				strcpy(pxlog,ps_str);
			else
				{
				pxerror = PGE_NTL;
				return;
				}
			}
		else
			strcpy(pxlog,"loadice.log");
#ifndef UNIX
		pclog = open(pxlog,O_CREAT|O_WRONLY|O_BINARY,0xFFFF);
#else
		pclog = open(pxlog,O_CREAT|O_WRONLY,0xFFFF);
#endif
		if (pclog<0)
			{
			perror("Logfile:");
			return;
			}
		pxdisp |= PLOG;
		}
	else
		{
		if (ps_i)
			{
			if (ps_num[0])
				pxdisp |= PLOG;
			else
				pxdisp &= ~PLOG;
			}
		else
			{
			if (pxdisp&PLOG)
				pxdisp &= ~PLOG;
			else
				pxdisp |= PLOG;
			}
		}
	if (pxdisp&PXHI)
		{
		if (pxdisp&PLOG)
			printf("\nLog is ON");
		else
			printf("\nLog is OFF");
		}
	}

/* `pibank` - 71 - load multiple banks */

static void pibank(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiBank()");
	if (!ps_i)
		{
		pxerror = PGE_BAA;
		return;
		}
	if (ps_num[0] < 0)
		{
		pxbanks = 0;
		if (piflags&(PiII|PiiX))
			{
			pifixcfg();
			if (pxdisp&PXHI)
				printf("\nBanking is OFF");
			}
		return;
		}
	if (!pxbanks)
		{
		switch(ps_num[0])
			{
			case 2:
			case 4:
			case 8:
			case 16:
			case 32:
			case 64:
				break;
			default:
				pxerror = PGE_BAA;
				return;
			}
		if (ps_id)
			{
			pxrom[ps_id].banks = (short)ps_num[0];
			pxrom[ps_id].flags |= PRBA;
			}
		pxbanks = ps_num[0];
		pxbank = 0;
		if (piflags&(PiII|PiiX))
			{
			pifixcfg();
			if (pxdisp&PXHI)
				printf("\nBanking is ON with %ld banks\n Bank 0 selected",pxbanks);
			}
		}
	else
		{
		if (ps_num[0] < 0 || ps_num[0] >= pxbanks)
			pxerror = PGE_BAA;
		else
			{
			pxbank = ps_num[0];
			if (pxdisp&PXHI)
				printf("\nBank %d is selected",pxbank);
			}
		}
	}

/* `pinetr` - 72 - reset fastport */

static void pinetr(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNetr()");
	if (ps_i)
		if (!ps_num[0])
			{
			piflags &= ~PiRF;
			return;
			}
		piflags |= PiRF;
	}

/* `pinoar` - 73 - no auto reset */

static void pinoar(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNoar()");
	if (ps_i)
		{
		if (ps_num[0])
			pxmode2 |= M2_LIGHT;
		else
			pxmode2 &= ~M2_LIGHT;
		}
	else
		pxmode2 |= M2_LIGHT;
	}

/* `piburst - 74 - set burst mode */

static void piburst(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiBurst()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(AIS31|TRACE)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		pxburst = (char)ps_num[0];
		pxflags &= ~POCB;
		}
	else
		pxerror = PGE_BAA;
	if (!pxerror)
		piflags |= PiAB;
	}

/* `piaieco` - 75 - set ai control options */

static void piaieco(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAieco()");
	
	pxaieco = 0;
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(AIS31|TRACE)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		pxaieco = (char)ps_num[0];
	else
		pxerror = PGE_BAA;
	if (pxaieco < 0 || pxaieco > 3)
		pxerror = PGE_BAA;
	if (!pxerror)
		piflags |= PiAB;
	}

/* `pimodei` - 76 - define mode at connect */

static void pimodei(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiModei()");
	if (ps_str)
		{
		if (*ps_str == 's')
			pxmodei = MO_LOAD;
		else
			if (*ps_str == 'g')
				pxmodei = MO_EMU;
			else
				pxerror = PGE_BAA;
		}
	else
		pxerror = PGE_BAA;
	}

/* `pimodeo` - 77 - define mode at exit */

static void pimodeo(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiModeo()");
	if (ps_str)
		{
		if (*ps_str == 's')
			pxmodeo = MO_LOAD;
		else
			if (*ps_str == 'g')
				pxmodeo = MO_EMU;
			else
				pxerror = PGE_BAA;
		}
	else
		pxerror = PGE_BAA;
	}

/* `piaimode` - 78 - set AI operating options */

static void piaimode(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAiMode()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(AIS31|TRACE)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		pxmode2 = (char)ps_num[0];
		if (ps_i>1)
			pxcmode = (char)ps_num[1];
		piflags |= PiMO;
		}
	else
		pxerror = PGE_BAA;
	}

/* `pinoload` - 79 - do not down-load file before dialog mode */

static void pinoload(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiNoLoad()");
	pxflags &= ~POLO;
	}

/* `piaddrerr` - 80 - address out of range errors */

static void piaddrerr(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAddrErr()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags &= ~PONO;
		else
			pxflags |= PONO;
		if (ps_i > 1)
			{
			if (ps_num[1])
				pxflags |= PODO;
			else
				pxflags &= ~PODO;
			}
		}
	else
		pxflags |= PONO;
	}

/* `picserr` - 81 - checksum checking */

static void picserr(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiCserr()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags &= ~PONK;
		else
			pxflags |= PONK;
		if (ps_i > 1)
			{
			if (ps_num[1])
				pxflags |= PODK;
			else
				pxflags &= ~PODK;
			}
		}
	else
		pxflags |= PONK;
	}

/* `pireqack` - 82 - use req/ack for read/write */

static void pireqack(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiReqAck()");

	if (pxflags&PORQ)
		pxflags &= ~PORQ;
	else
		{
		if (ps_i--)
			{
			piflags |= PiHO;
			pxhso = (short)ps_num[0];
			if (ps_i--)
				{
				piflags |= PiRQ;
				pxreq = (short)ps_num[1];
				if (ps_i)
					pxack = (short)ps_num[2];
				}
			}
		pxflags |= PORQ;
		}
	if (pxdisp&PXHI)
		{
		if (pxflags&PORQ)
			printf("\n Hold/HoldAck mode ON");
		else
			printf("\n Hold/HoldAck mode OFF");
		}
	}

/* `piafkeys` - 83 - assign alt-function keys */

static void piafkeys(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiFkeys()");
	if (!ps_i)
		pxerror = PGE_BAA;
	else
		{
		if (ps_str == NULL)
			pxerror = PGE_BAA;
		else
			{
			ps_num[0] += 11;
			pxkeys[ps_num[0]] = (char *)calloc(strlen(ps_str)+1,1);
			if (pxkeys[ps_num[0]])
				strcpy(pxkeys[ps_num[0]],ps_str);
			}
		}
	}

/* `pisleep` - 84 - waste some time */

static void pisleep(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiSleep()");
	if (!ps_i || !ps_num[0])
		ps_num[0] = 1;
	if (pxdisp&PXHI)
		printf("\nsleeping  %d units",(short)ps_num[0]);
	pi_sleep((short)ps_num[0]);
	}

/*	`fion` - 85 - FlashICE ON */

static void fion(void)
	{
	if (pxdisp&PXMH)
		printf(" >FiOn()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		pxflash[ps_id].fimoe |= MC_FIHO;
		pxflash[ps_id].fiflags |= FiFON;
		if (ps_i)
			{
			if (ps_num[0])
				pxflash[ps_id].fiflags |= FiBRF;
			else
				pxflash[ps_id].fiflags &= ~FiBRF;
			}
		else
			pxflash[ps_id].fiflags |= FiBRF;
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fioff` - 86 - FlashICE OFF */

static void fioff(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiOff()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		firexit(ps_id);
	else
		pxerror = PGE_UNF;
	}

/*	`fiwrite` - 87 - FlashICE write register */

static void fiwrite(void)
	{
	if (pxdisp&PXMH)
		printf(" >FiWrite()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i < 2)
			ps_num[1] = 0;
		if (ps_i < 1)
			ps_num[0] = 0;
		picmd((char)ps_id,FI_RW,2,(char)ps_num[0],(char)ps_num[1],0,0,0);
		ps_i = 0;
		if (!pxerror && !ps_num[0])
			firead();
		}
	else
		pxerror = PGE_UNF;
	}

/* `firead` - 88 - FlashICE readRegs */

static void firead(void)
	{
	short i,f,tda, id=0;
	char r[8];

	if (pxdisp&PXMH)
		printf(" >FiRead()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		tda = 0;
		f = 0;
		if (ps_i)
			{
			picmd((char)ps_id,FI_RR,1,(char)ps_num[0],0,0,0,0);
			if (!pxerror)
				printf("\n Register -> %02X",pxrsp[PIDT]&0x0ff);
			r[ps_num[0]] = pxrsp[PIDT];
			}
		else
			{
			pxflash[ps_id].fiflags &= ~FiFON;
	#ifndef UNIX
			while (!kbhit() && !pxerror)
	#else
			while (!pxerror)
	#endif
				{
				for (i=0; i<8; i++)
					{
					if (i==3 && !tda)
						continue;
					picmd((char)ps_id,FI_RR,1,(char)i,0,0,0,0);
					if (pxerror)
						break;
					if (r[i] != pxrsp[PIDT])
						{
						r[i] = pxrsp[PIDT];
						f++;
						if (i == 0)
							tda = r[0]&0x40;
						}
					}
				if (f)
					{
					printf("\nsed=%02x wrt=%02x%02x%02x/%02x flags[%02x%02x]",
						r[2]&0x0ff,r[4]&0x0ff,r[5]&0x0ff,
						r[6]&0x0ff,r[7]&0x0ff,r[0]&0xff,r[1]&0xff);
					if (r[0]&0x80)
						printf("-AIS");
					if (r[0]&0x40)
						printf("-ETL");
					if (r[0]&0x20)
						printf("-SUS");
					if (r[0]&0x10)
						printf("-SES");
					if (r[0]&0x08)
						printf("-CES");
					if (r[0]&0x04)
						printf("-BPS");
					if (r[0]&0x02)
						printf("-BPN");
					if (r[0]&0x01)
						printf("-ICS");
					if (r[1]&0x80)
						printf("-SMB");
					if (r[1]&0x40)
						printf("-SMA");
					if (r[1]&0x20)
						printf("-ERS");
					if (r[1]&0x10)
						printf("-ASS");
					if (r[1]&0x08)
						printf("-RRS");
					if (r[1]&0x04)
						printf("-OVR");
					if (r[1]&0x02)
						printf("-HDA");
					if (tda)
						{
						printf("-TDA mbi=%02x",r[3]&0x0ff);
						tda = 0;
						}
					}	
				f = 0;
				pi_sleep(3);
				}
			}
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fisspd` - 89 - FlashICE set sector protection data */

static void fisspd(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSspd()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i)
			{
			pxflash[ps_id].fispd = (char)ps_num[0];
			if (pxprom)
				picmd((char)ps_id,FI_RW|CM_CHANGE,5,pxflash[ps_id].fiman,
				pxflash[ps_id].fidev,pxflash[ps_id].fidv2,pxflash[ps_id].fispd,0);
			}
		else
			printf("\nspd=%02X",pxflash[ps_id].fispd&0xff);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fissed` - 90 - FlashICE show sector erase data */

static void fissed(void)
	{

	}

/*	`fimbpe` - 91 - FlashICE make byte program error */

static void fimbpe(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiMbpe()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		pxflash[ps_id].fiflags &= ~(FiALL|FiPEA|FiPEO|FiPET);
		switch (ps_char)
			{
			case 'A':
				pxflash[ps_id].fiflags |= FiALL;
			case 'a':
				pxflash[ps_id].fiflags |= FiPEA;
				break;
			case 'O':
				pxflash[ps_id].fiflags |= FiALL;
			case 'o':
				pxflash[ps_id].fiflags |= FiPEO;
				break;
			case 'T':
				pxflash[ps_id].fiflags |= FiALL;
			case 't':
				pxflash[ps_id].fiflags |= FiPET;
				break;
			case 'x':
			case 'X':
				break;
			default:
				pxerror = PGE_BAA;
				break;
			}
		if (ps_i)
			pxflash[ps_id].fipem = (char)ps_num[0];
		else
			pxflash[ps_id].fipem = (char)0x5A;
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fimsee` - 92 - FlashICE make sector erase error */

static void fimsee(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiMsee()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		pxflash[ps_id].fiflags &= ~(FiALL|FiSEA|FiSEO|FiSET);
		switch (ps_char)
			{
			case 'A':
				pxflash[ps_id].fiflags |= FiALL;
			case 'a':
				pxflash[ps_id].fiflags |= FiSEA;
				break;
			case 'O':
				pxflash[ps_id].fiflags |= FiALL;
			case 'o':
				pxflash[ps_id].fiflags |= FiSEO;
				break;
			case 'T':
				pxflash[ps_id].fiflags |= FiALL;
			case 't':
				pxflash[ps_id].fiflags |= FiSET;
				break;
			case 'x':
			case 'X':
				break;
			default:
				pxerror = PGE_BAA;
				break;
			}
		if (ps_i)
			pxflash[ps_id].fisem = (char)ps_num[0];
		else
			pxflash[ps_id].fisem = (char)0x5A;
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fimcee` - 93 - FlashICE make chip erase error */

static void fimcee(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiMcee()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		pxflash[ps_id].fiflags &= ~(FiALL|FiCEA|FiCEO|FiCET);
		switch (ps_char)
			{
			case 'A':
				pxflash[ps_id].fiflags |= FiALL;
			case 'a':
				pxflash[ps_id].fiflags |= FiCEA;
				break;
			case 'O':
				pxflash[ps_id].fiflags |= FiALL;
			case 'o':
				pxflash[ps_id].fiflags |= FiCEO;
				break;
			case 'T':
				pxflash[ps_id].fiflags |= FiALL;
			case 't':
				pxflash[ps_id].fiflags |= FiCET;
				break;
			case 'x':
			case 'X':
				break;
			default:
				pxerror = PGE_BAA;
				break;
			}
		if (ps_i)
			pxflash[ps_id].ficem = (char)ps_num[0];
		else
			pxflash[ps_id].ficem = (char)0x5A;
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fissec` - 94 - FlashICE show sector info */

static void fissec(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSsec()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i)
			{
			if (ps_num[0] > FIC_NS)
				{
				pxerror = PGE_BAA;
				return;
				}
			}
		else
			ps_num[0] = 0x0;
		fishows((char)ps_num[0]);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fischp` - 95 - FlashICE show chip info */

static void fischp(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSchp()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		fishowc();
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fisopt` - 96 - FlashICE set options */

static void fisopt(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSopt()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i)
			{
			pxflash[ps_id].fiopt = (char)ps_num[0];
			pxflash[ps_id].fimoe &= 0x3b;
			pxflash[ps_id].fimoe |= (pxflash[ps_id].fiopt<<6) | (pxflash[ps_id].fiopt&4);
			if (ps_i>1)
				pxflash[ps_id].fictl = (char)ps_num[1];
			if (pxprom)
				{
				picmd((char)ps_id,FI_RW,2,FIW_CTL|FIW_UCTL,pxflash[ps_id].fictl,0,0,0);
				picmd((char)ps_id,PI_CM,1,pxflash[ps_id].fimoe,0,0,0,0);
				}
			}
		else
			printf("\nOptions = %02X",pxflash[ps_id].fiopt);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fiolog` - 97 - FlashICE open log */

static void fiolog(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >FiOlog()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_str != NULL || fclog<0)
			{
			if (ps_str)
				{
				l = strlen(ps_str);
				if (l < PIC_FN)
					strcpy(fxlog,ps_str);
				else
					{
					pxerror = PGE_NTL;
					return;
					}
				}
			else
				strcpy(fxlog,"flashice.log");
			fclog = open(fxlog,O_CREAT|O_RDWR,0xFFFF);
			if (fclog<0)
				{
				perror("FlashICE Logfile:");
				return;
				}
			pxflash[ps_id].fiflags |= FiLOG;
			}
		else
			{
			if (ps_i)
				{
				if (ps_num[0])
					pxflash[ps_id].fiflags |= FiLOG;
				else
					pxflash[ps_id].fiflags &= ~FiLOG;
				}
			else
				{
				if (pxflash[ps_id].fiflags&FiLOG)
					pxflash[ps_id].fiflags &= ~FiLOG;
				else
					pxflash[ps_id].fiflags |= FiLOG;
				}
			}
		if (pxdisp&PXHI)
			{
			if (pxflash[ps_id].fiflags&FiLOG)
				printf("\nFlashICE Log is ON");
			else
				printf("\nFlashICE Log is OFF");
			}
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fifion` - 98 - FlashICE set ON */

static void fifion(void)
	{
	if (pxdisp&PXMH)
		printf(" >FiFiOn()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		fienb((char)ps_id);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fisman` - 99 - FlashICE set manufacturer's code */

static void fisman(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSman()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i)
			pxflash[ps_id].fiman = (char)ps_num[0];
		else
			pxflash[ps_id].fiman = 1;
		if (pxprom)
			picmd((char)ps_id,FI_RW|CM_CHANGE,5,pxflash[ps_id].fiman,
			pxflash[ps_id].fidev,pxflash[ps_id].fidv2,pxflash[ps_id].fispd,0);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`fisdev` - 100 - FlashICE set device code */

static void fisdev(void)
	{

	if (pxdisp&PXMH)
		printf(" >FiSdev()");
	if (ps_id < 0)
		ps_id = 0;
	if (!(piflags&PiiX) || (pxrom[ps_id].flags&PRFI))
		{
		if (ps_i)
			pxflash[ps_id].fidev = (char)ps_num[0];
		else
			pxflash[ps_id].fidev = (char)0xA4;
		if (pxprom)
			picmd((char)ps_id,FI_RW|CM_CHANGE,5,pxflash[ps_id].fiman,
			pxflash[ps_id].fidev,pxflash[ps_id].fidv2,pxflash[ps_id].fispd,0);
		}
	else
		pxerror = PGE_UNF;
	}

/*	`rports` - 101 - Read Ports 0,1,2,5 */

static void rports(void)
	{

	if (pxdisp&PXMH)
		printf(" >RPorts()");
	if (ps_id < 0)
		ps_id = 0;
	if (pxrom[ps_id].res&TRACE)
		{
		pxerror = PGE_NYI;
		return;
		}
	if (!ps_i)
		ps_num[0] = 5;
#ifndef UNIX
	while (!kbhit())
		{
#endif
		picmd((char)ps_id,0x4e,1,0,0,0,0,0);
		if (!(pxrsp[PICM]&CM_FAIL) && !pxerror)
			{
			printf("\nxaaa00 dd: %02X%02X00 %02X",pxrsp[PIDT+1]&0xff,
				pxrsp[PIDT+2]&0xff,pxrsp[PIDT]&0xff);
			}
		if (ps_num[0])
			pi_sleep((short)ps_num[0]);
#ifndef UNIX
		}
	ps_i = getchar();
#endif
	}

/* `traceit` - 102 - take the trace */

static void traceit(void)
	{
	if (pxdisp&PXMH)
		printf(" >TraceIt()");
	pitraceit();
	}

/* `trtest`	- 103 - Trace test trace memory */

static void trtest(void)
	{
	if (pxdisp&PXMH)
		printf(" >TrTest()");
	if (ps_i)
		pitrtest(ps_num[0]);
	else
		pitrtest(0);
	}

/* `trread`	- 104 - Trace read trace */

static void trread(void)
	{
	long tmp;

	if (pxdisp&PXMH)
		printf(" >TrRead()");
	if (piflags&PiCR)			/* if just CR typed then dump next range */
		{
		tmp = trrstop - trrstart;
		trrstart = trrstop;
		trrstop = trrstart + tmp;
		if (trrstop > pxmaxt)
			trrstop = pxmaxt;
		}
	else	/* depending on the number the arguments vary */
		{
		if (ps_i)
			if (ps_i > 1)
				{
				trrstart = ps_num[0];
				trrstop = ps_num[1];
				}
			else
				{
				trrstart = ps_num[0];
				trrstop = ps_num[0]+128;
				}
		else
			{
			trrstart = 0;
			trrstop = pxmaxt;
			}
		}
	pitrread(trrstart,trrstop,0);
	}

/* `trwrite` - 105 - Trace write trace */

static void trwrite(void)
	{
	if (pxdisp&PXMH)
		printf(" >TrWrite()");
	if (ps_i)
		if (ps_i > 2)
			pitrwrite(ps_num[0],ps_num[1],ps_num[2],0);
		else
		{
			if (ps_i < 2)
				pitrwrite(ps_num[0],ps_num[0]+255,0,0);
			else
				pitrwrite(ps_num[0],ps_num[1],0,0);
		}
	else
		pitrwrite(0,-1,0,0);
	}

/* `trsave` - 106 - Initialize the trace board */

static void trsave(void)
	{
	long start, stop;
	if (pxdisp&PXMH)
		printf(" >TrSave()");
	start = 0;
	stop = -1;
	if (!ps_str)
		ps_str = "trace.trc";
	if (ps_i)
	{
		ps_i--;
		start = ps_num[0];
	}
	if (ps_i)
		stop = ps_num[1];

	pitrsave(ps_str, start, stop);
	}

/* `trinit` - 107 - Initialize the trace board */

static void trinit(void)
	{
	if (pxdisp&PXMH)
		printf(" >TrInit()");
	if (ps_i)
		pitrinit(ps_num[0]);
	else
		pitrinit(0);
	}

/* `xmdoit` - 108 - turn on the map */

static void xmdoit(void)
	{
	if (pxdisp&PXMH)
		printf(" >XmDoIt()");
	pixmdoit();
	}

/* `xmtest`	- 109 - Xmap test xmap memory */

static void xmtest(void)
	{
	if (pxdisp&PXMH)
		printf(" >XmTest()");
	if (ps_i)
		pixmtest(ps_num[0]);
	else
		pixmtest(0);
	}

/* `xmread`	- 110 - Read XMAP memory */

static void xmread(void)
	{
	long map = -1;

	if (pxdisp&PXMH)
		printf(" >XmRead()");
	if (ps_str)
	{
		if (*ps_str++ == 'm')
		{
			switch(*ps_str)
			{
				case '0':
					map = 0;
					break;
				case '1':
					map = 1;
					break;
				case '2':
					map = 2;
					break;
				case '3':
					map = 3;
					break;
				default:
					pxerror = PGE_BAA;
			}
		}
		else
			pxerror = PGE_BAA;
	}
	if (pxerror)
		return;

	if (ps_i)
		if (ps_i > 1)
			pixmread(ps_num[0],ps_num[1],0, map);
		else
			pixmread(ps_num[0],ps_num[0]+255,0, map);
	else
		pixmread(0,-1,0, map);
	}

/* `xmwrite` - 111 - Write XMAP memory */

static void xmwrite(void)
	{
	long map = -1;

	if (pxdisp&PXMH)
		printf(" >XmWrite()");
	if (ps_str)
	{
		if (*ps_str++ == 'm')
		{
			switch(*ps_str)
			{
				case '0':
					map = 0;
					break;
				case '1':
					map = 1;
					break;
				case '2':
					map = 2;
					break;
				case '3':
					map = 3;
					break;
				default:
					pxerror = PGE_BAA;
			}
		}
		else
			pxerror = PGE_BAA;
	}
	if (pxerror)
		return;

	if (ps_i)
		if (ps_i > 2)
			pixmwrite(ps_num[0],ps_num[1],ps_num[2],0, map);
		else
		{
			if (ps_i < 2)
				pixmwrite(ps_num[0],ps_num[0]+255,0,0, map);
			else
				pixmwrite(ps_num[0],ps_num[1],0,0, map);
		}
	else
		pixmwrite(0,-1,0,0, map);
	}

/* `xmsave` - 112 - Save image to file */

static void xmsave(void)
	{
	long start, stop, map = -1;

	if (pxdisp&PXMH)
		printf(" >XmSave()");

	start = 0;
	stop = -1;

	if (!ps_str2)
		ps_str2 = "xmap.mem";
	if (ps_i)
	{
		ps_i--;
		start = ps_num[0];
	}
	if (ps_i)
		stop = ps_num[1];
	if (ps_str)
	{
		if (*ps_str++ == 'm')
		{
			switch(*ps_str)
			{
				case '0':
					map = 0;
					break;
				case '1':
					map = 1;
					break;
				case '2':
					map = 2;
					break;
				case '3':
					map = 3;
					break;
				default:
					pxerror = PGE_BAA;
			}
		}
		else
			pxerror = PGE_BAA;
	}

	pixmsave(ps_str2, start, stop, map);
	}


/* `xminit` - 113 - Initialize the XMAP circuit */

static void xminit(void)
	{
	if (pxdisp&PXMH)
		printf(" >XmInit()");
	if (ps_i)
		pitrinit(ps_num[0]);
	else
		pitrinit(0);
	}

/* `aiparam` - 114 - set AI2 parameters */

static void aiparam(void)
{
	if (pxdisp&PXMH)
		printf(" >AiParam()");
	if (ps_i)
	{
		ps_i--;
		pxaictl = (char)ps_num[0];
	}
	if (ps_i)
	{
		ps_i--;
		pxaicts = (char)ps_num[1];
	}

	if (ps_i)
	{
		ps_i--;
		pxaihots = (char)ps_num[2];
	}
	if (ps_i)
	{
		ps_i--;
		pxaiuctl = (char)ps_num[3];
	}
	if (ps_i)
		pxaimask = (char)ps_num[4];
	piflags |= PiAB;
}

/* `setup` - 115 - User Setup */

static void setup(void)
	{
	if (pxdisp&PXMH)
		printf(" >Setup()");
	pxsflags |= SuSETUP;
	}

/* `piaidirt` - 116 - AI direct write */

static void piaidirt(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAiDirt()");

	pxaictl |= AIC_AIDIRT;

	if (ps_i)
		if (!ps_num[0])
			pxaictl &= ~AIC_AIDIRT;
	piflags |= PiAB;
	}

/* `trfind`	- 117 - Trace find stuff in trace */

static void trfind(void)
	{
	long find,start,stop;

	if (pxdisp&PXMH)
		printf(" >TrFind()");
	start = 0;
	stop = -1;
	switch (ps_i)
		{
		case 3:
			stop = ps_num[2];
		case 2:
			start = ps_num[1];
		case 1:
			find = ps_num[0];
			break;
		default:
			pxerror = PGE_BAA;
		}
	pitrfind(find,start,stop);
	}

/* `pimodfix` - 118 - define mode at connect */

static void pimodfix(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiModeFixed()");
	pxflags |= POMF;
	}

/* `piromloc` - 119 - define mode at connect */

static void pifileoff(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiFileOffset()");
	if (ps_i)
		pxfoff = ps_num[0];
	else
		pxerror = PGE_BAA;
	}

/* `aicburst - 120 - set clocked burst mode */

static void aicburst(void)
	{
	if (pxdisp&PXMH)
		printf(" >AiCburst()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&(AIS31|TRACE)))
			{
			pxerror = PGE_N31;
			return;
			}
		}
	if (ps_i)
		{
		pxburst = (char)ps_num[0];
		pxflags |= POCB;
		}
	else
		pxerror = PGE_BAA;
	if (!pxerror)
		piflags |= PiAB;
	}

/* `pianalyze - 121 - analyze hex file */

extern unsigned long maps[];
extern unsigned long mape[];
extern long mapi;

static void pianalyze(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAnalyze()");

	if (!ps_str)
		pxerror = PGE_BAA;
	sprintf(pxcline,"file %s 0=0",ps_str);
	pisyn(pxcline,pusrsyn,psynf);
	pifile(1);
	if (pxcfile)
		pxcfile--;
	if (pxnfile)
		pxnfile--;
	if (!pxerror)
		{
		printf("\n\nFile Data Spans from 0x%08X to 0x%08X",maps[0],mape[mapi-1]);
		if (pxpcfg)
			printf("\n ROM Space Spans from 0x00000000 to 0x%08X",pxcfg->max); 
		}
}

/* `pifillall` - 122  - fill all PromICE space */

static void pifillall(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiFillall()");

	if (pigetcfg())	/* setup config - sets pxmax */
		{
		pxfstart = pxcfg->start;
		pxfend = pxmaxi;
		pxfdata = 0xffffffff;
		pxfsize = pxcfg->words;
		pxcfg->flags |= PCFL;
		}
	else
		{
		pxerror = PGE_BAF;
		return;
		}
	switch (ps_li)			/* number or args determine their type */
		{
		case 0:
			pxfdata = pxrom[0].fdata;
			break;
		case 1:
			pxfdata = ps_numl[0];
			break;
		case 2:
			pxfdata = ps_numl[0];
			pxfsize = ps_numl[1];
			break;
		case 5:
			pxfdata = ps_numl[0];
			pxfdata2 = ps_numl[1];
			pxfsize = ps_numl[2];
			break;

		default:
			pxerror = PGE_NUM;
			break;
		}
	pxflags |= POFC | POFA;
	pxflags &= ~POFR;

	if (!pxerror && piflags&(PiII|PiiX))
		{
		if (pigetcfg())
			{
			if (piflags&PiMU && !(pxflags&PORQ))		/* if not emulating */
				pxerror = PGE_EMU;
			else
				{
				pcfill();
				}
			pxcfg = pftcfg;	/* restore config */
			pifixcfg();
			}
		}
	else
		piflags |= PiFM;
	}

/* `piether` - 123 - ethernet host name */

static void piether(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >PiEthernet()");

	if ((ps_str2 == NULL) || (ps_str == NULL))
		{
		pxerror = PGE_BAA;
		return;
		}


	l = strlen(ps_str2);
	if (l < PIC_HN)
		{
		strcpy(pxhost,ps_str2);
		piflags |= PiNE;
		pxsflags |= SuHOST;
		}
	else
		{
		pxerror = PGE_NTL;
		return;
		}
	if (ps_str)
	{
		if (*ps_str == 'f')
		{
			pxhostcs = 2002;
			pxhostss = 2001;
			pxhostps = 2000;
		}
		else
		{
		}
	}
	if (ps_i--)
		{
		pxhostss = (short)ps_num[0];
		if (ps_i)
			pxhostps = (short)ps_num[1];
		}
	}


/* `piclrfiles` - 124 - ethernet host name */

static void piclrfiles(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiClearfiles()");

	pxnfile = 0;
	if (pxdisp&PXHI)
		printf("\nFile set is cleared");

	}


/* `piaixmti` - 125 -  xmt mt int on aitty */

static void piaixmti(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiAixmti()");
	if (piflags&PiiX)
		{
		if (piflags&PiLO)
			{
			pxerror = PGE_UNF;
			return;
			}
		if (!(pxrom[0].res&TRACE))
			{
			pxerror = PGE_NO2;
			return;
			}
		}
	if (ps_i)
		{
		if (ps_num[0])
			pxaictl |= AIC_AITOC;
		else
			pxaictl &= ~AIC_AITOC;
		}
	else
		{
		pxaictl |= AIC_AITOC;
		}
	piflags |= PiMO;
	piflags |= PiAB;
	}

/* `pinetm` - 126 - microplex network */

static void pinetm(void)
	{
	int l;

	if (pxdisp&PXMH)
		printf(" >PiNetm()");

	if (ps_str == NULL)
		{
		pxerror = PGE_BAA;
		return;
		}


	l = strlen(ps_str);
	if (l < PIC_HN)
		{
		strcpy(pxhost,ps_str);
		piflags |= PiNE;
		pxsflags |= SuHOST;
		}
	else
		{
		pxerror = PGE_NTL;
		return;
		}
	pxhostcs = 23;
	pxhostss = 4000;
	pxhostps = 4400;
	if (ps_i--)
		{
		pxhostss = (short)ps_num[0];
		if (ps_i)
			pxhostps = (short)ps_num[1];
		}
	}

/* `pihrm` - 127 - hex record mask */

static void pihrm(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiHrm()");

	if (ps_i)
		pxhexrecm = ps_num[0];
	else
		pxerror = PGE_BAA;
	}

/* `piundef` - UNDEFINED */

static void piundef(void)
	{
	if (pxdisp&PXMH)
		printf(" >PiUndef()");
	}

/* `pigetcfg` - find an existing one or build an alternate config */

static PICONFIG *pigetcfg(void)
	{
	pftcfg = pxcfg;
	if (ps_id >= 0)
		{
		if (ps_id >= pxprom)
			{
			pxerror = PGE_BIG;
			return(0);
			}
		pxcfg = &pxaltcfg;
		pxcfg->words = 1;
		pxcfg->uid[0] = ps_id;
		}
	pifixcfg();
	return(pxcfg);
	}

/*	table of function pointers -
	- this table is used by the input parser
	- to call the appropriate routine as
	- specied in the current script
*/
void (*psynf[])(void) = {
	piailoc,	/* 1 - set up ailoc for AITTY */
	pibrate,	/* 2 - baud rate */
	picompare,	/* 3 - comapre */
	pidump,		/* 4 - dump */
	piedit,		/* 5 - edit */
	xmaskx,		/* 6 - set extended address mask */
	pifill,		/* 7 - fill now */
	pihigh,		/* 8 - high speed */
	pihso,		/* 9 - hso polarity */
	pisearch,	/* 10 - search for stuff */
	pichksum,	/* 11 - checksum */
	piload,		/* 12 - load*/
	pimove,		/* 13 - move ROM data around */
	pinumber,	/* 14 - number of unit */
	piouput,	/* 15 - serial device */
	pistdpp,	/* 16 - parallel port */
	pibidipp,	/* 17 - bidirectional pp */
	piromsize,	/* 18 - rom size */
	pistop,		/* 19 - go in to load mode */
	pitest,		/* 20 - test unit */
	piserial,	/* 21 - return unit's serial number */
	piverify,	/* 22 - verify */
	piword,		/* 23 - word size */
	pinocksm,	/* 24 - no-check checksum */
	pidelay,	/* 25 - set timeout delay */
	pinoaddr,	/* 26 - ignore address out of range errors */
	piaisw,		/* 27 - loadice talking through the AISwitch */
	piaitty,	/* 28 - go into transparent mode*/
	pidiscfg,	/* 29 - display config */
	pidisply,	/* 30 - change display level */
	pisystem,	/* 31 - escape command to system */
	pifname,	/* 32 - hex file name */
	pigo,		/* 33 - go in to emulation */
	pihelp,		/* 34 - give out help */
	piimage,	/* 35 - image file */
	pisocket,	/* 36 - set socket size */
	pifkeys,	/* 37 - assign function keys */
	piiload,	/* 38 - load one binary file */
	piulock,	/* 39 - locked units */
	pinofil,	/* 40 - don't do filling */
	pimemap,	/* 41 - change map display status */
	pirecover,	/* 42 - recover from failure */
	piundef,	/* 43 - Undefined function */
	pireset,	/* 44 - reset target */
	pisave,		/* 45 - save to file */
	pippmode,	/* 46 - set fast parallel transfer mode */
	piautor,	/* 47 - autorecover */
	piversion,	/* 48 - report uCode ver# */
	piwrenb,	/* 49 - enable or disable write signal */
	piexit,		/* 50 - set exit code */
	pifast,		/* 51 - fast host */
	pidialog,	/* 52 - enter dialog mode */
	pippbus,	/* 53 - parallel port is bussed */
	pislows,	/* 54 - turn down the serial rate */
	pirlink,	/* 55 - establish link with remote/ROMview */
	picurse,	/* 56 - show or hide spinning cursor */
	pilite,		/* 57 - lights or no lights */
	pitimer,	/* 58 - timer or no timer */
	pistatus,	/* 59 - report target status */
	pinet,		/* 60 - fast port ethernet */
	pitint,		/* 61 - int target on hostint */
	pitrst,		/* 62 - reset target on hostint */
	piairst,	/* 63 - reset aitty on hostint */
	piaifst,	/* 64 - use aitty fast mode */
	pinorci,	/* 65 - no rcv char int on aitty */
	piairci,	/* 66 - rcv char int on ai (non-tty) */
	pitintl,	/* 67 - set target interrupt length */
	pigasrd,	/* 68 - set global async read */
	pigxint,	/* 69 - set global command completion int */
	pilog,		/* 70 - initiate loadice comm log */
	pibank,		/* 71 - load multiple banks */
	pinetr,		/* 72 - reset fastport */
	pinoar,		/* 73 - no auto reset */
	piburst,	/* 74 - set burst mode control */
	piaieco,	/* 75 - set ai control options */
	pimodei,	/* 76 - define default mode at connect */
	pimodeo,	/* 77 - define mode at exit */
	piaimode,	/* 78 - set AI mode all at once */
	pinoload,	/* 79 - do not load files */
	piaddrerr,	/* 80 - ignore address out of range error control */
	picserr,	/* 81 - ignore checksum error control */
	pireqack,	/* 82 - use req/ack for read/write */
	piafkeys,	/* 83 - alt function key */
	pisleep,	/* 84 - sleep a while */

	fion,		/* 85 - FlashICE ON - FlashICE OFF */
	fioff,		/* 86 - FlashICE ON - FlashICE OFF */
	fiwrite,	/* 87 - FlashICE write register */
	firead,		/* 88 - FlashICE readRegs */
	fisspd,		/* 89 - FlashICE set sector protection data */
	fissed,		/* 90 - FlashICE report sector erase data */
	fimbpe,		/* 91 - FlashICE make byte program error */
	fimsee,		/* 92 - FlashICE make sector erase error */
	fimcee,		/* 93 - FlashICE make chip erase error */
	fissec,		/* 94 - FlashICE show sector erase data */
	fischp,		/* 95 - FlashICE show chip erase data */
	fisopt,		/* 96 - FlashICE set operating options */
	fiolog,		/* 97 - FlashICE enable/disable log */
	fifion,		/* 98 - FlashICE enable the unit */
	fisman,		/* 99 - FlashICE set manufacturer's code */
	fisdev,		/* 100 - FlashICE set device code */
	rports,		/* 101 - Read PromICE ports 0, 1, 2, & 5 */
	traceit,	/* 102 - Trace trace it now */
	trtest,		/* 103 - Trace test trace memory */
	trread,		/* 104 - Trace read trace */
	trwrite,	/* 105 - Trace write trace */
	trsave,		/* 106 - Trace save to file */
	trinit,		/* 107 - Trace init board */
	xmdoit,		/* 108 - Xmap do it now */
	xmtest,		/* 109 - Xmap test memory */
	xmread,		/* 110 - Xmap read memory */
	xmwrite,	/* 111 - Xmap write memory */
	xmsave,		/* 112 - Xmap save to file */
	xminit,		/* 113 - Xmap init board */
	aiparam,	/* 114 - AI2 parameters */
	setup,		/* 115 - User Setup */
	piaidirt,	/* 116 - setup AI for direct write */
	trfind,		/* 117 - find stuff in trace */
	pimodfix,	/* 118 - leave the mode as it was, on exit */
	pifileoff,	/* 119 - target rom address */
	aicburst,	/* 120 - clocked burst mode */
	pianalyze,	/* 121 - analyze file data */
	pifillall,	/* 122 - fill all of memory */
	piether,	/* 123 - ethernet host name */
	piclrfiles,	/* 124 - clear file set */
	piaixmti,	/* 125 - enable tbmt ints */
	pinetm,		/* 126 - microplex network host */
	pihrm		/* 127 - set hex rec address mask */
	};
