/* vlog.c - edit 7

	vlog.c - a program to view loadice log
	(C) 1994-1996 Grammar Engine, Inc.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

int log;
unsigned char buf[1024];

#ifdef ANSI
void main(int argc, char **argv)
#else
void main(argc, argv)
int argc;
char **argv;
#endif
	{
	char *logfile;
	int getlog();
	int len=0,state=0,count,pcount=0,i,j,id;

	if (argc > 1)
		logfile = *++argv;
	else
		logfile = "loadice.log";

	if ((log = open(logfile,O_RDONLY)) < 0)
		perror("Logfile"),exit(1);
	while(len=getlog())
		{
		for (i=0; i<len; i++)
			{
			switch(state)
				{
				case 0:
					id = buf[i];
					break;
				case 1:
					if (buf[i]&0x80)
						printf("\nrsp:< ");
					else
						printf("\nCMD:> ");
					printf("%02X %02X",id,buf[i]);
					break;
				case 2:
					count = buf[i];
					if (!count)
						count = 256;
					count++;
					pcount = 2;
				default:
					printf(" %02X",buf[i]);
					count--;
					pcount++;
					if (pcount == 16)
						{
						printf("\n     ");
						pcount=0;
						}
					if (!count)
						state = -1;
				}
			state++;
			}		
		}
	}

int getlog()
		{
		return(read(log,buf,1024));
		}
