/*	PiShell.c - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-96 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "piconfig.h"
#include "piscript.h"
#include "pistruct.h"
#include "pierror.h"
#include "pihelp.h"

char *pidefs1 = "output=/dev/ttyb";
char *pidefs2 = "baud=19200";
char Utimes[32];

#ifdef ANSI
extern void (*psynf[])(void);
extern char *getenv(char *var);
extern void piemu(void);
extern void pilod(void);
extern void pcinit(void);
extern void pcexit(void);
extern void pcxinit(void);
extern void firemon(void);
static void pikeys(unsigned char c);
static void utime(short code);
void pishell(void)

#else
extern void (*psynf[])();
extern char *getenv();
extern void piemu();
extern void pilod();
extern void pcinit();
extern void pcexit();
extern void pcxinit();
extern void firemon();
static void pikeys();
static void utime();
void pishell()
#endif
	{
	short i;
	short skip;
	FILE *cf;
	unsigned char c;
	char *cstr,**hp;
	extern int errno;
	char ifile[PIC_FN];

	utime(0);	/* init timer */

	/* if user did just 'loadice ?' or 'loadice help' */

	if (pxcline[0] == '?' || !strcmp(pxcline,"help"))
		{
		hp = piclhlp;
		while(*hp)
			{
			printf("\n %s",*hp);
			if (**hp == '-')
				(void)fgets(pxuline,PIC_CL,stdin);
			hp++;
			}
		return;
		}

	/* if 'ini' file is on the command line as '@inifile' */

	if (pxcline[0] == '@')
		{
		cstr = ifile;
		for (i=0; ((i<(short)strlen(pxcline)) && (i<(PIC_FN-1))); i++)
			{
			pxcline[i] = ' ';
			if (pxcline[i+1] == ' ')
				break;
			else
				ifile[i] = pxcline[i+1];
			}
		ifile[i] = '\0';
		pxcline[i+1] = ' ';
		}
	else		/* look for environment variable or use default */
		{
		cstr = getenv("LOADICE");
		if (cstr == NULL)
			cstr = "loadice.ini";
		}

	if (pxcline[0] != '.') /* if command line start with '.' then don't do it */
		{
		cf = fopen(cstr,"r");
		if (cf == NULL)
			if (cstr == ifile)
				for (i=0; i<(short)strlen(cstr); i++)
					if (ifile[i] == '.')
						break;
				if (i == (short)strlen(cstr))
					{
					strcat(cstr,".ini");
					cf = fopen(cstr,"r");
					}
		if (pxdisp&PXHI)
				printf("\n Opening command file '%s'",cstr);
		if (cf != NULL)
			{
			while (fgets(pxuline,PIC_CL,cf) != NULL)
				{
				if (pxuline[0] == '*')	/* ignore comment lines */
					continue;
				if (pxuline[0] == '.')	/* execute command NOW */
					{
					pxuline[0] = ' ';
					piflags |= PiII;
					}
				else
					piflags &= ~PiII;
				pisyn(pxuline,pcmfsyn,psynf);	/* call parser */
				if (pxerror)
					{
					pierror();
					(void)fclose(cf);
					return;
					}
				pi_estr1 = (char *)0;
				}
			(void)fclose(cf);
			}
		else
			{
			if (pxdisp&PXHI)
				printf("\n File not found '%s' - proceeding",cstr);
			errno = 0;
			}
		}
	else
		pxcline[0] = ' '; /* get rid of the '.' */

	if (pxcline[0] != '\0')
		{
		if (pxdisp&PXHI)
			printf("\n Executing command line '%s'",pxcline);
		piflags |= PiCM;
		pisyn(pxcline,pcmlsyn,psynf);
		piflags &= ~PiCM;
		}

	if (pxerror)
		pierror();
	else	/* possibly dialog mode */
		{
		/* if wants to load, has files and no dialog mode requested */

		if (!(pxflags&POXX) && (pxflags&POLO || (pxnfile && !(pxflags&POIX))))
			{
			piflags |= PiII;
			pisyn("l",pusrsyn,psynf);
			if (pxerror)
				{
				pierror();
				piemu();
				pcexit();
				return;
				}
			}

		/* if dialog mode requested or no files given (force dialog) */

		if ((pxflags&POIX) || !pxnfile)
			{
			if (pxdisp&PXHI)
					printf("\n Entering dialog mode");
			pxflags &= ~POXX;
			pcinit();
			pibusy = 1;
			if (!pxerror)
				{
				piflags |= PiiX;
				for(;;)
					{
					if (pxerror)
						pierror();
					else
						piflags &= ~PiER;
					if (!(piflags&PiUP))
						{
						if (pxflags&POAR)
							{
							if (pxdisp&PXVH)
								printf(" Auto-recvery...");
							pisyn("restart",pusrsyn,psynf);
							if (pxerror)
								continue;
							}
						else
							if (pxdisp&PXVH)
								printf("\nCan't talk to the units - type 'restart'");
						}
					if (pxflash[0].fiflags&FiFON)
						if (piflags&PiMU)
							firemon();
					if (pibusy && pxdisp&PXVH)
						{
						utime(1);
						printf("\n\n%s",Utimes);
							if (pxflash[0].fiflags&FiFON)
								printf("FlashICE: ");
							else
								{
								if (piflags&PiMU)
									printf("LoadICE: ");
								else
									printf("LOADice: ");
								}
						}
					piflags &= ~PiCR;
					pibusy = 0;
					if (gets(pxuline))
						{
						pibusy = 1;
						if (!strlen(pxuline))
							{
							pxuline[0] = pxfirst;
							piflags |= PiCR;
							}
						pxfirst = pxuline[0];
						if (pxuline[0] == '.')	/* '.' means immediate */
							piflags |= PiII;
						else
							piflags &= ~PiII;
						utime(0);				/* reset timer */
						pisyn(pxuline,pusrsyn,psynf);	/* do command */
						if (pxerror)
							pierror();
						if (piflags&(PiHO|PiRQ|PiMO|PiAB))
							pcxinit();
						}
					if (pxflags&POXX)
						break;
					pi_estr1 = (char *)0;
					}
				}
			else
				pierror();
			}
		pcexit();	/* shut down link to PROMICEs */
		}
	}

static void pikeys(unsigned char c)
	{
	}

/* `utime` - time stamp the prompt */

#ifdef ANSI
static void utime(short code)
#else
static void utime(code)
short code;
#endif
	{
	static time_t t;
	time_t tt;
	short day,hour,minute;

	if (!code)
		t = time(NULL);
	else
		{
		day = hour = minute = 0;
		tt = time(NULL) - t;
		if (tt >= 86400)
			{
			day = tt/86400;
			tt %= 86400;
			}
		if (tt >= 3600)
			{
			hour = tt/3600;
			tt %= 3600;
			}
		if (tt >= 60)
			{
			minute = tt/60;
			tt %= 60;
			}
		if (day)
			{
			sprintf(Utimes,"%03d|%02d:%02d:%02d:",day,hour,minute,tt);
			return;
			}
		if (hour)
			{
			sprintf(Utimes,"%02d:%02d:%02d:",hour,minute,tt);
			return;
			}
		if (minute)
			{
			sprintf(Utimes,"%02d:%02d:",minute,tt);
			return;
			}
		sprintf(Utimes,"%02d:",tt);
		}
	}
