/*	PiMap.c - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-99 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - Handle File Data Maps
*/

#include <stdio.h>
#include "piconfig.h"
#include "pistruct.h"

#define MAP	1024

unsigned long maps[MAP];
unsigned long mape[MAP];
long mapi = 0;

void pimap(unsigned long start, unsigned long end, unsigned long init)
	{
	long i,j;
	unsigned long ts,te,tsx,tex;

	if (init)
		{
		mapi=0;
		return;
		}

	if (pxflags&POMP)
		printf("\nData %08lX-%08lX",start,end);
	for (i=0; i<MAP; i++)
		{
		if (i >= mapi)
			{
			maps[i] = start;
			mape[i] = end;
			mapi = i+1;
			break;
			}
		if (mape[i] == (start-1))
			{
			mape[i] = end;
			break;
			}
		if (maps[i] == (end+1))
			{
			maps[i] = start;
			break;
			}
		if (maps[i] > start)
			{
			ts = maps[i];
			te = mape[i];
			maps[i] = start;
			mape[i] = end;
			for (j=i+1; j<mapi+2; j++)
				{
				tsx = maps[j];
				tex = mape[j];
				maps[j] = ts;
				mape[j] = te;
				ts = tsx;
				te = tex;
				}
			mapi++;
			break;
			}
		}

	for (i=0; i<mapi-1; i++)
		{
		if (mape[i]+1 == maps[i+1])
			{
			mape[i] = mape[i+1];
			for (j=i+1; j<mapi-1; j++)
				{
				maps[j] = maps[j+1];
				mape[j] = mape[j+1];
				}
			mapi--;
			}
		}
	}
