        ;***********************************************************
	;*                                                         *
	;*                                                         *
	;*  FORMAT PROGRAM FOR S100/S1410 HARD DISK SYSTEM         *
	;*                                                         *
	;*    COPYRIGHT 1982   XEBEC CORP.                         *
	;*                     432 LAKESIDE DRIVE                  *
	;*                     SUNNYVALE, CALIFORNIA  94086        *
	;*                                                         *
	;*                                                         *
	;***********************************************************
		;
		;S100 NON-DMA FORMAT PROGRAM
		;REV 2.1  06-02-83
		;
		;
	;REVISION HISTORY
	;*********************
	;AUGUST 11, 1982...INITIAL RELEASE...JHD
	;
	;FEBRUARY 11,1983...ADDED DIFFERENT DRIVE SIZES CAPS.
        ;                   SEND INITIALIZE DRIVE COMMAND BEFORE
        ;                   EACH COMMAND
        ;
	;JUNE 02, 1983......FIXED THE REQUEST SENSE '00' ERROR
	;
TRUE    EQU     0FFFFH
FALSE   EQU     NOT TRUE
	;
;**************************************************************************
;
;        BELOW ARE THE EQUATES THAT MUST BE CHANGED
;        SUCH THAT THEY REFLECT THE CHARACTERISTICS
;        OF THE DRIVE WHAT WILL BE ATTACHED TO THIS
;        SYSTEM.
;
;        NOTE:  THESE VALUES ARE ALL RELATIVE TO '1'
;
;**************************************************************************
;
MXCL     EQU       153                 ;MAX CYLINDER
MXHD     EQU       4                   ;MAX HEAD
RWC      EQU       128                 ;STARTING REDUCED WRITE CURRENT CYL.
WPC      EQU       64                  ;STARTING WRITE PRECOMP CYLINDER
ECC      EQU       11                  ;ECC DATA BURST LENGTH
CNTRLB   EQU       0                   ;LOWER NIBBLE OF THE CONTROL
                                       ;BYTE OF THE DCB (FAST STEP OPT.)
FLAG1    EQU       FALSE               ;GREATER THAN 6 MBYTES ??? (4K/8K)
FLAG2    EQU       FALSE               ;GREATER THAN 12 MBYTES ??? (512/1024)
;









;*************************************************************************
;
;        BELOW ARE THE EQUATES WHICH MUST BE SET FOR SYSTEM WHICH
;        THIS DRIVER WILL BE USED.
;
;*************************************************************************
;
BASE     EQU       0E0H                 ;HOST ADAPTOR BASE ADDRESS
                                       ;
;*************************************************************************
;
;        FLAG1  = MAX # OF CYLINDERS * MAX # OF HEADS
;                 IT IS THE SWITCH POINT FROM 511 DIR 
;                 ENTRIES TO 1023 DIR ENTRIES
;
;        FLAG2  = MAX # OF CYLINDERS * MAX # OF HEADS
;                 IT IS THE SWITCH POINT FROM 8K BLKS
;                 TO 16K BLOCKS
; 
;  1 MBYTE              6 MBYTES               12 MBYTES
;    '                    '                       '
;    +--------------------+-----------------------+---------------------+
;    '                    '                       '                     '
;    '  BLKS SIZE = 8K    '  BLKS SIZE = 8K       '  BLKS SIZE = 16K    '
;    '                    '                       '                     '
;    '  DIR ENTRIES = 511 '  DIR ENTRIES = 1023   '  DIR ENTRIES = 1023 '
;    '                    '                       '                     '
;    +--------------------+-----------------------+---------------------+
;                         '                       '
;                       FLAG1                   FLAG2                    
;
;**************************************************************************
;
MCL      EQU       MXCL MOD 256        ;SPLIT UP THE WORDS INTO BYTES
MCH      EQU       MXCL / 256          ;
RWL      EQU       RWC MOD 256         ;
RWH      EQU       RWC / 256           ;
WPL      EQU       WPC MOD 256         ;
WPH      EQU       WPC / 256           ;
                                       ;
NFLAG1   EQU       NOT FLAG1           ;
NFLAG2   EQU       NOT FLAG2           ;













;**************************************************************************
;        
;        THE DPB WILL BE SET-UP USING THE VALUES WHICH
;        WERE EQUATED IN ABOVE.
;
;        NOTE:  THE ASSUMPTION WAS MADE THAT WE ARE USING
;               32 SECTORS PER TRACK ( 256 BYTES PER SECT.)
;
;**************************************************************************
;
IF FLAG2                               ;SET-UP FOR 16K BLOCKS       
BSH      EQU       7                   ;
BLM      EQU       127                 ;
EXM      EQU       7                   ;   
DSM      EQU       (( MXCL * MXHD ) - MXHD / 2 )   ;32 SEC, MINUS 1 CYL
ENDIF
;
IF NFLAG2                              ;SET-UP FOR 8K BLOCKS
BSH      EQU       6                   ;
BLM      EQU       63                  ;    
EXM      EQU       3                   ;
DSM      EQU      ((( MXCL * MXHD ) - MXHD ) )  ;32 SEC, MINUS 1 CYLINDER
ENDIF                
;
IF FLAG1                               ;SET-UP 1023 DIR ENTRIES
DRM      EQU       1023                ;ALLOW 1023 DIR ENTRIES
ENDIF
;
IF NFLAG1                              ;SET-UP 511 DIR ENTRIES
DRM      EQU       511                 ;ALLOW 511 DIR ENTRIES
ENDIF
;
IF NFLAG2 AND FLAG1                    ;BETWEEN 6 AND 12 MBYTES
AL0      EQU       0F0H                ;4 DIR BLOCKS
ENDIF
;
IF NFLAG1 OR FLAG2                     ;LESS THAN 6 OR MORE THAN 12 MBYTES
AL0      EQU       0C0H                ;2 DIR BLOCKS
ENDIF
	;
	;
	;HOST ADAPTOR EQUATES
	;
	;
	;
	ORG	100H
DATAIN	EQU	BASE+0	;DATA IN PORT
DATAOT	EQU	BASE+0	;DATA OUT PORT
DCON	EQU	BASE+1	;DISK CONTROL PORT
DSTA	EQU	BASE+2	;DISK STATUS PORT
	;
	;
	;MONITOR EQUATES FOR CP/M ACCESS
	;
BDOS	EQU	5	;BDOS CALL ADDRESS
CIN	EQU	1	;CONSOLE IN
COUT	EQU	2	;CONSOLE OUT
CST	EQU	11	;CONSOLE STATUS
PSTRING	EQU	9	;PRINT STRING
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
ESC	EQU	1BH	;ESCAPE
	;
	;COMMAND EQUATES
	;
FD	EQU	04H	;FORMAT DISK
CTF	EQU	05H	;CHECK TRACK FORMAT
WRT	EQU	0AH	;WRITE SECTOR
RDD	EQU	08H	;READ SECTOR
SEK	EQU	0BH	;SEEK
RECAL	EQU	01H	;RECALIBRATE
IDC	EQU	0CH	;INITIALIZE DRIVE CHARACTERISTICS
	;
	;MISC EQUATES
	;
NSCT2	EQU	32	;32 SECTORS, 256 BYTES PER SECTOR
NSCT5	EQU	17	;17 SECTORS, 512 BYTES PER SECTOR
BYTSPS2	EQU	256	;256 BYTES PER SECTOR
BYTSPS5	EQU	512	;512 BYTES PER SECTOR
ERRCT	EQU	0F1H	;MAX. ERROR COUNT 15
	;
	;
	;
	;
	;START OF PROGRAM
	;
MAIN	MVI	C,PSTRING
	LXI	D,TITLM
	CALL	BDOS	;GO PRINT TITLE MESSAGE
	;
MAIN1	LXI	D,OPTNM
	MVI	C,PSTRING
	CALL	BDOS	;GO PRINT OPTION MESSAGE
	MVI	C,CIN	;WAIT FOR OPERATOR
	CALL	BDOS
	;
	CPI	'C'	;SEE IF DRIVE C
	JNZ	MAIN2	;IT'S NOT C
	LXI	H,DRVNO	;POINT TO DRIVNO VAR.
	MVI	A,00
	MOV	M,A	;STORE DRIVE 0
	JMP	MAIN4	
MAIN2	CPI	'D'	;SEE IF IT'S DRIVE D
	JNZ	MAIN3	;NOT THAT EITHER
	LXI	H,DRVNO	;POINT TO DRIVNO VAR.
	MVI	A,20H	;STORE DRIVE 1
	MOV	M,A
	JMP	MAIN4	
MAIN3	CPI	ESC	;MAYBE HE REALLY DIDN'T WANT TO DO THIS...
	JNZ	MAIN1	;NOT ESC EITHER...TRY IT ALL OVER AGAIN
MAIN3A	JMP	0000	;REBOOT!!!!!!!!!!!!!!!
MAIN4	LXI	D,WARNM	;WARNING MESSAGE
	MVI	C,PSTRING
	CALL	BDOS	;PRINT IT
	;
	MVI	C,CIN	
	CALL	BDOS	;WAIT FOR OPERATOR
	CPI	'Y'	;OK???????
	JNZ	MAIN3A	;NO...REBOOT
	;OK...GO FOR IT
	CALL	BEGIN	;START IT
	JMP	MAIN1	;SEE IF THERE IS ANYTHING ELSE
	;
	;THIS IS THE FORMAT SUBROUTINE...IT WILL RECAL THE DRIVE,
	;ISSUE THE FORMAT DRIVE COMMAND, AND WRITE E5'S ON THE 
	;FIRST 2048 SECTORS OF THE DISC FOR THE CP/M DIRECTORY.
	;
	;
BEGIN	LXI	H,ERRCTR
	MVI	A,ERRCT	;MAX ERROR COUNT=15
	MOV	M,A
	LXI	H,CMDB	;POINT TO COMMAND BYTE
	MVI	A,RECAL	;RECAL COMMAND
	MOV	M,A	;STORE IT
	LXI	H,DRVNO	;GET CURRENT DRIVE
	MOV	A,M
	LXI	H,CMDB+1;POINT TO LUN BYTE
	MOV	M,A	;STORE IT
	MVI	A,00
	INX	H
	MOV	M,A	;ZERO MIDDLE ADD.
	INX	H
	MOV	M,A	;ZERO LOW ADD.
	MVI	A,01	;BLOCK COUNT (OR INTERLEAVE)=1
	INX	H
	MOV	M,A	;STORE IN B.C. BYTE
	LXI	B,CONTB	;CONTROL BYTE
	LDAX	B	;GET IT FROM MEM
	ANI	3FH	;ENABLE RETRIES FOR FORMAT
	INX	H	;POINT TO CONT. BYTE
	MOV	M,A	;STORE IT
        MVI     A,RECAL
FMCONT  LXI     H,CMDB  ;POINT TO COMMAND BLOCK
	CALL	EXCMD   ;GO DO RECAL
	;
	;
	JNZ	RECALER	;UH OH.....
	;
	;
	;
	;NOW GO FORMAT THE DRIVE
	;
DFORM	LXI	H,CMDB	;POINT TO COMMAND BYTE
	MVI	A,FD	;FORMAT DRIVE COMMAND
	MOV	M,A	;STORE IT
	;
	;ALL OTHER BYTES ARE THE SAME AS PREV. COMMAND
	;
	CALL	EXCMD 	;GO DO FORMAT DRIVE
	;
	JNZ	FORMERR	;GOT A HIT
	;
	;
	PAGE
	;
	;NOW WRITE E5'S ON THE FIRST 1024 SECTORS 
	;FOR THE CP/M DIRECTORY.
	;
		;FILL THE WRITE BUFFER WITH E5
		;
FILBUF	LXI	B,BYTSPS5;512 BYTE BUFFER
	MVI	A,0E5H	;E5 PATTERN
	LXI	H,WBUF	;POINT TO WRITE BUFFER
FILBU1	MOV	M,A	;STORE BYTE
	INX	H	;POINT TO NEXT BYTE
	DCR	C
	JNZ	FILBU1
	DCR	B
	MOV	A,B
        ANI	0FFH
	JZ	REPWRT	;DONE YET?...BR. IF YES
	MVI	C,00
	MVI	A,0E5H	;RESTORE FORMAT BYTE IN A
	JMP	FILBU1	;NOT DONE YET
	;
	;
	;NOW WRITE THE FIRST 1024 SECTORS
	;
	;
REPWRT	LXI	H,ERRCTR
	MVI	A,ERRCT	;MAX ERRORS ALLOWED
	MOV	M,A	;RESET ERROR COUNT BACK TO 0
	LXI	H,CMDB	;POINT TO COMMAND BYTE
	MVI	A,WRT	;WRITE COMMAND
	MOV	M,A	;STORE IT
	LXI	B,DRVNO	;GET CURRENT DRIVE
	LDAX	B
	INX	H
	MOV	M,A	;PUT IN COMMAND
	MVI	A,00
	INX	H	;POINT TO MIDDLE ADD
	MOV	M,A	;ZERO MIDDLE ADD
	INX	H	;POINT TO LOW ADD.
	MOV	M,A	;ZERO LOW ADD.
	MVI	A,01	;BLOCK COUNT 1
	INX	H
	MOV	M,A	;STORE BLOCK COUNT
REPT	LXI	H,CMDB	;POINT TO COMMAND DESCRIPTOR
	LXI	D,WBUF	;WRITE BUFFER
	MVI	C,0	;256 BYTES
	CALL	EXCMD 	;GO WRITE SECTOR
	JNZ	WRTERR	;BR. IF WE GOT AN ERROR
WTRT	LXI	H,CMDB+3;POINT TO LOW ADD.
	MOV	A,M	;PUT IN A
	INR	A	;INC IT
	MOV	M,A	;PUT ADD.+1 BACK IN COMMAND
	ANI	0FFH	;256 SECTORS YET?
	JNZ	REPT	;JMP IF NOT
	LXI	H,CMDB+2;POINT TO MIDDLE ADD.
	MOV	A,M	;PUT IN A
	INR	A	;INC IT
	MOV	M,A	;PUT BACK MIDDLE ADD. + 1
	ANI	04H	;1024 SECTORS YET?
	JNZ	FORMD	;JMP IF YES
	JMP	REPT	;NOT DONE YET
FORMD	LXI	D,FORMCM;FORMAT COMPLETE MESSAGE
	MVI	C,PSTRING
	CALL	BDOS	;GO PRINT FORMAT COMPLETE MESSAGE
	RET		;BACK TO MENU
	;
	;
	;THIS ROUTINE CONVERTS A HEXADECIMAL BYTE TO 2 ASCII
	;BYTES FOR DISPLAY BY THE CONSOLE.  
	;ON ENTRY, A CONTAINS THE BYTE TO BE CONVERTED AND
	;HL CONTAINS THE BEGINNING MEMORY ADDRESS WHERE THE 
	;RESULTING 2 ASCII BYTES ARE TO BE STORED...BC AND
	;DE ARE RESTORED ON EXIT.
	;
	;
HTA	PUSH	B
	PUSH	D
	MVI	C,0FEH	;FIRST TIME THRU FLAG IN C
	MOV	B,A	;SAVE THE BYTE IN B FOR LATER
	LXI	D,30F7H	;PRIME D WITH AN ASCII 0, E WITH 0-9 FLAG
	RAR
	RAR
	RAR
	RAR		;RIGHT JUSTIFY UPPER NIBBLE
HLP3	ANI	0FH	;CHOP OFF UPPER NIBBLE
	JZ	LDCHAR	;TEST FOR ZERO AT START
HLP1	INR	D	;NEXT ASCII CHAR.
	DCR	A	;DEC NIBBLE
	JZ	LDCHAR	;IS THIS IT?...BR. IF YES
	INR	E	;9 YET?
	JZ	HLP2	;BR IF YES
	JMP	HLP1	;NOT 9 YET...CONTINUE
HLP2	LXI	D,4000H	;PRIME D WITH ASCII A-1, E IS DON'T CARE
	JMP	HLP1
LDCHAR	MOV	A,D	;PUT ASCII CHAR IN A
	MOV	M,A	;PUT IN MEMORY
	MOV	A,B	;RESTORE HEX CHAR IN ACC.
	INX	H
	INR	C	;INC FTT FLAG
	LXI	D,30F7H	;PRIME D WITH ASCII 0, E WITH 0-9 FLAG
	JNZ	HLP3	;BACK TO DO OTHER NIBBLE
	POP	D	;RESTORE D
	POP	B	;RESTORE B
	RET		;BACK TO CALLER
	;
	;THIS ROUTINE PASSES THE COMMAND TO THE HOST ADAPTOR
	;ON ENTRY HL SHOULD CONTAIN THE COMMAND BLOCK ADRESS
	;DE SHOULD CONTAIN THE DATA BLOCK ADRESS, AND C SHOULD
	;CONTAIN THE DATA COUNT. THIS PARTICULAR MODULE IS
	;SET UP FOR THE S100 NON-DMA HOST ADAPTOR.
	;ON RETURN, THE A REG CONTINS THE STATUS, AND THE ZERO
	;FLAG IS CLEAR IF NO ERROR OCCURED.
	;
;*************************************************************
;
;        STORE REGISTERS ONTO STACK AND SEND OUT
;        A DRIVE INITIALIZE DRIVE COMMAND
;        UPON COMPLETION, RESTORE REGISTERS AND 
;        CONTINUE
;
;*************************************************************
;
EXCMD: 
         MOV       A,M                 ;SAVE COMMAND ALSO
         PUSH      PSW                 ;STORE REGISTERS ON STACK
         PUSH      B                   ;
         PUSH      D                   ;
         PUSH      H                   ;
         MVI       A,IDC               ;INITIALIZE DRIVE COMMAND
         LXI       H,CMDB              ;STORE COMMAND ADDRESS IN HL
         MOV       M,A                 ;STORE ACC IN MEMORY
         LXI       D,DRVCHR            ;CHARACTERISTS ADDRESS IN HL
         MVI       C,8                 ;SEND 8 BYTES
         CALL      EXCMD1              ;DO IT !!!
         POP       H                   ;RESTORE REGISTERS
         POP       D                   ;
         POP       B                   ;
         POP       PSW                 ;
         LXI       H,CMDB
         MOV       M,A
EXCMD1: MVI	A,1	;SELECT THE CONTROLLER
	OUT	DATAOT
	MVI	A,42H	;ASSERT SELECT
	OUT	DCON
CONBSY: 
      	IN	DSTA	;WAIT FOR CONTROLLER
	ANI	08H	;TO ASSERT BUSY
	JZ	CONBSY
 
	MVI	A,2	;SET FOR OUTBOUND DATA FLOW
	OUT	DCON
	MVI 	B,6	;SET FOR 6 BYTE TRANSFER
CONREQ:
      	IN	DSTA	;WAIT FOR REQUEST
	ANI	80H
	JZ	CONREQ
CONSND:
	MOV	A,M	;GET DATA BYTE
	OUT	DATAOT	;SEND IT
	INX	H	;STEP POINTER
	DCR	B	;STEP COUNT
	JNZ	CONSND	;NOT DONE
DATREQ:
	IN	DSTA	;WAIT FOR NEXT DATA REQUEST
	ANI	80H
	JZ	DATREQ
	IN	DSTA	;IS COMMAND HIGH?
	ANI	10H
	JNZ	GETSTA	;YES, NO DATA XFER
	XCHG		;SET UP DATA XFER BUFFER
	IN	DSTA	;TRANSFER WHICH DIRECTION?
	ANI	40H
	JNZ	DATWRT	;HIGH MEANS WRITE DATA
DATRD:			;GET THE BYTES
	IN	DATAIN	;GET BYTE
	MOV	M,A	;SAVE AWAY IN BUFFER
	INX	H	;ADVANCE ADRESS
	DCR	C	;STEP COUNT
	JNZ	DATRD	;CONTINUE
GETSTA:			;RETRIVE STATUS BYTES
	IN	DSTA	;WAIT FOR REQUEST
	ANI	80H
	JZ	GETSTA
	IN	DATAIN	;FETCH FIRST BYTE
	MOV	B,A	;SAVE
GETST2:
	IN	DSTA	;WAIT FOR REQ
	ANI	80H
	JZ	GETST2
	IN	DATAIN	;RETRIVE 2ND BYTE
	MOV	A,B	;GET FIRST BYTE
	ANI	02H	;CHECK ERROR BIT
	RET		;DONE
	;
DATWRT:			;SEND DATA TO CONTROLLER
	MOV	A,M	;GET BYTE
	OUT	DATAOT	;SEND
	INX	H	;STEP ADRESS
	DCR	C	;STEP COUNT
	JNZ	DATWRT	;NOT DONE
	JMP	GETSTA	;NOW FINISH
	;
	;THIS ROUTINE EXECUTES THE REQUEST SENSE COMMAND
	;AND PLACES THE SENSE BYTES IN A BUFFER IN ASCII
	;FORM FOR PRINTING BY THE CALLING ERROR PROCESSING
	;ROUTINE.  THE FORMAT OF THE ASCII BUFFER IS 2 ASCII
	;BYTES FOR EACH OF THE FOUR SENSE BYTES, WITH AN ASCII
	;BLANK INSERTED BETWEEN EACH OF THE TWO ASCII BYTES.
	;
	;
ERRPROC	LXI	H,DRVNO	;GET CURRENT DRIVE
	MOV	A,M	;PUT IN A
	LXI	H,RQSNS+1  ;POINT TO LUN BYTE
	MOV	M,A	;PUT CURRENT DRIVE IN DCB
	DCX	H	;POINT TO BEGINNING OF REQ SNS DCB
	LXI	D,SNSBUF;POINT TO SENSE BYTE BUFFER
	MVI	C,4	;FOUR STATUS BYTES
	CALL	EXCMD1 	;GO DO REQ. SENSE COMMAND
	MVI	B,0FCH	;COUNTER FOR FOUR BYTES
        LXI     D,SNSBUF
	LXI	H,ASBUFF;ADRESS OF ASCII BUFFER IN HL
EPLP1	LDAX	D	;PUT HEX BYTE IN A
	CALL	HTA	;GO DO ASCII CONVERSION
	INX	D	;NEXT HEX BYTE
	MVI	A,20H	;PUT ASCII BLANK IN A
	MOV	M,A	;PUT IT IN THE ASCII BUFF. BETWEEN SNS BYTES
	INX	H	;POINT TO NEXT LOCATION IN ASCII BUFFER
	INR	B	;INC COUNTER
	JNZ	EPLP1	;DONE YET?...BR. IF NOT
	RET		;BACK TO CALLER
	;
	;THIS ROUTINE WILL PRINT AN ERROR MESSAGE AND THE 
	;ABORT MESSAGE TO THE CONSOLE IN THE EVENT OF A RECAL
	;ERROR...NO ERRORS ARE ALLOWED.
	;
RECALER	CALL	ERRPROC		;GO DO REQ. SENSE
	LXI	H,RECERM+28	;DEST. OF ASCII BYTES IN ERRMSG
	LXI	B,ASBUFF	;ASCII BUFFER
	MVI	D,0F5H		;COUNTER FOR 11 BYTES
RECLP1	LDAX	B		;PUT BYTE IN A
	MOV	M,A		;STORE BYTE IN ERR. MSG.
	INX	H		;NEXT ERRMSG BYTE
	INX	B		;NEXT ASCII BYTE
	INR	D		;INC COUNTER
	JNZ	RECLP1		;DONE YET...BR. IF NOT
	MVI	C,PSTRING	;BDOS FUNCTION 9
	LXI	D,RECERM	;STRING ADDRESS
	CALL	BDOS		;GO PRINT MESSAGE
	;
	;NOW PRINT ABORT MESSAGE
	;
	MVI	C,PSTRING
	LXI	D,ABTM1		;RECAL ABORT MESSAGE
	CALL	BDOS		;GO PRINT MESSAGE
	RET			;BACK TO MENU
	;
	;
	;THIS ROUTINE OUTPUTS THE ERROR MESSAGE ON
	;A FORMAT ERROR...IT WILL ALSO RESTART THE
	;FORMAT OPERATION ONE TRACK PAST THE TRACK
	;ON WHICH THE ERROR OCCURED IF THE MAXIMUM 
	;NUMBER OF ERRORS ALLOWED (CURRENTLY 15)
	;HAS NOT BEEN EXCEEDED YET.
	;
	;
FORMERR	CALL	ERRPROC		;GO DO REQ. SENSE
	LXI	H,FORERM+29	;DEST. OF ASCII BYTES IN ERRMSG.
	LXI	B,ASBUFF	;ASCII BYFFER
	MVI	D,0F5H		;COUNTER FOR 11 BYTES
FLP1	LDAX	B		;PUT BYTE IN A
	MOV	M,A		;PUT IN ERR. MSG
	INX	H		;NEXT ERRMSG BYTE
	INX	B		;NEXT ASCII BYTE
	INR	D		;INC COUNTER
	JNZ	FLP1		;DONE YET?...BR IF NOT
	MVI	C,PSTRING	;BDOS FUNCTION 9
	LXI	D,FORERM	;FORMAT ERR. MESSAGE
	CALL	BDOS		;GO PRINT MESSAGE
	;
	;
	;NOW DUMMY UP COMMAND DESCRIPTOR TO CONTINUE FORMAT
	;ONE TRACK PAST THE POINT WHERE THE ERROR OCCURED...
	;UNLESS THE ERROR COUNT HAS EXPIRED.
	;
	;
	LXI	H,ERRCTR	;ERROR COUNTER
	MOV	A,M		;PUT IN A
	INR 	A		;INC IT
	MOV	M,A		;PUT BACK IN ERROR COUNTER
	JNZ	DMLP2		;BR IF NOT EXPIRED YET
	MVI	C,PSTRING	;BDOS FUNCTION	9
	LXI	D,ABTM		;ABORT MESSAGE
	CALL	BDOS		;GO PRINT IT
	RET			;BACK TO MENU
DMLP2	LXI	H,CMDB+1	;POINT TO COMMAND BLOCK
	LXI	B,SNSBUF+1	;SENSE BYTE BUFFER
	MVI	D,0FDH		;COUNTER FOR 3 BYTES
DMLP1	LDAX	B		;GET SNS BYTE
	MOV	M,A		;PUT IN CDB LUN/HI ADD. BYTE
	INX	H		;NEXT CMD BYTE
	INX	B		;NEXT SENSE BYTE
	INR	D		;INC COUNTER
	JNZ	DMLP1		;DONE YET?...BR IF NOT
	;
	;NOW STUFF IN CURRENT BLOCK + 1, JAM IN RECAL COMMAND
	;AND GO BACK TO FORMATTING
	;
	;
	LXI	H,CMDB+3	;POINT TO LOW ADD
	MOV	A,M		;PUT IN A
	ADI	NSCT2		;INC TO NEXT TRACK
	MOV	M,A		;PUT BACK IN COMMADM BLOCK
	JNC	DMLP3		;CHECK FOR OVERFLOW
	DCX	H		;POINT TO MID. ADD.
	MOV	A,M		;GET IT
	ADI	1		;ADD ONE (NEED CARRY FLAG)
	MOV	M,A		;STORE BACK
	JNC	DMLP3		;CHECK FOR OVERFLOW
	DCX	H		;POINT TO HI BYTE
	MOV	A,M		;GET IT
	ANI	1FH		;GET RID OF LUN BITS
	INR	A		;INC	IT
	MOV	B,A		;STASH IN B FOR A MINUTE
	MOV	A,M		;GET ORIGINAL BYTE
	ANI	0E0H		;SAVE LUN BITS
	ORA	B		;OR IN NEW HI ADD. BITS
	MOV	M,A		;PUT BACK IN COMMAND BLOCK
DMLP3	LXI	H,CMDB		;POINT TO COMMAND BYTE
	MVI	A,RECAL		;RECAL COMMAND
	MOV	M,A		;PUT IN COMMAND BLOCK
	JMP	FMCONT		;WHEW...NOW CONTINUE FORMAT
	;
	;
WRTERR	CALL	ERRPROC		;GO DO REQ. SENSE
	LXI	H,WRTERM+28	;DEST. OF ASCII BYTES IN ERRMSG.
	LXI	B,ASBUFF	;ASCII BUFFER
	MVI	D,0F5H		;COUNTER FOR 11 BYTES
WELP1	LDAX	B		;PUT ASCII BYTE IN A
	MOV	M,A		;PUT IT IN ERROR MSG.
	INX	H		;NEXT ERRMSG BYTE
	INX	B		;NEXT ASCII BYTE
	INR	D		;INC COUNTER
	JNZ	WELP1		;DONE YET?...BR IF NOT
	MVI	C,PSTRING	;BDOS FUNCTION 9
	LXI	D,WRTERM	;STRING ADD.
	CALL 	BDOS		;GO PRINT ERROR MESSAGE
	;
	;
	;NOW GO TO NEXT SECTOR AND CONTINUE...
	;UNLESS ERROR COUNT HAS EXPIRED.
	;
	;
	LXI	H,ERRCTR	;ERROR COUNTER
	MOV	A,M		;PUT IN A
	INR	A
	MOV	M,A		;PUT IT BACK
	JNZ	WTRT		;CONTINUE IF ERR CTR ISN'T EXPIRED
	MVI	C,PSTRING	;BDOS FUNCTION 9
	LXI	D,ABTM		;ABORT MESSAGE
	CALL	BDOS		;PRINT ABORT MESSAGE
	RET			;BACK TO MENU
			;
	;
	;
	;  MESSAGES
	;
	;
	;
TITLM	DB	CR,LF,LF,LF,'          XEBEC HARD DISK FORMAT UTILITY'
	DB	CR,LF,'          REV. 2.1  06-02-83 $'
OPTNM	DB	CR,LF,LF,'          WHICH DISK TO FORMAT (C OR D)?'
	DB	CR,LF,'          (OR HIT ESC TO REBOOT) $'
WARNM	DB	CR,LF,LF,'     WARNING...FORMATTING WILL DESTROY DATA'
	DB	CR,LF,'     ON THIS DRIVE...TYPE Y TO CONTINUE OR...'
	DB	CR,LF,'     ESC TO REBOOT...? $'
FORMCM	DB	CR,LF,LF,'     FORMATTING COMPLETE  $'
ABTM	DB	CR,LF,LF,'     EXCESSIVE ERRORS...FORMAT ABORTED  $'
ABTM1	DB	CR,LF,LF,'     FORMAT ABORTED DUE TO RECAL ERROR $'
RECERM	DB	CR,LF,'RECAL ERROR!  SENSE BYTES 00 00 00 00$'
FORERM	DB	CR,LF,'FORMAT ERROR!  SENSE BYTES 00 00 00 00$'
WRTERM	DB	CR,LF,'WRITE ERROR!  SENSE BYTES 00 00 00 00$'
	;
	;
	;
	;  BUFFERS
	;
	;
RBUF	DS	512
WBUF	DS	512
DRVNO	DB	0
ERRCTR	DB	0F0H
DRVCHAR	DB	0,0,0,0,0,0,0,0
RQSNS	DB	03,0,0,0,0,0
SNSBUF	DB	0,0,0,0
ASBUFF	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
DRVCHR: 

MXCLH    DB        MCH                 ;HIGH BYTE OF MXCL EQU
MXCLL    DB        MCL                 ;LOW BYTE OF MSCL EQU
LHD      DB        MXHD                ;MXHD EQU
RWCH     DB        RWH                 ;HIGH BYTE OF RWC EQU
RWCL     DB        RWL                 ;LOW BYTE OF RWC EQU
WPCH     DB        WPH                 ;HIGH BYTE OF WPC EQU
WPCL     DB        WPL                 ;LOW BYTE OF WPC EQU
MECC     DB        ECC                 ;ECC EQU

CMDB 
         DB        01H                 ;OPCODE
LUN      DB        0                   ;LUN & HIGH ADDRESS
MAD      DB        0                   ;MIDDLE ADDRESS
LAD      DB        0                   ;LOW ADDRESS
         DB        01H                 ;INTERLEAVE OR BLOCK COUNT
         DB        CNTRLB              ;CONTROL BYTE (FAST STEP OPT.)
CONTB    DB        0
         END
