/* Parser for TCL, a simple functional language to command
 Sam the turtle.  TCL source is 'compiled' into Actor source,
 and then parsed by Actor. */ !!

inherit(YaccMachine, #TCLParser, nil, 2, nil) !!



now(TCLParserClass)!!

now(TCLParser)!!

/* Action for primitives that take an 
  argument. */
Def doPrimVal(self)
{ yyVal := init( new(TCLMsgNode), 
  item(self,0), init(new(ItemList), 
  item(self,1)));
} !! 
 

/* Action for primitives that take no 
  arguments. */
Def doPrim(self)
{ yyVal := init( new(TCLMsgNode), 
  item(self,0), new(EmptyList));
} !! 
 

/* Action for function calls with 
  keywords. */
Def doFcall(self | keys )
{ keys := item(self,2);
  insert(keys, item(self,1));
  yyVal := init( new(TCLMsgNode), 
    item(self,0) + nameString(keys), 
    keys);
} !!

/* Action for a keyWord argument. */
Def doKeyArg(self)
{  yyVal := init( new(TCLArgNode),
  "_" + item(self,0), init(new(ItemList), item(self,1))) ;
} !!

/* Action for a keyWord argument list. */
Def doKeyList(self)
{ yyVal := add( item(self,0), item(self,
  1));
} !! 
 

/* Action for assignment statements. */
Def doAssgn(self)
{ yyVal := init( new(TCLAssgnNode), 
  item(self,0), item(self,2)) ;
} !!

/* Action for the do statement. */
Def doDo(self)
{ yyVal := init( new(TCLDoNode), 
  item(self,1), item(self,2));
} !!

/* Action for a single statement. */
Def doStmt(self)
{ yyVal := init( new(StmtList), 
  item(self, 0)) ;
} !!

/* Action for a statement list. */
Def doStmtList(self)
{ yyVal := add( item(self,0), item(self,
  2)) ;
} !! 
 

/* Action for a new function definition. 
  */
Def doDef(self)
{ yyVal := init( new(TCLDefNode), 
  item(self,1), item(self,2), item(self,
  3), item(self,4)) ;
} !! 
 

/* Compile the function definition just 
  parsed. */
Def doScriptDef(self)
{ TCLCompile(item(self,0));
} !!

/* Action for a no-argument function 
  def. */
Def doNoArgs(self)
{ yyVal := new(EmptyList);
} !! 
 

/* Action for a 1-argument function 
  def. */
Def doArg(self)
{ yyVal := init( new(TCLArgNode),
  "", init(new(ItemList), item(self, 0)));
} !!

/* Action for an infix expression. */
Def doInfix(self)
{ yyVal := init( new(TCLInfixNode), 
  item(self,0), item(self,2), item(self,
  1)) ;
} !!

/* Action for a locals declaration. */
Def doLocDef(self)
{ yyVal := item(self, 1);
} !!

/* Parse the string currently held by 
  the lexical analyzer. */
Def  parse(self)
{ TCLStream.collection :=
  "";
reset(TCLStream);
reset(lex);
clear(self);
acc := nil;
loop push(self);
  /*  print(tuple(st, ' ')); */
  newState(self);
while not(acc)
begin
endLoop;
^TCLStream.collection;
} !! 
 





Actor[#TParser] := new(TCLParser)!!
TParser.lex := new(TCLAnalyzer)!!

/* Compile and execute the parse tree 
  that was built. */
Def doScriptSlist(self)
{   TCLCompile( item(self,0));
} !! 
 

/* Action for a list of locals.  */
Def doLocList(self)
{ yyVal := add( item(self,0), item(self,
  1)) ;
} !!

/* Pass through a parenthesized value. */
Def doParen(self)
{ yyVal := item(self, 1);
} !! 
 

/* Action for an n-argument function def. 
  */
Def doArgList(self)
{ yyVal := insert(item(self,1), 
  item(self,0));
} !! 
 
               