/* A Set is a collection of unique objects.  There is a
 maximum of one instance of any given object.  Any kind
 of object can be a member of a set.

 The major operation for Set objects is membership, which
 is implemented with the in operator.  For instance,
 3 in Set(3 4 5) returns true.  */!!

/*  inherit(Collection, #Set, #(tally ), 2, 1) */ !!

now(class(Set))!!

now(Set)!!

/* Evaluate the one-argument block over the
  elements of the Set.  */
Def do(self, aBlock)
{ ^do( new(Interval, 0, limit(self), 1),
      {using(x |val)
       if (val := at(self:Object, x))
       then eval(aBlock, val);
       else nil
       endif;
      });
}!!

/* Return the receiver with more room for added elements. */
Def  grow(self | newSet)
{       newSet := new(class(self), limit(self) + 12);
        do(self,
          {using(elem)  add(newSet, elem)
          });
        swap(self, newSet);
} !!

/* Evaluate the one-argument block over the
  keys of the receiver.  The keys of a set are
  string versions of the physical indices of the
  elements.  For instance, if an element of the
  receiver is located at physical index 7, then
  the string "7" will be treated as the key and
  "7" will be the block argument.  */
Def keysDo(self, aBlock)
{ ^do(over(0,limit(self)),
      { using(idx)
        if self:Object[idx]
        then eval(aBlock, asString(idx, 10))
        endif;
      });
}!!

/* Re-hash all the elements of the Set.
  This needs to be done after deleting an entry
  because other hash values might need to
  occupy the empty slot.  */
Def fixUp(self, idx | nextIdx, newIdx, elem, val, lim)
  { nextIdx := idx;
  lim := limit(self) - 1;
  loop
    nextIdx := (if nextIdx == lim
    then  0
    else  nextIdx + 1
    endif)
  while   (elem := at(self:Object, nextIdx))
  begin     newIdx := find(self, elem);
    if not(at(self:Object, newIdx))
    then
      put(self:Object, nil, nextIdx);
      put(self:Object, elem, newIdx);
    endif;
  endLoop;
  }!!

/* Removes the specified element from the
  receiver Set.  */
Def remove(self, anElement | idx)
  {
  if not( at(self:Object, idx := find(self, anElement)))
  then  error(self, stackTop(0), #elemNotFndError);
  endif;
  put(self:Object, nil, idx);
  fixUp(self, idx);
  tally := tally - 1;
  ^anElement;
  }!!


/* Find and return the physical index of the
  specified set element or the first empty
  position if the element is not in the Set.  */
Def find(self, elem | idx, siz, obj)
  { idx := hash(elem) mod (siz :=   limit(self));
  loop
  while (obj := at(self:Object, idx))
  begin
    if elem = obj
    then ^idx;
    endif;
    if (idx := idx + 1) >= siz
    then idx := 0;
    endif;
  endLoop;
  ^idx
  } !!

/* Add an object to the Set, if there 
  isn't one already there.  */
 Def add(self, anElement | idx)
{
  if tally >= (limit(self) - 1)
  then grow(self)
  endif;
  if not(at(self:Object, idx := 
    find(self:Set, anElement)))
  then put(self:Object, anElement, idx);
    tally := tally + 1;
  endif;
}!!


/* Return true (specifically, return
  anElement) if anElement is a member of
  the Set. */
Def in(self, anElement)
  {  ^at(self:Object, find(self:Set, anElement));
  } !!

/* Return the current number of elements in
  the receiver.  */
Def size(self)
{ ^tally
}!!

/* Initialize the Set by setting the
  tally instance variable to zero. */
Prim init(self):Set!!
