/* A RndRect looks a lot like a Rectangle, but its corners
 are rounded.  Exactly how rounded the corners are is
 dependent on what MS-Windows calls the "radius of
 curvature."  Basically it has to do with the size of the
 ellipse that the corners are made from.  You can specify
 both x and y radii of curvature independently.  */!!

inherit(Rect, #RndRect, nil, nil, nil) !!

now(class(RndRect)) !!

/* Create and return a new RndRect.  */
Def new(self)
{ ^variableNew(self:Behavior, 12);
}!!


now(RndRect) !!

/* Draw the RndRect using the specified handle
  to a display context. */
 Def draw(self, hdc)
{ Call RoundRect(hdc, left(self),
    top(self), right(self), bottom(self),
    xCurve(self), yCurve(self))
}!!

/* Sets the radius of curvature for the
  RndRect according to the specified Point
  argument.  The x curvature is in the x
  value of the point, and the y curvature
  is in the y value of the point.  */
 Def setCurve(self, aPoint)
{ setXCurve(self, aPoint.x);
  setYCurve(self, aPoint.y);
}!!

/* Sets the x radius of curvature for the corners
  of the RndRect. */
Def setXCurve(self, x)
{ putWord(self:Struct, x, 8)
}!!


/* Sets the y radius of curvature for the corners
  of the RndRect. */
Def setYCurve(self, y)
{ putWord(self:Struct, y, 10)
}!!

/* Return the x radius of curvature for the corners
  of the RndRect.  */
Def xCurve(self)
{ ^asInt(wordAt(self, 8));
}!!


/* Return the y radius of curvature for the corners
  of the RndRect.  */
Def yCurve(self)
{ ^asInt(wordAt(self, 10));
}!!

/* Initialize the RndRect.  The left,
  top, right, and bottom arguments
  specify the origin and the corner of
  the rectangle, while the x and y
  arguments specify the radii of curvature
  for the corners.  */
 Def  init(self, left, top, right, bottom, x, y)
{ init(self:Rect, left, top, right, bottom);
  setXCurve(self, x);
  setYCurve(self, y);
}!!
                                                                                         