/*  Procs are objects defining dynamically-linked library procedures.
  They descend from Struct for space efficiency.
  Data format:   0 | args byte   |
                 2 | proc offset |
                 4 | proc seg    |    */ !!

inherit(Struct, #Proc, nil, 0, 1) !!



now(class(Proc));!!

/* Return a new Proc object.  */
Def new(self)
{  ^variableNew(self:Behavior, 6);
}!!

now(Proc);!!

/*  Set up the arguments and return value byte
  of the external function.  The first argument,
  rType, indicates whether the return value of
  the external function is a word or a long
  (0=word, 1=long).  The second argument, args,
  is a collection which indicates the byte/word
  status of each parameter.  Each element in args
  follows the same convention as rType.
  Example: setArgs(aProc, 0, #(0 1 1)); */
Def setArgs(self, rType, args | argwd, amask)
{ argwd := 0;
  amask := 16;
  do(args,
  {using(x)  argwd := argwd + (x *
    amask);
    amask := amask * 2;
  });
  argwd := argwd + (rType * amask);
  argwd := argwd + size(args);
  putWord(self, argwd, 0);
} !!


/*  Set the address of the Proc with a
  long received from Call GetProcAddress(...). */
Def setAddr(self, addr)
{ putLong(self, addr, 2);
} !! 
 
