/* Point objects are atomic objects with two instance
 variables, x and y.  They hold the x and y coordinates of
 the Point, respectively.

 Points are displayed in the form x@y, such as 44@33, -23@2,
 etc.  You can specify literal points this way, too.

 The methods of this class are used to connect Points
 together to make lines.  In addition, Points are useful
 whenever you need to combine two objects together as a
 packet (a particular row-column pair, for instance). */!!

inherit(Object, #Point, #(x /* The x value of the Point, e.g. 3 in 3@2 */
y /* The y value of the Point, e.g. 2 in 3@2 */), 2, nil) !!

now(class(Point)) !!

now(Point) !!

/* Print the Point in x@y format
  onto the specified stream. */
Def printOn(self, aStrm)
{ printOn(x, aStrm);
  nextPutAll(aStrm, "@");
  printOn(y, aStrm);
}!!

/* Change the current window position to
  be the receiver point using the specified
  handle to a device context. */
 Def moveTo(self, hdc)
{ Call MoveTo(hdc, asInt(x), asInt(y))
}!!


/* Return the x value of the receiver
  point. */
Def x(self)
{ ^x
}!!

/* Return the y value of the receiver
  point. */
Def y(self) { ^y }!!

/* Draw a line from the current position
  up to, but not including, self, using
  the specified handle to a display context.
  Reset the current window position
  to be the receiver Point. */
Def lineTo(self, hdc)
{ Call LineTo(hdc, asInt(x), asInt(y))
}!!

/* Draw a line from self to aPoint
  using the specified handle to a
  display context.  Reset the current
  window position to be aPoint. */
Def line(self, aPoint, hdc)
{ Call MoveTo(hdc, asInt(x), asInt(y));
  lineTo(aPoint, hdc);
}!!

/* Draw the point on the screen.  Since
  drawing a Point is not really defined,
  this method is included for completeness.
  It actually draws a very small rectangle. */
Def draw(self, hdc)
{	Call Rectangle(hdc, x, y, x, y);
}!!

/* Return a hash value equal to the hash
  value of x XORed with the hash value of
  y.  */
 Def hash(self)
{ ^(hash(x) bitXor hash(y))
}!!


/* Equals.  Two Points are equal to one
  another if their x instance
  variables are equal and their
  y instance variables are equal. */
Def =(self, aPt)
{ ^if class(aPt) == Point
  then x = aPt.x and y = aPt.y
  else nil
  endif;
}!!

