/* Magnitude is the abstract, formal ancestor class for
 all classes whose instances are atomic and can be
 compared with each other, such as the Number classes and
 the Char class.  If a class's instances are atomic and it
 is logical to say that one instance is greater than or
 less than another, then Magnitude should probably be the
 parent class of such a class.  */ !!

inherit(Object, #Magnitude, nil, 2, nil) !!

now(class(Magnitude))!!

now(Magnitude)!!

/* Return true if self is in the range
  defined by min and max, inclusive.  For
  example, between('c','a','f') returns
  true, whereas between(4,15,28) returns
  nil.  Note that max must be greater than
  min, i.e. between(3,10,0) returns nil. */
 Def between(self, min, max)
{ ^min <= self and self <= max;
}!!

/* Return the minimum of self and
  anObject.  For example, min('c','e')
  returns 'c'.  */
Def min(self, anObject)
{
  if self <= anObject
  then ^self
  else ^anObject
  endif;
}!!


/* Return the maximum of self and
  anObject.  For example, max('c','e')
  returns 'e'.  */
Def max(self, anObject)
{
  if self >= anObject
  then ^self
  else ^anObject
  endif;
}!!

setAncestor(Char, Magnitude)!!

