/* The ListBox class creates and manages all the ListBox
  controls.  A ListBox is a window with a vertical list of
  elements which can be scrolled using the scrollbar and
  selected using the mouse.  All Actor file dialogs, class
  lists, method lists, etc. are managed using the methods from
  this class.  */!!

inherit(Control, #ListBox,
#(selIdx /* An integer containing the index of the selected item */
selStr   /* String representation of currently selected item */), nil, nil) !!

now(class(ListBox)) !!

/* Create a new list box object in Actor and Windows.
  Parent passes itself and the control ID. */
Def  new (self, id, par | theLB)
{	theLB := new(self:Behavior);	/* create object */
	setVars(theLB, id, par);
	create(theLB, nil, "ListBox", LBS_STANDARD + WS_CHILD);
	if handle(theLB) = 0
	then error(self, stackTop(), #wCreateError);
	endif;
	^theLB;
} !!

now(ListBox) !!

/* Set the instance variables of the ListBox.  */
Def  setVars(self, id, par)
{	selStr := new(String, 30);
	contID := id;
	parent := par;
} !!

/* Clear the contents of the ListBox. */
Def  clearList(self)
{	^sendMessage(self, LB_RESETCONTENT, 0, 0)
} !!

/* Add aStr to the ListBox, maintaining sorted order, and
  return its index. */
Def  addString(self, aStr )
  { ^sendMessage(self, LB_ADDSTRING, 0,
  asciiz(aStr));
  } !!


/* Add aStr to the ListBox at the specified idx,
  overriding the sorted order and return its index.
  If idx=-1, aStr is added to end of ListBox. */
Def   insertString(self, aStr, idx)
  { ^sendMessage(self, LB_INSERTSTRING, idx,
  asciiz(aStr));
  } !!

/* Set the current selection to idx. */
Def	setCurSel(self, idx)
{	^sendMessage(self, LB_SETCURSEL, idx, 0)
} !!

/* Set the current selection to whatever was the
  last selected item. */
Def	setLastSel(self)
{	if selIdx
	then ^setCurSel(self, selIdx)
	endif
} !!

/* Return the index of whatever item is
  currently selected and set selIdx.
  Return nil if no item is selected. */
Def   getSelIdx(self | idx )
{	idx := sendMessage(self, LB_GETCURSEL, 0, 0);
	if idx = LBN_ERR
	then ^nil
	else ^selIdx := idx
	endif
} !!

/* Select the specifed string if possible.
  Set and return selIdx.  Return nil if
  selecting aStr doesn't work. */
Def   selectString(self, aStr | idx, len )
{	idx := sendMessage(self, LB_SELECTSTRING, -1, asciiz(aStr));
	if idx = LBN_ERR
	then ^selIdx := nil
	else ^selIdx := idx
	endif
} !!

/* Return the selected string.  Return nil if
  none is selected. */
Def   getSelString(self | idx, len )
{	if idx := getSelIdx(self)
	then len := sendMessage(self, LB_GETTEXT, idx, selStr);
			^subString(selStr, 0, asInt(len));
	else ^nil
	endif
} !!

