/* IndexedCollection is a formal class which provides methods
 used by all the indexed collections, such as Array,
 OrderedCollection, and ByteCollection.  An IndexedCollection's
 elements accessed by integer subscripts, such as Sam[5].
 The subscripts serve as physical indices, or offsets, into
 the collection.  All indices start at 0. */  !!

/* inherit(Collection, #IndexedCollection, nil, nil, nil) */!!

now(class(IndexedCollection)) !!

now(IndexedCollection) !!

/* Evaluate the block over the
  indexed collection. */
 Def do(self, aBlock)
{       ^do( new(Interval, 0, size(self),
  1),
  {using(idx)  eval(aBlock, at(self, idx))
  });
}!!

/* Return suitable species for cloning,
  etc.--OrderedCollection.  If a descendant
  class doesn't redefine species, the
  species of an IndexedCollection is
  OrderedCollection.  */
 Def species(self)
{ ^OrderedCollection
}!!

/* Evaluate a one-argument block over
  the keys of the receiver.  In an
  IndexedCollection, the keys are the
  integer indices of the collection, and
  thus are probably of little interest.
  However, keysDo is provided so that any
  collection can respond to keysDo. */
 Def keysDo(self, aBlock)
{       ^do( over(0,limit(self)),
  { using(idx)  eval(aBlock, asString(idx,
    10))
  });
}!!



/* Return true if one indexed collection
  is equal to another.  Two indexed
  collections are considered equal if all
  their elements are equal.  By
  definition, if two indexed collections
  are not the same size, then they
  cannot be equal. */
 Def =(self, coll)
{
  if size(self) ~= size(coll)
  then ^nil
  endif;
  do(size(self),
  {using(i)
    if not(self[i] = coll[i])
    then ^nil
    endif;
  });
}!!

/* Return the hash value of an indexed
  collection.  It is computed by by XORing
  the hash values of its elements and
  then producing an Int. */
 Def hash(self | sum)
{ sum := 1;
  do(self,
  { using(elem) sum := sum * 2 bitXor
    hash(elem);
  });
  ^asInt(sum bitAnd 0x3fff);
}!!

/* Return a new collection that is the
  result of applying the one-argument block
  to each of the receiver's elements.  The
  new collection is the same size and class
  as the receiver. */
 Def map(self, aBlock | coll idx)
{ coll := new(class(self), size(self));
  idx := 0;
  do(self,
  {using(elem)  coll[idx] := eval(aBlock,
    elem);
    idx := idx + 1;
  });
  ^coll;
}!!

/* Reverse the collection in place (that is, the
  collection itself is altered) and return self.  */
Def  reverse(self | j)
{       j := size(self) - 1;
        do(new(Interval,0,(j+1)/2,1),
                {using(i | a)  a := self[i];
                        self[i] := self[j-i];
                        self[j-i] := a;
                });
}!!