/* DebugDialog displays the stack activation records that led
  up to an error, and allows any of them to be converted into
  Context object and Inspected by double clicking on them. */  !!

inherit(ModalDialog, #DebugDialog,
#(message /* The caption string for the dialog */
basePtr /* The address of the top activation record in the dialog */
), 2, nil) !!

now(class(DebugDialog)) !!

/* Create and show a modal dialog that
  announces an Actor error. */
Def new(self, resID, parent, msg |
  theDlg)
{ setDialog(theDlg :=
  new(self:Behavior));
  theDlg.message := msg;
  Call DialogBox(HInstance, resID,
    handle(parent), LpDFunc);
  ^0
} !!


now(DebugDialog) !!

/* Convert an activation to a Context
  and start an Inspector to inspect it.
  This occurs when the user double-clicks
  on an activation.
  */
Def inspectContext(self | recs, bp)
{ recs := asInt(Call
  SendDlgItemMessage(handle, ERR_LB,
  LB_GETCURSEL, 0, 0));
  bp := basePtr;
  do(recs,
  {using(i) bp := stackLink(bp);
  });
  inspect(new(Context, bp));
} !!

/* Fill the newly created dialog's
  listbox with a series of items
  corresponding to stack activation
  records.  These items were built in the
  Debugger via a fill(bp) message. */
Def WM_INITDIALOG(self, wp, lp)
{ do(Bug.frames,
  { using(aStr) Call
    SendDlgItemMessage(handle, ERR_LB,
    LB_INSERTSTRING, -1, asciiz(aStr))
  });
  basePtr := Bug.basePtr;
  setText(self, message);
  ^1
} !!



/* The only events that can occur are
  the OK button or a ListBox item being
  selected.  This method handles those
  events.  */
Def WM_COMMAND(self, wp, lp)
{
  select
    case wp = IDOK
    is Bug.frames := nil;
		Call EndDialog(handle, 1);
    endCase
    case wp = ERR_LB and  high(lp) = 2
    /* LBN_DBLCLK */
    is  inspectContext(self)
    endCase
  endSelect;
  ^1
} !!




