/* Behavior describes the behavior of all classes considered
  as objects.  The inheritance scheme is implemented in Behavior,
  as are many of the new methods for the various classes.  */     !!


/* inherit(Object, #Behavior, #(
ancestor
methods
variables
format
fileName
name),
nil, nil) */!!

now(class(Behavior))!!

now(Behavior)!!

/* Add all of the receiver's ancestors to
  a collection, including the receiver. */
Def  addAncestors(self, aColl)
{ if ancestor
  then addAncestors(ancestor, aColl);
  endif;
  add(aColl, self);
  ^aColl;
} !!

/* Return an OrderedCollection of the
  receiver and its ancestors in inheritance
  order. */
Def  ancestors(self | oc)
{ oc := new(OrderedCollection, 20);
  ^addAncestors(ancestor, oc);
} !!

/* Return true if aClass is an ancestor
  of or == receiver. */
Def  isAncestor(self, aClass)
{ ^aClass in addAncestors(self, new(Set,
  20));
} !!


/* Return an OrderedCollection containing this class's
  inherited and own variables, in inheritance order.  */
Def variables(self)
{ ^addVariables(self, new(OrderedCollection, 20));
}!!

/* Add all the receiver's own and
  inherited variables to a collection. */
Def addVariables(self, coll)
{ if ancestor ~= Object
  then addVariables(ancestor, coll);
  endif;
  do(variables,
  { using(var) add(coll,var);
  });
  ^coll;
} !!

/* Perform a block over each of the
  receiver's descendants.  Requires a
  dictionary produced by buildClassLists as
  the first argument.  The two-argument
  block receives a descendant and a level
  at each invocation.  Level is incremented
  at each level of inheritance. */
Def  descendantsDo  (self, aDict, aBlock, level)
{ eval(aBlock, self, level);
  do(aDict[self],
  { using(elem)  descendantsDo(elem,
    aDict, aBlock, level+1)
  })
} !!


/* Return an Ordered Collection
  containing the descendants of the
  receiver in inheritance order.  */
Def descendants(self | list oc)
{ oc := new(OrderedCollection, 20);
  descendantsDo(self, buildClassLists(Actor),
  {using(cl, lev) add(oc, cl)
  }, 0);
  ^oc;
} !!

/* Given the parameters for an inherit
  message, determine the names, if any, of
  classes that should be recompiled.  The
  receiver is the ancestor specified in the
  inherit, and it finds if there are
  existing descendants with similar names
  but dissimilar properties. */
Def shouldCompile(self, cl, ivars, fmt, idxFlag | oldCl )
{ if (oldCl := Actor[cl])
  then
    if oldCl.ancestor == self and (ivars
      = oldCl.variables) and
      (bldFormat(self, fmt, idxFlag) =
      (oldCl.format bitAnd -512 bitAnd fmt_pmask) or not(fmt
      or idxFlag))
    then ^nil
    else ^collect( descendants(oldCl),
      {using(c) c.name
      });
    endif;
  else ^nil
  endif;
} !!


/* Print the name of the class onto the specified stream.  */
Def printOn(self, aStrm)
{ nextPutAll(aStrm, name)
}!!

/* Classes respond to < and > so they they can
  be sorted in SortedCollections.  Comparison is based on name. */
Def >(self, aCl)
{ ^aCl.name > name;
} !!


/* Classes respond to < and > so they can
  be sorted in SortedCollections.  Comparison is based on name. */
Def <(self, aCl)
{ ^aCl.name < name;
} !!

/* Define a new descendant class of the receiver.  If
  a class by this name already exists, ask
  shouldCompile to see if ivars, ancestor or format
  have changed.  If so, announce with a warning
  message.  The existing class's object pointer is used
  in any case, so as to preserve early-bound references
  to existing functions.  */
Def inherit(self, clName, ivars, fmt, idx | col, theClass, theMeta, theDict)
{ initCache();
  if (format bitAnd fmt_ptrs = 0) and ivars
  then error(self, stackTop(), #ivarsError);
  endif;
  if not(theClass := Actor[clName])
  then  theMeta := new(Meta);
    theMeta.name := asSymbol(clName +
    "Class");
    theClass := new(theMeta);
    theClass.name := clName;
    Actor[clName] := theClass;
  endif;
  setAncestor(theClass, self);
  theClass.format := bldFormat(self, fmt, idx);
  theClass.variables := ivars;
  setFixedVars(theClass, fixedVars(self) +
    size(ivars));
  if (col := shouldCompile(self, clName, ivars, fmt,
    idx))
  then print(
    "***** Warning: classes should be recompiled:");
    print(col);
    print(
    "***** Remove existing instances");
  endif;
} !!


/* Return the index of a named instance
  variable in the receiver, including any
  inherited instance variables.  This treats an object
  like an array, in which each cell has a
  name.  System use only. */
Prim findVar(self, symbol):Int !!

/* Return the number of named instance
  variables in objects that have the
  receiver as their class.  */
Prim fixedVars(self):Int !!

/* Return the function or primitive that
  corresponds to a given name in the
  receiver's method dictionary, or nil if
  not found. */
Prim method(self, symbol):method !!

/* Create a new instance of the receiver
  as an atomic object. */
Prim new(self):instance !!

/* Set the current class for which
  methods are to be compiled as the
  receiver. */
Prim now(self):self !!

/* Return a new instance of the receiver.
  For non-atomic classes only.  Collections
  re-implement new to call variableNew.  */
Prim variableNew(self, size):instance !!

/* Return true (specifically, return the
  method itself) if a method with the specified
  name aSym exists in the method dictionary of
  the receiver class.  For instance,
  findFunction(Behavior, #findFunction) returns
  Behavior:findFunction, whereas
  findFunction(Behavior, #joe) returns nil.
  Equivalent to the statement aClass.methods[aSym].
  Used in the error handling process to see if an
  error handling routine is defined.  */
Prim findFunction(self, aSym):Boolean!!

/* Determine the proper file name for
  this class's source code, and return it. */
Def  getFileName(self)
{ ^subString(name, 0, 8) + ".cls";
} !!

