        title   'ADAPTEC hard disk controller & Seagate 412 drive'


 ;      *****************************************************
 ;      *                                                   *
 ;      *       NOTE:                                       *
 ;      *                                                   *
 ;      *       DO NOT MODIFY ANY CODE IN THIS MODULE       *
 ;      *                                                   *
 ;      *        PMC CANNOT SUPPORT ANY MODIFICATIONS       *
 ;      *                                                   *
 ;      *****************************************************

 ;              'DISKIOH'
 ;              ' Copyright (C), 1983   Personal Micro Computers, Inc.'
 ;              ' 475 Ellis St. Mountain View, CA  94304'
 ;              ' version 3.0      07 FEB. 1984 '


 ;10/01/83      created
 ;02/07/84      no changes
 ;??/??/??


        maclib  z80
        maclib  ports
        maclib  pmcequ

 public f$Hread, f$Hwrite, f$Hlogin, f$Hinit, ID
 extrn  @rdrv, @adrv, @dma, @dbnk, @trk, @sect, @ermde, @cbnk, @type
 extrn  RWdon

        dseg

 ;********************
 ; Initialization entry point. called for first time initialization.
 ;
 ;********************

f$Hinit:
f$Hlogin:
        ret             ;no initialization or login required

 ;********************
 ; disk READ and WRITE entry points.
 ; these entries are called with the following arguments:
 ; relative drive number IN @rdrv (8 bits)
 ; absolute drive number IN @adrv (8 bits)
 ; disk transfer address IN @dma (16 bits)
 ; disk transfer bank   IN @dbnk (8 bits)
 ; disk track address   IN @trk (16 bits)
 ; disk sector address  IN @sect (16 bits)
 ; pointer to DPH IN <DE>
 ; they transfer the appropriate data, perform retries if necessary,
 ; then return an error code IN <A>
 ;********************

f$Hread:
        lxi     h,RDcmd
        jr      f$rw$common
f$Hwrite:
        lxi     h,WRcmd
f$rw$common:
        shld    cmdptr
        inx     h

        lda     @rdrv           ;get drive code
        ani     0000$0111b      ;get ID bits
;       jrz     ID0             ;if 0 then =ID 0
        mov     b,a             ;convert binary number to ID bit
        inr     b               ;0=ID0=set bit 0
        xra     a
        stc
nxt$ID: ralr    a               ;RL A
        djnz    nxt$ID
ID0:
        sta     ID
        lda     @rdrv           ;get drive code
        ani     0011$0000b      ;mask out ID bits
        res     5,m
        ora     m               ;set new drive
        mov     m,a             ;save new drive select

                        ;Algorithm to calc Phy SPT from any DPB!!
        lxi     h,12            ;offset to DPB
        dad     d
        mov     e,m             ;get DPB from DPH
        inx     h
        mov     d,m     
        xchg                    
        mov     e,m             ;get logical SPT from DPB       
        inx     h
        mov     d,m
        dcx     h
        push    d               ;save SPT count
        lxi     d,15            ;offset to PSH (shift factor)
        dad     d
        pop     d               ;restore SPT count
        mov     a,m             ;get PSH from DPB       
        ora     a               
        jrz     noshift         ;if 0 shift factor then skip
        mov     b,a
shftlp:                 ;b=shift factor, de=Log SPT
        srlr    d               ;16 bit shift (MSB)
        rarr    e               ;             (LSB)
        djnz    shftlp  
noshift:
        lxi     h,0             ;calculate virtual sector#
        lbcd    @trk
calc$lp:
        mov     a,b
        ora     c
        jrz     no$calc
        dad     d               ;DE=SPT from dpb
        dcx     bc
        jr      calc$lp
no$calc:
        lded    @sect           ;add in sector count
        dad     d
        xchg                    ;DE=logical sector
        lhld    cmdptr
        inx     h               ;->Msb (cannot have)
        inx     h               ;->mSB
        mov     m,d             ;save
        inx     h               ;->LSB
        mov     m,e             ;save
driver:                         ;H=ptr->cmd$
        call    wakeup
        lhld    cmdptr
        call    send
        call    waitrq
        bit     4,a
        jrnz    getsta
        ani     HDio
        lxiy    Hwrite
        jrz     do$it
        lxiy    Hread
do$it:  
        call    execute
getsta: call    status
        jrc     driver
        rz
        call    wakeup
        lxi     h,sense
        call    send
        call    waitrq
        lxi     h,ercode
        call    Hread
        call    status
        mvi     a,-1
        sta     endsta
        ret

wakeup:
        in      HAstat
        ani     HDbusy
        jrnz    wakeup
        lda     ID              
        out     HAdata
        out     HAack
        mvi     a,HDselect
        out     HActrl
ckbusy: in      HAstat
        ani     HDbusy
        jrz     ckbusy
        mvi     a,00            ;release SEL line once BUSY is active
        out     HActrl
        ret

send:
        call    waitrq
        bit     4,a
        rz
        ani     HDio
        rnz
        mov     a,m
        out     HAdata
        out     HAack
        inx     h
        jr      send


        cseg
 ;************************
execute:                        ;must reside in cseg
        lhld    @dma
        mvi     c,HAdata
        lda     @dbnk           ;set DMA bank
        ora     a
        jrz     exec$1
        dcr     A
        ori     80H             ;set hi bit if not bank 0
exec$1: out     p$bankselect
        pciy
Hread:
        in      HAstat
        rlc
        jnc     Hwrite
        ani     HDcd shl 1
        jnz     RWdon
        ini
        out     HAack
        jr      Hread

Hwrite:
        in      HAstat
        rlc
        jnc     Hwrite
        ani     HDcd shl 1
        jnz     RWdon
        outi
        out     HAack
        jr      Hwrite

 ;**************************
        dseg

status:
        call    waitrq
        in      HAdata          ;read status byte
        out     HAack
        sta     endsta
        call    waitrq
        in      HAdata          ;read message byte
        out     HAack
        lda     endsta
        ani     HDbsybit
        jrz     notbsy
        stc
        ret
notbsy:
        lda     endsta
        ana     a
        ret

waitrq:
        in      HAstat
        bit     7,a
        jrz     waitrq
        ret

ID:     db      0
cmdptr: dw      00
endsta: db      0
ercode: db      0,0,0,0
sense:  db      003h,000h,000h,000h,000h,000h
rdcmd:  db      008h,000h,000h,000h,001h,000h
wrcmd:  db      00Ah,000h,000h,000h,001h,000h
                ;    |    |    |    |    |____reserved
                ;    |    |    |    |_________number of blocks
                ;    |    |    |______________block adr LSB
                ;    |    |___________________          mSB
                ;    |________________________ 4->0 =   MSB     bits 7->5=LUN  

        end

