static char vj_regHSid[]="@(#)vj_reg.h	30.1 3/13/91 AppEng/SCCS Interphase";

/* in vi :set ts=4
 **** REVISION HISTORY:
 **   DATE     ID    VER     COMMENT
 ** 03/13/91 rbrant 30.1     New development/distribution format.
 ** 03/13/91  jdb   23.13    added ioctl defines for reading 
                             defect list from drives
 ** 12/18/90  jdb   23.13    added support for Sony Magneto Optical drive
 ** 08/30/90  jqo   23.12    Bumped to new SBU/SCCS level.
 ** 08/15/90  JQO    3.12    Bumped SCCS version level to coincide with RCS 
 **                          version level 3.12 on  08/15/90 jqo
 ** 08/18/89         3.12    RCS
 **                  2.4     Support multiple major no.
 **                  2.2     Support GEMS HP DAT. 
 **                          Introduce several config line flags.
 **                  2.1     Multiple jaguar support.
 **
 ****/
/* ********************************************************************** */
/*      vjreg.h for NEW Jaguar 4210 V/SCSI support                        */
/* ********************************************************************** */

#define VJ_WSIZ (sizeof(VJ_IOPB)/sizeof(UWORD))  /* rnds 2 16 bit wrds*/

/* config line flags: */
#define VJ_2ND_SCSI_BUS			0x01	/* secondary SCSI bus		*/
#define VJ_NO_SYNC_XFER			0x02	/* suppressed sync xfer		*/
#define VJ_TAPE_FIXED_BLK		0x04	/* fixed block size for tape*/
#define VJ_FORCED_TAPE			0x08	/* a forced tape device     */
#define VJ_FORCED_DISK			0x10	/* a forced disk device     */

#ifndef NDKMAP
#	define NDKMAP		8
#endif
#define NLPART          NDKMAP      /* # of logical partitions (8)  */
#define SPECIAL_DEV_MASK  0x80
#define SPECIAL( dev )  ( (dev) & SPECIAL_DEV_MASK )
#define LPART(dev)      (minor(dev) & 0x7)
#define REWND_CHK(dev)	(minor(dev) & 0x1)	   /* Rewind-on-close	*/
#define NTRCK_CHK(dev)	(minor(dev) & 0x2)	   /* 9 -track drive	*/
#if GDAT
#define FIXED_CHK(dev)	(minor(dev) & 0x4)	   /* GDAT fixed partition */
#endif

#if MULT_MAJOR
/* These macros will calculate the drive to the proper controller */
/* and pass back the proper unit number.						  */
#define VJCNTNO(x)      (major(x))
#define VJUNITWC(x)     ((minor(x)>>3) & 0xF)
#define BPTOVJCNT(bp)   VJCNTNO(bp->b_dev)
#define BPTOVJNWC(bp)   VJUNITWC(bp->b_dev)
#define VJCHRORBLK(x)   (x < VJCHRMAJOR?VJBLKMAJOR:VJCHRMAJOR)
#define VJUNIT(dev)     (vjindex[VJCNTNO(dev) - VJCHRORBLK(VJCNTNO(dev))].\
                        ix[VJUNITWC(dev)])
#define BPTOVJN(bp)     (vjindex[BPTOVJCNT(bp) - VJCHRORBLK(BPTOVJCNT(bp))].\
                        ix[BPTOVJNWC(bp)])
#else
#define VJUNIT(x)       ((minor(x)>>3) & 0xF)
#define BPTOVJN(bp)     VJUNIT(bp->b_dev)
#endif

#define VJCTLR(un)      ((un)->un_ctlrno)
#define SECSIZE         512
#define SCTRSHFT        9			/* SECSIZE shift, for fast div and mults */
#define SECTORSIZE      SECSIZE

#if SOFT_GROUPING
#	define VJ_Q_SIZ       2			/* depth of work queues */
#else
#	define VJ_Q_SIZ       50		/* depth of work queues */
#endif

#define VJ_DISK_PRIORITY        1
#define VJ_DISK_SLOTS           VJ_Q_SIZ
#define MAX_WORK_QUEUES         15

#define VJ_SELECTION_TIMEOUT    1000 /* 1 Second                         */
#define VJ_RESELECTION_TIMEOUT  0    /* reserved for future iopb timeout                         */
#define VJ_INFINITE_TIMEOUT     0

#define ADRM_STD_S_P            0x3E    /*    Standard Supervisory Program  */
#define ADRM_STD_S_D            0x3D    /*    Standard Supervisory Data     */
#define ADRM_STD_N_P            0x3A    /*    Standard Normal Program       */
#define ADRM_STD_N_D            0x39    /*    Standard Normal Data          */
#define ADRM_SHT_S_IO           0x2D    /*    Short Supervisory IO          */
#define ADRM_SHT_N_IO           0x29    /*    Short Normal IO               */
#define ADRM_EXT_S_P            0x0E    /*    Extended Supervisory Program  */
#define ADRM_EXT_S_D            0x0D    /*    Extended Supervisory Data     */
#define ADRM_EXT_N_P            0x0A    /*    Extended Normal Program       */
#define ADRM_EXT_N_D            0x09    /*    Extended Normal Data          */

typedef struct mb_ctlr      MB_CTLR;
typedef struct mb_device    MB_DEVICE;
typedef struct dk_label     DK_LABEL;
typedef struct dk_map       DK_MAP;
typedef struct mb_hd        MB_HD;
typedef struct dk_geom      DK_GEOM;

#if sun2
#	define	DK_DEVLEN	16				/* device name max length, including */
										/* unit # & NULL (ie - "xyc1") */
	/*
 	 * Used for configuration info
 	 */
	struct dk_conf {
			char	dkc_cname[DK_DEVLEN];	/* controller name (no unit #) */
			u_short	dkc_ctype;				/* controller type */
			u_short	dkc_flags;				/* flags */
			short	dkc_cnum;				/* controller number */
			int		dkc_addr;				/* controller address */
			u_int	dkc_space;				/* controller bus type */
			int		dkc_prio;				/* interrupt priority */
			int		dkc_vec;				/* interrupt vector */
			char	dkc_dname[DK_DEVLEN];	/* drive name (no unit #) */
			short	dkc_unit;				/* unit number */
			short	dkc_slave;				/* slave number */
		};
#	define	DKIOCGCONF	_IOR(d, 126, struct dk_conf)	/* Get conf info */
#endif

typedef struct buf          BUF;

/* ********************************************************************** */
/*                                                                        */
/* Data per controller                                                    */
/*                                                                        */
/* ********************************************************************** */
typedef struct  ctlr {
    VJ_SHIO     *c_io;              /* ptr to I/O space                   */
    MB_HD       *c_md_hd;           /* for mbsetup                        */
    BYTE        c_present;          /* ctlr is present                    */
    BYTE        c_init;             /* is ctlr initialized?               */
    BYTE        c_nintvec;          /* normal int vector                  */
    BYTE        c_eintvec;          /* error int vector                   */
    BYTE        c_qintvec;          /* Queue Entry Available              */
    BYTE        c_level;            /* interrupt level                    */
    BYTE        c_wait_cqe;         /* waiting on room in CQE's           */
	BYTE		c_busy;				/* the board is busy				  */
    USHORT      c_ccount;           /* the number of commands on the board*/
	struct vj_unit *c_first;		/* head of the unit queue			  */
	struct vj_unit *c_last;			/* tail of the unit queue			  */
    VJ_IOPB    *c_mce_iopb;         /* Address of MCE IOPB                */
    VJ_CQE     *c_cqe_top;          /* Top pointer to CQE list            */
    VJ_CQE     *c_cqe_end;          /* End pointer to CQE list            */
    VJ_CQE      c_mce;              /* MCE structure                      */
    VJ_IOPB     c_miopb;            /* MCE IOPB structure                 */
    VJ_CIB      c_cib;              /* CIB structure                      */
    VJ_WQCF     c_wqcf;             /* WQCF structure                     */
    VJ_SBRF     c_sbrf;             /* SBRF structure                     */
	BUF			*c_splcmd[16];		/* vjsense() bp in vjeint(), per workq*/
    ULONG       c_qcount[16];       /* number of q entries used, per workq*/
    BYTE        c_qinit[16];        /* workq init flag					  */
	BYTE		c_pid;				/* ctlr's primary bus SCSI id		  */
	BYTE		c_sid;				/* ctlr's secondary bus SCSI id		  */
#if SOFT_GROUPING
	IPSG_FREE	*c_sg_hd;			/* points to next free entry		  */
	IPSG_FREE	c_sg_fentry[NUM_M_SG]; /* s/g free list					  */
	ULONG		c_sg_mbinfo;		/* mballoc cookie to index off of     */
#endif
} VJ_CTLR;

/* ********************************************************************** */
/*                                                                        */
/*   Definition of a unit or disk drive.                                  */
/*                                                                        */
/* ********************************************************************** */
typedef struct  vj_unit {
    INT         un_flags;           /* a copy of md_flags                 */
    DK_MAP      un_map[NLPART];     /* logical partitions                 */
    DK_GEOM     un_g;               /* disk geometry                      */
    UBYTE       un_present;         /* physical unit is present           */
    UBYTE       un_ready;			/* physical unit is ready             */
    BUF         un_rtab;            /* for raw I/O                        */
    BUF         un_sbuf;            /* for tape spl cmd                   */
    VJ_CTLR    *un_ctlr;            /* pointer back to controller         */
	BYTE		un_ctlrno;			/* unit's controller number			  */
	BYTE		un_active;			/* unit is on controller's queue	  */
	struct vj_unit *un_next;		/* next unit on the controller's queue*/
	BUF			*un_actf;			/* first buffer on unit queue		  */
	BUF			*un_actl;			/* last buffer on unit queue		  */
	BUF			*un_acts;			/* buffer on unit queue to sort after */
	UINT		un_iocnt;			/* number of I/O requests			  */
#ifdef NSTRIPE
    UBYTE       un_slave[NSTRIPE+1]; /* for two unit support              */
    UBYTE       un_workq[NSTRIPE+1]; /* Unit work Queue                   */
    VJ_IOPB     un_iopb[NSTRIPE+1]; /* IOPB structure                     */
#else
    UBYTE       un_slave;           /* for two unit support               */
    UBYTE       un_workq;           /* Unit work Queue                    */
    VJ_IOPB     un_iopb;            /* IOPB structure                     */
#endif
    INT         un_splpri;          /* spl value                          */
    UBYTE       un_burst;           /* Unit Burst Count                   */
    UBYTE       un_unit;            /* SCSI Unit Address                  */
    UBYTE       un_lun;             /* SCSI Logical Unit No               */
    ULONG       un_bcount;          /* tape block length size			  */
	ULONG		un_spc;				/* Number of sectors per cylinder     */
    UBYTE       un_retries;         /* Max retries on unit                */
    UBYTE       un_type;            /* unit/device type                   */
    UBYTE       un_opened;          /* lock against multiple opens        */
    UBYTE       un_mtflag;          /* unit is doing tape ioctl           */
    UBYTE       un_rwflag;          /* unit has done a read/write         */
    UBYTE       un_unxfmk;          /* flag for forward filemark          */
	UBYTE		un_locked;			/* removable medium locked flag		  */
	UBYTE		un_dir;				/* last tape motion direction		  */
    SCSI_EXT_SENSE  *un_sense;      /* points to extended sense data      */
	char		*un_spladdr;		/* address for ioctl commands         */
#if	GDAT
	UBYTE		un_gdat;			/* Genesis DAT dev (config flag 0x20) */
	UBYTE		un_part;			/* partition number					  */
#endif
	UBYTE		un_blackhole;		/* toggle vme black hole mode		  */
} VJ_UNIT;

#if MULT_MAJOR
/* This is an array that contains one entry for each controller   */
/* defined in the configuration file.  It will map the device     */
/* entry number to the unit number.								  */
/* ex. controller 0 = 0 1 2 3 4  5  ff ff ff ff ff ff ff ff ff ff */
/*     controller 1 = 6 7 8 9 a  b  ff ff ff ff ff ff ff ff ff ff */
/*     controller 2 = c d e f 10 11 ff ff ff ff ff ff ff ff ff ff */
/*     ...														  */
typedef struct  vj_index {
    UBYTE   ix[16];
} VJ_INDEX;
#endif

typedef struct  dev_driver {
    char        dr_revision[72];
} VJ_DRIVER;

typedef struct disk_partition {
    struct dk_map dk_part[NDKMAP];
} VJ_DKMAP;

/*
 *	Values for un_dir (last tape motion direction)
 */
#define	TAPE_FORWARD	0
#define	TAPE_BACKWARD	1

/*  SCSI IOPB definitions                                                 */
#define SCSI_PASS_THRU      0x20    /* SCSI Pass Through commands         */
#define SCSI_PASS_THRU_EXT  0x21    /* SCSI Pass Through Extended commands*/
#define SCSI_RESET          0x22    /* SCSI Reset bus                     */

/*  SCSI Control IOPB's                                                   */
#define CNTR_DIAG           0x40    /* Perform Diagnostics                */
#define CNTR_INIT           0x41    /* Initialize Controller              */
#define CNTR_INIT_WORKQ     0x42    /* Initialize Work Queue              */
#define CNTR_DUMP_INIT      0x43    /* Dump Initialization Parameters     */
#define CNTR_DUMP_WORDQ     0x44    /* Dump work Queue Parameters         */
#define CNTR_FLUSH_WORKQ    0x49    /* Flush Work Queue                   */

/*  Memory types                                                         */
#define MEMT_16BIT              1   /* 16 Bit Memory type                */
#define MEMT_32BIT              2   /* 32 Bit Memory type                */
#define MEMT_SHIO               3   /* Short I/O Memory type             */

/*  Transfer types                                                       */
#define TT_NORMAL               0   /* Normal Mode Tranfers              */
#define TT_BLOCK                1   /* Block  Mode Tranfers              */
#define TT_DISABLE_INC_ADDR     2   /* Disable Incrementing Addresses    */

/*  VME Direction                                                        */
#define WRITE_TO_VME            0   /* Data is Written to VMEbus         */
#define READ_FROM_VME           1   /* Data is Read from VMEbus          */


/* Unit/device types                             */
#define DT_DISK                 0x01
#define DT_TAPE          		0x02
#define DT_EXABYTE_TAPE         0x04
#define DT_PRINTER              0x08
#define	DT_WORM					0x10
#define	DT_REMOVABLE			0x20
#define DT_EXT_RW				0x40	/* use extended(10-byte) cdb for rw */
#define DT_SONY_MO				0x80	/* SONY MAGNETO OPTICAL DRIVE */

#define VJIOSOPEN       _IO(d, 18)      /* Special open                     */
#define VJIONOPEN       _IO(d, 19)      /* Normal open                      */
#define VJIOFORMAT      _IO(d, 20)      /* ioctl Format unit                */
#define VJIOBLACKHOLE   _IO(d, 21)      /* ioctl toggle vme black hole mode */
#define VJIOSLABEL      _IO(d, 22)      /* start to use newly created label */
#define VJIOFORMATDEF   _IO(d, 23)      /* ioctl Format unit Primary list   */
#define VJIOMSENSE03    _IOR(d, 20, VJ_MODE_SENSE)  /* scsi mode sense page 03     */
#define VJIOMSENSE04    _IOR(d, 21, VJ_MODE_SENSE)  /* scsi mode sense page 04     */
#define VJIOCONF        _IOR(d, 22, VJ_CSB)         /* ioctl Jaguar config  */
#define VJIOINQ         _IOR(d, 23, VJ_INQUIRY)     /* scsi inquiry cmd     */
#define VJIOCAP         _IOR(d, 24, VJ_CAPACITY)    /* scsi read_capacity   */
#define VJIODRIVER      _IOR(d, 25, VJ_DRIVER)      /* ioctl dev driver     */
#define VJIOCSPART      _IOW(d, 20, VJ_DKMAP)       /* ioctl dkl map        */
#define VJIOMSELECT     _IOW(d, 21, VJ_MODE_SENSE)  /* scsi mode select     */
#define VJIORSGNBLK     _IOW(d, 22, VJ_RSGNBLK)		/* scsi reassign blk	*/
#define VJIOGETGDEF		_IOW(d, 23, char *)			/* scsi read G-list     */
#define VJIOGETPDEF		_IOW(d, 24, char *)			/* scsi read P-list     */

#if	GDAT
/*
 *	Genesis Digital Audio tape status codes (for mtget->mt_resid)
 */
#define	GDAT_READY				(1<<0)
#define	GDAT_NOT_READY			(1<<1)
#define	GDAT_MEDIUM_ERROR		(1<<2)
#define	GDAT_HARDWARE_ERROR		(1<<3)
#define	GDAT_ILLEGAL_REQUEST	(1<<4)
#define	GDAT_UNIT_ATTENTION		(1<<5)
#define	GDAT_WRITE_PROTECT		(1<<6)
#define	GDAT_BLANK_CHECK		(1<<7)
#define	GDAT_COPY_ABORTED		(1<<8)
#define	GDAT_ABORTED_COMMAND	(1<<9)
#define	GDAT_VOLUME_OVERFLOW	(1<<10)
#define	GDAT_EOF				(1<<11)
#define	GDAT_EOT				(1<<12)
#define	GDAT_BOT				(1<<13)
#define	GDAT_NOMEDIA			(1<<14)
#define	GDAT_MEDCHG				(1<<15)

#define	GDAT_ONLINE				GDAT_READY

/*
 *	READLOG ioctl structure
 */
struct	st_dat_tape_log	{
	UBYTE	resv0		: 2;
	UBYTE	pagecode	: 6;	/* page returned */
	UBYTE	resv1;
	UBYTE	pagelen[2];			/* length of page */
	UBYTE	params[88];			/* parameter page */
};

/*
 *	The log_params structure is a template that is fitted into
 *	the params array of the st_dat_tape_log structure.  The first
 *	template goes at offset 0, every following template goes at
 *	offset (previous_offset + 4 + template->parmlen).
 */
struct	log_params	{
	UBYTE	paramc[2];			/* param code */
	UBYTE	bits;				/* miscellaneous bits */
	UBYTE	parmlen;			/* parameter length */
	UBYTE	parm[1];			/* parameter value place holder, */
								/* the real length is from 2 to 4 */
};

/*
 *	RECVDIAG ioctl structure
 */
struct	st_dat_diag	{
	UBYTE	reset_error	: 1;
	UBYTE	time_resync	: 1;
	UBYTE	unused		: 2;
	UBYTE	error_set	: 4;		/* error set */
	UBYTE	error_code;				/* error code */
	UBYTE	resulta;				/* Sub assembly 1 */
	UBYTE	resultb;				/* Sub assembly 2 */
	UBYTE	testnum;				/* Test number */
};

/*
 *	Genesis Digital Audio Tape ioctls
 */
#define	ADDPART			_IOW(h, 8, int)			/* create partition P1 */
#define	DELPART			_IO(h, 9)				/* delete partition P1 */
#define	GETPART			_IOR(h, 18, int)		/* get size of partition P1 */
#define	SWITCHPART		_IOW(h, 14, int)		/* switch partitions */
#define	SENSEPART		_IOR(h, 15, int)		/* return which partition */
#define	WRITE_SETMARK	_IO(h, 10)				/* write fast search set mark */
#define	SPACE_SM		_IOW(h, 11, int)		/* space fwd/bwd set marks */
#define	LOCKMEDIA		_IO(h, 16)				/* prevent medium removal */
#define	UNLOCKMEDIA		_IO(h, 17)				/* allow medium removal */
#define	READLOG			_IOR(h, 7, struct st_dat_tape_log)	/* SCSI log sense */
#define	SENDIAG			_IO(h, 12)				/* SCSI send diagnostic */
#define	RECVDIAG		_IOR(h, 13, struct st_dat_diag)	/* SCSI rcv diagnostic*/
#endif	/* GDAT */
