static char vjCSid[]="@(#)vj.c	30.2 3/14/91 SH00024-A00 Interphase";

/* in vi :set ts=4
 * Configuration defines: set to 0 to turn off, 1 to turn on
 */

/**   Known Deficiencies: 30.2
 **     Tape: Currently device "flags" override whether device supports
 **           variable vs. fixed block.  An incorrectly set flag (from
 **           config) will cause reads and writes to fail with "io error".
 **           Fixed vs variable should be the result of Mode Sense.
 **
 **           Emulex MT02 doesn't work correctly yet - gets error in
 **           attach for Mode Sense/Select and "hangs" on reads & writes.
 ** 
 **   REVISION HISTORY
 **   DATE     ID    VER     COMMENT
 ** 03/14/91 rbrant 30.2     A00:Add deficiency list.
 ** 03/13/91 rbrant 30.1     New development/distribution format.
 **                          Moved DPRINTF of vjCSid from vjmce_init to
 **                          printf in vjprobe.
 **                          Changed size for dr_revision in vjioctl.
 ** 03/13/91  jdb   24.9d    added ioctl for reading defect list from drive
 ** 02/25/91  ron	24.9c	 added support for sync negotation rates
 ** 02/20/91  ron   24.9b	 changed vjopen to check for unit ready 
 ** 01/29/91  ron   24.9a    added support for MD21 - not tested
 ** 12/21/90  jdb   24.9	 added support for Sony Magneto Optical drive
 ** 11/06/90  jdb   24.8     fixed define problem for GDAT and DOROFILE
 ** 11/06/90  jdb   24.7	 added tape mt ioctl MTEOM, MTRETEN and MTOFFL
 ** 10/22/90  jdb	24.6	 changed mode select page structures
 ** 09/10/90  jdb   24.5     changed the mode select command to work with 1/4"
 ** 08/29/90  JQO   24.4     BUMPED TO NEW SBU/SCCS LEVEL.
 ** 06/21/90  jdb    4.4     Changed uprintf to printf because of PANIC messgs
 ****/

#define MULT_MAJOR          0       /* large number of disk support */
#define	NEW_SORT			1		/* Use new vjdisksort algorithm */
#define	PRINT_MODE_SENSE	0		/* Display mode sense data when read */
#define VJ_DEBUG			1		/* turn on/off debugging output */
#define	GDAT				0		/* Genesis Digital Audio Tape support */
#define SYNCRATE 			0		/* Enable Sync negotation - SM board	*/

/*#define	HARD_GROUPING	0		// Hardware command grouping */
/*#define	ONLY_ONE_DRIVER	0		// Only initialize the board once */
/*#define	TAPE_LOAD		0		// Do a tape load when opening */
#define	DOROFILE			0		/* DOROFILE Optical Disk support */
#define	SOFT_GROUPING		0		/* Software command grouping - CAUTION */
									/* WILL NOT WORK IN ALL CONFIGURATIONS */

# include "vj.h"

#if NVJ > 0


static unsigned vj_options = ( (MULT_MAJOR			<< 0)
							 | (NEW_SORT			<< 1)
							 | (PRINT_MODE_SENSE	<< 2)
							 | (DOROFILE			<< 3)
							 | (GDAT				<< 4)
							 | (VJ_DEBUG			<< 5) );
#define OPTION_BITS	"\20\1MULT_MAJOR\2NEW_SORT\3PRINT_MODE_SENSE\4DOROFILE\5GDAT\6VJ_DEBUG"

#ifdef OS4
# include <sys/param.h>
# include <sys/systm.h>
# include <sys/dk.h>
# include <sys/buf.h>
# include <sys/conf.h>
# include <sys/dir.h>
# include <sys/user.h>
# include <sys/file.h>
# include <sys/map.h>
# include <sys/vmmac.h>
# include <sys/ioctl.h>
# include <sys/mtio.h>
# include <sys/uio.h>
# include <sys/kernel.h>
# include <machine/psl.h>
# include <sun/dklabel.h>
# include <sun/dkio.h>
# include <sundev/mbvar.h>
# include <sundev/IPtypes.h>
# include <sundev/vj_struct.h>
# include <sundev/vj_scsi.h>
# include <sundev/vj_reg.h>
#else OS4
# include "../h/param.h"
# include "../h/systm.h"
# include "../h/dk.h"
# include "../h/buf.h"
# include "../h/conf.h"
# include "../h/dir.h"
# include "../h/user.h"
# include "../h/file.h"
# include "../h/map.h"
# include "../h/vmmac.h"
# include "../h/ioctl.h"
# include "../h/mtio.h"
# include "../h/uio.h"
# include "../h/kernel.h"
# include "../machine/psl.h"
# include "../sun/dklabel.h"
# include "../sun/dkio.h"
# include "../sundev/mbvar.h"
# include "../sundev/IPtypes.h"
# include "../sundev/vj_struct.h"
# include "../sundev/vj_scsi.h"
# include "../sundev/vj_reg.h"
#endif OS4

#if MULT_MAJOR
/* This include file contains the first blk and chr major numbers in the    */
/* conf.c file.  This file must contain the following:						*/
/* #define VJBLKMAJOR xx          xx = first blk major number (from conf.c) */
/* #define VJCHRMAJOR xx          xx = first chr major number (from conf.c) */
# include "vj_major.h"
#endif

int vj_debug = 0;
int vj_verbose = 1;
#if VJ_DEBUG > 0
#  define	VPRINTF		if (vj_verbose) printf
#  define	DPRINTF		if (vj_debug) printf
#else
#  define	VPRINTF
#  define	DPRINTF
#endif

int vjprobe(), vjslave(), vjattach();

VJ_CTLR vjctlrs[NVJC];
VJ_UNIT vjunits[NVJ];

#if MULT_MAJOR
/* This is an array that contains one entry for each controller   */
/* defined in the configuration file.  It will map the device     */
/* entry number to the unit number.								  */
/* ex. controller 0 = 0 1 2 3 4  5  ff ff ff ff ff ff ff ff ff ff */
/*     controller 1 = 6 7 8 9 a  b  ff ff ff ff ff ff ff ff ff ff */
/*     controller 2 = c d e f 10 11 ff ff ff ff ff ff ff ff ff ff */
/*     ... 														  */
VJ_INDEX vjindex[NVJC];
#endif

struct	mb_ctlr		*vjcinfo[NVJC];
struct	mb_device	*vjdinfo[NVJ];
struct  mb_driver	vjcdriver = {
						vjprobe, vjslave, vjattach, 0, 0, 0,
						sizeof(VJ_SHIO), 
						"vj", vjdinfo, "vjc", vjcinfo, MDR_BIODMA,
						};
static	MB_DEVICE	*md_save[NVJC];

#if	sun2
#	define	MEMTYPE			MEMT_16BIT	/* do 16-bit transfers */
#	undef	SOFT_GROUPING
#	define	SOFT_GROUPING	0			/* turn off software grouping */
#else
#	define	MEMTYPE			MEMT_32BIT	/* do 32-bit transfers */
#endif
#define VJLUN(slave)		(slave & 07)
#define	COPYIN			bcopy
#define	COPYOUT			bcopy
#define	ERETURN(x)		return (x)
#define	UPRINTF			printf /* uprintf caused PANIC w/OS4.1	*/
#define	SPLX()			splx(un->un_splpri)
#define	VJ_BURST_COUNT	0
#if SYNCRATE
#define VJ_SYNC_RATE	0
#define VJ_CIB_OPT		0
#endif 
/* partition block offset */
#define PART_BLOCK(lp,un)  ((lp)->dkl_cylno * (un)->un_spc)

/*
 *	System independent defines
 */
#define	TRUE			1
#define	FALSE			0

#define	GROUP_COUNT		VJ_Q_SIZ
#define	VEC(c, vec)		(((c)->c_level << 8) + (vec))
#ifndef STARVSIZE
#	define	STARVSIZE	64		/* must be power of 2, for NEW_SORT */
#endif

#define WHILE_DELAY		10000

#define ADDR_MOD		( (TT_NORMAL << 10) | (MEMTYPE << 8) | ADRM_STD_S_D )
#define BLACKHOLE_MOD	( (TT_DISABLE_INC_ADDR<<10)|(MEMTYPE<<8)|ADRM_STD_S_D )
#define SHIO_MOD		( (TT_NORMAL << 10) | (MEMT_SHIO << 8) | ADRM_SHT_N_IO )
#define DEFAULT_SCSI_ID		M_PSID_DFT

/* vjcmd() flags */
#define NO_INTERRUPT         0
#define WANT_INTERRUPT       1

/* mode_sensel_cmd() flags */
#define MODE_SENSE_ONLY		0x1
#define MODE_SENSE_SELECT	0x2
#define MODE_SELECT_ONLY	0x4

/* Jaguar SCSI errors */
#define SCSI_BUS_RESET       0x11
#define SCSI_SELECT_TO		 0x30
#define SCSI_DISC_TO		 0x31
#define SCSI_ERROR			 0x32
#define SCSI_BAD_DISC		 0x33
#define SCSI_XFER_EXCEPTION  0x34
#define	SCSI_ERR(x)		( (((x)>>8)&0xff) \
						|| ( (((x)&0xff) >= SCSI_SELECT_TO) \
						  && (((x)&0xff) <= SCSI_BAD_DISC) ) )

#define WORK_QUEUE_ABORT    0x80
#define MAX_RETRIES            0
#define MAX_SENSE_REQUESTS     2
#define SPECIAL_MASK  0xFFFFFFF0

#define B_SPL		0x80000000
#define b_paddr		b_un.b_addr
#define b_pblkno	b_resid		/* for vjdisksort() */
#define b_scsicmd	b_forw
#define b_scsicnt	b_back
#define b_scsierr	av_forw
#define b_scsiparam	b_bufsize

#ifndef	OPTION_10B
#define	OPTION_10B	0x80		/* use 10 byte CDB */
#endif

#define EXABYTE_UNIQ_PARAM_LEN 0x4

/*
 *	Jaguar Commands
 */
#define	VJ_UNIT_READY		1
#define	VJ_RESTORE			2
#define	VJ_SENSE			3
#define	VJ_READ				4
#define	VJ_WRITE			5
#define	VJ_SEEK				6
#define	VJ_FORMAT			7
#define	VJ_REWIND			8
#define	VJ_ERASE			9
#define	VJ_W_FM				10
#define	VJ_SPACE			11
#define	VJ_INQUIRY_CMD		12
#define	VJ_MODE_SENSE_CMD	13
#define	VJ_MODE_SELECT_CMD	14
#define	VJ_LOAD				15
#define	VJ_REASSIGN_BLOCK	16
#define	VJ_READ_CAPACITY	17
#define	VJ_LOCK				18
#define	VJ_FLUSH_WORKQ		19
#define	VJ_INIT_WORKQ		20
#define	VJ_CNTR_INIT		21
#define VJ_SCSI_RESET       22
#define VJ_SPECIAL_SCSI     23
#define VJ_LIST_DEFECT		24

struct vj_cmds	{
	UBYTE	macsi_cmd;
	UBYTE	scsi_cmd;
	char	*scsi_name;
};

static	struct vj_cmds	vjcmds[] = {
	{ 0,				0,						"NULL" },
	{ SCSI_PASS_THRU,	SCSI_TEST_UNIT_READY,	"UNIT_READY" },
	{ SCSI_PASS_THRU,	SCSI_REZERO_UNIT,		"RESTORE" },
	{ SCSI_PASS_THRU,	SCSI_REQUEST_SENSE,		"SENSE" },
	{ SCSI_PASS_THRU,	SCSI_READ,				"READ" },
	{ SCSI_PASS_THRU,	SCSI_WRITE,				"WRITE" },
	{ SCSI_PASS_THRU,	SCSI_SEEK_EXTENDED,		"SEEK" },
	{ SCSI_PASS_THRU,	SCSI_FORMAT_UNIT,		"FORMAT" },
	{ SCSI_PASS_THRU,	SCSI_REWIND,			"REWIND" },
	{ SCSI_PASS_THRU,	SCSI_ERASE,				"ERASE" },
	{ SCSI_PASS_THRU,	SCSI_WRITE_FILE_MARKS,	"WRITE FILEMARK" },
	{ SCSI_PASS_THRU,	SCSI_SPACE,				"SPACE" },
	{ SCSI_PASS_THRU,	SCSI_INQUIRY,			"INQUIRY" },
	{ SCSI_PASS_THRU,	SCSI_MODE_SENSE,		"MODE_SENSE" },
	{ SCSI_PASS_THRU,	SCSI_MODE_SELECT,		"MODE_SELECT" },
	{ SCSI_PASS_THRU,	SCSI_LOAD,				"LOAD/UNLOAD" },
	{ SCSI_PASS_THRU,	SCSI_REASSIGN_BLOCK,	"REASSIGN_BLOCK" },
	{ SCSI_PASS_THRU,	SCSI_READ_CAPACITY,		"READ_CAPACITY" },
	{ SCSI_PASS_THRU,	SCSI_LOCK,				"LOCK/UNLOCK" },
	{ CNTR_FLUSH_WORKQ,	0,						"FLUSH_WORKQ" },
	{ CNTR_INIT_WORKQ,	0,						"INIT_WORKQ" },
    { CNTR_INIT,        0,                      "CTLR_INIT" },
    { SCSI_RESET,       0,                      "SCSI RESET" },
    { SCSI_PASS_THRU,   0,                      "SPECIAL SCSI" },
    { SCSI_PASS_THRU,   SCSI_LIST,              "READ DEFECTS" }
};

typedef	struct	{
	UBYTE	err;				/* error number */
	char	*msg;				/* error message */
} VJ_ETABLE;

/*
 *	Sense errors
 */
static	VJ_ETABLE	sense_errs[] = {
	{ SCSI_NO_SENSE,			"No Sense: " },
	{ SCSI_RECOVERABLE_ERROR,	"Command completed with recovery actions" },
	{ SCSI_NOT_READY,			"Drive can't be accessed" },
	{ SCSI_MEDIUM_ERROR,		"Non-recoverable data error" },
	{ SCSI_HARDWARE_ERROR,		"Non-recoverable hardware failure(parity,etc)"},
	{ SCSI_ILLEGAL_REQUEST,		"Illegal parameter in cdb" },
	{ SCSI_UNIT_ATTENTION,		"Media change or drive was reset" },
	{ SCSI_DATA_PROTECT,		"Cartridge is write-protected" },
	{ SCSI_BLANK_CHECK,			"No-data condition encountered on tape" },
	{ SCSI_ABORT_COMMAND,		"Drive aborted the command" },
	{ SCSI_VOLUME_OVERFLOW,		"Physical EOM reached, data still in buffer"},
	{ 0xFF,						"Status code not in table" }
};

/*
 *	SCSI errors
 */
static	VJ_ETABLE	scsi_errs[] = {
    { 0x00, "Good Status" },
    { 0x02, "Request Sense needed."},
    { 0x08, "Busy Status."},
    { 0x10, "Intermediate Status."},
    { 0x18, "Reservation Conflict."},
    { 0xFF, "Unknown Error." }
};

/*
 *	Jaguar errors
 */
static	VJ_ETABLE	jaguar_errs[] = {
	{ 0x00, "Good Status" },
	{ 0x01, "Work Queue Full" },
	{ 0x02, "Work Queue not Initialized." },
	{ 0x03, "First command not Initialize." },
	{ 0x04, "Invalid Command Type." },
	{ 0x05, "Invalid Work Queue Number." },
	{ 0x06, "Work Queue already initialized." },
	{ 0x07, "Re-initialization of a Work Queue Failed." },
	{ 0x08, "Start Queue Mode before Initialize Command." },
	{ 0x09, "Command Type not Implemented." },
	{ 0x0A, "Invalid Priority specified." },
	{ 0x10, "Reserved Field not Zero." },
	{ 0x11, "Bus Reset issued by Jaguar." },
	{ 0x12, "Bus 2 is not available." },
	{ 0x13, "SCSI ID Requested is our own." },
	{ 0x14, "SCSI Bus is held in Reset." },
	{ 0x15, "Command Canceled - External." },
	{ 0x16, "Invalid Page size in CIB." },
	{ 0x17, "Command Tag Search == 0." },
	{ 0x18, "Command is on the Bus." },
	{ 0x20, "Bus-Error Occurred during DMA." },
	{ 0x21, "VME timeout." },
	{ 0x23, "Invalid DMA Address." },
	{ 0x24, "Illegal memory type." },
	{ 0x25, "Invalid transfer count." },
	{ 0x26, "IOPB fetch bus error." },
	{ 0x27, "IOPB fetch timeout." },
	{ 0x28, "IOPB post bus error." },
	{ 0x29, "IOPB post timeout." },
	{ 0x2A, "Illegal address on IOPB Fetch." },
	{ 0x2B, "Illegal address on IOPB Post." },
	{ 0x2C, "Bus error on Scatter/Gather Fetch." },
	{ 0x2D, "Timeout error on Scatter/Gather Fetch." },
	{ 0x2E, "Invalid number of Scatter/Gather Elements." },
	{ 0x30, "Selection phase of the SCSI device failed." },
	{ 0x31, "Device did not reselect the board and timedout." },
	{ 0x32, "SCSI operation did not complete successfully." },
	{ 0x33, "SCSI invalid disconnection." },
	{ 0x34, "SCSI transfer count did not match the count given." },
	{ 0x40, "Odd Count in Scatter/Gather List." },
	{ 0x41, "Illegal Memory Type in Scatter/Gather List." },
	{ 0x42, "Illegal Address in Scatter/Gather List." },
	{ 0x50, "Buffer Count too large." },
	{ 0x51, "Can't execute because of ExCRB." },
	{ 0x80, "Command flushed on error." },
	{ 0x81, "Cancelled due to flush command." },
	{ 0x82, "Unknown Device Re-Selection." },
	{ 0x83, "Count Exhausted Error." },
	{ 0x84, "Data Direction Error." },
	{ 0xC0, "IOPB Type Error." },
	{ 0xC1, "IOPB Timeout Error." },
	{ 0xFF, "Unknown Error." }
};

/*
 *	Known Ioctls
 */
typedef struct {
	int	ioctl_num;
	char *ioctl_name;
} VJ_ITABLE;
static	VJ_ITABLE	ioctl_array[] = {
	{ DKIOCINFO,		"DKIOCINFO" },
	{ DKIOCGCONF,		"DKIOCGCONF" },
	{ DKIOCGGEOM,		"DKIOCGGEOM" },
	{ DKIOCSGEOM,		"DKIOCSGEOM" },
	{ DKIOCGPART,		"DKIOCGPART" },
	{ DKIOCSPART,		"DKIOCSPART" },
	{ VJIOCSPART,		"VJIOCSPART" },
	{ VJIODRIVER,		"VJIODRIVER" },
	{ VJIOCONF,			"VJIOCONF" },
	{ VJIOINQ,			"VJIOINQ" },
	{ VJIOCAP,			"VJIOCAP" },
	{ VJIOMSENSE03,		"VJIOMSENSE03" },
	{ VJIOMSENSE04,		"VJIOMSENSE04" },
	{ VJIOMSELECT,		"VJIOMSELECT" },
	{ VJIORSGNBLK,		"VJIORSGNBLK" },
	{ VJIOFORMAT,		"VJIOFORMAT" },
	{ VJIOFORMATDEF,	"VJIOFORMATDEF" },
	{ VJIOGETGDEF,		"VJIOGETGDEF" },
	{ VJIOGETPDEF,		"VJIOGETPDEF" },
	{ MTIOCTOP,			"MTIOCTOP" },
	{ MTRETEN,			"MTRETEN" },
	{ MTREW,			"MTREW" },
	{ MTOFFL,			"MTOFFL" },
	{ MTWEOF,			"MTWEOF" },
	{ MTFSF,			"MTFSF" },
	{ MTBSF,			"MTBSF" },
	{ MTFSR,			"MTFSR" },
	{ MTBSR,			"MTBSR" },
	{ MTNOP,			"MTNOP" },
	{ MTERASE,			"MTERASE" },
	{ MTIOCGET,			"MTIOCGET" },
	{ MTEOM,			"MTEOM" },

#if	GDAT
	{ ADDPART,			"ADDPART" },
	{ DELPART,			"DELPART" },
	{ GETPART,			"GETPART" },
	{ SWITCHPART,		"SWITCHPART" },
	{ SENSEPART,		"SENSEPART" },
	{ WRITE_SETMARK,	"WRITE_SETMARK" },
	{ SPACE_SM,			"SPACE_SM" },
	{ LOCKMEDIA,		"LOCKMEDIA" },
	{ UNLOCKMEDIA,		"UNLOCKMEDIA" },
	{ READLOG,			"READLOG" },
	{ SENDIAG,			"SENDIAG" },
	{ RECVDIAG,			"RECVDIAG" },
#endif	/* GDAT */

	{ 0xFF,				"Unknown IOCTL" }
};

static char *
sense_err_msg(err)
register UBYTE err;
{
	register VJ_ETABLE	*ep = sense_errs;

	do {
		if (err == ep->err)
			return (ep->msg);
		ep++;
	} while( ep->err != 0xFF );
	return (ep->msg);
}

static char *
scsi_err_msg(err)
register UBYTE err;
{
	register VJ_ETABLE	*ep = scsi_errs;

	do {
		if (err == ep->err)
			return (ep->msg);
		ep++;
	} while( ep->err != 0xFF );
	return (ep->msg);
}

static char *
jaguar_err_msg(err)
register UBYTE err;
{
	register VJ_ETABLE	*ep = jaguar_errs;

	do {
		if (err == ep->err)
			return (ep->msg);
		ep++;
	} while( ep->err != 0xFF );
	return (ep->msg);
}

static char *
ioctl_str(cmd)
register int cmd;
{
	register VJ_ITABLE	*ip = ioctl_array;

	do {
		if (cmd == ip->ioctl_num)
			return (ip->ioctl_name);
		ip++;
	} while( ip->ioctl_num != 0xFF );
	DPRINTF("ioctl_str: Unknown - 0x%x\n", cmd);
	return (ip->ioctl_name);
}


vjfill(s,n,c)
register char *s;
register int n;
register char c;
{
	while(n--)
		*s++ = c;
}

#define	vjmove(src, dst, cnt) \
{ \
	register USHORT *x, *y, z; \
	z = cnt/2; \
	x = (USHORT *)src; \
	y = (USHORT *)dst; \
    while (z--)  \
        *y++ = *x++; \
}

vjzero(src, cnt)
register USHORT *src;
register USHORT cnt;
{
    register USHORT zero = 0;

    cnt >>= 1;
    while( cnt-- )
        *src++ = zero;
}

/*
	#define vjmove(x,y,z)	bcopy(x,y,z)
	#define vjzero(x,y)		bzero(x,y)
*/

/*
 *	Temporarily (or permanently if tagp is NULL) allocate 'n' bytes of memory.
 *	Returns a pointer to the usable memory, and returns a tag to be used
 *		for freeing the memory in 'tagp'.
 */
char *
vjalloc(n, tagp)
int n;
caddr_t *tagp;
{
	caddr_t	tag;

	tag = (caddr_t)rmalloc(iopbmap, n+4);
	if ( tag == NULL )
		return NULL;
	if ( tagp != NULL )
		*tagp = tag;
	return (char *)(((int)tag & ~3) + 4);
}

/*
 *	Free the 'n' bytes of allocated memory associated with 'tag'.
 */
vjfree(n, tag)
int n;
caddr_t tag;
{
	rmfree(iopbmap, n+4, tag);
}

/*
 *	Determine existence of and initialize the controller
 */
vjprobe(reg, ctlr)
caddr_t reg;
{
    register VJ_CTLR *c = &vjctlrs[ctlr];
    register VJ_SHIO *shio;
    register VJ_HSB  *hsb;         /* Host Semaphore Block      */
    register int rc;

    printf("%s\n", vjCSid);

#if MULT_MAJOR
    /* initalize all of the index entries to ff */
    for (rc = 0; rc < 16; rc++)
        vjindex[ctlr].ix[rc] = 0xff;
#endif

    vjzero((USHORT *)c, sizeof(VJ_CTLR));
    c->c_io = (VJ_SHIO *)reg;        /* Store address to board    */
    shio    = c->c_io;
	rc = 0;
	if ( peek(shio) != -1 )
	{
		DPRINTF("Jaguar 4210 board at 0x%x, options=%b\n", shio, vj_options, OPTION_BITS);
		rc = sizeof( VJ_SHIO );
		hsb  = &shio->sh_HSB;

#if ONLY_ONE_DRIVER
		if ( hsb->hsb_INITQ != HOST_ID )
#endif
		{
			if ( vjmce_init(c) )    /* returns true if passed */
			{
				hsb->hsb_INITQ = HOST_ID;
			}
			else
				rc = 0;
		}
		if ( rc )
			c->c_present = TRUE;
	}
    return ( rc );
}

/*
 *	MCE Initialization code.
 */
vjmce_init(c)
register VJ_CTLR *c;
{
    register VJ_SHIO *shio = c->c_io;
    register VJ_MSR  *msr  = &shio->sh_MCSB.mcsb_MSR;
    register VJ_MCR  *mcr  = &shio->sh_MCSB.mcsb_MCR;
    VJ_CSB   Csb;
    register INT i,j;

    WORDP(mcr) |= M_MCR_RES;    /* Reset the controller */
	DELAY(500);

    WORDP(mcr) &= ~M_MCR_RES;    /* Clear the controller */
	DELAY(10000);

    i = WHILE_DELAY;            /* wait for BOK bit to show up */
    while ( !(WORDP(msr) & M_MSR_BOK) && (WORDP(msr)&0xff) != 0xd1 && i-- )
		DELAY(1000);

    if ( !(WORDP(msr) & M_MSR_BOK) && (WORDP(msr)&0xff) != 0xd1 )
    {
        printf("vj: Board failed powerup diagnostics MSR=0x%x\n", WORDP(msr));
        return (0);
    }

    if ( (WORDP(msr)&0xff) == 0xd1 )
	{
		/* End Panther boot emulation */
		W( shio->sh_MCSB.mcsb_IQAR ) = 0x7f00;
		WORDP(mcr) |= 0x0080;
		DELAY(10000);

		i = WHILE_DELAY;      /* Wait for Board OK */
		while( !( WORDP( msr ) & M_MSR_BOK ) && i-- )
			DELAY(1000);

		if ( !(WORDP(msr) & M_MSR_BOK) )
		{
			printf("vj: Board never completed Panther emulation: MSR=0x%x\n",
					WORDP(msr));
			return (0);
		}
	}

    vjmove( &shio->sh_CSS, &Csb, sizeof( VJ_CSB ) );
    DPRINTF("   Firmware Revision (%s-%c-%s) Date %s with %d Kbytes ram.\n",
            &Csb.csb_PCODE[0],
            Csb.csb_PVAR,
            &Csb.csb_FREV[0],
            &Csb.csb_FDATE[0],
            Csb.csb_BSIZE);
	DPRINTF("   Primary Bus ID = %x, Secondary Bus ID = %x\n",
			Csb.csb_PID, Csb.csb_SID);

/* start rogue's mods */

#if VJ_DEBUG
        DPRINTF(" DEBUG(0x%x)", vj_debug);
#endif
#if HARD_GROUPING
        DPRINTF(" HARD_GROUPING(%d)", GROUP_COUNT);
#endif
#if NEW_SORT
        DPRINTF(" NEW_SORT(%d)", STARVSIZE);
#endif
#if NO_SYNC_XFER
        DPRINTF(" NO_SYNC_XFER");
#endif
#if SOFT_GROUPING
        DPRINTF(" SOFT_GROUPING");
#endif
#if TAPE_LOAD
        DPRINTF(" TAPE_LOAD");
#endif
        DPRINTF("\n");
 
/* end rogue's mods */

	/*
	 *	Calculate the appropriate slave to unit number mapping, depending
	 *	on the Jaguar's primary and secondary SCSI id's.
	 */
	c->c_pid = Csb.csb_PID;
	c->c_sid = Csb.csb_SID;
    /*
     * Clear all important areas of short I/O
     */
    vjzero((USHORT *)&c->c_mce,          sizeof(VJ_CQE));
    vjzero((USHORT *)&c->c_miopb,        sizeof(VJ_IOPB));
    vjzero((USHORT *)&shio->sh_CQE[0],  (sizeof(VJ_CQE) * NUM_CQE));
    vjzero((USHORT *)&shio->sh_IOPB[0], (sizeof(VJ_IOPB) * NUM_IOPB));
    vjzero((USHORT *)&shio->sh_MCE_IOPB, sizeof(VJ_IOPB));
    vjzero((USHORT *)&shio->sh_CIB,      sizeof(VJ_CIB));
    vjzero((USHORT *)&shio->sh_HUS[0],   S_HUS_FREE);
    vjzero((USHORT *)&shio->sh_CRB,      sizeof(VJ_CRB));
    vjzero((USHORT *)&shio->sh_RET_IOPB, sizeof(VJ_IOPB));

    c->c_cqe_top    = &shio->sh_CQE[ 0 ];
    c->c_cqe_end    = &shio->sh_CQE[ NUM_CQE - 1 ];

    shio->sh_HSB.hsb_WORKQ = 1;            /* set up first work queue */

    for (i =0; i< NUM_CQE; i++)            /* setup iopb address in cqe's */
	{
        shio->sh_CQE[i].cqe_IOPB_ADDR = ((INT)&shio->sh_IOPB[i] - (INT)shio);
        shio->sh_CQE[i].cqe_IOPB_LENGTH = 0;
	}

    shio->sh_MCSB.mcsb_QHDP = ((INT)&shio->sh_CQE[0] - (INT)shio);

    return (sizeof(VJ_SHIO));
}

/*
 *	See if a slave unit exists
 *	Since we allow status change interrupts to allow a drive to
 *		spin up and become available, we always say yes.
 */
vjslave(md, reg)
MB_DEVICE *md;
caddr_t reg;
{
	return (1);
}

vjattach(md)
register MB_DEVICE *md;
{
	md_save[md->md_ctlr] = md;
	DPRINTF("vjattach(%d,%d,%d,%d,0)\n",md->md_ctlr,md->md_unit,
		md->md_slave,md->md_flags);
	/* md_flags = 0:primary bus; 1:secondary bus */
	/* md_flags & 0x20 ==> GDAT device */
	/* md_flags & 0x80 ==> DOROFILE device */
	return do_attach(md->md_ctlr, md->md_unit, md->md_slave, md->md_flags, 0);
}

static
do_attach(ctlr, unit, slave, flags, special)
int ctlr, unit, slave, flags, special;
{
	register VJ_CTLR *c = &vjctlrs[ctlr];
	register VJ_UNIT *un = &vjunits[unit];
    register VJ_SHIO *shio = c->c_io;
    register int i,j;
#if SOFT_GROUPING
	char *sg;
#endif

	DPRINTF("do_attach(%d,%d,%d,%d,%d)\n",ctlr,unit,slave,flags,special);
    if ( unit >= NVJ )
	{
		VPRINTF("vj: Invalid unit number %d\n", unit);
		return (-1);
	}

	if (!c->c_init)		/* only needs to be init the first time */
	{
		/* set up for vectored interrupts */
		MB_CTLR *mc = md_save[ctlr]->md_mc;

		c->c_nintvec = mc->mc_intr[0].v_vec;	/* normal interrupt */
		*(mc->mc_intr[0].v_vptr) = (int)c;
		c->c_eintvec = mc->mc_intr[1].v_vec;	/* error interrupt */
		*(mc->mc_intr[1].v_vptr) = (int)c;
		c->c_qintvec = mc->mc_intr[2].v_vec;	/* Queue entry Avail */
		*(mc->mc_intr[2].v_vptr) = (int)c;
		c->c_md_hd	= md_save[ctlr]->md_hd;
		c->c_level	= mc->mc_intpri;
		c->c_ccount = 0;

		W( shio->sh_MCSB.mcsb_IQAR )   = 0;

        /* Initialize Controller Command Format */
    	un->un_ctlr = c;
        vjcmd(un, VJ_CNTR_INIT, (char *)0, 0, 0, NO_INTERRUPT);
        if ( vjwait( un, M_CRSW_CC ) )
        {
            printf("vj: Unable to Initialize Controller\n");
            return(-1);
        }

        /* Start Queued Mode */
        W( shio->sh_MCSB.mcsb_MCR ) |= M_MCR_SQM;
        if ( vjwait( un, M_CRSW_QMS ) )
        {
            printf("vj: Unable to Start Queued Mode\n");
            return(-1);
        }

#if SOFT_GROUPING
		/* Allocate and initialize scatter/gather space */
		sg = kmem_alloc(NUM_M_SG*S_MACSI_SG);
		if ( sg == NULL )
		{
			printf("vj: No space for Scatter/Gather information\n");
			return(-1);
		}
		c->c_sg_mbinfo = mballoc(c->c_md_hd, sg, NUM_M_SG*S_MACSI_SG, 0);
		for ( i = 0; i < NUM_M_SG; i++ )
		{
			c->c_sg_fentry[i].ipsg_entry = i;
			c->c_sg_fentry[i].ipsg = (IPSG *)(sg + i*S_MACSI_SG);
		}
		/* Initialize Gather Grouping Free list	*/
		for ( i = 0; i < NUM_M_SG; i++ )
		{
			c->c_sg_fentry[i].nxt = &c->c_sg_fentry[i+1];
			for ( j = 0; j < MACSI_SG; j++ )
			{
				W(c->c_sg_fentry[i].ipsg[j].sg_meminfo) = ADDR_MOD;
			}
		}
		c->c_sg_fentry[--i].nxt = (IPSG_FREE *) 0;	/* end list	*/
		c->c_sg_hd = &c->c_sg_fentry[0];			/* init head */
#endif /* SOFT_GROUPING */

		c->c_init = TRUE;
	}

#if MULT_MAJOR
    /* place this device in the index array */
    for ( i = 0; i < 16; i++)
        if (vjindex[ctlr].ix[i] == 0xff)
            break;
    vjindex[ctlr].ix[i] = unit;
#endif

    /* 
     * Initialize slave (physical drive).  Note that we assume un_present
	 * was initialized by compiler since vjunits[] is global.
     */
	if (!un->un_present)
	{
		if ( un->un_sense == NULL )		/* only allocate first time attaching */
		{
			un->un_sense = (SCSI_EXT_SENSE *)vjalloc(sizeof(SCSI_EXT_SENSE), (caddr_t *)0);
			if (un->un_sense == NULL)
			{
				printf("vj%d: No space for Request Sense information\n", unit);
				return (-1);
			}
		}
		un->un_flags	= flags;
    	un->un_ctlr     = c;        /* need ptr to ctlr struct    */
		un->un_ctlrno   = ctlr;
		un->un_ready    = 0;        /* assume drive not ready    */
		un->un_retries  = MAX_RETRIES;
		un->un_rwflag   = 0;
		un->un_locked   = 0;
		un->un_splpri	= pritospl(c->c_level);
		un->un_unit     = unit;
		un->un_lun      = VJLUN(slave);
		un->un_slave    = (slave >> 3) & 0x7;		/* scsi address */
		un->un_slave    = flags & VJ_2ND_SCSI_BUS ? (un->un_slave | M_UNIT_BUS)
									: un->un_slave;
		un->un_workq    = (unit%14)+1;
#if GDAT
		un->un_gdat		= flags & 0x20;
#endif
		/* Detect device's existence */
        if ((un->un_flags & VJ_FORCED_TAPE) || (un->un_flags & VJ_FORCED_DISK))
        {
            un->un_present = 1;
            if (un->un_flags & VJ_FORCED_TAPE)
                un->un_type |= DT_TAPE;
            	else un->un_type |= DT_DISK;
        }
		else
		{
			if (inquiry_cmd(un))
				return(-1);
			else
				un->un_present = 1;
		}

		/* Initialize the workq */
		if ( !c->c_qinit[un->un_workq] )
		{
			vjcmd(un, VJ_INIT_WORKQ, (char *)0, 0, 0, NO_INTERRUPT);
			if ( vjwait( un, M_CRSW_CC ) )
				return(-1);
			c->c_qinit[un->un_workq] = 1;
		}

		if (un->un_type & DT_TAPE)  /* added 2/21/91 ron */
			un->un_ready = 1;

#if GDAT
		if ( un->un_gdat )
		{
			un->un_ready = 1;		/* assume its ready, open will check */
			return 0;
		}
#endif
	}

	/* Test device's readiness */
	{
		for (i=0; i<5; i++)
		{
			vjcmd(un, VJ_UNIT_READY, (char *)0, 0, 0, NO_INTERRUPT);
			if ( vjwait(un, M_CRSW_CC) )
				vjsense(c, un, NO_INTERRUPT);
			else
				break;
		}
		if (i == 5)
		{
			VPRINTF("vj%d: Unit not ready\n", unit);
			if (!(un->un_type & DT_TAPE))
				return(-1);
		}
		else
			un->un_ready = 1;
	}

	/* Read capacity for disks */
	if (un->un_type & DT_DISK)
	{
		caddr_t cap;
		VJ_CAPACITY *capacity;
		unsigned int disk_cap = 0;

		capacity = (VJ_CAPACITY *)vjalloc(sizeof(VJ_CAPACITY), &cap);
		if ( capacity == NULL )
		{
			printf("vj%d: No space for Disk Capacity information\n", unit);
			return(-1);
		}
		vjzero((USHORT *)capacity, sizeof(VJ_CAPACITY));
		vjcmd(un, VJ_READ_CAPACITY, (char *)capacity, 0, 1, NO_INTERRUPT);
		if ( vjwait( un, M_CRSW_CC ) )
			vjsense(c, un, NO_INTERRUPT);
		else
		{
			disk_cap = (capacity->blk_addr_3 << 24)
						+ (capacity->blk_addr_2 << 16)
						+ (capacity->blk_addr_1 << 8)
						+ capacity->blk_addr_0;
			DPRINTF("vj%d: disk capacity=%d<%x,%x,%x,%x>/<%x,%x,%x,%x>\n", unit,
					disk_cap,
					capacity->blk_addr_3, capacity->blk_addr_2,
					capacity->blk_addr_1, capacity->blk_addr_0,
					capacity->blk_len_3, capacity->blk_len_2,
					capacity->blk_len_1, capacity->blk_len_0);
		}
		vjfree(sizeof(VJ_CAPACITY), cap);

		/* 6-byte cdb has a logical blk addr limit: 0x1fffff, or 2,097,151 */
		if (disk_cap > 2097151)
		{
			un->un_type |= DT_EXT_RW;	/* 10-byte cdb for read & write cmd */
			VPRINTF("vj%d: use SCSI_READ_EXTENDED/SCSI_WRITE_EXTENDED\n", unit);
		}
	}

#if PRINT_MODE_SENSE
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 1);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 2);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 3);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 4);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 7);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 8);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0xa);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0xc);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0x10);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0x11);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0x20);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0x32);
	mode_sensel_cmd(un, MODE_SENSE_ONLY, 512, 0, 0, 0x38);
	DPRINTF("\n");
#endif

	mode_sensel_cmd(un, MODE_SENSE_SELECT, 512, 0, 0, 0);
    if ((un->un_type & DT_TAPE) && (flags & VJ_TAPE_FIXED_BLK) &&
        (un->un_bcount <= 0))
        mode_sensel_cmd(un, MODE_SENSE_SELECT, 512, 0, 0, 0);
    if ((un->un_type & DT_DISK) && (!(un->un_type & DT_SONY_MO)))	
		/* just enable read-cache no matter what */
		mode_sensel_cmd(un, MODE_SENSE_SELECT, 512, 0, 0, 0x38);
    if ((un->un_type & DT_DISK) && (un->un_type & DT_SONY_MO))
	{
		/* Mode Select pages 1 and 2 for Sony Magneto Optical Drive */
		mode_sensel_cmd(un, MODE_SELECT_ONLY, 512, 0, 0, 0x01);
		mode_sensel_cmd(un, MODE_SELECT_ONLY, 512, 0, 0, 0x02);
	}

	/* Initialize the partitions for disks */
	if ( (un->un_type & DT_DISK) && !special )
	{
		if ( !vjgetlabel(c, un) )
		{
			for ( i = 0; i < NLPART; i++ )
			{
				un->un_map[i].dkl_cylno = 0;
				un->un_map[i].dkl_nblk  = 0;
			}
			un->un_ready = 0;
			UPRINTF("vj%d: no label\n", un->un_unit);
			return (-1);
		}
	}
	return(0);
}

inquiry_cmd(un)
register VJ_UNIT *un;
{
	register VJ_INQUIRY *inquiry;
	register int i;
	register char *pp;
	char product[32];
	caddr_t inq;

	inquiry = (VJ_INQUIRY *)vjalloc(sizeof(VJ_INQUIRY), &inq);
	if (inquiry == NULL)
	{
		printf("vj%d: No space for Inquiry information\n", un->un_unit);
		return(-1);
	}
	for (i=0; i<3; i++)
	{
		vjcmd(un, VJ_INQUIRY_CMD, (char *)inquiry, 0, 1, NO_INTERRUPT);
		if ( !vjwait( un, M_CRSW_CC ) )
			break;
	}
	if (i == 3)
	{
		VPRINTF("vj%d: Device not present\n", un->un_unit);
		vjfree(sizeof(VJ_INQUIRY), inq);
		return(-1);
	}
	un->un_type = 0;
	DPRINTF("device_type=%x\n", inquiry->device_type);
	switch ( inquiry->device_type )
	{
	case 0:
		un->un_type |= DT_DISK;
		break;
	case 1:
	case 0x61:	/* MT02 */
		un->un_type |= DT_TAPE;
		break;
	case 2:
		un->un_type |= DT_PRINTER;
		break;
	case 0x7f:							/* Logical unit not connected */
		vjfree(sizeof(VJ_INQUIRY), inq);
		return(-1);
	default:
		VPRINTF("vj%d: Unknown SCSI device type: 0x%x\n",
			un->un_unit, inquiry->device_type);
		vjfree(sizeof(VJ_INQUIRY), inq);
		return(-1);
	}
#if GDAT
	if ( un->un_gdat && !(un->un_type & DT_TAPE) )
	{
		printf("vj%d: GDAT device not a tape? type=%x\n",
				un->un_unit, un->un_type);
		return(-1);
	}
#endif
	if (!bcmp("EXABYTE", inquiry->vendor_id, 7))
		un->un_type |= DT_EXABYTE_TAPE;
	if ( inquiry->rm )
		un->un_type |= DT_REMOVABLE;
	/* check for SONY Magneto Optical drive */
	if (!bcmp("SONY", inquiry->vendor_id, 4) && (un->un_type & DT_REMOVABLE))
		un->un_type |= DT_SONY_MO;

	pp = product;
	for(i=0; i<8; i++)
		*pp++ = inquiry->vendor_id[i];
	*pp++ = ' ';
	for(i=0; i<16; i++)
		*pp++ = inquiry->product_id[i];
	*pp++ = ' ';
	for(i=0; i<4; i++)
		*pp++ = inquiry->revision_level[i];
	*pp = NULL;
	printf("vj%d: <%s>\n", un->un_unit, product);
	vjfree(sizeof(VJ_INQUIRY), inq);
	return(0);
}

mode_sensel_cmd( un, flag, block_size, data, datasz, page )
register VJ_UNIT *un;
register int flag, block_size;
register char *data;	/* for mode_sel only */
register int datasz;	/* for mode_sel only */
register int page;		/* page code */
{
	register VJ_CTLR *c = un->un_ctlr;
	register VJ_MODE_SENSE *mode_sense;
	caddr_t ms;

	mode_sense = (VJ_MODE_SENSE *)vjalloc(128, &ms);
	if (mode_sense == NULL)
	{
		printf("vj%d: No space for Mode Sense information\n", un->un_unit);
		return(-1);
	}

	if (flag & MODE_SELECT_ONLY)
	{
		bcopy(data, (char *)mode_sense, datasz);
	}
	else
	{
		vjcmd(un, VJ_MODE_SENSE_CMD, (char *)mode_sense, page, 0, NO_INTERRUPT);
		if ( vjwait( un, M_CRSW_CC ) )
		{
			VPRINTF("vj%d: Mode Sense command failed\n", un->un_unit);
			vjfree(128, ms);
			vjsense(c, un, NO_INTERRUPT);
			return(-1);
		}

	if (flag & MODE_SENSE_ONLY)
	{
#if PRINT_MODE_SENSE
		DPRINTF("\nMODE SENSE:\n");
		prt_mode_sense_data(un, mode_sense, page);
#endif
	}

	}
	if (flag & MODE_SENSE_ONLY)
	{
		un->un_bcount = (mode_sense->blk_desc.blk_len_high << 16)
						+ (mode_sense->blk_desc.blk_len_mid << 8)
						+ mode_sense->blk_desc.blk_len_low;
		vjfree(128, ms);
		return(0);
	}
	/*
	 * 	Mode Select:
	 */
	if(un->un_type & DT_DISK)
	{
		mode_sense->hdr.sense_data_len = 0;
		((VJ_MS_PAGE1 *)mode_sense->pg)->res0 = 0;	/* zero out resv bit */
		if (un->un_type & DT_SONY_MO)
		{
			/* Sony Magneto Optical drive */
			mode_sense->hdr.medium_type = 0;	/* medium type */
			mode_sense->hdr.WP = 0;				/* reserved    */ 
			mode_sense->hdr.resv = 0;			/* reserved    */
			mode_sense->hdr.EBC = 0;			/* reserved    */
			mode_sense->hdr.blk_desc_len = 0;	/* block descriptor length */
		}
		switch (page)
		{
		case 0x01:
			/*((VJ_MS_PAGE1 *)mode_sense->pg)->per = 1;	* post error */
			/*((VJ_MS_PAGE1 *)mode_sense->pg)->dcr = 1;	* disable correction */
			if (un->un_type & DT_SONY_MO)
			{
				/* Sony Magneto Optical drive */
				mode_sense->blk_desc.density_code = 1;	/* page code (page 1) */
				mode_sense->blk_desc.nob_high = 6;		/* page length        */
				mode_sense->blk_desc.nob_mid = 0x80;	/* AWRE enabled       */
				mode_sense->blk_desc.nob_low = 2;		/* retry count        */
				mode_sense->blk_desc.resv = 0;			/* reserved           */
				mode_sense->blk_desc.blk_len_high = 0;	/* reserved           */
				mode_sense->blk_desc.blk_len_mid = 0;	/* reserved           */
				mode_sense->blk_desc.blk_len_low = 0;	/* reserved           */
			}
			break;
		case 0x02:
			if (un->un_type & DT_SONY_MO)
			{
				/* Sony Magneto Optical drive */
				mode_sense->blk_desc.density_code = 2;	/* page code (page 2) */
				mode_sense->blk_desc.nob_high = 0xa;	/* page length        */
				mode_sense->blk_desc.nob_mid = 0x80;	/* buffer full ratio  */
				mode_sense->blk_desc.nob_low = 0x80;	/* buffer empty ratio */
				mode_sense->blk_desc.resv = 0;			/* reserved           */
				mode_sense->blk_desc.blk_len_high = 0;	/* reserved           */
				mode_sense->blk_desc.blk_len_mid = 0;	/* reserved           */
				mode_sense->blk_desc.blk_len_low = 0;	/* reserved           */
				mode_sense->pg[0] = 0;					/* reserved           */
				mode_sense->pg[1] = 0;					/* reserved           */
				mode_sense->pg[2] = 0;					/* reserved           */
				mode_sense->pg[3] = 0;					/* reserved           */
				mode_sense->pg[4] = 0;					/* reserved           */
			}	
			break;
		case 0x38:
			if (((VJ_MS_PAGE38H *)mode_sense->pg)->ce == 0)
				((VJ_MS_PAGE38H *)mode_sense->pg)->ce = 1;	/* cache enabled */
			break;
		}
	}
	else if (un->un_type & DT_TAPE)
	{
		mode_sense->hdr.sense_data_len = 0; /*<== */
		mode_sense->hdr.medium_type = 0;	/* default value */
		mode_sense->hdr.WP = 0;

		/* what is this for? do we need it for mt02? jdb */
		/*mode_sense->hdr.resv = 0;	// mt02 BUFM off */

		/* changed by jdb 9/10/90 */
		/* always set nob to 0 */
		mode_sense->blk_desc.nob_high = 0;
		mode_sense->blk_desc.nob_mid = 0;
		mode_sense->blk_desc.nob_low = 0;

		if (un->un_type & DT_EXABYTE_TAPE)	/* EXABYTE */
		{
			block_size = 0;	/* var blk sz; default is 1024 fixed blk sz*/
			mode_sense->pg[0] = 0xc; /* vender unique param */
		}

		if (!(un->un_flags & VJ_TAPE_FIXED_BLK))
			block_size = 0;

		mode_sense->blk_desc.blk_len_high = (block_size >> 16) & 0xff;
		mode_sense->blk_desc.blk_len_mid  = (block_size >> 8) & 0xff;
		mode_sense->blk_desc.blk_len_low  = block_size & 0xff;

		/**(char *)((char *)&mode_sense->hdr.sense_data_len
			 + mode_sense->hdr.sense_data_len) = 0x01;	// set SEC */
		/*mode_sense->hdr.sense_data_len = 0x15;	// mt02 ??? <=== */
	}
#if PRINT_MODE_SENSE
	DPRINTF("MODE SELECT:");
	prt_mode_sense_data(un, mode_sense, page);
#endif

	vjcmd(un, VJ_MODE_SELECT_CMD, (char *)mode_sense, page, 0, NO_INTERRUPT);
	if ( vjwait( un, M_CRSW_CC ) )
	{
		VPRINTF("vj%d: Mode Select command failed\n", un->un_unit);
		vjfree(128, ms);
		vjsense(c, un, NO_INTERRUPT);
		return(-1);
	}
	vjfree(128, ms);
	un->un_bcount = block_size;
	return(0);
}

vjsense(c, un, flag)
VJ_CTLR *c;
VJ_UNIT *un;
int flag;
{
    register VJ_SHIO *shio = c->c_io;
    ULONG i;
    int rc=0;

	vjzero((USHORT *)un->un_sense, sizeof(SCSI_EXT_SENSE));
	for (i=0; i<MAX_SENSE_REQUESTS; i++)
	{
		vjcmd(un, VJ_SENSE, (char *)un->un_sense, 0, 1, flag);
		if ( flag == NO_INTERRUPT )
		{
			if ( rc = vjwait( un, M_CRSW_CC ))
			{
				DPRINTF("vj%d: Request Sense failed\n", un->un_unit);
			}
			else
			{
				DPRINTF("vj%d: %s",
					un->un_unit, sense_err_msg(un->un_sense->key));
				if (un->un_sense->key == SCSI_NO_SENSE)
				{
					if ( un->un_sense->filmrk ) DPRINTF("FM ");
					if ( un->un_sense->eom ) DPRINTF("EOM ");
				}
				DPRINTF("\n");
			}
		}
		if ( rc == 0 )
			break;
	} /* for */
	if ( rc != 0 )
		DPRINTF("vj%d: Invalid status on Request Sense (0x%x)\n", un->un_unit, rc);
    return( rc );
}

vjrawio(c, un, cmd, name, addr, block, count)
VJ_CTLR *c;
VJ_UNIT *un;
int cmd;
char *name, *addr;
int block, count;
{
	register int	i;

	for ( i = 0; i < 4; i++ )
	{
		vjcmd(un, cmd, addr, block, count, NO_INTERRUPT);
		if ( vjwait(un, M_CRSW_CC) )
		{
			DPRINTF("vj%d: Error %sing %s\n",
					un->un_unit, cmd == VJ_READ ? "read" : "writ", name);
		}
		if ( (c->c_io->sh_RET_IOPB.iopb_STATUS & 0xFF00) )
			vjsense(c, un, NO_INTERRUPT);
		else
			break;
	}
	return (i < 4);
}

/*
 *    routine to send commands directly to the controller
 *
 *    NOTE:
 *        cyl & head are OPTIONAL arguments.
 *
 *        If the count is less than 0 then the request is assumed
 *        to be a physical request and cyl & head MUST be present;
 *        otherwise they can be left off.
 *
 *    ALSO:
 *        If the cmd is less than 0 interrupts will be enabled.
 *        otherwise it is assumed that the CSR will be polled.
 *
 */
vjcmd(un, cmd, dmaddr, block, count, flag)
VJ_UNIT *un;
int cmd;
char *dmaddr;
int block, count, flag;
{
    register VJ_IOPB *iopb;
    register VJ_CTLR *c    = un->un_ctlr;
    register VJ_SHIO *shio = c->c_io;
    VJ_CQE  *mce;                    /* Master Controller Entry   */

	DPRINTF("vjcmd: unit=%x, cmd=%s, dmaddr=%x, block=%x, count=%x, flag=%x\n",
			un->un_unit, vjcmds[cmd].scsi_name, dmaddr, block, count, flag);
	if ( dmaddr )
		dmaddr = (char *)(dmaddr - DVMA);
    mce        = &c->c_mce;
    vjzero((USHORT *)mce, sizeof(VJ_CQE));
    if ( cmd == VJ_CNTR_INIT )
    {
        VJ_CIB  *cib;

        iopb                 = &c->c_miopb;
        cib                  = &c->c_cib;

        vjzero((USHORT *)iopb, sizeof(VJ_IOPB));
        vjzero((USHORT *)cib, sizeof(VJ_CIB));

        mce->cqe_IOPB_ADDR   = (UWORD)((INT)&shio->sh_MCE_IOPB - (INT)shio);
        mce->cqe_IOPB_LENGTH = 0;

        c->c_mce_iopb        = (VJ_IOPB *)&shio->sh_MCE_IOPB;
        iopb->iopb_CMD       = CNTR_INIT;
        W( iopb->iopb_ADDR ) = SHIO_MOD;
        LV(iopb->iopb_BUFF, (ULONG)((INT)&shio->sh_CIB - (INT)shio));
        LV(iopb->iopb_LENGTH, (ULONG)S_CIB);

        cib->cib_NCQE        = NUM_CQE;
        cib->cib_BURST       = VJ_BURST_COUNT;
        W( cib->cib_NVECT )  = VEC(c, c->c_nintvec);
        W( cib->cib_EVECT )  = VEC(c, c->c_eintvec);
        W( cib->cib_PID )    = DEFAULT_SCSI_ID;
        W( cib->cib_SID )    = DEFAULT_SCSI_ID;
        cib->cib_SELECT_msw  = VJ_SELECTION_TIMEOUT << 16;
        cib->cib_SELECT_lsw  = VJ_SELECTION_TIMEOUT;
        cib->cib_RESELECT_msw= VJ_INFINITE_TIMEOUT << 16;
        cib->cib_RESELECT_lsw= VJ_INFINITE_TIMEOUT;
        cib->cib_VMETIMO_msw = 0; 	/* VME time out in 32 msec increment */
        cib->cib_VMETIMO_lsw = 0;
        cib->cib_CRBO        = (UWORD)((INT)&shio->sh_CRB - (INT)shio);
#if SYNCRATE
		cib->cib_SYNCRATE	 = VJ_SYNC_RATE;
		cib->cib_OPTIONS	 = VJ_CIB_OPT;
#endif
        vjmove(iopb, &shio->sh_MCE_IOPB, sizeof( VJ_IOPB) );
        vjmove(cib,  &shio->sh_CIB,      sizeof( VJ_CIB ) );
    }
    else if ( cmd == VJ_INIT_WORKQ )
    {
        VJ_WQCF *wqcf = &c->c_wqcf;

        vjzero((USHORT *)wqcf, sizeof(VJ_WQCF));

        mce->cqe_IOPB_ADDR   = ((INT)c->c_mce_iopb - (INT)shio);
        LV(mce->cqe_CTAG, (ULONG)c->c_mce_iopb);
        mce->cqe_IOPB_LENGTH = 0;

        wqcf->wqcf_CMD       = CNTR_INIT_WORKQ;    
        wqcf->wqcf_NVCT      = c->c_nintvec;
        wqcf->wqcf_EVCT      = c->c_eintvec;
        wqcf->wqcf_ILVL      = c->c_level;
#if HARD_GROUPING
		wqcf->wqcf_RES1[0]	 = GROUP_COUNT;
#endif

        wqcf->wqcf_WORKQ     = un->un_workq;

        W( wqcf->wqcf_WOPT ) = M_WOPT_FE | M_WOPT_IWQ; /* Freeze on error and reinit wq allowed */

        wqcf->wqcf_SLOTS     = VJ_DISK_SLOTS + 1;
        wqcf->wqcf_PRIORITY  = VJ_DISK_PRIORITY;

        vjmove(wqcf, &shio->sh_MCE_IOPB, sizeof( VJ_WQCF ) );
    }
    else if ( cmd == VJ_SCSI_RESET )
    {
        VJ_SBRF *sbrf = &c->c_sbrf;
 
        vjzero((USHORT *)sbrf, sizeof(VJ_SBRF));
 
        mce->cqe_IOPB_ADDR   = ((INT)c->c_mce_iopb - (INT)shio);
        LV(mce->cqe_CTAG, (ULONG)c->c_mce_iopb);
        mce->cqe_IOPB_LENGTH = 0;
 
        sbrf->sbrf_CMD       = SCSI_RESET;
        sbrf->sbrf_NVCT      = c->c_nintvec;
        sbrf->sbrf_EVCT      = c->c_eintvec;
        sbrf->sbrf_ILVL      = c->c_level;
 
        if ( block )
            W_ROPT(sbrf->sbrf_BUS) = M_ROPT_BUS;
 
        vjmove(sbrf, &shio->sh_MCE_IOPB, sizeof(VJ_SBRF));
    }
    else                /* Pass thru command      */
    {
        mce->cqe_IOPB_ADDR   = (UWORD)((INT)c->c_mce_iopb - (INT)shio);
        if ( VJ_SENSE == cmd )
		{
            LV(mce->cqe_CTAG, (ULONG)(SPECIAL_MASK | un->un_workq));
		}
        else
		{
            LV(mce->cqe_CTAG, (ULONG)c->c_mce_iopb);
		}
        mce->cqe_IOPB_LENGTH = 0;

        iopb = &c->c_miopb;
		vjzero((USHORT *)iopb, sizeof(VJ_IOPB));

		W( iopb->iopb_OPTION ) = 0;
        if (flag & WANT_INTERRUPT)
            W( iopb->iopb_OPTION ) |= M_OPT_IE;		/* Interrupt enable */
		if (un->un_flags & VJ_NO_SYNC_XFER)
			W( iopb->iopb_OPTION ) |= M_OPT_SS;			/* Supress sync xfer */
		vj_cmdiopb(un, iopb, cmd, count, block, dmaddr);

        vjmove(iopb, c->c_mce_iopb, sizeof(VJ_IOPB));
    }
    vjmove(mce, &shio->sh_MCE, sizeof( VJ_CQE ) );
	CQE_GO( shio->sh_MCE.cqe_QECR );
}

/*
 * Set up the IOPB for a SCSI pass through command
 * The arguments come from:
 *				vjcmd()			vjsplcmd()	==> vjenqspl()
 *	cmd:		cmd arg			cmd arg		==> bp->b_scsicmd
 *	count:		count arg		count arg	==> bp->b_scsicnt
 *	param:		block arg		param arg	==> bp->b_scsiparam
 *	addr:		dmaddr arg		addr arg	==>	un_spladdr
 */
vj_cmdiopb(un, iopb, cmd, count, param, addr)
register VJ_UNIT *un;
VJ_IOPB *iopb;
int cmd, count, param;
char *addr;
{
	VJ_CTLR		*c = un->un_ctlr;
	SCSI_CDB	*cdb = (SCSI_CDB *)&iopb->iopb_SCSI[0];
	SCSI_CDB_1	*cdb1 = (SCSI_CDB_1 *)&iopb->iopb_SCSI[0];

	iopb->iopb_CMD		= vjcmds[cmd&0xff].macsi_cmd;
	iopb->iopb_NVCT		= c->c_nintvec;
	iopb->iopb_EVCT		= c->c_eintvec;
	iopb->iopb_LEVEL	= c->c_level;
	W(iopb->iopb_ADDR)	= ADDR_MOD;
	W(iopb->iopb_UNIT)	= un->un_slave;
	iopb->iopb_UNIT.U.b.LUN	= un->un_lun;

    if ( (cmd & 0xff) == VJ_SPECIAL_SCSI )
    {
        int size = (cmd>>8)&0xff;
        int option = (cmd>>16)&0xff;
 
        cdb->cmd = (cmd>>24)&0xff;
        cdb->lun = un->un_lun;
        if ( option & OPTION_10B )
        {
            cdb1->res0 = (option>>1)&0xf;
            cdb1->reladr = option&0x1;
            CDB_ADDR_1(cdb1, param);
            CDB_XFER_LEN_1(cdb1, count);
        }
        else
        {
            CDB_ADDR(cdb, param);
            cdb->count = count&0xff;
        }
        LV(iopb->iopb_LENGTH, (ULONG)size);
        LV(iopb->iopb_BUFF, (ULONG)addr);
        if ( cdb->cmd == SCSI_MODE_SELECT
          || cdb->cmd == SCSI_REASSIGN_BLOCK
          || cdb->cmd == SCSI_WRITE )
            W(iopb->iopb_OPTION) |= M_OPT_DIR;
		if ( vj_debug )
			dump_bytes((char *)cdb, (option & OPTION_10B) ? 10 : 6);
        return;
    }
 
    cdb->cmd            = vjcmds[cmd&0xff].scsi_cmd;
	cdb->lun			= un->un_lun;

	switch ( cdb->cmd ) {

	case SCSI_WRITE_FILE_MARKS:
		cdb->high_addr = param;
		CDB_XFER_LEN(cdb, count);
		break;

	case SCSI_SPACE:
		cdb->high_addr = param;
		CDB_XFER_LEN(cdb, count);
		break;

	case SCSI_ERASE:
		cdb->high_addr = param;
	case SCSI_REWIND:
		break;

	case SCSI_LOAD:
		cdb->count = count;
		cdb->high_addr = param;
		break;

	case SCSI_LOCK:
		cdb->count = count;
		break;

	case SCSI_FORMAT_UNIT:
		/* Initiator defect list will NOT be supplied */
		/* Defect list format is block format */
		/* Use default format data pattern */
		/* Use default interleave factor */
		break;

	case SCSI_INQUIRY:
		cdb->count = sizeof(VJ_INQUIRY);
		LV(iopb->iopb_LENGTH, (ULONG)sizeof(VJ_INQUIRY));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		break;

	case SCSI_MODE_SENSE:
		cdb->count = sizeof(VJ_MS_HDR) + sizeof(VJ_MS_BLK_DESC);
        if(un->un_type & (DT_DISK|DT_WORM))
		{
			switch (param)	/* page code */
			{
			case 0x00:
				break;
			case 0x01:
				/* Sony Magneto Optical drive */
                if (un->un_type & DT_SONY_MO)
                    cdb->count = 12;			/* set correct count for page 1 */
                else cdb->count += sizeof(VJ_MS_PAGE1);
				break;
			case 0x02:
				/* Sony Magneto Optical drive */
                if (un->un_type & DT_SONY_MO)
                    cdb->count = 16;			/* set correct count for page 2 */
                else cdb->count += sizeof(VJ_MS_PAGE2);
				break;
			case 0x03:
				cdb->count += sizeof(VJ_MS_PAGE3);
				break;
			case 0x04:
				cdb->count += sizeof(VJ_MS_PAGE4);
				break;
			case 0x07:
				cdb->count += sizeof(VJ_MS_PAGE7);
				break;
			case 0x08:
				cdb->count += sizeof(VJ_MS_PAGE8);
				break;
			case 0x0a:
				cdb->count += sizeof(VJ_MS_PAGEAH);
				break;
			case 0x0c:
				cdb->count += sizeof(VJ_MS_PAGECH);
				break;
			case 0x10:
				cdb->count += sizeof(VJ_MS_PAGE10H);
				break;
			case 0x11:
				cdb->count += sizeof(VJ_MS_PAGE11H);
				break;
            case 0x20:
				/* Sony Magneto Optical drive */
                cdb->count = 16;			/* set correct count for page 20 */
                break;
			case 0x32:
				cdb->count += sizeof(VJ_MS_PAGE32H);
				break;
			case 0x38:
				cdb->count += sizeof(VJ_MS_PAGE38H);
				break;
			default:
				DPRINTF("unknown page code\n");
				break;
			}
			cdb->mid_addr = param;
		}
		LV(iopb->iopb_LENGTH, (ULONG)cdb->count);
		LV(iopb->iopb_BUFF, (ULONG)addr);
		break;

	case SCSI_MODE_SELECT:
		cdb->count = sizeof(VJ_MS_HDR) + sizeof(VJ_MS_BLK_DESC);
		if (un->un_type & DT_TAPE)
		{
			if (un->un_type & DT_EXABYTE_TAPE)
				cdb->count += EXABYTE_UNIQ_PARAM_LEN;
		}
		else /* disk, ... */
		{
			switch (param)	/* page code */
			{
			case 0x00:
				break;
			case 0x01:
				/* Sony Magneto Optical drive */
                if (un->un_type & DT_SONY_MO)
                {
                    cdb->high_addr |= 0x10;		/* set PF */
                    cdb->count = 12;			/* set correct count for page 1 */
                }
                else cdb->count += sizeof(VJ_MS_PAGE1);
				break;
			case 0x02:
				/* Sony Magneto Optical drive */
                if (un->un_type & DT_SONY_MO)
                {
                    cdb->high_addr |= 0x10;		/* set PF */
                    cdb->count = 16;			/* set correct count for page 2 */
                }
                else cdb->count += sizeof(VJ_MS_PAGE2);
				break;
			case 0x03:
				cdb->count += sizeof(VJ_MS_PAGE3);
				break;
			case 0x04:
				cdb->count += sizeof(VJ_MS_PAGE4);
				break;
			case 0x07:
				cdb->count += sizeof(VJ_MS_PAGE7);
				break;
			case 0x08:
				cdb->count += sizeof(VJ_MS_PAGE8);
				break;
			case 0x0a:
				cdb->count += sizeof(VJ_MS_PAGEAH);
				break;
			case 0x0c:
				cdb->count += sizeof(VJ_MS_PAGECH);
				break;
			case 0x10:
				cdb->count += sizeof(VJ_MS_PAGE10H);
				break;
			case 0x11:
				cdb->count += sizeof(VJ_MS_PAGE11H);
				break;
            case 0x20:
				/* Sony Magneto Optical drive */
                cdb->high_addr |= 0x10;		/* set PF */
                cdb->count = 16;			/* set correct count for page 20 */
                break;
			case 0x32:
				cdb->count += sizeof(VJ_MS_PAGE32H);
				break;
			case 0x38:
				cdb->count += sizeof(VJ_MS_PAGE38H);
				break;
			default:
				DPRINTF("unknown page code\n");
				break;
			}
		}
		if (cdb->count & 1)
		{
			int cnt = cdb->count + 1;	/* make it a even no */
			LV(iopb->iopb_LENGTH, (ULONG)cnt);
		}
		else
			LV(iopb->iopb_LENGTH, (ULONG)cdb->count);
		LV(iopb->iopb_BUFF, (ULONG)addr);
		W(iopb->iopb_OPTION) |= M_OPT_DIR;
		break;

	case SCSI_READ_CAPACITY:
		LV(iopb->iopb_LENGTH, (ULONG)sizeof(VJ_CAPACITY));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		break;

	case SCSI_REASSIGN_BLOCK:
		LV(iopb->iopb_LENGTH, (ULONG)sizeof(VJ_RSGNBLK));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		W(iopb->iopb_OPTION) |= M_OPT_DIR;
		break;

	case SCSI_REQUEST_SENSE:
		CDB_ADDR(cdb, param);
		cdb->count = sizeof(SCSI_EXT_SENSE);
		LV(iopb->iopb_LENGTH, (ULONG)sizeof(SCSI_EXT_SENSE));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		break;

	case SCSI_LIST:
		/* get G-list or P-list of defects */
		LV(iopb->iopb_LENGTH, (ULONG)sizeof(VJ_DEFLIST));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		cdb1->blk_addr_3 = param;
		cdb1->blk_addr_2 = 0;
		cdb1->blk_addr_1 = 0;
		cdb1->blk_addr_0 = 0;
		cdb1->res1 = 0;
		cdb1->len_1 = (sizeof(VJ_DEFLIST) >> 8) & 0xff;
		cdb1->len_0 = sizeof(VJ_DEFLIST) & 0xff; 
		cdb1->vu1 = 0;
		cdb1->res4 = 0;
		cdb1->flag = 0;
		cdb1->link = 0;
		break;

	case SCSI_WRITE:
		W(iopb->iopb_OPTION) |= M_OPT_DIR;
	case SCSI_READ:
		if (un->un_type & DT_EXT_RW)
		{
			/* bump into SCSI_READ_EXTENDED or SCSI_WRITE_EXTENDED */
    		cdb1->cmd += 0x20;
            CDB_ADDR_1(cdb1, param);
            CDB_XFER_LEN_1(cdb1, count);
		}
		else
		{
			CDB_ADDR(cdb, param);
			cdb->count = (count & 0xff);
		}
		LV(iopb->iopb_LENGTH, (ULONG)(SECTORSIZE * count));
		LV(iopb->iopb_BUFF, (ULONG)addr);
		break;

	case SCSI_TEST_UNIT_READY:
		break;

	default:
		DPRINTF("vj_cmdiopb: unknown scsi cmd = %x\n", cdb->cmd);
		break;
	}
}

vjwait( un, mask )
register VJ_UNIT *un;
register UWORD mask;
{
    register VJ_CTLR *c = un->un_ctlr;
    register VJ_SHIO *shio = c->c_io;
    register VJ_CRB *crb   = &shio->sh_CRB;
    register VJ_IOPB *iopb = &shio->sh_RET_IOPB;
    register int count, rc;

	DPRINTF("vjwait: unit=%x, mask=%x\n", un->un_unit, mask);
	DELAY(5000);
	count = WHILE_DELAY;

    while( !(W( crb->crb_CRSW ) & M_CRSW_CRBV) && count-- ) 
    {
		DELAY(1000);
    }

    rc = 0;
    if (count <= 0)
    {
        rc = ((int)W( crb->crb_CRSW ) & 0x0FFFF );
        DPRINTF("vj%d: CRBV bit not found, CRSW = 0x%x\n",
			un->un_unit, W( crb->crb_CRSW ));
    }
    else if ( (W( crb->crb_CRSW ) & mask) != mask)
    {
        rc = ((int)W( crb->crb_CRSW ) & 0x0FFFF );
        DPRINTF("vj%d: CRSW = 0x%x, mask = 0x%x\n",
			un->un_unit, W( crb->crb_CRSW ), mask);
    }
    if ( W( crb->crb_CRSW ) & M_CRSW_ER && rc == 0)
    {
        rc = ((int)iopb->iopb_STATUS )& 0x0FFFF;
        if ( (rc & 0xFF) == SCSI_XFER_EXCEPTION
          || (rc & 0xFF) == SCSI_BUS_RESET )
		{
			rc = 0;
		}
		else
		{
			DPRINTF("vj%d: Unable to send command, CRSW = 0x%x, SCSI error=0x%x (%s)\n",
					un->un_unit, W( crb->crb_CRSW), iopb->iopb_STATUS >> 8,
					scsi_err_msg(iopb->iopb_STATUS >> 8));
			DPRINTF("    Jaguar Exception=%x (%s)\n",
					iopb->iopb_STATUS&0xff,
					jaguar_err_msg(iopb->iopb_STATUS&0xff));
		}
    }

    CRB_CLR_DONE( crb->crb_CRSW );
    return( rc );
}

/*
 *	Queue 'special' (mostly tape) commands through vjstrategy
 */
vjsplcmd(un, cmd, count, param, addr)
register VJ_UNIT *un;
char *addr;
{
	register BUF *bp;
	register int s;
	register int i;
	register int x;

	bp = &un->un_sbuf;

	s = SPLX();

	while (bp->b_flags & B_BUSY)
	{
		bp->b_flags |= B_WANTED;
		sleep((caddr_t)bp, PRIBIO);
	}
	bp->b_flags = B_BUSY | B_SPL;	/* tape 'special' cmd */

	splx(s);

	/* I know it is ugly, I know. */
#if MULT_MAJOR
    /* calculate the proper major and minor numbers */
    for ( i = 0, bp->b_dev = 0; bp->b_dev == 0; i++)
        for ( x = 0; x < 16; x++)
            if (vjindex[i].ix[x] == un->un_unit)
            {
                bp->b_dev = (VJCHRMAJOR + i) << 8;
                bp->b_dev |= x * 8;
				break;
            }
#else
    bp->b_dev = un->un_unit << 3;
#endif
	bp->b_scsicmd = (BUF *)cmd;	/* put scsi cmd and params in buf hdr structure */
	bp->b_scsicnt = (BUF *)count;
	bp->b_scsiparam = param;
	un->un_spladdr = addr;

	vjstrategy(bp);

	iowait(bp);


	bp->b_flags &= ~(B_BUSY|B_SPL);
	if (bp->b_flags & B_WANTED)
		wakeup((caddr_t)bp);

	return (bp->b_flags & B_ERROR);
}

/*
 *	Return the size of a logical partition.
 */
vjsize(dev)
dev_t dev;
{
    register VJ_UNIT *un = &vjunits[VJUNIT(dev)];
	VJ_CTLR *c = &vjctlrs[VJCTLR(un)];

	if ( !un->un_ready )
		return -1;
	return un->un_map[LPART(dev)].dkl_nblk;
}

vjopen(dev, flag)
dev_t dev;
{
    int s, unit = VJUNIT(dev);
    register VJ_UNIT *un = &vjunits[unit];
	VJ_CTLR *c = &vjctlrs[VJCTLR(un)];
    
	if (unit >= NVJ)
	{
		ERETURN(ENXIO);
	}
	DPRINTF("vjopen: dev=%x, unit=%x, type=%x, present=%x, ready=%x\n",
			dev, unit, un->un_type, un->un_present, un->un_ready);
	if ( un->un_slave & M_UNIT_BUS )	/* secondary bus */
	{
		if ( (un->un_slave&0x7) == c->c_sid )
			ERETURN(ENXIO);
	}
	else
	{
		if ( (un->un_slave&0x7) == c->c_pid )
			ERETURN(ENXIO);
	}

	if ( SPECIAL(dev) && (un->un_type & DT_DISK) )
	{
		/* fake a disk geometry in */
		un->un_map[LPART(dev)].dkl_cylno = 0;
		un->un_map[LPART(dev)].dkl_nblk = 16384;
		un->un_g.dkg_ncyl	= 823;
		un->un_g.dkg_acyl	= 23;
		un->un_g.dkg_bcyl	= 0;
		un->un_g.dkg_nhead	= 4;
		un->un_g.dkg_nsect	= 32;
		un->un_spc			= 128;
		un->un_ready = 1;
	}

/* start of rogue's mods */

    /* force a reattach if the special device is called and the device
       is an Exabyte tape.  This will act to reset the tape drive drive
       in the event of a Exabyte hang/power fail */

    if ( (un->un_type & DT_EXABYTE_TAPE) && SPECIAL(dev) )
    {
        s = SPLX();
        (void) do_attach(VJCTLR(un), unit, (un->un_slave&0x7)*8+un->un_lun,
                    un->un_slave&M_UNIT_BUS, SPECIAL(dev));
        splx(s);
    }
/* end of rogue's mods */

	/* Sony Magneto Optical drive */
	/* The test unit ready command must be executed every time
	   open is called.  Because if the media has been changed
	   the current label must be trashed and un_ready must be
	   cleared. */
    if ((un->un_type & DT_SONY_MO) && (un->un_ready))
    {
        if ( vjsplcmd(un, VJ_UNIT_READY, 0, 0, (char *)0) )
        {
            (void) vjsplcmd(un, VJ_SENSE, 0, 0, un->un_sense);
            for ( s = 0; s < NLPART; s++ )
            {
                un->un_map[s].dkl_cylno = 0;
                un->un_map[s].dkl_nblk  = 0;
            }
            un->un_ready = 0;
        }
    }
 
	if ( !un->un_ready )	/*  test for un_present is implied */
	{
		if (un->un_type & DT_TAPE)
		{
		/* REMOVED 2/21/91 ron
			s = SPLX();
			do_attach (VJCTLR(un), unit, (un->un_slave&0x7)*8+un->un_lun,
					un->un_slave&M_UNIT_BUS, SPECIAL(dev));
			splx(s);
			if ( !un->un_ready )	
				ERETURN(ENXIO);
		*/
		}
		/* Sony Magneto Optical drive */
		/* If the media has been changed we must get the new
		   label. */
		if (un->un_type & DT_SONY_MO)
		{
			s = SPLX();
			do_attach (VJCTLR(un), unit, (un->un_slave&0x7)*8+un->un_lun,
					un->un_slave&M_UNIT_BUS, 0);
			splx(s);
			if ( !un->un_ready )					/* never attached */
				ERETURN(ENXIO);
		}
		else
		{
			ERETURN(ENXIO);
		}
	}


    if ( un->un_type & (DT_TAPE | DT_PRINTER) )
	{
		if ( !un->un_opened )
			un->un_opened = TRUE;
		else
		{
			ERETURN(EBUSY);						/* already opened */
		}
	}
 
	/* added 2/21/91 ron -- Test Unit Ready */
	if (un->un_type & DT_TAPE)
	{
		int	i;

		for ( i = 0; i < 3; ++i )
		{
			if ( !vjsplcmd(un, VJ_UNIT_READY, 0, 0, (char *)0) )
				break;
		}
		(void) vjsplcmd(un, VJ_SENSE, 0, 0, un->un_sense);
		if ( i == 3 )
		{
			VPRINTF("vj%d: Tape not ready\n", unit);
			un->un_opened = FALSE;
			ERETURN(EIO);
		}
		un->un_ready = 1;
		un->un_unxfmk = 0;		/* move forward filemark enable */
		ERETURN(0);
	}
#if	GDAT
	if ( un->un_gdat )
	{
		int	i, j;

		/* Test Unit Ready */
		for ( i = 0; i < 3; ++i )
		{
			for ( j = 0; j < 3; ++j )
				if ( !vjsplcmd(un, VJ_UNIT_READY, 0, 0, (char *)0) )
					break;
			if ( j < 3 )
				break;

			/* Try to load a tape if not ready */
			if ( vjsplcmd(un, VJ_LOAD, 1, 0, (char *)0) )
			{
				printf("vj%d: Can't load the DAT\n", unit);
				un->un_opened = FALSE;
				ERETURN(EIO);
			}
			(void) vjsplcmd(un, VJ_SENSE, 0, 0, un->un_sense);
		}
		if ( i == 3 )
		{
			printf("vj%d: DAT not ready\n", unit);
			un->un_opened = FALSE;
			ERETURN(EIO);
		}

		/* Sense the current partition */
		if ( gdat_sense_part(un) )
		{
			printf("vj%d: Can't access the DAT\n", unit);
			un->un_opened = FALSE;
			ERETURN(EIO);
		}

		/* Set the correct partition */
		if ( FIXED_CHK(dev) && un->un_part != 1
		  || !FIXED_CHK(dev) && un->un_part != 0 )
		{
			if ( gdat_switch_part(un, un->un_part ^ 1) )
			{
				printf("vj%d: Can't change the DAT partition\n", unit);
				un->un_opened = FALSE;
				ERETURN(EIO);
			}
		}

		/* Prevent the tape from being removed */
		if ( vjsplcmd(un, VJ_LOCK, 1, 0, (char *)0) )
		{
			printf("vj%d: Error in preventing DAT removal\n", unit);
			un->un_opened = FALSE;
			ERETURN(EIO);
		}
		un->un_locked = 1;
		un->un_unxfmk = 0;		/* move forward filemark enable */
		ERETURN(0);
	}
#endif	/* GDAT */


	if ( !(un->un_type & DT_WORM) && (un->un_type & DT_REMOVABLE) && !un->un_locked )
	{
		if ( vjsplcmd(un, VJ_LOCK, 1, 0, (char *)0) )
		{
			VPRINTF("vj%d: Error locking in removable media\n", unit);
			un->un_opened = FALSE;
			ERETURN(EIO);
		}
		un->un_locked = 1;
	}

    ERETURN(0);
}

vjclose(dev, flag)
dev_t dev;
{
    register VJ_UNIT *un = &vjunits[ VJUNIT(dev) ];
    register int fmkcnt;

	DPRINTF("vjclose: dev=%x, unit=%x\n", dev, un->un_unit);
	if ( !(un->un_type&DT_TAPE) && (un->un_type&DT_REMOVABLE) && un->un_locked )
	{
		if ( vjsplcmd(un, VJ_LOCK, 0, 0, (char *)0) )
			VPRINTF("vj%d: Error unlocking removable media\n", un->un_unit);
		un->un_locked = 0;
	}
    if ( un->un_type & DT_DISK )
    {
    	ERETURN(0);
    }
	else
    if ( !(un->un_type & DT_TAPE) )
    {
		un->un_opened = FALSE;	/* reset opened flag */
    	ERETURN(0);
    }
    /*
     *  For tape only
     */
    if ((un->un_rwflag & FWRITE) && !un->un_mtflag)
    {				/* write 2 file marks */
		if (NTRCK_CHK(dev))
			fmkcnt = 2;		/* 9-track */
		else
			fmkcnt = REWND_CHK(dev) ? 2 : 1;	/* stream tape */

    	if ( vjsplcmd(un, VJ_W_FM, fmkcnt, 0, (char *)0) )
			VPRINTF("vj%d: Error in writing file marks\n", un->un_unit);

		if (REWND_CHK(dev))
		{
    		if ( vjsplcmd(un, VJ_REWIND, 0, 0, (char *)0) )
				VPRINTF("vj%d: Error in rewinding\n", un->un_unit);
		}
		else
		if (NTRCK_CHK(dev))
		{
			/* back 1 space fm */
			if ( vjsplcmd(un, VJ_SPACE, -1, 1, (char *)0) )
				VPRINTF("vj%d: Error in bsf\n", un->un_unit);
		}
#if 0
		else
			VPRINTF("vj%d: Warning: only a single file mark was written to the tape.\n", un->un_unit);
#endif
    }	
    else
    {
		if((un->un_rwflag & FREAD) && !un->un_mtflag)
		{
    		if (REWND_CHK(dev))
			{
				if ( vjsplcmd(un, VJ_REWIND, 0, 0, (char *)0) )
					VPRINTF("vj%d: Error in rewinding\n", un->un_unit);
			}
			else
#if	GDAT
			if ( !un->un_gdat )			/* Leave GDAT where it last read */
#endif
			{
				if (!un->un_unxfmk)
				{
    				if ( vjsplcmd(un, VJ_SPACE, 1, 1, (char *)0) )
						VPRINTF("vj%d: Error in fsf\n", un->un_unit);
				}
				printf("clearing unxfmk in vjclose");
				un->un_unxfmk = 0; /* added by jdb 1/21/91 */
			}
		}
    }

	/* Allow the tape to be removed */
	if ( un->un_locked )
	{
		if ( vjsplcmd(un, VJ_LOCK, 0, 0, (char *)0) )
			VPRINTF("vj%d: Error in unlock\n", un->un_unit);
		un->un_locked = FALSE;
	}

    un->un_opened = FALSE;				/* reset opened flag */
	un->un_mtflag = FALSE;				/* reset mt ioctl flag */
	un->un_rwflag = FALSE;				/* reset read/write flag */
    ERETURN(0);
}

vjioctl(dev, cmd, data, flag)
dev_t dev;
caddr_t data;
{
    register VJ_UNIT *un = &vjunits[VJUNIT(dev)];
    register VJ_CTLR *c  = (VJ_CTLR *)un->un_ctlr;
	VJ_SHIO *shio = c->c_io;
    int callcnt, rc;
    struct mtop *mtop;
    struct mtget *mtget;

	DPRINTF("vjioctl: dev=%x, cmd=%s, data=%x, flag=%x, un_type=%x\n",
			dev, ioctl_str(cmd), data, flag, un->un_type);

    if(un->un_type & DT_DISK)
	{
		switch (cmd)
		{
		case DKIOCINFO:
			{
			struct dk_info *inf;

			inf            = (struct dk_info *)data;
			inf->dki_ctype = DKC_UNKNOWN;
            inf->dki_ctlr  = ( int )( un->un_ctlr->c_io) ; /* vme addr */
            inf->dki_unit  = un->un_slave;
            inf->dki_flags = DKI_FMTTRK+DKI_MAPTRK;
			}
            break;

		case DKIOCGCONF:	/* we actually use it to pass 'unit' conf info */
			{
			struct dk_conf *conf;

			conf = (struct dk_conf *)data;
			strncpy(conf->dkc_cname, "Jaguar", DK_DEVLEN);
			conf->dkc_slave = un->un_slave;
			conf->dkc_unit = dev;
			}
			break;

        case DKIOCGGEOM:
            *(struct dk_geom *)data = un->un_g;    /* struct assignment */
            break;

        case DKIOCSGEOM:
            if ( !suser() )
			{
                ERETURN(EACCES);
			}
            un->un_g = *(struct dk_geom *)data;    /* struct assignment */
            break;

        case DKIOCGPART:
			{
			DK_MAP *lp  = &un->un_map[LPART(dev)];

            *(struct dk_map *)data = *lp;        /* struct assignment */
			}
            break;

        case DKIOCSPART:
			{
			DK_MAP *lp  = &un->un_map[LPART(dev)];

            if ( !suser() )
			{
					ERETURN(EACCES);
			}
            *lp = *(struct dk_map *)data;        /* struct assignment */
			}
            break;

		case VJIOCSPART:
            if ( !suser() )
			{
					ERETURN(EACCES);
			}
            COPYIN(data, (char *)un->un_map, sizeof(VJ_DKMAP));
            break;

		case VJIOSLABEL:	/* use newly created lable */
			if ( !suser() || !vjgetlabel(c, un) )
			{
					ERETURN(EACCES);
			}
            break;

		case VJIODRIVER:
			strncpy(((VJ_DRIVER *)data)->dr_revision, vjCSid,
				sizeof(vjCSid));
			break;

		case VJIOCONF:
		{
			VJ_CSB Csb;
    		vjmove( &shio->sh_CSS, &Csb, sizeof( VJ_CSB ) );
			COPYOUT(&Csb, data, sizeof(VJ_CSB));
			/*COPYOUT((char *)&(shio->sh_CSS), data, sizeof(VJ_CSB)); ??? */
			break;
		}

		case VJIOINQ:
			ERETURN(vj_splioctl(un, VJ_INQUIRY_CMD, "Inquiry",
								sizeof(VJ_INQUIRY), data, B_READ, 0));

		case VJIOCAP:
			ERETURN(vj_splioctl(un, VJ_READ_CAPACITY, "Read Capacity",
								sizeof(VJ_CAPACITY), data, B_READ, 0));

		case VJIOMSENSE03:
			/* Sony Magneto Optical drive */
    		if (un->un_type & DT_SONY_MO)
			{
				/* SMO does not have page 3, so set up for vjutil call.
                   Cylinder count will be zero, vjutil will calculate
				   this number from the read capacity command.
				   return heads = 16, sectors = 30, interleave = 1 */
				data[14] = 0;	/* trk_per_zone_hi =  0 */
				data[15] = 1;	/* trk_per_zone_lo = 1 */
				data[20] = 0;	/* alt_trk_per_vol_hi =   0 */
				data[21] = 32;	/* alt_trk_per_vol_lo = 32 */
				data[22] = 0;	/* sctr_per_trk_hi =  0 */
				data[23] = 30;	/* sctr_per_trk_lo = 30 */
				data[26] = 0;	/* interleave_value_hi = 0 */
				data[27] = 1;	/* interleave_value_lo = 1 */
				return(0);
			}
			rc = vj_splioctl(un, VJ_MODE_SENSE_CMD, "Mode Sense",
				sizeof(VJ_MS_HDR)+sizeof(VJ_MS_BLK_DESC)+sizeof(VJ_MS_PAGE3),
				data, B_READ, 0x03);
			return(rc);

		case VJIOMSENSE04:
			/* Sony Magneto Optical drive */
    		if (un->un_type & DT_SONY_MO)
			{
				/* SMO does not have page 4, so set up for vjutil call.
                   Cylinder count will be zero, vjutil will calculate
				   this number from the read capacity command.
				   return heads = 16, sectors = 30, interleave = 1 */
				data[14] = 0;	/* max_no_cyl_hi  =  0 */
				data[15] = 0;	/* max_no_cyl_mid =  0 */
				data[16] = 0;	/* max_no_cyl_lo  =  0 */
				data[17] = 16;	/* max_no_heads   = 16 */
				return(0);
			}
			rc = vj_splioctl(un, VJ_MODE_SENSE_CMD, "Mode Sense",
				sizeof(VJ_MS_HDR)+sizeof(VJ_MS_BLK_DESC)+sizeof(VJ_MS_PAGE4),
				data, B_READ, 0x04);
			return(rc);

		case VJIOMSELECT:
			/* If mode select for Sony defined page 0x20 and not Sony
			   Magneto Optical drive return 0.  This is for vjutil call
			   for Sony specific page. */
    		if (!(un->un_type & DT_SONY_MO) && (data[4] == 0x20))
				return(0);
			/* Special Sony Magneto Optical drive page 0x20 */
    		if ((un->un_type & DT_SONY_MO) && (data[4] == 0x20))
				ERETURN(vj_splioctl(un, VJ_MODE_SELECT_CMD, "Mode Select",
								sizeof(VJ_MODE_SENSE), data, B_WRITE, 0x20));
			else ERETURN(vj_splioctl(un, VJ_MODE_SELECT_CMD, "Mode Select",
								sizeof(VJ_MODE_SENSE), data, B_WRITE, 0));

		/* get G-list of defects */
        case VJIOGETGDEF:
			/* the user data space to copy defect list to is 
			passed in through the data structure */
            ERETURN(vj_splioctldef(un, VJ_LIST_DEFECT, "Get G-list Defects",
                                sizeof(VJ_DEFLIST), data, B_READ, 0x0d));

		/* get P-list of defects */
        case VJIOGETPDEF:
			/* the user data space to copy defect list to is 
			passed in through the data structure */
            ERETURN(vj_splioctldef(un, VJ_LIST_DEFECT, "Get P-list Defects",
                                sizeof(VJ_DEFLIST), data, B_READ, 0x15));

		case VJIORSGNBLK:
			ERETURN(vj_splioctl(un, VJ_REASSIGN_BLOCK, "Reassign Block",
								sizeof(VJ_RSGNBLK), data, B_WRITE, 0));

        case VJIOFORMAT:		/* support runtime formatting */
            if ( !suser() )
			{
				ERETURN(EACCES);
			}
            if ( vjsplcmd(un, VJ_FORMAT, 0, 0, (char *)0) )
			{
				UPRINTF("vj%d: Error in Format Unit command\n", un->un_unit);
				ERETURN(EIO);
			}
            break;

        case VJIOFORMATDEF:	/* support runtime formatting using defect list*/
            if ( !suser() )
			{
				ERETURN(EACCES);
			}
            if ( vjsplcmd(un, VJ_FORMAT, 8, 0, (char *)0) )
			{
				UPRINTF("vj%d: Error in Format Unit command\n", un->un_unit);
				ERETURN(EIO);
			}
            break;

        case VJIOBLACKHOLE:		/* toggle vme black hole mode */
            if ( !suser() )
			{
				ERETURN(EACCES);
			}
			un->un_blackhole = un->un_blackhole ? 0 : 1;
			printf("vj%d: blackhole mode: %x\n", un->un_unit, un->un_blackhole);
			break;

        default:
            ERETURN(ENOTTY);
		} /* switch */
	} /* if */

    /*
     *		Tape
     */
    if(un->un_type & DT_TAPE)
    {
		un->un_mtflag = TRUE;
		switch(cmd)
		{
		case MTIOCTOP:
			mtop = (struct mtop *)data;

			switch(mtop->mt_op)
			{
			case MTEOM:
    			if ( vjsplcmd(un, VJ_LOAD, 4, 0, (char *)0) )
				{
					VPRINTF("vj%d: Error in position to end of media\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTRETEN:
    			if ( vjsplcmd(un, VJ_LOAD, 3, 0, (char *)0) )
				{
					VPRINTF("vj%d: Error in retension\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTOFFL:
    			if ( vjsplcmd(un, VJ_LOAD, 0, 0, (char *)0) )
				{
					VPRINTF("vj%d: Error in offline\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTREW:
    			if ( vjsplcmd(un, VJ_REWIND, 0, 0, (char *)0) )
				{
					VPRINTF("vj%d: Error in rewinding\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTWEOF:
				callcnt = mtop->mt_count;
				while (--callcnt >= 0)
				{
    				if ( vjsplcmd(un, VJ_W_FM, 1, 0, (char *)0) )
					{
						VPRINTF("vj%d: Error in eof\n", un->un_unit);
						ERETURN(EIO);
					}
				}
				break;
			case MTFSF:
				callcnt = mtop->mt_count;
				un->un_dir = TAPE_FORWARD;
				while (--callcnt >= 0)
				{
    				if ( vjsplcmd(un, VJ_SPACE, 1, 1, (char *)0) )
					{
						VPRINTF("vj%d: Error in fsf\n", un->un_unit);
						ERETURN(EIO);
					}
				}
				break;
			case MTBSF:
				callcnt = mtop->mt_count;
				un->un_dir = TAPE_BACKWARD;
				un->un_sense->eom = 0;
				while (--callcnt >= 0)
				{
    				if ( vjsplcmd(un, VJ_SPACE, -1, 1, (char *)0) )
					{
						VPRINTF("vj%d: Error in bsf\n", un->un_unit);
						ERETURN(EIO);
					}
				}
				/* Get to the EOT side of the filemark (if not at BOT) */
				if ( !un->un_sense->eom
				  && vjsplcmd(un, VJ_SPACE, 1, 1, (char *)0) )
				{
					VPRINTF("vj%d: Error in fsf after bsf(s)\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTFSR:
				callcnt = mtop->mt_count;
				un->un_dir = TAPE_FORWARD;
				while (--callcnt >= 0)
				{
    				if ( vjsplcmd(un, VJ_SPACE, 1, 0, (char *)0) )
					{
						VPRINTF("vj%d: Error in fsr\n", un->un_unit);
						ERETURN(EIO);
					}
				}
				break;
			case MTBSR:
				callcnt = mtop->mt_count;
				un->un_dir = TAPE_BACKWARD;
				un->un_sense->filmrk = 0;
				while (--callcnt >= 0)
				{
    				if ( vjsplcmd(un, VJ_SPACE, -1, 0, (char *)0) )
					{
						VPRINTF("vj%d: Error in bsr\n", un->un_unit);
						ERETURN(EIO);
					}
				}
				/* Get to the EOT side of the filemark, if we hit one */
				if ( un->un_sense->filmrk && !un->un_sense->eom
				  && vjsplcmd(un, VJ_SPACE, 1, 1, (char *)0) )
				{
					VPRINTF("vj%d: Error in fsf after bsr(s)\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			case MTNOP:
				vjsense(c, un, NO_INTERRUPT);
				break;
			case MTERASE:
				if ( vjsplcmd(un, VJ_ERASE, 0, 1, (char *)0) )
				{
					VPRINTF("vj%d: Error in erase\n", un->un_unit);
					ERETURN(EIO);
				}
				break;
			default:
				printf("vj%d: Unknown tape command 0x%x\n",
					un->un_unit, mtop->mt_op);
				ERETURN(ENXIO);
			}
			break;

		case MTIOCGET:
			mtget = (struct mtget *)data;
#if	GDAT
			if ( un->un_gdat )
			{
				mtget->mt_type = 0x2c;
				mtget->mt_dsreg = 0;
				mtget->mt_erreg = 0;
				mtget->mt_fileno = 0;
				mtget->mt_blkno = 0;
				switch ( un->un_sense->key )
				{
				case SCSI_NO_SENSE:
				case SCSI_RECOVERABLE_ERROR:
					mtget->mt_resid = GDAT_READY;;
					break;
				case SCSI_NOT_READY:
					mtget->mt_resid = GDAT_NOT_READY;
					if ( un->un_sense->sense_code == 0x3a )
						mtget->mt_resid |= GDAT_NOMEDIA;
					break;
				case SCSI_MEDIUM_ERROR:
					mtget->mt_resid = GDAT_MEDIUM_ERROR;
					break;
				case SCSI_HARDWARE_ERROR:
					mtget->mt_resid = GDAT_HARDWARE_ERROR;
					break;
				case SCSI_ILLEGAL_REQUEST:
					mtget->mt_resid = GDAT_ILLEGAL_REQUEST;
					break;
				case SCSI_UNIT_ATTENTION:
					mtget->mt_resid = GDAT_UNIT_ATTENTION;
					if ( un->un_sense->sense_code == 0x28 )
						mtget->mt_resid |= GDAT_MEDCHG;
					break;
				case SCSI_DATA_PROTECT:
					mtget->mt_resid = GDAT_WRITE_PROTECT;
					break;
				case SCSI_BLANK_CHECK:
					mtget->mt_resid = GDAT_BLANK_CHECK;
					break;
				case SCSI_COPY_ABORTED:
					mtget->mt_resid = GDAT_COPY_ABORTED;
					break;
				case SCSI_ABORT_COMMAND:
					mtget->mt_resid = GDAT_ABORTED_COMMAND;
					break;
				case SCSI_VOLUME_OVERFLOW:
					mtget->mt_resid = GDAT_VOLUME_OVERFLOW;
					break;
				default:
					mtget->mt_resid = 0;
					break;
				}
				if ( un->un_sense->filmrk )
					mtget->mt_resid |= GDAT_EOF;
				if ( un->un_sense->eom )
					mtget->mt_resid |= (un->un_dir == TAPE_FORWARD) ? GDAT_EOT
																    : GDAT_BOT;
			}
			else
#endif
			{
				mtget->mt_type	 = MT_ISSC;	     /* from mtio.h */
			}
			break;

		default:
#if	GDAT
			if ( un->un_gdat )
			{
				switch ( cmd )
				{
				case ADDPART:			/* create partition P1 */
					callcnt = *(int *)data;
					if ( callcnt < 1 )
						ERETURN(EINVAL);
					if ( gdat_add_part(un, callcnt) )
						ERETURN(EIO);
					break;

				case DELPART:			/* delete partition P1 */
					if ( gdat_del_part(un) )
						ERETURN(EIO);
					break;

				case GETPART:			/* get the size of partition P1 */
					if ( gdat_get_part(un, (int *)data) )
						ERETURN(EIO);
					break;

				case SWITCHPART:		/* switch partitions */
					callcnt = *(int *)data;
					if ( callcnt < 0 || callcnt > 1 )
						ERETURN(EINVAL);
					if ( gdat_switch_part(un, callcnt) )
						ERETURN(EIO);
					break;

				case SENSEPART:			/* return which partition */
					if ( gdat_sense_part(un) )
						ERETURN(EIO);
					*(int *)data = un->un_part;
					break;

				case WRITE_SETMARK:		/* write fast search set mark */
    				if ( vjsplcmd(un, VJ_W_FM, 1, 2, (char *)0) )
					{
						VPRINTF("vj%d: Error in Write Set Marks command\n",
							un->un_unit);
						ERETURN(EIO);
					}
					break;

				case SPACE_SM:			/* space fwd/bwd set marks */
					callcnt = *(int *)data;
    				if ( vjsplcmd(un, VJ_SPACE, callcnt, 4, (char *)0) )
					{
						VPRINTF("vj%d: Error in Space Set Marks command\n",
							un->un_unit);
						ERETURN(EIO);
					}
					break;

				case LOCKMEDIA:			/* prevent medium removal */
					if ( vjsplcmd(un, VJ_LOCK, 1, 0, (char *)0) )
					{
						if ( un->un_sense->key != SCSI_UNIT_ATTENTION
						  || vjsplcmd(un, VJ_LOCK, 1, 0, (char *)0) )
						{
							VPRINTF("vj%d: Error in Medium Lock command\n",
								un->un_unit);
							ERETURN(EIO);
						}
					}
					un->un_locked = 1;
					break;

				case UNLOCKMEDIA:		/* allow medium removal */
					if ( vjsplcmd(un, VJ_LOCK, 0, 0, (char *)0) )
					{
						VPRINTF("vj%d: Error in Medium Unlock command\n",
							un->un_unit);
						ERETURN(EIO);
					}
					un->un_locked = 0;
					break;

				case READLOG:			/* SCSI log sense */
					{
					caddr_t tag;
					struct st_dat_tape_log	*sp;
					int	command;

					/* Get space for log sense information */
					sp = (struct st_dat_tape_log *)
							vjalloc(sizeof(struct st_dat_tape_log), &tag);
					if ( sp == NULL )
					{
						VPRINTF("vj%d: No space for Log Sense\n",un->un_unit);
						ERETURN(EIO);
					}  

					/* Do a log sense */
					command = (SCSI_LOG_SENSE << 24)
							| (OPTION_10B << 16)
							| (sizeof(struct st_dat_tape_log) << 8)
							| VJ_SPECIAL_SCSI;
					if ( vjsplcmd(un, command,
								  sizeof(struct st_dat_tape_log),
								  0x70000000, sp) )
					{
						VPRINTF("vj%d: Error in Log Sense\n", un->un_unit);
						vjfree(sizeof(struct st_dat_tape_log), tag);
						ERETURN(EIO);
					}
					if ( vj_debug )
						dump_bytes((char *)sp, sizeof(struct st_dat_tape_log));

					COPYOUT(sp, data, sizeof(struct st_dat_tape_log));
					vjfree(sizeof(struct st_dat_tape_log), tag);
					}
					break;

				case SENDIAG:			/* SCSI send diagnostic */
					if ( vjsplcmd(un, (SCSI_SEND_DIAG << 24) | VJ_SPECIAL_SCSI,
								  0, 0x040000, (char *)0)
					  && un->un_sense->key != SCSI_HARDWARE_ERROR )
					{
						VPRINTF("vj%d: Error in Send Diagnostic\n",un->un_unit);
						ERETURN(EIO);
					}
					break;

				case RECVDIAG:			/* SCSI rcv diagnostic*/
					{
					caddr_t tag;
					struct st_dat_diag	*sp;
					int		command;

					/* Get space for log sense information */
					sp = (struct st_dat_diag *)
							vjalloc(sizeof(struct st_dat_diag), &tag);
					if ( sp == NULL )
					{
						VPRINTF(
							"vj%d: No space for Receive Diagnostic Results\n",
							un->un_unit);
						ERETURN(EIO);
					}  

					/* Do a receive diagnostic results */
					command = (SCSI_RECEIVE_DIAG_RESULTS << 24)
							| (sizeof(struct st_dat_diag) << 8)
							| VJ_SPECIAL_SCSI;
					if ( vjsplcmd(un, command, 5, 0, sp) )
					{
						VPRINTF("vj%d: Error in Receive Diagnostic Results\n",
							un->un_unit);
						vjfree(sizeof(struct st_dat_diag), tag);
						ERETURN(EIO);
					}
					if ( vj_debug )
						dump_bytes((char *)sp, sizeof(struct st_dat_diag));

					COPYOUT(sp, data, sizeof(struct st_dat_diag));
					vjfree(sizeof(struct st_dat_diag), tag);
					}
					break;

				default:
					printf("vj%d: Unknown GDAT ioctl 0x%x\n", un->un_unit, cmd);
					ERETURN(ENXIO);
				}
				break;
			}
#endif /* GDAT */
			printf("vj%d: Unknown ioctl 0x%x\n", un->un_unit, cmd);
			ERETURN(ENXIO);
		}
    } /* tape */


    ERETURN(0);
}

#if	GDAT
/*
 *	GDAT mode sense/select structures
 */
struct	x10	{
	VJ_MS_HDR		h;
	VJ_MS_BLK_DESC	b;
	VJ_MS_PAGE10H	p;
};

struct	x11	{
	VJ_MS_HDR		h;
	VJ_MS_BLK_DESC	b;
	VJ_MS_PAGE11H	p;
};

/*
 *	GDAT partition support routines
 */
gdat_add_part(un, size)
register VJ_UNIT *un;
{
	caddr_t tag;
	struct x11	*xp;
	int		command, part;

	/* Get space for medium partition parameters */
	xp = (struct x11 *) vjalloc(sizeof(struct x11), &tag);
	if ( xp == NULL )
	{
		VPRINTF("vj%d: No space for medium partition parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the medium partition parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x1100, xp) )
	{
		VPRINTF("vj%d: Error in Add Partition Mode Sense for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x11));

	/* See if the partition is already defined correctly */
	if ( xp->p.add_part == 1 && xp->p.part_size == size )
	{
		vjfree(sizeof(struct x11), tag);
		return 0;
	}

	/* Get to PBOT, since the IDP bit can only be set at PBOT */
	part = un->un_part;
	if ( un->un_part != 0 && gdat_switch_part(un, 0) )
	{
		vjfree(sizeof(struct x11), tag);
		return 1;
	}
	if ( vjsplcmd(un, VJ_REWIND, 0, 0, (char *)0) )
	{
		VPRINTF("vj%d: Error in rewinding for Add Partition\n", un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}

	/* Do a mode select to add the fixed partition */
	xp->h.sense_data_len = 0;		/* clear out sense data length field */
	xp->h.medium_type = 0;			/* clear out medium type field */
	xp->p.idp = 1;
	xp->p.add_part = 1;
	xp->p.part_size = size;
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x11));
	command = (SCSI_MODE_SELECT << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x100000, xp) )
	{
		VPRINTF("vj%d: Error in Add Partition Mode Select for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}

	vjfree(sizeof(struct x11), tag);
	return gdat_switch_part(un, part);
}

gdat_del_part(un)
register VJ_UNIT *un;
{
	caddr_t tag;
	struct x11	*xp;
	int		command;

	/* Get space for medium partition parameters */
	xp = (struct x11 *) vjalloc(sizeof(struct x11), &tag);
	if ( xp == NULL )
	{
		VPRINTF("vj%d: No space for medium partition parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the medium partition parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x1100, xp) )
	{
		VPRINTF("vj%d: Error in Delete Partition Mode Sense for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x11));

	/* Ignore if the tape doesn't have both partitions */
	if ( xp->p.add_part != 1 )
	{
		vjfree(sizeof(struct x11), tag);
		return 0;
	}

	/* Get to PBOT, since the IDP bit can only be set at PBOT */
	if ( un->un_part != 0 && gdat_switch_part(un, 0) )
	{
		vjfree(sizeof(struct x11), tag);
		return 1;
	}
	if ( vjsplcmd(un, VJ_REWIND, 0, 0, (char *)0) )
	{
		VPRINTF("vj%d: Error in rewinding for Delete Partition\n", un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}

	/* Do a mode select to delete the fixed partition */
	xp->h.sense_data_len = 0;		/* clear out sense data length field */
	xp->h.medium_type = 0;			/* clear out medium type field */
	xp->b.blk_len_high = 0;			/* only variable left, reset block size */
	xp->b.blk_len_mid  = 0;
	xp->b.blk_len_low  = 0;
	xp->p.idp = 1;
	xp->p.add_part = 0;
	xp->p.part_size = 0;
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x11));
	command = (SCSI_MODE_SELECT << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x100000, xp) )
	{
		VPRINTF("vj%d: Error in Delete Partition Mode Select for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}

	vjfree(sizeof(struct x11), tag);
	return gdat_sense_part(un);
}

gdat_get_part(un, sizep)
register VJ_UNIT *un;
int *sizep;
{
	caddr_t tag;
	struct x11	*xp;
	int		command;

	/* Get space for medium partition parameters */
	xp = (struct x11 *) vjalloc(sizeof(struct x11), &tag);
	if ( xp == NULL )
	{
		VPRINTF("vj%d: No space for medium partition parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the medium partition parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x1100, xp) )
	{
		VPRINTF("vj%d: Error in Get Partition Mode Sense for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x11));

	/* Save the partition size and return */
	*sizep = xp->p.part_size;
	vjfree(sizeof(struct x11), tag);
	return 0;
}

gdat_sense_part(un)
register VJ_UNIT *un;
{
	caddr_t tag;
	struct x10	*xp;
	int		command;

	/* Get space for device configuration parameters */
	xp = (struct x10 *) vjalloc(sizeof(struct x10), &tag);
	if ( xp == NULL )
	{
		VPRINTF("vj%d: No space for device config parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the device configuration parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x10) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x10), 0x1000, xp) )
	{
		VPRINTF("vj%d: Error in Sense Partition Mode Sense command\n",
			un->un_unit);
		vjfree(sizeof(struct x10), tag);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)xp, sizeof(struct x10));

	/* Set the current partition and record length */
	un->un_part = xp->p.active_part;
	un->un_bcount = (xp->b.blk_len_high << 16)
				  | (xp->b.blk_len_mid << 8)
				  | xp->b.blk_len_low;
	DPRINTF("vj%d: part=%d, bcount=%d\n",
		un->un_unit, un->un_part, un->un_bcount);
	vjfree(sizeof(struct x10), tag);
	return 0;
}

gdat_switch_part(un, part)
register VJ_UNIT *un;
{
	caddr_t tag10;
	caddr_t tag11;
	struct x10	*x10p;
	struct x11	*x11p;
	int		command;

	/* Get space for medium partition parameters */
	x11p = (struct x11 *) vjalloc(sizeof(struct x11), &tag11);
	if ( x11p == NULL )
	{
		VPRINTF("vj%d: No space for medium partition parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the medium partition parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x11) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x11), 0x1100, x11p) )
	{
		VPRINTF("vj%d: Error in Switch Partition Mode Sense for page 11\n",
			un->un_unit);
		vjfree(sizeof(struct x11), tag11);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)x11p, sizeof(struct x11));

	/* Make sure the tape has both partitions */
	if ( x11p->p.add_part != 1 )
	{
		vjfree(sizeof(struct x11), tag11);
		if ( part == 1 )
		{
			VPRINTF("vj%d: Tape only has one partition\n", un->un_unit);
			return 1;
		}
		else
			return 0;
	}
	vjfree(sizeof(struct x11), tag11);

	/* Get space for device configuration parameters */
	x10p = (struct x10 *) vjalloc(sizeof(struct x10), &tag10);
	if ( x10p == NULL )
	{
		VPRINTF("vj%d: No space for medium partition parameters\n",un->un_unit);
		return 1;
	}  

	/* Do a mode sense to get the device configuration parameters */
	command = (SCSI_MODE_SENSE << 24)
			| (sizeof(struct x10) << 8)
			| VJ_SPECIAL_SCSI;
	if ( vjsplcmd(un, command, sizeof(struct x10), 0x1000, x10p) )
	{
		VPRINTF("vj%d: Error in Switch Partition Mode Sense for page 10\n",
			un->un_unit);
		vjfree(sizeof(struct x10), tag10);
		return 1;
	}
	if ( vj_debug )
		dump_bytes((char *)x10p, sizeof(struct x10));

	/* See if we need to do a switch */
	if ( x10p->p.active_part != part )
	{
		/* Do a mode select to set the new device configuration parameters */
		x10p->h.sense_data_len = 0;		/* clear out sense data length field */
		x10p->h.medium_type = 0;		/* clear out medium type field */
		x10p->p.active_part = part;
		x10p->p.cap = 1;
		if ( part == 0 )
		{
			/* Partition 0 is variable ==> block size of 0 */
			x10p->b.blk_len_high = 0;
			x10p->b.blk_len_mid  = 0;
			x10p->b.blk_len_low  = 0;
		}
		else
		{
			/* Partition 1 is fixed ==> block size of 512 */
			x10p->b.blk_len_high = 0;
			x10p->b.blk_len_mid  = 2;
			x10p->b.blk_len_low  = 0;
		}
		if ( vj_debug )
			dump_bytes((char *)x10p, sizeof(struct x10));
		command = (SCSI_MODE_SELECT << 24)
				| (sizeof(struct x10) << 8)
				| VJ_SPECIAL_SCSI;
		if ( vjsplcmd(un, command, sizeof(struct x10), 0x100000, x10p) )
		{
			VPRINTF("vj%d: Error in Switch Partition Mode Select command\n",
				un->un_unit);
			vjfree(sizeof(struct x10), tag10);
			return 1;
		}
		vjfree(sizeof(struct x10), tag10);

		/* Do a sense to make sure and reset un_part and un_bcount */
		return gdat_sense_part(un);
	}

	vjfree(sizeof(struct x10), tag10);
	return 0;
}
#endif	/* GDAT */

vj_splioctl(un, cmd, name, size, data, dir, param)
register VJ_UNIT *un;
int	cmd;
char *name;
int size;
caddr_t data;
int dir, param;
{
	caddr_t tag;
	char	*addr;

	addr = vjalloc(size, &tag);
	if ( addr == NULL )
	{
		VPRINTF("vj%d: No mb space for %s information\n", un->un_unit, name);
		return EIO;
	}
	if ( dir == B_WRITE )
	{
		if ( !suser() )
			return EACCES;
		COPYIN(data, addr, size);
	}
	if ( vjsplcmd(un, cmd, 0, param, addr) )
	{
		vjfree(size, tag);
		VPRINTF("vj%d: Error in %s command\n", un->un_unit, name);
		return EIO;
	}
	if ( dir == B_READ )
	{
		COPYOUT(addr, data, size);
	}
	vjfree(size, tag);
	return 0;
}

/* special ioctl for retreving defect list from disk drive */
vj_splioctldef(un, cmd, name, size, data, dir, param)
register VJ_UNIT *un;
int	cmd;
char *name;
int size;
char **data;
int dir, param;
{
	caddr_t tag;
	char	*addr;
	char	*addr1;

	/* set up user address into addr1 to copyout defect list */
    addr1 =  *data;

	addr = vjalloc(size, &tag);
	if ( addr == NULL )
	{
		VPRINTF("vj%d: No mb space for %s information\n", un->un_unit, name);
		return EIO;
	}
	if ( vjsplcmd(un, cmd, 0, param, addr) )
	{
		vjfree(size, tag);
		VPRINTF("vj%d: Error in %s command\n", un->un_unit, name);
		return EIO;
	}
	/* copy defect data from kernel space to user space */
	copyout(addr, addr1, size);
	vjfree(size, tag);
	return 0;
}

vjread(dev, uio)
dev_t dev;
struct uio *uio;
{
	return vjrdwr(dev, uio, B_READ);
}

vjwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	return vjrdwr(dev, uio, B_WRITE);
}

vjrdwr(dev, uio, flag)
dev_t dev;
struct uio *uio;
{
    register VJ_UNIT *un;
    register int unit = VJUNIT(dev);

    if ( unit >= NVJ )
    {
        return (ENXIO);
    }
    un = &vjunits[unit];
	unit = physio(vjstrategy, &un->un_rtab, dev, flag, minphys, uio);
	return unit;
}

vjstrategy(bp)
register BUF *bp;
{
    register DK_MAP *lp;
    register VJ_UNIT *un;
    register VJ_CTLR *c;
    register int unit;
    register daddr_t bn;
    int s;

    unit = BPTOVJN(bp);
	if ( unit != 0 && !(bp->b_flags & B_SPL) )
		DPRINTF("vjstrategy: unit=%x, flags=%x, block=%x, bcount=%x\n",
				unit, bp->b_flags, dkblock(bp), bp->b_bcount);
    un = &vjunits[unit];
    c = un->un_ctlr;

    bp->b_error = 0;
	bp->b_resid = 0;
#if SOFT_GROUPING
	/*
	 * av_back holds the gather free-list entry when doing gathering and
	 *  bp is on the board.
	 */
	bp->av_back = 0;
#endif /* SOFT_GROUPING */

    if (unit >= NVJ)
	{
        bp->b_error = ENXIO;
		goto err;
	}
    else
    {
        if (!un->un_ready)
		{
            bp->b_error = ENXIO;
			goto err;
		}
        else
        {
			if (un->un_type & DT_PRINTER)
			{
				if (bp->b_bcount % 2)
					bp->b_bcount++;
			}
			else if (un->un_type & DT_TAPE)
			{
				if (un->un_flags & VJ_TAPE_FIXED_BLK)
				{
					if( !(bp->b_flags & B_SPL) && ((bp->b_bcount % 512) != 0))
					{
						bp->b_flags |= B_ERROR;
						uprintf("vj%d: Block size not a multiple of 512: %d\n",				    		un->un_unit, bp->b_bcount);
						iodone(bp);
						return;
					}
				}
				if( !(bp->b_flags & B_SPL))
				{
					if (un->un_unxfmk)	/* EOT or filemark */
					{
						bp->b_resid = bp->b_bcount;	/* YES, no more i/o */
						iodone(bp);
					/*	un->un_unxfmk = 0;	 /* next read should work */
						return;
					}
#if	GDAT0
					if ( un->un_gdat )
					{
						if ( un->un_part == 1 && bp->b_bcount != un->un_bcount )
						{
							bp->b_flags |= B_ERROR;
							DPRINTF("vj%d: Partition 1, Blocksize %d != %d\n",
								un->un_unit, bp->b_bcount, un->un_bcount);
							iodone(bp);
							return;
						}
					}
					else
#endif
				}
			} /*tape */
			else
			if ( un->un_type & DT_DISK )
			{
        		lp = &un->un_map[LPART(bp->b_dev)];
				bn = dkblock(bp);
				if ((bn < 0) || 
					(bn + howmany(bp->b_bcount, SECSIZE) > lp->dkl_nblk))
				{
                	if ((bn == lp->dkl_nblk) && (bp->b_flags & B_READ))/* EOF */
                	{
                    	bp->b_resid = bp->b_bcount;
                    	iodone(bp);
						return;
                	}
                	bp->b_error = ESPIPE;            /* illegal seek */
					goto err;
				}
            } /* disk */
        }
    }

	s  = SPLX();

	if (un->un_type & DT_DISK)
	{
		/* set physical block number for vjdisksort() */
		bp->b_pblkno = bn + PART_BLOCK(lp, un);
		vjdisksort(un, bp);		/* queue request */
	}
	else
	{
		/* tape, printer */
		vjqbp(un, bp);
	}

	if (un->un_active == 0)	/* put on ctlr q if not yet there */
	{
		vjustart(un);		/* put unit q on ctlr q */
	}
	vjcstart(c);

    (void) splx(s);

err:
    if ( bp->b_error )
    {
        bp->b_resid = bp->b_bcount;        /* whole request failed */
        bp->b_flags |= B_ERROR;
        iodone(bp);
    }
}

#if NEW_SORT
/*
 * Seek sort for disks.  The driver has already decomposed the disk address
 * into b_pblkno.
 *
 * av_forw is used to link together grouped lists.
 * av_back is used to link together members of grouped lists.
 * the av_forw pointer of the first member of the grouped list
 * points to the last member of a grouped list.
 */
vjdisksort(un, bp)
register VJ_UNIT *un;
register BUF *bp;
{
	register int d1;
	register int d2;
	register BUF *cp;
	register BUF *np;

	bp->av_back = (BUF*)0;

	if ( !un->un_actf )
	{
		un->un_iocnt = 0;
		un->un_actf = bp;
		un->un_actl = bp;
		un->un_acts = bp;
		bp->av_forw = (BUF*)0;
		return;
	}

	/*
	 * see if its time to switch our sort pointer to the end
	 * of the current grouped lists. (to enforce fairness)
	 */
	if ( !(++un->un_iocnt & (STARVSIZE-1)) )
	{
		un->un_acts = un->un_actl;
	}

	/*
	 * start looking at the current sort pointer to pick the nearest
	 * grouped list.
	 */
	for ( cp = un->un_acts; np = cp->av_forw; cp = np )
	{
		/*
		 * first get delta between current bp and new bp
		 */
		if ( (d1 = (cp->b_pblkno - bp->b_pblkno)) < 0 )
			d1 = -d1;
		/*
		 * now get delta between current bp and next bp
		 */
		if ( (d2 = (cp->b_pblkno - np->b_pblkno)) < 0 )
			d2 = -d2;
		/*
		 * if delta from current bp and new bp is closer, all done
		 */
		if ( d1 < d2 )
			break;
	}

	/*
	 * At this point we know that bp goes in between cp and np.
	 * If cp's block number is greater than np's, the new bp either
	 * goes after the grouped list starting with np or a new list
	 * needs to be started before np.
	 */
	if ( np && cp->b_pblkno > np->b_pblkno )
	{
		if ( np->av_back )				/* anybody in the list yet?	*/
		{
			if ( bp->b_pblkno == 
					(np->av_back->av_forw->b_pblkno +
					(np->av_back->av_forw->b_bcount >> SCTRSHFT)) )
			{
				np->av_back->av_forw->av_back = bp;
				np->av_back->av_forw = bp;
				bp->av_forw = (BUF*) 0;
			}
			else
			{
				cp->av_forw = bp;
				if ( !(bp->av_forw = np) )
					un->un_actl = bp;
			}
		}
		else
		{
			if ( bp->b_pblkno == (np->b_pblkno + (np->b_bcount >> SCTRSHFT )) )
			{
				np->av_back = bp;
				bp->av_forw = bp;
			}
			else
			{
				cp->av_forw = bp;
				if ( !(bp->av_forw = np) )
					un->un_actl = bp;
			}
		}
	}
	else
	/*
	 * At this point we know that bp either goes after the grouped
	 * list starting with cp or a new list needs to be started after cp.
	 */
	if ( cp->av_back )				/* anybody in the list yet?	*/
	{
		if ( bp->b_pblkno == 
				(cp->av_back->av_forw->b_pblkno +
				(cp->av_back->av_forw->b_bcount >> SCTRSHFT)) )
		{
			cp->av_back->av_forw->av_back = bp;
			cp->av_back->av_forw = bp;
			bp->av_forw = (BUF*) 0;
		}
		else
		{
			cp->av_forw = bp;
			if ( !(bp->av_forw = np) )
				un->un_actl = bp;
		}
	}
	else
	{
		if ( bp->b_pblkno == (cp->b_pblkno + (cp->b_bcount >> SCTRSHFT )) )
		{
			cp->av_back = bp;
			bp->av_forw = bp;
		}
		else
		{
			cp->av_forw = bp;
			if ( !(bp->av_forw = np) )
				un->un_actl = bp;
		}
	}
}
#else /* !NEW_SORT */
/*
 * Seek sort for disks.  The driver has already decomposed the disk address
 * into b_pblkno.
 *
 * The argument unit structure holds an activity chain pointer
 * on which we keep two queues, sorted in ascending order.
 * The first queue holds those requests which are positioned after
 * the current cylinder (in the first request); the second holds
 * requests which came in after their block number was passed.
 * Thus we implement a one way scan, retracting after reaching the
 * end of the drive to the first request on the second queue,
 * at which time it becomes the first queue.
 *
 * A one-way scan is natural because of the way UNIX read-ahead
 * blocks are allocated.
 */
vjdisksort(un, bp)
register VJ_UNIT *un;
register BUF *bp;
{
	register BUF *ap;

	/*
	 * If nothing on the activity queue, then
	 * we become the only thing.
	 */
	if ( (ap = un->un_actf) == NULL )
	{
		un->un_actf = bp;
		un->un_actl = bp;
		bp->av_forw = NULL;
		return;
	}

	/*
	 * If we lie after the first (currently active)
	 * request, then we must locate the second request list
	 * and add ourselves to it.
	 */
	if ( bp->b_pblkno < ap->b_pblkno )
	{
		while ( ap->av_forw )
		{
			/*
			 * Check for an ``inversion'' in the
			 * normally ascending cylinder numbers,
			 * indicating the start of the second request list.
			 */
			if ( ap->av_forw->b_pblkno < ap->b_pblkno )
			{
				/*
				 * Search the second request list
				 * for the first request at a larger
				 * cylinder number.  We go before that;
				 * if there is no such request, we go at end.
				 */
				do
				{
					if ( bp->b_pblkno < ap->av_forw->b_pblkno )
						goto insert;
					ap = ap->av_forw;
				} while ( ap->av_forw );
				goto insert;		/* after last */
			}
			ap = ap->av_forw;
		}
		/*
		 * No inversions... we will go after the last, and
		 * be the first request in the second request list.
		 */
		goto insert;
	}
	/*
	 * Request is at/after the current request...
	 * sort in the first request list.
	 */
	while ( ap->av_forw )
	{
		/*
		 * We want to go after the current request
		 * if there is an inversion after it (i.e. it is
		 * the end of the first request list), or if
		 * the next request is a larger cylinder than our request.
		 */
		if ( ap->av_forw->b_pblkno < ap->b_pblkno
		  || bp->b_pblkno < ap->av_forw->b_pblkno )
			goto insert;
		ap = ap->av_forw;
	}
	/*
	 * Neither a second list nor a larger
	 * request... we go at the end of the first list,
	 * which is the same as the end of the whole schebang.
	 */
insert:
	bp->av_forw = ap->av_forw;
	ap->av_forw = bp;
	if ( ap == un->un_actl )
		un->un_actl = bp;
}
#endif /* NEW_SORT */

/*
 *	Simply add a bp to the end of a units bp Q
 */
vjqbp(un, bp)
register VJ_UNIT *un;
register BUF *bp;
{
	/*
	 * If nobody is there, we become the first one
	 * else the last bp points to us and we are the last bp
	 */
	if ( !un->un_actf )
	{
		un->un_actf = bp;
#if NEW_SORT
		un->un_acts = bp;
		un->un_iocnt = 0;
#endif
	}
	else
		un->un_actl->av_forw = bp;

	un->un_actl = bp;
	bp->av_forw = (BUF *)0;
#if NEW_SORT
	bp->av_back = (BUF *)0;
	if ( !(++un->un_iocnt & (STARVSIZE-1)) )
		un->un_acts = un->un_actl;
#endif
}

#if NEW_SORT
/*
 *	Singular dequeue, get the first bp and return it.
 */
BUF *
vj_dequeue(un)
register VJ_UNIT *un;
{
	register BUF	*bp;
	register BUF	*np;

	/*
	 *	Check for an empty unit.
	 */
	if ( !(bp = un->un_actf) )
		panic("vj_dequeue");
	
	/*
	 *	Check for a group list.
	 */
	if ( bp->av_back )
	{
		np = bp->av_back;
		/*
		 *	Need to update the list's end pointer if there are more
		 */
		if ( np->av_back )
			np->av_back->av_forw = np->av_forw;
		np->av_forw = bp->av_forw;
		bp->av_back = (BUF *)0;
	}
	else
	{
		np = bp->av_forw;
	}

	/*
	 *	Update the unit's list head, tail, and sort start.
	 */
	un->un_actf = np;
	if ( un->un_actl == bp )
		un->un_actl = np;
	if ( un->un_acts == bp )
		un->un_acts = np;
	
	return bp;
}
#endif /* NEW_SORT */

/*
 * Unit start routine.  If unit is already active, or if unit has nothing
 * to do, just return.  Otherwise, put this unit queue on the controllers
 * activity queue.  The controllers c_first and c_last pointers are used
 * to point to the first & last unit header which needs processing.
 * The un_next within each unit link multiple units to a controller.
 * The un_actf and un_actl are the active first and last buffer (bp) structures
 * waiting to be processed.  If un_actf is NULL the unit queue is empty.
 */
vjustart(un)
register VJ_UNIT *un;
{
	register VJ_CTLR *c = un->un_ctlr;

	if ( un->un_active || (un->un_actf == NULL) )
		return;

	/* put unit on controller queue */

	if ( c->c_first == NULL )
		c->c_first = un;
	else
		c->c_last->un_next = un;

	c->c_last = un;
	un->un_next = NULL;
	un->un_active = 1;
}

/*
 * Set up mutiple device operations
 * We will link the unit structure to the end of controller Q to insure
 * that no unit gets starved off.
 */
vjcstart(c)
register VJ_CTLR *c;
{
	register VJ_UNIT *un;			/* current unit struct	*/
	register VJ_UNIT *un1;			/* next unit struct	*/
	register int rc;

	if ( c->c_busy )					/* controller is busy so just leave */
		return;
	un = c->c_first;					/* get the Top unit	*/

	/*
	 * Loop while there is something to do
	 */
	while ( un )
	{
		/*
		 * Process all the commands we can for this queue
		 */
		rc = 0;
		while ( un->un_actf != NULL && rc == 0 )
		{
			if (un->un_actf->b_flags & B_SPL)	/* for tape-specific cmds */
				rc = vjenqspl(un);
			else
				rc = vjenqnorm(un);
		}
		/*
		 * Continue depending on how we broke out of the previous loop
		 */
		switch ( rc )
		{
		case 0:
			/*
			 * This unit is idle, remove from the controller queue and go to
			 *	the next.
			 */
			un->un_active = 0;
			un1 = un->un_next;
			un->un_next = NULL;
			c->c_first = un1;
			un = un1;
			break;
		case 1:
			/*
			 * The board is full, put this unit on the end and return
			 */
			if ( un1 = un->un_next )
			{
				c->c_first = un1;
				c->c_last->un_next = un;
				c->c_last = un;
				un->un_next = NULL;
			}
			return;
		case 2:
			/*
			 * Work queue is full for this unit, remove it from the controller
			 * queue and go on to the next unit.
			 */
			un1 = un->un_next;
			un->un_next = NULL;
			un->un_active = 0;
			c->c_first = un1;
			un = un1;
			break;
		default:
			panic("vjcstart");
		}
	}
}

/*
 *	SPECIAL iopb que routine for tape ioctl cmds and disk format cmd
 */
vjenqspl(un)
register VJ_UNIT *un;
{
    register VJ_CTLR *c;
    register VJ_SHIO *shio;
	register BUF *bp;
    register int cmd;
    SCSI_CDB *cdb;
    VJ_IOPB  *iopb;
    VJ_CQE   *cqe;
    VJ_CQE   Cqe;
    VJ_MCSB  *mcsb;
    ULONG rc;
	char *addr;

    rc      = 0;
    c       = un->un_ctlr;
    shio    = c->c_io;

    mcsb    = &shio->sh_MCSB;

    cqe = (VJ_CQE *)((INT)mcsb->mcsb_QHDP + (INT)shio);
    if ( W_QECR( cqe->cqe_QECR ) & M_QECR_GO )
    {
        if ( !c->c_wait_cqe )
        {
			/* set IQAR bit and wait */
            W( shio->sh_MCSB.mcsb_IQAR ) =
                (M_IQAR_IQEA | M_IQAR_IQEH | VEC(c,c->c_qintvec) );
            c->c_wait_cqe = TRUE;
        }
        rc = 1;
    }
    else
    {
        if ( c->c_qcount[un->un_workq] >= VJ_Q_SIZ )
            rc = 2;
        else
        {
			/* get and unlink the bp */
#if NEW_SORT
			bp = vj_dequeue(un);
#else
			bp = un->un_actf;
			un->un_actf = bp->b_actf;
#endif
            bp->b_actf = NULL;

			DPRINTF("vjenqspl: unit=%x, cmd=%s, count=%x, param=%x\n",
					un->un_unit, vjcmds[(int)bp->b_scsicmd&0xff].scsi_name,
					bp->b_scsicnt, bp->b_scsiparam);

            mcsb->mcsb_QHDP =  ((INT)cqe + sizeof(VJ_CQE)) - (INT)shio;
            if ( cqe >= c->c_cqe_end )
                mcsb->mcsb_QHDP =  ((INT)c->c_cqe_top - (INT)shio);

			vjmove(cqe, &Cqe, sizeof(VJ_CQE));
            LV(Cqe.cqe_CTAG, (ULONG)bp);
            Cqe.cqe_IOPB_LENGTH = 0;
            Cqe.cqe_WORK_QUEUE  = un->un_workq;

            iopb = &un->un_iopb;
			vjzero((USHORT *)iopb, sizeof(VJ_IOPB));

			W(iopb->iopb_OPTION) |= M_OPT_IE;
			if (un->un_flags & VJ_NO_SYNC_XFER)
				W( iopb->iopb_OPTION ) |= M_OPT_SS;
			vj_cmdiopb(un, iopb, (int)bp->b_scsicmd, (int)bp->b_scsicnt,
						bp->b_scsiparam, un->un_spladdr - DVMA);

           	vjmove(&Cqe, cqe, sizeof(VJ_CQE) );
            vjmove(iopb, (VJ_IOPB *)((INT)Cqe.cqe_IOPB_ADDR + (int)shio),
				   sizeof(VJ_IOPB));
            CQE_GO( cqe->cqe_QECR );

            c->c_qcount[un->un_workq]++;
			c->c_ccount++;
        }
    }
    return( rc );
}

/*
 * NORMAL iopb que routine for disk/tape read/write
 */
vjenqnorm(un)
register VJ_UNIT *un;
{
	register VJ_IOPB	*iopb;
	register VJ_CQE		*cqe;
	register VJ_CTLR	*c;
	register VJ_SHIO	*shio;
	register BUF		*bp;
	register int		nsect;
	SCSI_CDB			*cdb;
	SCSI_CDB_1			*cdb1;
	DK_MAP				*lp;
	VJ_MCSB				*mcsb;
	ULONG				rc, secsz;
	ULONG				mbinfo;

	rc    = 0;
	bp	  = un->un_actf;
	c     = un->un_ctlr;
	shio  = c->c_io;
	mcsb  = &shio->sh_MCSB;
	cqe   = (VJ_CQE *)((INT)mcsb->mcsb_QHDP + (INT)shio);

	if ( W_QECR( cqe->cqe_QECR ) & M_QECR_GO )
	{
		c->c_busy = 1;
		if ( !c->c_wait_cqe )
		{
			W( shio->sh_MCSB.mcsb_IQAR ) =    /* set IQAR BIT and wait */
				(M_IQAR_IQEA | M_IQAR_IQEH | VEC(c,c->c_qintvec) );
			c->c_wait_cqe = TRUE;
		}
		rc = 1;
	}
#if SOFT_GROUPING
	else
	if ( !c->c_sg_hd )
	{
		rc = 1;
	}
#endif /* SOFT_GROUPING */
	else
	if ( c->c_qcount[un->un_workq] >= VJ_Q_SIZ )
	{
		rc = 2;
	}
	else
	if ( !(mbinfo = (ULONG)mbsetup(c->c_md_hd, bp, MB_CANTWAIT)))
	{
		int vjtimeout();

		if ( !c->c_ccount )
			timeout(vjtimeout, c, hz/10);
		rc = 1;						/* break out of vjcstart enqueue loop */
	}
	else
	{
		mcsb->mcsb_QHDP = ((INT)cqe + sizeof(VJ_CQE)) - (INT)shio;
		if ( cqe >= c->c_cqe_end )
			mcsb->mcsb_QHDP = ((INT)c->c_cqe_top - (INT)shio);

		LV(cqe->cqe_CTAG, (ULONG)bp);
		cqe->cqe_IOPB_LENGTH = 0;
		cqe->cqe_WORK_QUEUE  = un->un_workq;
		iopb                 = (VJ_IOPB *)((int)cqe->cqe_IOPB_ADDR + (int)shio);
		vjzero((USHORT *)iopb, sizeof(VJ_IOPB));
		cdb                  = (SCSI_CDB *)&iopb->iopb_SCSI[0];
		cdb1                 = (SCSI_CDB_1 *)&iopb->iopb_SCSI[0];
		cdb->lun			 = un->un_lun;
		un->un_mtflag		 = FALSE;
		un->un_dir			 = TAPE_FORWARD;

		if ( bp->b_flags & B_READ )
		{
			un->un_rwflag		  |= FREAD;
			iopb->iopb_CMD         = vjcmds[VJ_READ].macsi_cmd;
			cdb->cmd               = vjcmds[VJ_READ].scsi_cmd;
			W( iopb->iopb_OPTION ) = M_OPT_IE;
		}
		else
		{
			un->un_rwflag		  |= FWRITE;
			iopb->iopb_CMD         = vjcmds[VJ_WRITE].macsi_cmd;
			cdb->cmd               = vjcmds[VJ_WRITE].scsi_cmd;
			W( iopb->iopb_OPTION ) = (M_OPT_DIR + M_OPT_IE);
		}
		if (un->un_type & DT_EXT_RW)
    		cdb1->cmd += 0x20; /* SCSI_READ_EXTENDED or SCSI_WRITE_EXTENDED */
		if (un->un_flags & VJ_NO_SYNC_XFER)
			W( iopb->iopb_OPTION )|= M_OPT_SS;
		iopb->iopb_NVCT 		   = c->c_nintvec;
		iopb->iopb_EVCT			   = c->c_eintvec;
		iopb->iopb_LEVEL		   = c->c_level;
		if (un->un_blackhole)	/* <==== */
			W( iopb->iopb_ADDR )	   = BLACKHOLE_MOD;
		else
			W( iopb->iopb_ADDR )	   = ADDR_MOD;
		W( iopb->iopb_UNIT )	   = un->un_slave;
		iopb->iopb_UNIT.U.b.LUN		= un->un_lun;
		LV(iopb->iopb_BUFF, (ULONG)MBI_ADDR(mbinfo));
		if ( un->un_type & DT_PRINTER )
		{
			LV(iopb->iopb_LENGTH, (ULONG)bp->b_bcount);
			CDB_XFER_LEN(cdb, bp->b_bcount);
		}
		else
		if ( un->un_type & DT_TAPE )
		{
#if	GDAT
			if ( un->un_gdat )
			{
				if ( un->un_part == 0 )
				{
					/* Variable record mode */
					LV(iopb->iopb_LENGTH, (ULONG)bp->b_bcount);
					CDB_XFER_LEN(cdb, bp->b_bcount);
					if ( bp->b_flags & B_READ )
					{
						/* Supress Incorrect Length Indicator */
						cdb->high_addr = 0x02;
					}
				}
				else
				{
					/* Fixed record mode */
					secsz = un->un_bcount;
					nsect = howmany(bp->b_bcount, secsz);
					if ( bp->b_bcount > nsect * secsz )
						bp->b_resid = bp->b_bcount - nsect * secsz;
					LV(iopb->iopb_LENGTH, (ULONG)(nsect * secsz));
					cdb->high_addr = 0x01;
					CDB_XFER_LEN(cdb, nsect);
				}
			}
			else
#endif
			if ( (un->un_flags & VJ_TAPE_FIXED_BLK))
			{
				secsz = un->un_bcount;
				nsect = howmany(bp->b_bcount, secsz);
				if ( bp->b_bcount > nsect * secsz )
					bp->b_resid = bp->b_bcount - nsect * secsz;
				cdb->high_addr = 0x01;
				CDB_XFER_LEN(cdb, nsect);
				LV(iopb->iopb_LENGTH, (ULONG)(nsect * secsz));
			}
			else
			{
				CDB_XFER_LEN(cdb, bp->b_bcount);
				LV(iopb->iopb_LENGTH, (ULONG)bp->b_bcount);
			}
			if ( vj_debug )
				dump_bytes((char *)cdb, 6);
		}
		else
		if ( un->un_type & DT_DISK )
		{
#if SOFT_GROUPING
			if ( vj_sgsetup(un, bp, iopb, cdb, mbinfo) )
				goto startit;
			else
#endif /* SOFT_GROUPING */
			{
				lp = &un->un_map[LPART(bp->b_dev)];
				nsect = howmany(bp->b_bcount, SECSIZE);
				nsect = min(nsect, lp->dkl_nblk - bp->b_blkno);
				LV(iopb->iopb_LENGTH, (ULONG)(nsect << SCTRSHFT));
				if (un->un_type & DT_EXT_RW)
				{
					CDB_ADDR_1(cdb1, bp->b_pblkno);
					CDB_XFER_LEN_1(cdb1, nsect);
				}
				else
				{
					CDB_ADDR(cdb, bp->b_pblkno);
					cdb->count = (nsect & 0xff);
				}
			}
		}
#if NEW_SORT
		(void) vj_dequeue(un);
#else
		un->un_actf = bp->b_actf;
#endif
		bp->b_actf = (BUF *)mbinfo;
		bp->av_back = (BUF *)0;

startit:
		CQE_GO( cqe->cqe_QECR ); 

		c->c_qcount[un->un_workq]++;
		c->c_ccount++;
	}
	return( rc );
}

#if SOFT_GROUPING
/*
 * Setup a read/write command, possibly using scatter/gather.
 */
vj_sgsetup(un, bp, iopb, cdb, mbinfo)
register VJ_UNIT *un;
register BUF *bp;
register VJ_IOPB *iopb;
SCSI_CDB *cdb;
ULONG mbinfo;
{
	register BUF *nbp;
#if NEW_SORT
	register BUF *gbp = bp;
	BUF *lbp;
#endif
	register IPSG *sg;
	register int links;
	register long total;
	register IPSG *firstsg;
	register VJ_CTLR *c;
	IPSG_FREE *ipsg_free;
	BUF *sbp = bp;						/* starting buffer pointer */
	ULONG tmbinfo;
#if SG_TEST
	int tlinks;
#endif

	/*
	 *	Get the next bp
	 */
#if NEW_SORT
	nbp = bp->av_back ? bp->av_back : bp->av_forw;
	lbp = bp->av_back ? bp->av_back->av_forw : (BUF *)0;
#else
	nbp = bp->av_forw;
#endif
	/*
	 *	Check to see if grouping is even possible
	 */
	if ( bp->b_error
	  || nbp == NULL
	  || (nbp->b_flags & B_SPL)
	  || (bp->b_flags & B_READ) != (nbp->b_flags & B_READ)
	  || nbp->b_error
	  || ((bp->b_pblkno + (bp->b_bcount >> SCTRSHFT)) != nbp->b_pblkno)
	  || bp->b_bcount+nbp->b_bcount >= 0x20000	/* SCSI simple R/W limit */
	)
		return 0;

	c = un->un_ctlr;
	ipsg_free = c->c_sg_hd;						/* get top free entry */
	firstsg = sg = &ipsg_free->ipsg[0];			/* get top SG entry */

	links = 0;
	total = 0;

	while ( 1 )
	{
		/* fill in sg struct */
		sg->sg_count = bp->b_bcount;
		sg->sg_addrlo = (int)MBI_ADDR(mbinfo) & 0xffff;
		sg->sg_addrhi = ((int)MBI_ADDR(mbinfo) >> 16) & 0xffff;
		ipsg_free->ipsg_mbinfo[links] = mbinfo;
		total += bp->b_bcount;
		sg++;

		/*
		 *	Check for the end of the links
		 */
#if NEW_SORT
		if ( bp->av_back )
		{
			/*
			 *	Get and check the next in a grouped list
			 */
			nbp = bp->av_back;
			if ( ++links >= MACSI_SG
			  || (nbp->b_flags & B_SPL)
			  || (bp->b_flags & B_READ) != (nbp->b_flags & B_READ)
			  || (bp->b_flags & B_READ) && nbp == lbp
			  || nbp->b_error
			  || total+nbp->b_bcount >= 0x20000		/* SCSI simple R/W limit */
			)
				break;
		}
		else
		{
			/*
			 *	Get and check the next (grouped) list header
			 */
			if ( nbp = gbp->av_forw )
			{
				if ( un->un_acts == gbp )
					un->un_acts = nbp;
				gbp = nbp;
			}
			if ( ++links >= MACSI_SG
			  || !nbp
			  || (nbp->b_flags & B_SPL)
			  || (bp->b_flags & B_READ) != (nbp->b_flags & B_READ)
			  || (bp->b_flags & B_READ) && nbp == lbp
			  || nbp->b_error
			  || ((bp->b_pblkno + (bp->b_bcount >> SCTRSHFT)) != nbp->b_pblkno)
			  || total+nbp->b_bcount >= 0x20000		/* SCSI simple R/W limit */
			)
				break;
		}
#else /* !NEW_SORT */
	 	if ( ++links >= MACSI_SG
	  	  || (nbp = bp->av_forw) == NULL
		  || (nbp->b_flags & B_SPL)
		  || (bp->b_flags & B_READ) != (nbp->b_flags & B_READ)
		  || nbp->b_error
		  || ((bp->b_pblkno + (bp->b_bcount >> SCTRSHFT)) != nbp->b_pblkno)
		  || total+nbp->b_bcount >= 0x20000		/* SCSI simple R/W limit */
		)
			break;
#endif /* NEW_SORT */

		/* Next link */
		if ( !(tmbinfo = mbsetup(c->c_md_hd, nbp, MB_CANTWAIT)))
			break;
		mbinfo = tmbinfo;
#if NEW_SORT
		bp->av_back = nbp;
#else
		un->un_actf = nbp->av_forw;
#endif
		bp = nbp;
	}

	/*
	 *	Check for no links, only scatter/gathering if there are some
	 */
	if ( links != 1 )
	{
#if NEW_SORT
		/* Update last pointer if we stopped in the middle of a grouped list */
		if ( gbp->av_back && nbp )
		{
			if ( nbp->av_back )
				nbp->av_back->av_forw = gbp->av_back->av_forw;
			nbp->av_forw = gbp->av_forw;
		}
		/* Update the unit's list head, tail, and sort start */
		un->un_actf = nbp;
		if ( un->un_actl == gbp )
			un->un_actl = nbp;
		if ( un->un_acts == gbp )
			un->un_acts = nbp;
		/* end bp list */
		bp->av_back = NULL;
		/* The rest of the code needs the list linked by av_forw, make it so */
		bp = sbp;
		while ( bp )
		{
			bp->av_forw = bp->av_back;
			bp->av_back = NULL;
			bp = bp->av_forw;
		}
#else /* !NEW_SORT */
		bp->av_forw = NULL;						/* end lbp list	*/
#endif /* NEW_SORT */

		sbp->av_back = (struct buf *)ipsg_free;	/* save free entry for intr */
		c->c_sg_hd = ipsg_free->nxt;			/* unlink it */
		/*
		 *	Fill in the iopb for scatter/gather
		 */
		W(iopb->iopb_OPTION) |= M_OPT_SG;
		LV(iopb->iopb_LENGTH, links);				/* number of entries */
		ipsg_free->ipsg_num = links;
		tmbinfo = MBI_ADDR(c->c_sg_mbinfo) + ipsg_free->ipsg_entry*S_MACSI_SG;
		LV(iopb->iopb_BUFF, tmbinfo);
		iopb->iopb_RES2 = (total >> 16) & 0xffff;	/* total transfer length */
		iopb->iopb_RES3 = total & 0xffff;
		CDB_ADDR(cdb, sbp->b_pblkno);
		cdb->count = total >> SCTRSHFT;
#if SG_TEST
		sg = firstsg;
		tlinks = links;
		do {
			if ( sg->sg_count != sbp->b_bcount )
				printf("<%d,%d> sg_count(%x) != b_bcount(%x)\n",
					tlinks, links,
					sg->sg_count, sbp->b_bcount);
			if ( (caddr_t)((sg->sg_addrhi<<16)+sg->sg_addrlo)
					!= (caddr_t)(ipsg_free->ipsg_mbinfo[links-tlinks]) )
				printf("<%d,%d> sg_addr(%x) != b_paddr(%x)\n",
					tlinks, links, (sg->sg_addrhi<<16)+sg->sg_addrlo,
					ipsg_free->ipsg_mbinfo[links-tlinks]);
			total -= sg->sg_count;
			--tlinks;
			++sg;
		} while ( (sbp=sbp->av_forw) != NULL );
		if ( total != 0 )
			printf("non-zero total(%x)\n", total);
		if ( tlinks != 0 )
			printf("non-zero links(%d)\n", tlinks);
#endif /* SG_TEST */
	}
	return links-1;
}
#endif /* SOFT_GROUPING */

vjtimeout(c)
VJ_CTLR *c;
{
	int s = splx(pritospl(c->c_level));

	vjcstart(c);
	splx(s);
}

/* 
 * Queue Entry Available interrupt.
 */
vjqint(c)
register VJ_CTLR *c;
{
	register VJ_CRB		*crb = &c->c_io->sh_CRB; 

	if ( W( crb->crb_CRSW ) & M_CRSW_CQA )
	{
		CRB_CLR_DONE( crb->crb_CRSW );
		c->c_busy = 0;
		if ( c->c_wait_cqe )
		{
			c->c_wait_cqe = FALSE;
			if ( c->c_first && !c->c_busy )
				vjcstart(c);
		}
	}
	else
		CRB_CLR_DONE( crb->crb_CRSW );
}

/*
 *	Handle error interrupts
 */
vjeint(c) 
register VJ_CTLR *c;
{
	register VJ_SHIO	*shio = c->c_io;
	register VJ_UNIT	*un;
	register VJ_CRB		*crb;
	register VJ_IOPB	*iopb;
	register BUF		*bp;
	VJ_CRSW				crsw;
	ULONG				ctag, length;
	UWORD				cmd, scsi, status;
	UBYTE				workq;

	crb		= &shio->sh_CRB;
	crsw	= crb->crb_CRSW;
	VL(ctag, crb->crb_CTAG);
	workq	= crb->crb_WORK_QUEUE;
	iopb	= &shio->sh_RET_IOPB;
	cmd		= iopb->iopb_CMD;
	scsi	= iopb->iopb_SCSI[0];
	status	= iopb->iopb_STATUS;
	VL(length, iopb->iopb_LENGTH);

	CRB_CLR_DONE( shio->sh_CRB.crb_CRSW );

	if ( !(W( crsw ) & M_CRSW_ER) )
	{
		DPRINTF("VJEINT: Command not an ERROR  CRSW(%x)\n", W( crsw ));
	}
	else
	if ( !c->c_present )
	{
		DPRINTF("VJEINT: Interrupt from non-existent board\n");
	}
	else
	if ( (ctag & SPECIAL_MASK) != SPECIAL_MASK )	/* Not a spl cmd */
	{
		bp = (BUF *)ctag;
		un = &vjunits[BPTOVJN(bp)];

		if ( (status & 0xff) != WORK_QUEUE_ABORT
		  && (status & 0xff) != SCSI_XFER_EXCEPTION )
		{
			DPRINTF("vj%d: Cmd=%x CDB=%x Queue=%d  SCSI error=%x (%s)\n",
				un->un_unit, cmd, (scsi >> 8), workq,
				(status >> 8), scsi_err_msg(status >> 8));
			DPRINTF("      Jaguar Exception=%x (%s)\n",
				status & 0xff, jaguar_err_msg(status & 0xff));
		}
		else
		{
			if ( (status & 0xff) == WORK_QUEUE_ABORT )
				DPRINTF("vjeint: WORK_QUEUE_ABORT\n");
			if ( (status & 0xff) == SCSI_XFER_EXCEPTION )
				DPRINTF("vjeint: SCSI_XFER_EXCEPTION len=%x\n", length);
		}

		c->c_qcount[un->un_workq]--;
		c->c_ccount--;
#if SOFT_GROUPING
		if ( bp->av_back )				/* SG entry to free? */
		{
			register IPSG_FREE	*ipsg_free = (IPSG_FREE *)bp->av_back;
			register int		i;

			for ( i = ipsg_free->ipsg_num; i > 0; )
			{
				mbrelse(c->c_md_hd, &ipsg_free->ipsg_mbinfo[--i]);
			}
		}
		else
#endif
		if ( bp->b_actf )
		{
			mbrelse(c->c_md_hd, &bp->b_actf);
		}

		vjsense(c, un, WANT_INTERRUPT);
		c->c_splcmd[un->un_workq] = bp;
						/* save bp to be used in either vjnint or vjeint,
						   also thaw work queue there. */
		if ( un->un_type & (DT_TAPE | DT_PRINTER) )
		{
			return; /* maybe an fm or eom, find out in vjnint */
		}

		/* disk */
		if ( un->un_retries && bp->b_error < un->un_retries )
		{
#if SOFT_GROUPING
			if ( bp->av_back )				/* SG entry to free? */
				vj_sgretry(c, un, bp);
			else
#endif
			{
				DK_MAP *lp;
        		lp = &un->un_map[LPART(bp->b_dev)];
				bp->b_pblkno = dkblock(bp) + PART_BLOCK(lp, un);
				vjdisksort(un, bp);
				++bp->b_error;
			}
		}
		else
		{
			bp->b_flags |= B_ERROR;
			bp->b_error  = EIO;
			bp->b_resid  = bp->b_bcount;	/* whole request failed */
#if SOFT_GROUPING
			if ( bp->av_back )				/* SG entry to free? */
				vj_sgdone(c, bp);
			else
#endif
			iodone(bp);						/* wake up process just done */
		}

		if ( un->un_actf && !un->un_active )
			vjustart(un);
		if ( c->c_first && !c->c_busy )
			vjcstart(c);
	}
	else            /* Special command failed ooops!!!! */
	{
		register int	unit = ctag & ~SPECIAL_MASK;

		if ( (status & 0xff) == SCSI_XFER_EXCEPTION )
		{
			DPRINTF("vj%d: Transfer count incorrect, should be %d\n",
				unit-1, length);
		}
		else
		{
			DPRINTF("vj%d: SplCmd=%x CDB=%x Queue=%d  SCSI error=%x (%s)\n",
				unit-1, cmd, (scsi >> 8), unit,
				(status >> 8), scsi_err_msg(status >> 8));
			DPRINTF("        Jaguar Exception=%x (%s)\n",
				status & 0xff, jaguar_err_msg(status & 0xff));
		}

		if ( (bp=c->c_splcmd[unit]) == NULL )
		{
			DPRINTF("vj%d: Illegal splcmd bp, workq=%d\n", unit-1, unit);
			goto out;
		}
		un = &vjunits[BPTOVJN(bp)];

		if (un->un_type & (DT_TAPE | DT_PRINTER))
		{
			bp->b_flags |= B_ERROR;
			bp->b_error = EIO;
			bp->b_resid  = bp->b_bcount;	/* whole request failed */
			iodone(bp);						/* wake up process just done */

			if ( un->un_actf && !un->un_active )
				vjustart(un);
			if ( c->c_first && !c->c_busy )
				vjcstart(c);
		}

out:
		c->c_splcmd[workq] = NULL;			/* clear up spl cmd bp entry */
		W( shio->sh_MCSB.mcsb_THAW ) = ((ctag&~SPECIAL_MASK)<<8) | M_THAW_TWQE;
	}
}

/*
 *	Handle normal interrupts
 */
vjnint(c) 
register VJ_CTLR *c;
{
	register VJ_SHIO	*shio = c->c_io;
	register VJ_UNIT	*un;
	register VJ_CRB		*crb;
	register VJ_IOPB	*iopb;
	register BUF		*bp;
	VJ_CRSW				crsw;
	ULONG				ctag, length;
	UWORD				cmd, status;
	UBYTE				workq;

	crb		= &shio->sh_CRB;
	crsw	= crb->crb_CRSW;
	VL(ctag, crb->crb_CTAG);
	workq	= crb->crb_WORK_QUEUE;
	iopb	= &shio->sh_RET_IOPB;
	cmd		= iopb->iopb_CMD;
	status	= iopb->iopb_STATUS;
	VL(length, iopb->iopb_LENGTH);

	CRB_CLR_DONE( shio->sh_CRB.crb_CRSW );

	if ( !(W( crsw ) & M_CRSW_CC) )
	{
		DPRINTF("VJNINT: Command not Complete  CRSW(%x)\n", W( crsw ) );
	}
	else
	if ( !c->c_present )
	{
		DPRINTF("VJNINT: Interrupt from non-existent board\n");
	}
	else
	if ( (ctag & SPECIAL_MASK) != SPECIAL_MASK )	/* Not a spl cmd */
	{
		bp  = (BUF *)ctag;
		un  = &vjunits[BPTOVJN(bp)];

		if ( W( crsw ) & M_CRSW_EX )
		{
            {
				DPRINTF("vj%d: Cmd=%x, Exception=%x, Work Queue=%d, ",
					un->un_unit, cmd, status, workq );
				DPRINTF("\n");
            }
		}

		c->c_qcount[un->un_workq]--;
		c->c_ccount--;

#if SOFT_GROUPING
		if ( bp->av_back )				/* SG entry to free? */
		{
			register IPSG_FREE	*ipsg_free = (IPSG_FREE *)bp->av_back;
			register int		i;

			for ( i = ipsg_free->ipsg_num; i > 0; )
			{
				mbrelse(c->c_md_hd, &ipsg_free->ipsg_mbinfo[--i]);
			}
		}
		else
#endif
		if ( bp->b_actf )					/* not a (tape) special cmd */
		{
			mbrelse(c->c_md_hd, &bp->b_actf);
		}

#if SOFT_GROUPING
		if ( bp->av_back )					/* SG entry to free? */
			vj_sgdone(c, bp);
		else
#endif
		{
			bp->b_error = 0;				/* may have been a retry count */
			bp->b_resid = 0;				/* was the physical block number */
			iodone(bp);						/* wake up process just done */
		}

		if ( un->un_actf && !un->un_active )
			vjustart(un);
		if ( c->c_first && !c->c_busy )
			vjcstart(c);
	}
	else									/* special cmd */
	{
		int unit = ctag & ~SPECIAL_MASK;

		if ((bp=c->c_splcmd[unit]) == NULL)
		{
			DPRINTF("vj%d: Illegal splcmd bp, workq=%d\n", unit-1, unit);
			goto out;
		}
		un = &vjunits[BPTOVJN(bp)];

		DPRINTF("vj%d: 0x%x(%s", un->un_unit, 
			un->un_sense->key, sense_err_msg(un->un_sense->key));
		if (un->un_type & DT_TAPE)
		{
			if ( un->un_sense->filmrk ) DPRINTF(" FM");
			if ( un->un_sense->eom ) DPRINTF(" EOM");
		}
		DPRINTF(")\n");

		if ( un->un_type & DT_PRINTER )
		{
			bp->b_resid = bp->b_bcount;
			iodone(bp);
			if ( un->un_actf && !un->un_active )
				vjustart(un);
			if ( c->c_first && !c->c_busy )
				vjcstart(c);
		}
		else
		if ( un->un_type & DT_TAPE )
		{
			if ( un->un_sense->key != SCSI_NO_SENSE )
			{
				if ( un->un_sense->key == SCSI_RECOVERABLE_ERROR)
				{
					uprintf("vj%d: SCSI_RECOVERABLE_ERROR\n", un->un_unit);
					bp->b_resid = 0;
					bp->b_error = 0;
					goto done;
				}
				else
				{
					if ( un->un_sense->key != SCSI_UNIT_ATTENTION )
					{
						uprintf("vj%d: %s\n", un->un_unit, 
						sense_err_msg(un->un_sense->key));
					}
					bp->b_flags |= B_ERROR;
					bp->b_error = EIO;
				}
			}
			else
			if ( un->un_sense->filmrk || un->un_sense->eom )
				un->un_unxfmk = 1;
			if ( un->un_sense->valid )
			{
				int info;
				info = ((un->un_sense->info0<<24)
						+ (un->un_sense->info1<<16)
						+ (un->un_sense->info2<<8)
						+ un->un_sense->info3);
				if ( (un->un_flags & VJ_TAPE_FIXED_BLK))
					bp->b_resid = un->un_bcount * info;
				else
					bp->b_resid = info;
			}
			else
				bp->b_resid = bp->b_bcount;
done:
			iodone(bp);
			if ( un->un_actf && !un->un_active )
				vjustart(un);
			if ( c->c_first && !c->c_busy )
				vjcstart(c);
		}
out:
		c->c_splcmd[workq] = NULL;				/* clear up spl cmd bp entry */
		W( shio->sh_MCSB.mcsb_THAW ) = ((ctag&~SPECIAL_MASK)<<8) | M_THAW_TWQE;
	}
}

#if SOFT_GROUPING
vj_sgretry(c, un, bp)
VJ_CTLR *c;
VJ_UNIT *un;
register BUF *bp;
{
	register BUF		*nbp;
	register DK_MAP		*lp;
	IPSG_FREE			*ipsg_free;

	/* link entry back into free list */
	ipsg_free = (IPSG_FREE*) bp->av_back;
	ipsg_free->nxt = c->c_sg_hd;
	c->c_sg_hd = ipsg_free;
	bp->av_back = NULL;

	do {
		nbp = bp->av_forw;
		lp = &un->un_map[LPART(bp->b_dev)];
		bp->b_pblkno = dkblock(bp) + PART_BLOCK(lp, un);
		vjdisksort(un, bp);

		++bp->b_error;
	} while ( bp = nbp );
}

vj_sgdone(c, bp)
VJ_CTLR *c;
register BUF *bp;
{
	register BUF	*nbp;
	register BUF	*sbp = bp;
	IPSG_FREE		*ipsg_free;

	/* link entry back into free list */
	ipsg_free = (IPSG_FREE *)bp->av_back;
	ipsg_free->nxt = c->c_sg_hd;
	c->c_sg_hd = ipsg_free;
	bp->av_back = NULL;

	do {
		nbp = bp->av_forw;

		if ( sbp->b_flags & B_ERROR )
		{
			bp->b_flags |= B_ERROR;
			bp->b_error = sbp->b_error;
			bp->b_resid = bp->b_bcount;
		}
		else
		{
			bp->b_error = 0;
			bp->b_resid = 0;
		}
		iodone(bp);
	} while ( bp = nbp );
}
#endif /* SOFT_GROUPING */

vjgetlabel(c, un)
VJ_CTLR *c;
register VJ_UNIT *un;
{
	register DK_LABEL	*label;
	caddr_t				lab;

	label = (DK_LABEL *)vjalloc(SECSIZE, &lab);
	if ( label == NULL )
	{
		printf("vj%d: No space for Disk Label\n", un->un_unit);
		return (0);
	}
	label->dkl_magic = 0;
	/*
	 *	Search for a label MUST be done in physical mode
	 */
	if ( !vjrawio(c, un, VJ_READ, "label", (char *)label, 0, 1) )
	{
		vjfree(SECSIZE, lab);
		return(0);
	}
	/*
	 *	Check for a valid label
	 */
	if ( vjislabel(un, label) )
	{
		vjuselabel(un, label);
		vjfree(SECSIZE, lab);
		return(1);
	}
	vjfree(SECSIZE, lab);
	return(0);
}

/*
 *	Check the validity of the label
 */
vjislabel(un, label)
register VJ_UNIT *un;
register DK_LABEL *label;
{
	register int rc = 0;
	int i;

	if ( label->dkl_magic != DKL_MAGIC )
	{
		VPRINTF("vj%d: Wrong dkl_magic\n", un->un_unit);
	}
	else if ( !vj_cksum(label) )
	{
		VPRINTF("vj%d: Corrupt label read\n", un->un_unit);
	}
	else if ( label->dkl_ppart < 0 || label->dkl_ppart > 1 )
	{
		VPRINTF("vj%d: Unsupported partition # %d\n",
			un->un_unit, label->dkl_ppart);
	}
	else
	{
		rc = 1;
	}
	return (rc);
}

/*
 * Check the checksum of the label
 */
vj_cksum(label)
DK_LABEL *label;
{
	register short *sp, sum = 0;
	register short count = sizeof(DK_LABEL)/sizeof(short);

	sp = (short *)label;
	while (count--) 
		sum ^= *sp++;
	return (sum ? 0 : 1);
}

vjuselabel(un, label)
register VJ_UNIT *un;
register DK_LABEL *label;
{
    register INT i;

	un->un_g.dkg_ncyl		= label->dkl_ncyl;
	un->un_g.dkg_acyl		= label->dkl_acyl;
    un->un_g.dkg_bcyl   	= 0;
	un->un_g.dkg_nhead		= label->dkl_nhead;
	un->un_g.dkg_bhead		= label->dkl_bhead;
	un->un_g.dkg_nsect		= label->dkl_nsect;
	un->un_g.dkg_gap1		= label->dkl_gap1;
	un->un_g.dkg_gap2		= label->dkl_gap2;
	un->un_g.dkg_intrlv		= label->dkl_intrlv;
#ifndef sun2
	un->un_g.dkg_apc		= label->dkl_apc;
#endif

	un->un_spc			= label->dkl_nhead * label->dkl_nsect;
    un->un_burst        = VJ_BURST_COUNT;   /* default burst count  */

    for ( i = 0; i < NLPART; i++ )
		un->un_map[i] = label->dkl_map[i]; /* struct assignment	*/
}

vjdump(dev, addr, blkno, nblk)
dev_t dev;
caddr_t addr;
daddr_t blkno, nblk;
{
    register VJ_UNIT *un = &vjunits[VJUNIT(dev)];
	VJ_CTLR *c = &vjctlrs[VJCTLR(un)];
	register struct dk_map *lp = &un->un_map[LPART(dev)];
	daddr_t cblkno;
	int nsect, sect, head, cyl;
	int err;

	DPRINTF("VJDUMP: dev=%x,addr=%x,blkno=%x,nblk=%x\n",dev,addr,blkno,nblk);
	if (!un->un_ready)
		return (ENXIO);
	if (blkno >= lp->dkl_nblk || (blkno+nblk) > lp->dkl_nblk)
		return (EINVAL);

	do
	{
		nsect = un->un_g.dkg_nsect - (blkno % un->un_g.dkg_nsect);
		nsect = min(nsect, nblk);
		nblk -= nsect;

		cblkno = blkno + (lp->dkl_cylno*un->un_g.dkg_nhead*un->un_g.dkg_nsect);
		vjcmd(un, VJ_WRITE, (char *)addr-DVMA, cblkno, nsect, NO_INTERRUPT);
        err = vjwait(un, M_CRSW_CC);
		blkno += nsect;
		addr += nsect*DEV_BSIZE;
	} while (nblk > 0 && !err);
	return (err ? EIO : 0);
}

#if PRINT_MODE_SENSE 
prt_mode_sense_data(un, mode_sense, page)
register VJ_UNIT *un;
register VJ_MODE_SENSE *mode_sense;
register int page;
{
	DPRINTF("block descriptor\n");
	DPRINTF("vj%d: sense_data_len=%x, med_type=%x, WP=%x, EBC=%x, blk_desc_len=%x\n",
				un->un_unit,
				mode_sense->hdr.sense_data_len,
				mode_sense->hdr.medium_type,
				mode_sense->hdr.WP,
				mode_sense->hdr.EBC,
				mode_sense->hdr.blk_desc_len);
	DPRINTF("density_code=%x, nob=(%x.%x.%x), blk_len=(%x.%x.%x)\n",
				mode_sense->blk_desc.density_code,
				mode_sense->blk_desc.nob_high,
				mode_sense->blk_desc.nob_mid,
				mode_sense->blk_desc.nob_low,
				mode_sense->blk_desc.blk_len_high,
				mode_sense->blk_desc.blk_len_mid,
				mode_sense->blk_desc.blk_len_low);
/*	if (un->un_type & DT_TAPE)
		return; */

	switch (page)
	{
	case 0x01:
	if ((((VJ_MS_PAGE1 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE1 *)mode_sense->pg)->page_code == 0x01) 
	{
	DPRINTF("  PAGE=0x%x: read/write error recovery page\n",
				((VJ_MS_PAGE1 *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, awre=%x, arre=%x, tb=%x, rc=%x,\n \
 eer=%x, per=%x, dte=%x, dcr=%x, r_retry_count=%x, correction_span=%x,\n \
 head_offset=%x, stobe_offset=%x, w_retry_count=%x, recovery_time=(%x.%x)\n",
				((VJ_MS_PAGE1 *)mode_sense->pg)->ps,
				((VJ_MS_PAGE1 *)mode_sense->pg)->page_length, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->awre, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->arre, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->tb, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->rc, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->eer, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->per, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->dte, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->dcr, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->r_retry_count, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->correction_span, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->head_offset, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->strobe_offset, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->w_retry_count, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->recovery_time_msb, 
				((VJ_MS_PAGE1 *)mode_sense->pg)->recovery_time_lsb); 
	}
	else DPRINTF("  PAGE=0x1: does NOT exist - read/write error recovery page\n");
	break;

	case 0x02:
	if ((((VJ_MS_PAGE2 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE2 *)mode_sense->pg)->page_code == 0x02) 
	{
	DPRINTF("  PAGE=0x%x: disconnect reconnect page\n",
				((VJ_MS_PAGE2 *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, buf_full_ratio=%x, buf_empty_ratio=%x,\n \
 bus_inact_limit_msb=(%x.%x), dis_time_limit=(%x.%x), con_time_limit=(%x.%x),\n \
 max_burst_size=(%x.%x), dtdc=%x\n",
				((VJ_MS_PAGE2 *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE2 *)mode_sense->pg)->buffer_full_ratio,
				((VJ_MS_PAGE2 *)mode_sense->pg)->buffer_empty_ratio,
				((VJ_MS_PAGE2 *)mode_sense->pg)->bus_inact_limit_msb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->bus_inact_limit_lsb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->dis_time_limit_msb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->dis_time_limit_lsb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->con_time_limit_msb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->con_time_limit_lsb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->max_burst_size_msb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->max_burst_size_lsb,
				((VJ_MS_PAGE2 *)mode_sense->pg)->dtdc);
	}
	else DPRINTF("  PAGE=0x2: does NOT exist - disconnect reconnect page\n");
	break;

	case 0x03:
	if ((((VJ_MS_PAGE3 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE3 *)mode_sense->pg)->page_code == 0x03)
	{
	DPRINTF("  PAGE=0x%x: format device page\n",
				((VJ_MS_PAGE3 *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, track_per_zone=(%x.%x),\n \
 alt_sectors_per_zone=(%x.%x), alt_tracks_per_zone=(%x.%x),\n \
 alt_tracks_per_vol=(%x.%x), sector_per_track=(%x.%x),\n \
 byte_per_phy_sctr=(%x.%x), interleave_value=(%x.%x),\n \
 track_skew_factor=(%x.%x), cyl_skew_factor=(%x.%x), ssec=%x,\n \
 hsec=%x, rmb=%x, surf=%x\n",
				((VJ_MS_PAGE3 *)mode_sense->pg)->ps,
				((VJ_MS_PAGE3 *)mode_sense->pg)->page_length, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->trk_per_zone_hi, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->trk_per_zone_lo, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_sctr_per_zone_hi, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_sctr_per_zone_lo, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_trk_per_zone_hi, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_trk_per_zone_lo, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_trk_per_vol_hi, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->alt_trk_per_vol_lo, 
				((VJ_MS_PAGE3 *)mode_sense->pg)->sctr_per_trk_hi,
				((VJ_MS_PAGE3 *)mode_sense->pg)->sctr_per_trk_lo,
				((VJ_MS_PAGE3 *)mode_sense->pg)->byte_per_phy_sctr_hi,
				((VJ_MS_PAGE3 *)mode_sense->pg)->byte_per_phy_sctr_lo,
				((VJ_MS_PAGE3 *)mode_sense->pg)->interleave_value_hi,
				((VJ_MS_PAGE3 *)mode_sense->pg)->interleave_value_lo,
				((VJ_MS_PAGE3 *)mode_sense->pg)->track_skew_factor_hi,
				((VJ_MS_PAGE3 *)mode_sense->pg)->track_skew_factor_lo,
				((VJ_MS_PAGE3 *)mode_sense->pg)->cyl_skew_factor_hi,
				((VJ_MS_PAGE3 *)mode_sense->pg)->cyl_skew_factor_lo,
				((VJ_MS_PAGE3 *)mode_sense->pg)->ssec,
				((VJ_MS_PAGE3 *)mode_sense->pg)->hsec,
				((VJ_MS_PAGE3 *)mode_sense->pg)->rmb,
				((VJ_MS_PAGE3 *)mode_sense->pg)->surf);
	}
	else DPRINTF("  PAGE=0x3: does NOT exist - format device page\n");
	break;

	case 0x04:
	if ((((VJ_MS_PAGE4 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE4 *)mode_sense->pg)->page_code == 0x04)
	{
	DPRINTF("  PAGE=0x%x: rigid disk drive geometry page\n",
				((VJ_MS_PAGE4 *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, max_no_of_cylinder=(%x.%x.%x),\n \
 max_no_of_head=%x, start_cyl_wr_pre=(%x.%x.%x), start_cyl_wr_cur=(%x.%x.%x),\n \
 drive_step_rate=(%x.%x), land_zone_cyl=(%x.%x.%x), rpl=%x, rot_offset=%x,\n \
 med_rot_rate=%x\n",
				((VJ_MS_PAGE4 *)mode_sense->pg)->ps,
				((VJ_MS_PAGE4 *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE4 *)mode_sense->pg)->max_no_cyl_hi,
				((VJ_MS_PAGE4 *)mode_sense->pg)->max_no_cyl_mid,
				((VJ_MS_PAGE4 *)mode_sense->pg)->max_no_cyl_lo,
				((VJ_MS_PAGE4 *)mode_sense->pg)->max_no_heads,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_pre_hi,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_pre_mid,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_pre_lo,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_cur_hi,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_cur_mid,
				((VJ_MS_PAGE4 *)mode_sense->pg)->start_cyl_wr_cur_lo,
				((VJ_MS_PAGE4 *)mode_sense->pg)->drive_step_rate_hi,
				((VJ_MS_PAGE4 *)mode_sense->pg)->drive_step_rate_lo,
				((VJ_MS_PAGE4 *)mode_sense->pg)->land_zone_cyl_hi,
				((VJ_MS_PAGE4 *)mode_sense->pg)->land_zone_cyl_mid,
				((VJ_MS_PAGE4 *)mode_sense->pg)->land_zone_cyl_lo,
				((VJ_MS_PAGE4 *)mode_sense->pg)->rpl,
				((VJ_MS_PAGE4 *)mode_sense->pg)->rot_offset,
				((VJ_MS_PAGE4 *)mode_sense->pg)->med_rot_rate);
	}
	else DPRINTF("  PAGE=0x4: does NOT exist - rigid disk drive geometry page\n");
	break;

	case 0x07:
	if ((((VJ_MS_PAGE7 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE7 *)mode_sense->pg)->page_code == 0x07) 
	{
	DPRINTF("  PAGE=0x%x: verify error recovery page\n",
				((VJ_MS_PAGE7 *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, eer=%x, per=%x, dte=%x, dcr=%x,\n \
 verify_retry_cnt=%x, verify_correc_span=%x, ver_rec_time_limit=(%x.%x)\n",
				((VJ_MS_PAGE7 *)mode_sense->pg)->ps,
				((VJ_MS_PAGE7 *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE7 *)mode_sense->pg)->eer,
				((VJ_MS_PAGE7 *)mode_sense->pg)->per,
				((VJ_MS_PAGE7 *)mode_sense->pg)->dte,
				((VJ_MS_PAGE7 *)mode_sense->pg)->dcr,
				((VJ_MS_PAGE7 *)mode_sense->pg)->verify_retry_cnt,
				((VJ_MS_PAGE7 *)mode_sense->pg)->verify_correc_span,
				((VJ_MS_PAGE7 *)mode_sense->pg)->ver_rec_time_limit_hi,
				((VJ_MS_PAGE7 *)mode_sense->pg)->ver_rec_time_limit_lo);
	}
	else DPRINTF("  PAGE=0x7: does NOT exist - verify error recovery page\n");
	break;

	case 0x08:
	if ((((VJ_MS_PAGE8 *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE8 *)mode_sense->pg)->page_code == 0x08) 
	{
	DPRINTF("  PAGE=0x%x: caching page\n",
				((VJ_MS_PAGE8 *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, wce=%x, mf=%x, rcd=%x, drrp=%x,\n \
 wrp=%x, dis_pf_xfer=(%x.%x), min_prefetch=(%x.%x),\n \
 max_prefetch=(%x.%x), max_pf_ceiling=(%x.%x)\n",
				((VJ_MS_PAGE8 *)mode_sense->pg)->ps,
				((VJ_MS_PAGE8 *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE8 *)mode_sense->pg)->wce,
				((VJ_MS_PAGE8 *)mode_sense->pg)->mf,
				((VJ_MS_PAGE8 *)mode_sense->pg)->rcd,
				((VJ_MS_PAGE8 *)mode_sense->pg)->drrp,
				((VJ_MS_PAGE8 *)mode_sense->pg)->wrp,
				((VJ_MS_PAGE8 *)mode_sense->pg)->dis_pf_xfer_len[0],
				((VJ_MS_PAGE8 *)mode_sense->pg)->dis_pf_xfer_len[1],
				((VJ_MS_PAGE8 *)mode_sense->pg)->min_prefetch[0],
				((VJ_MS_PAGE8 *)mode_sense->pg)->min_prefetch[1], 
				((VJ_MS_PAGE8 *)mode_sense->pg)->max_pf_ceiling[0],
				((VJ_MS_PAGE8 *)mode_sense->pg)->max_pf_ceiling[1]);
	}
	else DPRINTF("  PAGE=0x8: does NOT exist - caching page\n");
	break;
				
	case 0x0a:
	if ((((VJ_MS_PAGEAH *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGEAH *)mode_sense->pg)->page_code == 0x0a) 
	{
	DPRINTF("  PAGE=0x%x: control mode page\n",
				((VJ_MS_PAGEAH *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, rlec=%x, qam=%x, qerr=%x, dque=%x,\n \
 eeca=%x, raenp=%x, uaaenp=%x, eaenp=%x, ready_aen_h_per=(%x.%x)\n",
				((VJ_MS_PAGEAH *)mode_sense->pg)->page_length,
				((VJ_MS_PAGEAH *)mode_sense->pg)->rlec,
				((VJ_MS_PAGEAH *)mode_sense->pg)->qam,
				((VJ_MS_PAGEAH *)mode_sense->pg)->qerr,
				((VJ_MS_PAGEAH *)mode_sense->pg)->dque,
				((VJ_MS_PAGEAH *)mode_sense->pg)->eeca,
				((VJ_MS_PAGEAH *)mode_sense->pg)->raenp,
				((VJ_MS_PAGEAH *)mode_sense->pg)->uaaenp,
				((VJ_MS_PAGEAH *)mode_sense->pg)->eaenp,
				((VJ_MS_PAGEAH *)mode_sense->pg)->ready_aen_h_per_hi,
				((VJ_MS_PAGEAH *)mode_sense->pg)->ready_aen_h_per_lo);
	}
	else DPRINTF("  PAGE=0xA: does NOT exist - control mode page\n");
	break;

	case 0x0c:
	if ((((VJ_MS_PAGECH *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGECH *)mode_sense->pg)->page_code == 0x0c) 
	{
	DPRINTF("  PAGE=%x: notch page\n",
				((VJ_MS_PAGECH *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, nd=%x, pln=%x, max_num_notch=%x,\n \
 active_notch=%x, start_bound=(%x.%x), end_bound=(%x.%x), pages_notched=(%x.%x.%x.%x)\n",
				((VJ_MS_PAGECH *)mode_sense->pg)->ps,
				((VJ_MS_PAGECH *)mode_sense->pg)->page_length,
				((VJ_MS_PAGECH *)mode_sense->pg)->nd,
				((VJ_MS_PAGECH *)mode_sense->pg)->pln,
				((VJ_MS_PAGECH *)mode_sense->pg)->max_num_notch,
				((VJ_MS_PAGECH *)mode_sense->pg)->active_notch,
				((VJ_MS_PAGECH *)mode_sense->pg)->start_bound_hi,
				((VJ_MS_PAGECH *)mode_sense->pg)->start_bound_lo,
				((VJ_MS_PAGECH *)mode_sense->pg)->end_bound_hi,
				((VJ_MS_PAGECH *)mode_sense->pg)->end_bound_lo,
				((VJ_MS_PAGECH *)mode_sense->pg)->pages_notched_hi,
				((VJ_MS_PAGECH *)mode_sense->pg)->pages_notched_midhi,
				((VJ_MS_PAGECH *)mode_sense->pg)->pages_notched_midlow,
				((VJ_MS_PAGECH *)mode_sense->pg)->pages_notched_low);
	}
	else DPRINTF("  PAGE=0xC: does NOT exist - notch page\n");
	break;

	case 0x10:
	if ((((VJ_MS_PAGE10H *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE10H *)mode_sense->pg)->page_code == 0x10) 
	{
	DPRINTF("  PAGE=0x%x: device configuration page\n",
				((VJ_MS_PAGE10H *)mode_sense->pg)->page_code); 
	DPRINTF("  ps=%x, page_len=%x, cap=%x, caf=%x, active_form=%x,\n \
 active_part=%x, wbfr=%x, rber=%x, wdt=%x, dbr=%x, ris=%x, rsmk=%x,\n \
 avc=%x, socf=%x, rbo=%x, rew=%x, gapsize=%x, eod=%x, eeg=%x, sew=%x,\n \
 bsew=(%x.%x.%x), sdca=%x\n",
				((VJ_MS_PAGE10H *)mode_sense->pg)->ps,
				((VJ_MS_PAGE10H *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE10H *)mode_sense->pg)->cap,
				((VJ_MS_PAGE10H *)mode_sense->pg)->caf,
				((VJ_MS_PAGE10H *)mode_sense->pg)->active_form,
				((VJ_MS_PAGE10H *)mode_sense->pg)->active_part,
				((VJ_MS_PAGE10H *)mode_sense->pg)->wbfr,
				((VJ_MS_PAGE10H *)mode_sense->pg)->rber,
				((VJ_MS_PAGE10H *)mode_sense->pg)->wdt,
				((VJ_MS_PAGE10H *)mode_sense->pg)->dbr,
				((VJ_MS_PAGE10H *)mode_sense->pg)->ris,
				((VJ_MS_PAGE10H *)mode_sense->pg)->rsmk,
				((VJ_MS_PAGE10H *)mode_sense->pg)->avc,
				((VJ_MS_PAGE10H *)mode_sense->pg)->socf,
				((VJ_MS_PAGE10H *)mode_sense->pg)->rbo,
				((VJ_MS_PAGE10H *)mode_sense->pg)->rew,
				((VJ_MS_PAGE10H *)mode_sense->pg)->gapsize,
				((VJ_MS_PAGE10H *)mode_sense->pg)->eod,
				((VJ_MS_PAGE10H *)mode_sense->pg)->eeg,
				((VJ_MS_PAGE10H *)mode_sense->pg)->sew,
				((VJ_MS_PAGE10H *)mode_sense->pg)->bsew_hi,
				((VJ_MS_PAGE10H *)mode_sense->pg)->bsew_mid,
				((VJ_MS_PAGE10H *)mode_sense->pg)->bsew_lo,
				((VJ_MS_PAGE10H *)mode_sense->pg)->sdca);
	}
	else DPRINTF("  PAGE=0x10: does NOT exist - device configuration page\n");
	break;

	case 0x11:
	if ((((VJ_MS_PAGE11H *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE11H *)mode_sense->pg)->page_code == 0x11) 
	{
	DPRINTF("  PAGE=0x%x: medium partition page(1)\n",
				((VJ_MS_PAGE11H *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, max_part=%x, add_part=%x, fdp=%x,\n \
 sdp=%x, idp=%x, psum=%x, mfr=%x, part_size=%x\n",
				((VJ_MS_PAGE11H *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE11H *)mode_sense->pg)->max_part,
				((VJ_MS_PAGE11H *)mode_sense->pg)->add_part,
				((VJ_MS_PAGE11H *)mode_sense->pg)->fdp,
				((VJ_MS_PAGE11H *)mode_sense->pg)->sdp,
				((VJ_MS_PAGE11H *)mode_sense->pg)->idp,
				((VJ_MS_PAGE11H *)mode_sense->pg)->psum,
				((VJ_MS_PAGE11H *)mode_sense->pg)->mfr,
				((VJ_MS_PAGE11H *)mode_sense->pg)->part_size);
	}
	else DPRINTF("  PAGE=0x11: does NOT exist - medium partition page(1)\n");
	break;

	case 0x20:
	if ((((VJ_MS_PAGE20H *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE20H *)mode_sense->pg)->page_code == 0x20) 
	{
	DPRINTF("  PAGE=0x%x: Sony MO format parameters page\n",
				((VJ_MS_PAGE20H *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, fmt_mode=%x, type=%x, num_of_bands=%x, \
 size_spare_band=%x\n",
				((VJ_MS_PAGE20H *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE20H *)mode_sense->pg)->fmt_mode,
				((VJ_MS_PAGE20H *)mode_sense->pg)->type,
				((VJ_MS_PAGE20H *)mode_sense->pg)->num_of_bands,
				((VJ_MS_PAGE20H *)mode_sense->pg)->size_spare_band);
	}
	else DPRINTF("  PAGE=0x20: does NOT exist - Sony MO format parameters page\n");
	break;

	case 0x32:
	if ((((VJ_MS_PAGE32H *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE32H *)mode_sense->pg)->page_code == 0x32) 
	{
	DPRINTF("  PAGE=0x%x: maxtor drive control page\n",
				((VJ_MS_PAGE32H *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, esdtr=%x, fdpe=%x, cr=%x, dua=%x,\n \
 start=%x, ssid=%x, scsiadr=%x\n",
				((VJ_MS_PAGE32H *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE32H *)mode_sense->pg)->esdtr,
				((VJ_MS_PAGE32H *)mode_sense->pg)->fdpe,
				((VJ_MS_PAGE32H *)mode_sense->pg)->cr,
				((VJ_MS_PAGE32H *)mode_sense->pg)->dua,
				((VJ_MS_PAGE32H *)mode_sense->pg)->start,
				((VJ_MS_PAGE32H *)mode_sense->pg)->ssid,
				((VJ_MS_PAGE32H *)mode_sense->pg)->scsiadr);
	}
	else DPRINTF("  PAGE=0x32: does NOT exist - maxtor drive control page\n");
	break;

	case 0x38:
	if ((((VJ_MS_PAGE38H *)mode_sense->pg)->page_length != 0) &&
				((VJ_MS_PAGE38H *)mode_sense->pg)->page_code == 0x38) 
	{
	DPRINTF("  PAGE=0x%x: cache control parameters\n",
				((VJ_MS_PAGE38H *)mode_sense->pg)->page_code); 
	DPRINTF("  page_len=%x, wie=%x, ce=%x, ctbsz=%x, pref_td=%x,\n \
 max_pref=%x, max_pref_mul=%x, min_pref=%x, min_pref_mul=%x\n",
				((VJ_MS_PAGE38H *)mode_sense->pg)->page_length,
				((VJ_MS_PAGE38H *)mode_sense->pg)->wie,
				((VJ_MS_PAGE38H *)mode_sense->pg)->ce,
				((VJ_MS_PAGE38H *)mode_sense->pg)->ctbsz,
				((VJ_MS_PAGE38H *)mode_sense->pg)->pref_td,
				((VJ_MS_PAGE38H *)mode_sense->pg)->max_pref,
				((VJ_MS_PAGE38H *)mode_sense->pg)->max_pref_mul,
				((VJ_MS_PAGE38H *)mode_sense->pg)->min_pref,
				((VJ_MS_PAGE38H *)mode_sense->pg)->min_pref_mul);
	}
	else DPRINTF("  PAGE=0x38: does NOT exist - cache control parameters\n");
	break;
	}
}
#endif /* PRINT_MODE_SENSE */

static
dump_bytes(s, l)
register char *s;
register int l;
{
	int i;
	char *cp = s;
	for (i=0; i<l; i++)
		printf("%x,", (*cp++)&0xff);
	printf("\n");
}

#ifdef NODEF
static
dump_dontype(dt) /* param for DONIO_SETDRIVE, DONIO_GETDRIVE, DONIO_GETINFO */
dontypet *dt;
{
	int i;
	printf("unit=%x, ", dt->unit);
	printf("id=%x, ", dt->id);
	printf("lun=%x, ", dt->lun);
	printf("iqui_l=%x, ", dt->iqui_l);
	printf("param=%x, ", dt->param);
	printf("name=%s, ", dt->name);
	printf("ssize=%x, ", dt->ssize);
	printf("bsize=%x, ", dt->bsize);
	printf("dsize=%x, ", dt->dsize);
	printf("request=%x, ", dt->request);
	printf("errcode=%x, ", dt->errcode);
	printf("msel_l=%x, ", dt->msel_l);
	printf("msen_l=%x, ", dt->msen_l);
	printf("msdata=");
	for (i=0; i<16; i++)
		printf("%x.", dt->msdata[i]);
	printf("\n");
}
#endif

#endif /* NVJ > 0 */
