:
# "AUsynch.ss", a shell script to copy various master files on
#               startup and on the hour (if an OpenNET system).

# Copyright 1986 Intel Corporation.

# 04/27/86  gll  Added /etc/motd to copy list.
# 05/22/86  gll  Added logical network synchronization.
# 05/30/86  oer  Add trap to remove lock file
# 06/27/86  gll  SPR 171.  Modified checking of ilnaWIP flag so it will
#                time out after 10 minutes and proceed anyway.  This
#                should also clean up if the previous sync was errant.
# 07/09/86  gll  Modified to set and export required variables for
#                logical network update.
# 08/05/86  gll  Added pull of /net/data and /net/cdf from master.
# 08/05/86  gll  Add setting of MASNODE.

node=`cat /etc/systemid`

# see if can access with //node, if so OpenNET is installed
[ -f //$node/etc/systemid ] || exit

MASNODEP=`sed -n -e 's/^\(\/\/[^/]*\)\/etc\/passwd$/\1/p' /net/self`

oldIFS="$IFS"
IFS=/
set A $MASNODEP
IFS="$oldIFS"
MASNODE=$2

# if this node is the master, don't copy but DO perform
# logical network synchronization

case //$node in
   $MASNODEP) # See if logical network updates are pending
              if [ -f $MASNODEP/usr/ilna/netsynch/applied/ilnaP ]
              then 
                   # See if some Sub-network node is updating
                   # If so, wait until complete.

                   TIME=0
                   while [ -f $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP \
                           -a $TIME -lt 10 ]
                   do sleep 60
                      TIME=`expr $TIME + 1`
                   done

                   iDIS=/usr/iDIS       # NOTE: THIS IS HARD CODED !!!
                   iDISBIN=/usr/iDISbin # and does not include the node name
                   export iDIS iDISBIN MASNODEP MASNODE

                   # Mark the directory as busy, and start updating
                   trap "rm -f $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP;\
		      trap 0; exit" 0 1 2 3 15
                   >$MASNODEP/usr/ilna/netsynch/applied/ilnaWIP
                   chmod a+r $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP
                   $iDISBIN/Alnapply.ss
              fi
              exit ;;
esac

# See if Sub-Network Master is updating network files.
# If so, wait until complete.

TIME=0
while [ -f $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP -a $TIME -lt 10 ]
do sleep 60
   TIME=`expr $TIME + 1`
done

# Now mark directory as busy so master doesn't start an update
# while we are busy.

trap "rm -f $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP; \
   trap 0; exit" 0 1 2 3 15

>$MASNODEP/usr/ilna/netsynch/applied/ilnaWIP
chmod a+r $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP

# Start copying the files

copy -o	$MASNODEP/net/data		/net/cp$$
mv	/net/cp$$			/net/data
copy -o	$MASNODEP/net/cdf		/net/cp$$
mv	/net/cp$$			/net/cdf
copy -o	$MASNODEP/etc/passwd		/etc/cp$$
mv	/etc/cp$$			/etc/passwd
copy -o	$MASNODEP/etc/group		/etc/cp$$
mv	/etc/cp$$			/etc/group
copy -o  $MASNODEP/etc/motd		/etc/cp$$
mv	/etc/cp$$			/etc/motd
copy -o	$MASNODEP/etc/drm/finder.rsrc	/etc/drm/cp$$
mv	/etc/drm/cp$$			/etc/drm/finder.rsrc
copy -o	$MASNODEP/etc/drm/finder.assign	/etc/drm/cp$$
mv	/etc/drm/cp$$			/etc/drm/finder.assign
copy -o	$MASNODEP/etc/drm/finder.types	/etc/drm/cp$$
mv	/etc/drm/cp$$			/etc/drm/finder.types
copy -o	$MASNODEP/usr/lib/mail/mailrc	/usr/lib/mail/cp$$
mv	/usr/lib/mail/cp$$		/usr/lib/mail/mailrc

# Remove the busy flag, and the sync is complete.
rm -f $MASNODEP/usr/ilna/netsynch/applied/ilnaWIP
