: 'Copyright 1986 Intel Corp.'
# create/delete menu system login/deauth information
# Runs on the target node itself.
# This is called with an environment that contains most of the user's info.
# The login.dat and deauth.dat files are locked prior to call.
# Current directory is the menu system control directory
#	Parm1 = APPLY or RESTART
#	Parm2 = English name of the menu system
#	Parm3 = login.dat info.  (only for APPLY)
#	Parm4 = deauth.dat info. (only for APPLY)

set -x
msname=$2

case $1 in
   # APPLY
   APPLY)
      login=$3
      deauth=$4
      cat login.dat  $login  > login.tmpA
      cat deauth.dat $deauth > deauth.tmpA
      sort login.tmpA  -u -o login.tmpA
      sort deauth.tmpA -u -o deauth.tmpA
      /usr/iDIS/menus/md/baf login.tmpA deauth.tmpA auth.file.tmpA menu.file > error.tmpA 2>&1
      case $? in
	 0) mv login.tmpA  login.dat
	    mv deauth.tmpA deauth.dat
	    mv auth.file.tmpA auth.file
	    chmod 664 login.dat deauth.dat auth.file
	 ;;

	 *) { echo "Problem in generating menu system authorization files"
	      echo "on node $NODE, for Batch `expr $BATCH + 0`."
	      echo "Menu system is: $msname"
	      echo '------------------------------------------------'
	      echo "The following error conditions were detected:\n"
	      cat error.tmpA
	      echo '------------------------------------------------'
	      echo "\nAs a result these portions of the transaction"
	      echo "have removed from this node:\n"
	      echo "Login Information:"
	      cat $login
	      echo '------------------'
	      echo "\nDeauthorization Information:"
	      cat $deauth
	      echo '------------------------------------------------'
	      echo "\nThe previous authorization files have been retained."
	    } | mail -s "Menu system generation error" $LOGIN
	 ;;
      esac
   ;;

   # RESTART
   RESTART)
      sed -e "/^$Ausr[ 	]*/d" login.dat  > /tmp/login.$$
      sed -e "/^$Ausr[ 	]*/d" deauth.dat > /tmp/deauth.$$
      mv /tmp/login.$$  login.dat
      mv /tmp/deauth.$$ deauth.dat
      chmod 664 login.dat deauth.dat
   ;;

esac
