: 'Copyright 1986 Intel Corp.'
# Atranss.ss
# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 04/08/86 oer add schedule capability
# 05/05/86 oer report minutes in the current hour
# 05/06/86 oer fix problem with simultaneous scheduling
# 05/08/86 oer change to reference the master node
# 05/17/86 oer make wording similar to Erbld.ss
# 05/28/86 oer rexec Astage2.ss, if OpenNET, to cut down network traffic
# 06/13/86 oer modify standalone Astage2.ss to correct MASNODEP
# 08/04/86 dan corrected misspelling of immediatly

MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
export MASSYNCH

echo "One moment ..."

if [ ! -f /usr/tmp/$LOGINID.idisP ] ; then
	echo "No pending transactions currently exist."
	exit 1
fi

# See if any valid transactions exist
if egrep '^#\(' /usr/tmp/$LOGINID.idis? > /dev/null 2>&1 ; then :
else
	echo "All of the pending transactions had been marked as deleted."
	echo "The Pending Transactions indicator will be removed."
	echo "No further processing is required"
	rm -f /usr/tmp/$LOGINID.idis?
	exit 1
fi

echo -n "
The time required to process the pending transactions varies with the
number and type of transactions.  This may be a lengthy process.

This process may be deferred to a later time or done immediately.
In either case, you will be notified by mail when they complete.\n
"

while :
do
   cat <<-HERE
	Do you wish to defer the pending transactions for later application?
	If so, you will be asked to provide a time at which they should applied.
	If you do not wish to defer, the transactions will be applied immediately.

	(DEL will cancel the operation without scheduling the transactions)

	HERE
   echo -n "\nPlease enter (y) to defer or (n) to apply immediately: "
   read resp
   case $resp in
      y*|Y*) resp=y break ;;
      n*|N*) resp=n break ;;
      *) echo "Invalid response <$resp>, please respecify.\n" ;;
   esac
done

$iDISBIN/Fclrscrn

case $resp in
   n)
      # trap hangup, interrupt (delete), quit, and software kill
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3 15

      echo "One moment, applying the transactions ..."

      # Make this directory if it doesn't already exist
      if [ ! -d $MASSYNCH/$LOGINID.Batch ] ; then
   	   mkdir $MASSYNCH/$LOGINID.Batch
   	   chmod 777 $MASSYNCH/$LOGINID.Batch
      fi
   
      cd $MASSYNCH/$LOGINID.Batch
   
      # see if a previous apply has not finished
      if [ -f Stage1 ] ; then
   	   echo "A previous batch, number `cat BatchNumber`, has not yet finished" its
   	   echo "intermediate processing.  You can wait a few minutes and"
   	   echo "try again, or you can \047schedule\047 this set of transactions."
   	   exit 1
      fi
   
      Batch=`$iDISBIN/Anxtbatch`
   
      # move files to work queue
      echo $Batch > BatchNumber
      mv /usr/tmp/$LOGINID.idis? .
      rm -f $LOGINID.idisP
      > Stage1
   
      # mail report to user, indicating batch
      { echo "Contents are:\n"
       sed -n -e 's/^#(\(.*\)$/\1/p' $LOGINID.idis?
       echo "\nYou will be sent mail when the batch completes (with or without error)."; } |
   	   mail -s "Batch $Batch scheduled to be applied immediately." $LOGINID
   
      # put info in logfile
      { echo "Batch $Batch scheduled to be applied immediately `date`, contents are:"
      sed -n -e 's/^#(\(.*\)$/\1/p' $LOGINID.idis?; } >> $MASSYNCH/logfile
   
      # start Stage2 and exit
      # Run Astage2.ss on the master node, if OpenNET
      case $OPENNET in
         n) exec $iDISBIN/Astage2.ss $iDIS \
	       $iDISBIN $OPENNET $MASNODE / \
	       $MASSYNCH $LOGINID $MASSYNCH/$LOGINID.Batch & ;;
	 y) case $PHYSYS in
	       $MASNODE) exec $iDISBIN/Astage2.ss $iDIS \
		            $iDISBIN $OPENNET $MASNODE $MASNODEP \
		            $MASSYNCH $LOGINID $MASSYNCH/$LOGINID.Batch & ;;
	       *) rexec $MASNODEP`$iDISBIN/Unonode $iDISBIN`/Astage2.ss $iDIS \
		     $iDISBIN $OPENNET $MASNODE $MASNODEP \
		     $MASSYNCH $LOGINID $MASSYNCH/$LOGINID.Batch -- /dev/null ;;
	    esac ;;
      esac
   
      cat <<-HERE > /dev/tty
	Transaction Batch $Batch has been scheduled to be applied immediately.
	Further details have been sent via mail.
	HERE
      exit 1
   ;;

   # Deferred transaction
   y)
      # get current day, hour, minute
      set `date '+%w %H %M'`
      day=$1
      ch=`expr $2 + 0`
      cm=`expr $3 + 0`
      echo
      while :
      do
	 cat <<-HERE
		Please supply the hour you wish the transactions to be scheduled.  This will
		be a number between 0 and 23.  Where 0 is midnight, 8 is 8am, and 23 is 11pm.

		The current time is $cm minutes past hour  $ch.   If the hour you supply is
		equal to or less than  $ch , the transactions will be scheduled for tomorrow
		at that time.

		(DEL will cancel the operation without scheduling the transactions)

		HERE
	 echo -n "\nPlease supply the desired hour (a number between 0 and 23): "
	 read oresp
	 # only allow numbers and letters
	 resp=`echo $oresp|tr -d "[\001-\057][\072-\100][\133-\140][\173-\177]"`
	 if echo $resp | egrep '[^0-9]' > /dev/null ; then
	    echo "Invalid response <$oresp>, please respecify.\n"
	 elif [ -z "$resp" -o "$resp" -lt 0 -o "$resp" -gt 23 ] ; then
	    echo "Invalid response <$oresp>, please respecify.\n"
	 else
	    break
	 fi
      done
      hour=$resp

      # trap hangup, interrupt (delete), quit, and software kill
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3 15

      # handle those for tomorrow
      if [ $hour -le $ch ] ; then
	 case $day in
	    0) day=Monday ;;
	    1) day=Tuesday ;;
	    2) day=Wednesday ;;
	    3) day=Thursday ;;
	    4) day=Friday ;;
	    5) day=Saturday ;;
	    6) day=Sunday ;;
	 esac
	 which=tomorrow
      else
	 day=""
	 which=today
      fi

      $iDISBIN/Fclrscrn

      echo "One moment, scheduling the pending transactions ..."
      TXN=/usr/tmp/idisAt$$
      S=/usr/tmp/SAt$$
      trap "rm -f $TXN; trap 0; exit 1" 0

      Batch=`$iDISBIN/Anxtbatch`

      cd /usr/tmp
      # NOTE: DON'T CHANGE THE '# Scheduled transactions' COMMENT !!!
      #    (AUatrm.ss needs it)
      cat <<-HERE > $TXN
	: /bin/sh
	# Scheduled transactions, Batch $Batch

	# Build the script to copy the files into the workarea
	trap "rm -f $S; trap 0; exit" 0
	cat <<THERE@@ > $S
	: /bin/sh
	\\\$NSDBUG && echo Entered $S for Batch $Batch >> $MASSYNCH/debug

	# See if a previously scheduled transaction (if any)
	# has finished the use of the workarea.  If not, exit
	[ -f Stage1 ] && exit 101

	echo $Batch > BatchNumber
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $TXN
      exec >> $TXN
      for file in `ls $LOGINID.idis?`
      do
	 case $file in
	    $LOGINID.idisP) continue ;;
	 esac
	 echo "cat <<HERE## > $file"
	 cat $file
	 echo 'HERE##'
      done

      cat <<-HERE

	> Stage1
	\\\$NSDBUG && echo Left $S for Batch $Batch >> $MASSYNCH/debug
	THERE@@
        MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
	export MASSYNCH
	umask 0
	# Set debug, if requested
	if [ -f $MASSYNCH/debug ] ; then
	   NSDBUG=/bin/true
	else
	   NSDBUG=/bin/false
	fi
	export NSDBUG

	# Ensure workarea exists and create lock file
	if [ ! -d $MASSYNCH/.Sched.Batch ] ; then
	   mkdir $MASSYNCH/.Sched.Batch
	   > $MASSYNCH/.Sched.Batch/.lock
	fi
	cd $MASSYNCH/.Sched.Batch
	[ -f .lock ] || > .lock		# create lock file if needed

	# Get exclusive control of workarea and try to set it up
	count=0
	while :
	do
	   /iDISboot/Flock -r $MASSYNCH/.Sched.Batch/.lock -e /bin/sh $S
	   case \$? in
	      201) \$NSDBUG && echo "Batch $Batch sleep 5" >> $MASSYNCH/debug
	           sleep 5;; # files aren't available
	      202) echo Problem in accessing .Sched.Batch, Batch $Batch > /dev/console
	           echo Problem in accessing .Sched.Batch, Batch $Batch > $MASSYNCH/logfile ;;
	      101) \$NSDBUG && echo "Batch $Batch sleep 60" >> $MASSYNCH/debug
	           sleep 60	# Workarea was in use, try again
	           count=\`expr \$count + 1\`
	           # Allow two hours, if not successful, clear out prior transaction
	           if [ \$count -gt 120 ] ; then
	              { echo \$0: Network synchronization error \`date\`
	                echo Please check $MASSYNCH/logfile; } > /dev/console
	              { echo \$0: Network synchronization error \`date\`
	                echo Batch $Batch could not gain access to $MASSYNCH/.Sched.Batch
	                echo As a result the files of previous batch \`expr \\\`cat BatchNumber\\\` + 0\` were removed; } >> $MASSYNCH/logfile
	              { echo \$0: Network synchronization error \`date\`
	                echo Batch $Batch could not gain access to $MASSYNCH/.Sched.Batch
	                echo As a result the files of previous batch \`expr \\\`cat BatchNumber\\\` + 0\` were removed; } |
	                mail -s "Network synchronization error" $LOGINID
	                rm -f $MASSYNCH/.Sched.Batch/*
	              count=0
	           fi
	      ;;
	      *)   break ;;
	   esac
	done

	# mail to user that batch has been scheduled
	echo "Deferred batch $Batch started at \`date\`" |
	   mail -s "Deferred batch $Batch started" $LOGINID

	# and to logfile (and debug log)
	echo "Deferred batch $Batch started at \`date\`" >> $MASSYNCH/logfile
	\$NSDBUG && echo "Deferred batch $Batch started " >> $MASSYNCH/debug

	# Start Stage2
	# Run Astage2.ss on the master node, if OpenNET
	case $OPENNET in
	   n) exec $iDISBIN/Astage2.ss $iDIS \
	         $iDISBIN $OPENNET $MASNODE / \
	         $MASSYNCH $LOGINID $MASSYNCH/.Sched.Batch & ;;
	   y) case $PHYSYS in
	         $MASNODE) exec $iDISBIN/Astage2.ss $iDIS \
		             $iDISBIN $OPENNET $MASNODE $MASNODEP \
		             $MASSYNCH $LOGINID $MASSYNCH/.Sched.Batch & ;;
	         *) rexec $MASNODEP`$iDISBIN/Unonode $iDISBIN`/Astage2.ss $iDIS \
		       $iDISBIN $OPENNET $MASNODE $MASNODEP \
		       $MASSYNCH $LOGINID $MASSYNCH/.Sched.Batch -- /dev/null ;;
	      esac ;;
	esac
	HERE

      # mail report to user, indicating batch
      { echo "Contents are:\n"
       sed -n -e 's/^#(\(.*\)$/\1/p' $LOGINID.idis?
       echo "\nThe batch is deferred until hour $hour $which."
       echo "\nYou will be sent mail when the batch starts and completes"; } |
   	   mail -s "Batch $Batch has been scheduled for deferred application." $LOGINID
   
      # put info in logfile
      { echo "Batch $Batch has been scheduled for deferred application`date`, on hour $hour $which,  contents are:"
      sed -n -e 's/^#(\(.*\)$/\1/p' $LOGINID.idis?; } >> $MASSYNCH/logfile

      # remove pending transactions
      rm -f $LOGINID.idis?


      # remove any previous iDIS transactions from the 'past' queue
      exec /iDISboot/Ar $iDISBIN/AUatrm.ss &

      # schedule the transaction
      at $hour $day $TXN
   
      cat <<-HERE > /dev/tty
	Transaction Batch $Batch has been scheduled for deferred application
	on hour $hour $which.
	Further details have been sent via mail.
	HERE
      exit 1
   ;;
esac
