:
# Copyright 1986 Intel Corporation.
# "Alnau.ss",	a shell script to help the user update network configuration
#		files on Sub-Network master nodes around the network.
#
# 04/24/86	dan	Extracted almost in its entirety from oer's Atransa.ss
# 04/25/86	dan	added in gll's suggested improvements
# 05/20/86      gll     modified to support update of Sub-Network Synch.

$iDISBIN/Fclrscrn

   echo -n "
The time required to update network configuration files on the
Sub-Network master nodes varies with the size of the network.
This may be a lengthy process.

This process may be deferred to a later time or done immediately.
"

while :
do
   echo -n "

Do you want to schedule the update of network configuration files
on the Sub-Network master nodes for a later time?

(DEL will cancel the operation without scheduling the update)

Please enter (y) to defer or (n) to update immediately: "


   read resp
   case $resp in
      y*|Y*) resp=y break ;;
      n*|N*) resp=n break ;;
      *) echo "Invalid response <$resp>, please respecify." ;;
   esac
done

$iDISBIN/Fclrscrn

case $resp in
   n)
      # trap hangup, interrupt (delete), and quit
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3

      /iDISboot/Ar $iDISBIN/Alnaupd.ss "$ILNAP" &

      echo "
The process to update network configuration files on the Sub-Network
master nodes is processing in the background.

You will be notified by mail when it has been completed.


"

      exit 0
   ;;

   y)
      ch=`expr \`date +%H\` + 0`	# get current hour and day
      day=`date +%w`
      echo -n "
To defer the update of network configuration files on the Sub-Network
master nodes to a later time, it is necessary for you to supply the
hour that this task is to be started.

This will be a number between 0 and 23.  Where 0 is midnight,
8 is 8am, and 23 is 11pm.

If the hour you supply is less than or equal to the current hour,
which is $ch,  the transactions will be scheduled for tommorrow
at that time.

"
      while :
      do
	 echo -n "
Please enter the hour this task is to start (a number between 0 and 23): "

	 read oresp
	 # only allow numbers and letters
	 resp=`echo $oresp|tr -d "[\001-\057][\072-\100][\133-\140][\173-\177]"`
	 if echo $resp | egrep '[^0-9]' > /dev/null ; then
	    echo "Invalid response <$oresp>, please respecify.\n"
	 elif [ -z "$resp" -o "$resp" -lt 0 -o "$resp" -gt 23 ] ; then
	    echo "Invalid response <$oresp>, please respecify.\n"
	 else
	    break
	 fi
      done
      hour=$resp

      # trap hangup, interrupt (delete), and quit
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3

      # handle those for tomorrow
      if [ $hour -le $ch ] ; then
	 case $day in
	    0) day=Monday ;;
	    1) day=Tuesday ;;
	    2) day=Wednesday ;;
	    3) day=Thursday ;;
	    4) day=Friday ;;
	    5) day=Saturday ;;
	    6) day=Sunday ;;
	 esac
	 which=tomorrow
      else
	 day=""
	 which=today
      fi

      $iDISBIN/Fclrscrn

      echo "One moment please ..."


      echo ":
# Scheduled update of network configuration files on Sub-Network Master nodes.
LOGINID=$LOGINID; export LOGINID
MASNODE=$MASNODE; export MASNODE
MASNODEP=$MASNODEP; export MASNODEP
/iDISboot/Ar $iDISBIN/Alnaupd.ss $ILNAP
" > /tmp/Alnupd$$

      at $hour $day /tmp/Alnupd$$

      rm /tmp/Alnupd$$

      $iDISBIN/Fclrscrn
   
      echo "
The process to update the network configuration files on the Sub-Network
master nodes has been scheduled to begin at hour $hour ${which}.

You will be notified by mail when it has been completed.


"

      exit 0
   ;;
esac
