# "Agrpp.ss", a shell script to print group information.

# Copyright 1986 Intel Corporation.

# 03/22/86  gll  Initial entry for iDIS R2.0.
# 04/15/86  ugg  Modified to pass full pathname to Aplpr.ss
# 04/29/86  ugg  Replaced Aplpr.ss by lpr
# 08/05/86  gll  Added trap to prevent kill on user logout.
#                Also made a fix to make sure a final carriage return 
#                is placed into the print file.

# Keep going, even if user logs out.

trap "" 1 2 3 15

# We do this until we run out of groups.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=62
maxcols=7
colwid=10
line=6
pgno=1
ldate="`date`"
continue=yes
groupname=${1-absent}
grouplist=$*
prnnode=`$iDISBIN/Uselect -es : 2 0 $CURPRTR < /etc/drm/finder.rsrc`

if [ "$prnnode" = "" ]
then OPENNET=n
fi

pid=$$

# Set trap to remove temp file in the event we're aborted

trap "rm -f /usr/tmp/Agrpp.$pid; exit" 2 3 15

# Start the output file with a page header.

echo "$ldate   Sub-Network Group Information    Page $pgno\n\n" \
>> /usr/tmp/Agrpp.$pid

# Now make sure there is at least one group to display.

if [ "$groupname" = "absent" ]
then echo "
$0: no group names specified!" >> /usr/tmp/Agrpp.$pid
     lpr -r -C $LOGINID -J groups /usr/tmp/Agrpp.$pid
     exit 1
fi

# Enter the loop and process the first group name.

while [ "$continue" != "c" ]
do

# Find the gid for this group.

gid=`$iDISBIN/Uselect -s : 2 0 $groupname < $MASNODEP/etc/group`

# Only do the rest if this is a real group

if [ "$gid" = "" ]
then echo "
************************************************************************
No such group as \"$groupname\"!
************************************************************************" \
     >> /usr/tmp/Agrpp.$pid
     line=`expr $line + 4`

else


# Establish type of group (GROUP/USER LOGIN), (GROUP/NOLOGIN), 
# (GROUP/NO WORKAREA), (iDISGROUP WITH WORKAREA)
# (IMPROPERLY MADE XENIX GROUP)

pentry=`grep -c ${groupname}: $MASNODEP/etc/passwd`

password=`$iDISBIN/Uselect -s : 1 0 $groupname < $MASNODEP/etc/passwd`

case $password in   NOLOGIN) also="(XENIX GROUP/NOLOGIN)        "
                             alsof=y;;
                  iDISGROUP) also="(iDIS GROUP WITH WORKAREA)   "
                             alsof=y;;
                      GROUP) also="(iDIS GROUP WITHOUT WORKAREA)"
                             alsof=n;;
                          *) uid=`$iDISBIN/Uselect -s : 2 0 $groupname \
                                  < $MASNODEP/etc/passwd`
                             if [ "$uid" != "" ]
                             then also="(GROUP & USER LOGIN (uid=$uid))"
                                  alsof=y
                             else if [ $pentry -gt 0 ]
                                  then also="(IMPROPERLY MADE XENIX GROUP)"
                                       alsof=y
                                  else also="(XENIX GROUP ONLY)           "
                                       alsof=n
                                  fi
                             fi;;
esac

# Find the home path for the group workarea, or none if there
# is no workarea for this group.

if [ "$alsof" = "n" ]
then grphome="No workarea was created for this group."
else grphome=`$iDISBIN/Uselect -s : 5 0 $groupname < $MASNODEP/etc/passwd`
     if [ "$grphome" = "" ]
     then grphome="*** No home path found! ***"
     fi
fi

# Find the membership list (group manager is first one listed).

members=`$iDISBIN/Uselect -s : 3 0 $groupname < $MASNODEP/etc/group`

ORGIFS=$IFS
IFS=,
set $members LAST
IFS=$ORGIFS

# Now display the information nicely for the administrator.

newpage=y
mgrmsg="\n            (First one listed is the group Manager)"

while [ "$newpage" = "y" ]
do

echo "========================================================================

Group name: $groupname $also Group id (uid): $gid

Home path for workarea: $grphome

========================================================================
                         Group Members $mgrmsg
" >> /usr/tmp/Agrpp.$pid

if [ "$mgrmsg" != "(continued)" ]
then mgrmsg="(continued)"
     line=`expr $line + 10`
else line=`expr $line + 9`
fi

cnt=1
while [ "$1" != "LAST" ]
do

echo -n "$1" >> /usr/tmp/Agrpp.$pid
memwid=`expr $1 : '.*'`
case $memwid in 1) echo -n "         " >> /usr/tmp/Agrpp.$pid;;
                2) echo -n "        " >> /usr/tmp/Agrpp.$pid;;
                3) echo -n "       " >> /usr/tmp/Agrpp.$pid;;
                4) echo -n "      " >> /usr/tmp/Agrpp.$pid;;
                5) echo -n "     " >> /usr/tmp/Agrpp.$pid;;
                6) echo -n "    " >> /usr/tmp/Agrpp.$pid;;
                7) echo -n "   " >> /usr/tmp/Agrpp.$pid;;
                8) echo -n "  " >> /usr/tmp/Agrpp.$pid;;
esac
shift
cnt=`expr $cnt + 1`
if [ $cnt -gt $maxcols ]
then echo >> /usr/tmp/Agrpp.$pid
     cnt=1
     line=`expr $line + 1`
     if [ $line -gt $maxlines ]
     then pgno=`expr $pgno + 1`
          line=6
echo "\n\n\n\n\n\n$ldate   Sub-Network Group Information    Page $pgno\n\n" \
>> /usr/tmp/Agrpp.$pid
          break
     fi
fi
done

if [ "$1" = "LAST" ]
then newpage=n
fi

done

fi

# Now move to the next group, or quit if there are no more.

set $grouplist
shift
groupname=${1-absent}
grouplist=$*

if [ "$groupname" = "absent" ]
then continue=c
     echo "\n" >> /usr/tmp/Agrpp.$pid
else

linesleft=`expr $maxlines - $line`

if [ $linesleft -le 11 ]
then 
     case $linesleft in 1) echo "\n\n\n">> /usr/tmp/Agrpp.$pid;;
                        2) echo "\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        3) echo "\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        4) echo "\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        5) echo "\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        6) echo "\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        7) echo "\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        8) echo "\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                        9) echo "\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                       10) echo "\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
                       11) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Agrpp.$pid;;
     esac
     pgno=`expr $pgno + 1`
     line=6
     echo "\n\n\n\n$ldate   Sub-Network Group Information    Page $pgno\n\n" \
     >> /usr/tmp/Agrpp.$pid
else echo "\n" >> /usr/tmp/Agrpp.$pid
     line=`$iDISBIN/Uinc $line 2`
fi

fi

done

# Finally, spool the file to the assigned printer

if [ "$OPENNET" = "y" ] ; then
   lpr -r -C $LOGINID -J groups `net name`/usr/tmp/Agrpp.$pid
else
   lpr -r -C $LOGINID -J groups /usr/tmp/Agrpp.$pid
fi
