: 'Copyright 1983, 1986 Intel Corporation.'
# "Afinst.ss"
# install software option
#
#  Parameters:
#     1 - feature name being installed
#     2 - node name (Optional)
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
feature=$1
node=$2
idis=`$iDISBIN/Unonode $iDIS`
#
if [ "$node" != "" ] ; then
  reference=node
else
  reference=system
fi
#
if [ -d $idis ] ; then
  iDIS=$idis
  iDISBIN=`$iDISBIN/Unonode $iDISBIN`
  export iDIS iDISBIN
else
  echo "
        iDIS software is not installed on this $reference.
        You can not install $feature feature on this $reference.

	You may have made an error in specifying the iDIS resources.
	Please check the resource specifications.
       "
  exit 0
fi
#
#   First make sure that the feature installation/deletion is not in progress
#
$iDISBIN/Flock -x $iDIS/fb_lock -e sleep 0
if [ $? != 0 ] ; then
   echo 
   echo "   Feature installation/deletion is currently under progress"
   echo "     on this $reference. Please try later."
   exit 0
fi
#
ttydev=`tty`

#  ignore quit signal
trap "" 1 2 3 15

#  Invoke feature build while locking the fb_lock file.
#
$iDISBIN/Flock -x $iDIS/fb_lock -e env - iDIS=$iDIS PATH=$PATH iDISBIN=$iDISBIN fbtty=$ttydev $iDISBIN/fb $ttydev
#
#   See whether there were any errors
#
if [ $? != 0 ] ; then    # fb could not install
   fb_err=1
elif [ -f $iDIS/report ] ; then  
   # fb installed the feature, but there were errors
   count=`grep -c "^[^> ]" $iDIS/report`
   if [ $count -gt 0 ] ; then
      errors=
   else
      errors="NO "
   fi
fi
#
#   Feature installation is complete on remote system. Now append the
#    the latest activity log to the zaplog file for future reference.
#
echo "          iDIS SOFTWARE FEATURE INSTALLATION of $feature feature " >> $iDIS/zaplog
echo "            on `date`" >> $iDIS/zaplog
echo " " >> $iDIS/zaplog
cat $iDIS/report >> $iDIS/zaplog
#
#  Next insert the message as how to look for errors in report file.
#
cd $iDIS
echo "NOTE: Please look for lines that start in column 1" > report.tmp1
echo " (but not with a '>' character) to identify errors, if any." >> report.tmp1
echo " " >> report.tmp1
cat report >> report.tmp1
rm report
mv report.tmp1 report
# 
chown iDIS report debug
chmod 444 report debug
#
#   Now that we are done with the entire feature installation process,
#    we need to send mail to the person who initiated the feature 
#    installation.
#
if [ "$fb_err" = "1" ] ; then
   mail -s "Installation of $feature feature on this system" `logname` > /dev/null <<!
The $feature feature was not installed on this system. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
elif [ "$node" = "" ] ; then
  mail -s "Installation of $feature feature on this system" `logname` > /dev/null <<!
The installation of $feature feature on this system is complete. 
There were ${errors}errors during the $feature feature installation. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
else
  mail -s "Installation of $feature feature on node $node" `logname` > /dev/null <<!
The installation of the $feature feature on the node $node is complete. 
There were ${errors}errors during the $feature feature installation. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
fi
#
if [ "$fb_err" = "1" ] ; then
  echo "
  The $feature feature was not installed.
  The installation procedure for $feature feature was missing.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  "  | tee -a report | tee -a zaplog
elif [ "$errors" = "NO " ] ; then
  echo "
  The $feature feature installation is successful.
  Please logout and login again to use $feature feature.
  "  | tee -a report | tee -a zaplog
else
  echo "
  Errors were encountered during the $feature feature installation.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  "  | tee -a report | tee -a zaplog
fi
#
echo "/* ------------------------------------------------------------------- */" >> zaplog
echo " " >> zaplog
echo
#
