# restores a work area from a backup archiver
# Copyright 1986 Intel Corporation.
umask 0
filename=$1
if [ $CURDEV != "unassigned" ]; then
	curtype=`Uselect -s : 1 0 $CURDEV < /etc/drm/finder.rsrc`
	blocking="`Uselect -s : 1 0 $curtype \
				< /etc/drm/finder.usage | tr ';' ' '`"
	device=`Uselect -s : 3 0 $CURDEV < /etc/drm/finder.rsrc`
else
	echo "\n Current device is unassigned.\n"\
		"Choose \"chng\" from menu to select a device for save/restore."
	exit 1
fi
if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $CURDEV < /etc/drm/finder.rsrc`
	devnode=//$nodename
	echo " You are using the $CURDEV device " \
		"on node $nodename"
else
	devnode=""
	echo " You are using the $CURDEV device " 
fi
##############
NOTALLOWED="The work area selected is not on a node which you are allowed to administer."
AUTH=`Aauthority.ss $LOGINID`
case $AUTH in
	keyoperator)
		NODELIST=`Argetnodes.ss $LOGINID keyoperator | tr '\012' ' '`
		ASK=yes
	;;
	lognetadmin|subnetadmin)
		ASK=yes
	;;
	*)
		ASK=no
	;;
esac

if [ "$ASK" = "yes" ]; then 
PASS=/etc/passwd
OP=restore
if [ "$OPENNET" = "y" ]; then
	echo -n \
	"\n Current work area is the $WATYPE work area on the $WORKSYS node.\n"
else
	echo -n \
	"\n Current work area is the $WATYPE work area.\n"
fi
while [ TRUE ] ; do
echo -n "\n Please enter the type of work area which you want to $OP\n"\
			"(c=current i=individual g=group p=public): "
read RESP
case $RESP in 
	c*)	break
	;;
	i*)	echo -n "\n Please enter the loginid of the user"\
			"\n whose work area you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid login.\n"
		fi
	;;
	g*)	echo -n "\n Please enter the name of the group work"\
			"area you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid group workarea.\n"
		fi
	;;
	p*)	echo -n "\n Please enter the name of the"\
			"public work area you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid public workarea.\n"
		fi
	;;
esac
done
fi
#########

echo "
 This operation will restore (copy) files from the $CURDEV drive to the
 selected workarea.  Be certain that the media on the $CURDEV device
 contains the data you wish to restore.  It is possible to view the contents
 of the media by the 'unit' menu selection.\n
 (If you wish to cancel this operation, without restoring, press the DEL key)\n"

# name of the lock file
LOCK=$devnode/tmp/$CURDEV

# see if the device is in use
if [ -f $LOCK ] ; then
   set `cat $LOCK`
   menuid=$1
   owner=$2
   case $menuid in
      $MENUID) ;;	# It is us, everything is o.k.
      *)
	  echo "
 It is possible that the $CURDEV drive is in use by someone else.  Our
 information suggests that it is in use by a user whose login ID is $owner.
 It is recommended that you physically examine the drive to determine if it is
 in fact being used.

 You will be given an opportunity to go ahead with this operation.  If you
 do go ahead, and the $CURDEV drive IS in use it is possible that you will
 destroy any data that exists on $owner's media.\n"

	  while :
	  do
	      echo -n " Do you wish to go ahead with this operation (y or n)? "
	      read resp
	      case $resp in
		y*|Y*)	rm -f $LOCK
			break ;;
		n*|N*)	echo " Operation has been canceled."
			exit 1 ;;
		*)	echo "\n Invalid response <$resp>, please respecify"
	      esac
	  done
      ;;
   esac
fi

# remove lock when script exits (normally or abnormally)
trap "rm -f $LOCK; trap 0; exit" 0 1 2 3 15

# reserve the device
echo "$MENUID $LOGINID" > $LOCK
chmod 666 $LOCK

cd $HOME
case $curtype in

	5-in-diskette|8-in-diskette)
	echo -n " Please insert the first backup diskette.\n" \
	     	"Press return when ready."
	read x
	again=yes
	while [ "$again" = "yes" ]
	do
		tar xnvf $devnode$device 
		echo -n " Are there more backup diskettes in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo 	" Please remove the current diskette and "\
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;

	directory)
	echo -n " Ready to begin restoring the workarea.\n"\
		"Press return to start."
	read x
	tar xvf $devnode/$device/$filename
	;;

	streamertape)
	echo -n " Do you want to retension your tape cartridges? (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavert.ss	
	fi
	echo -n " Ready to begin restoring the workarea.\n"
	echo -n " Please insert the first tape cartridge.\n"\
		"Press return when ready. "
	read x
	again=yes
	while [ "$again" = "yes" ]
	do
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/bin/tar xvf $device "
			/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
		else
			tar xvf $device
		fi
		echo -n "Are there more backup cartridges in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo 	"Please remove the current cartridge and " \
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;

	9tracktape)
	echo -n " Please insert the first tape reel.\n"\
		"Press return when ready. "
	read x
	again=yes
	while [ "$again" = "yes" ]
	do
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/bin/tar xvf $device "
			/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
		else
			tar xvf $device
		fi
		echo -n "Are there more backup tape reels in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo 	"Please remove the current tape reel and " \
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;
esac
