:
# "Aaddps.ss", a shell script to add the nfs entry in the master /net/data
#              file for a new node.

# Copyright 1986 Intel Corporation.

# 05/07/86  gll  Written for iDIS R2.0.
# 06/27/86  gll  SPR 83.  Modified to give user option to proceed if
#                node already in /net/data.  Also remove duplicates
#                from master /net/data, /net/cdf, finder.rsrc, finder.assign.
# 07/11/86  gll  Modified to push iDISboot software to new public
#                server so that printer admin, etc. will work.
# 07/16/86  gll  Modified to copy newpsdata to a similarly named file
#                instead of a directory when an existing public server
#                cannot be updated immediately.  Also made a variable
#                to hold "/usr/iDIS" to simplify changes.
# 08/11/86  gll  Modified to abort on overinstalls.  Added invocation
#                of Apsetserial.ss from /etc/rc on server nodes.  Added
#                make of iDISgw device.  Corrected logic to remove extra
#                'fi' and also ensure disconnect on error conditions.
# 08/12/86  gll  Added 'env -' to make iDISgw command to ensure it can
#                run.  Corrected problems with updates of public servers
#                /net/data files.  Added iBASE tag to SCP current file.
# 08/13/86  gll  Removed net use style connection to existing public
#                servers since net use is not needed and requires a
#                password I don't really have after all.

# Bring in the parameters:
#
#      1  --  Node Name
#      3  --  Node Ethernet address
#      4  --  Node Description
#

node=$1
address=$2
shift;shift
comment="$*"

# Set a couple of known variables.

idisvers="iBASE R2.0, V1.0"
process=nfs
type=XENIX
save=$MASNODEP/usr/ilna/netsynch
updates=$MASNODEP/usr/ilna/netsynch/pending
oldnode=n
idisp=usr/iDIS
export node address comment process type idisvers

echo "
Validating information specified for Public Server $node ..."

# Make sure the specified entry does not already exist.
# We have to do this because mkns does not return an error code.

count=`grep -c "^$node:" $MASNODEP/etc/drm/subnet`

if [ $count -ne 0 ] # Its already a public server.
then echo "
The entry for node $node already exists in $MASNODEP/etc/drm/subnet.

Node $node has NOT been overwritten."
     exit 1
fi

count=`grep -c "^$node/" $MASNODEP/net/data`

if [ $count -gt 0 ] # It was added as a node of different type.
then echo "
The entries for node $node already exist in the nameserver database.

Node $node has not been overwritten."
     exit 1
fi 

# Check for validity of the Ethernet address.

a=`expr $address : '.*'`

if [ $a -lt 12 ]
then echo "
The address $address is not valid.  The address MUST be 12 characters long.

The Public Server $node has not been added to the network."
     exit 1
else a=`expr $address : '[0-9a-fA-F]*'`

     if [ $a -lt 12 ]
     then echo "
The address $address is not valid.  The address MUST consist of hexadecimal
digits only: (0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F) 

The Public Server $node has not been added to the network."
          exit 1
     fi

fi  

# Set a trap so user can't kill us from here forward

trap "" 1 2 3 15

#  Next make the nfs entry in /net/data

/etc/mkns <<HERE >/dev/null
addname
$node/$process
$type
y
8000
y
$address
done
HERE

if [ $? != 0 ]
then echo "
Could not create nfs entry for Public Server $node in master /net/data file.

Public Server $node has not been added to the network."
     exit 1
fi

#  Next try to talk to the new node.

echo "
Attempting OpenNET connection to Public Server $node ..."

$iDISBIN/Aconnect.ss -l root $node

# If we cannot talk, remove the entry from the nameserver database,
# and abort the operation.

if [ $? != 0 ]
then echo "
The Public Server $node has not been added to the network."

     if [ "$oldnode" = "n" ]
     then # remove /net/data entry only if it wasnt already there.
          sed -e "/^$node\/$process/d" < $MASNODEP/net/data \
            > $MASNODEP/tmp/netdata$$
          mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
          chmod 644 $MASNODEP/net/data
     fi
     exit 1

# If we can talk to the new public server, make entries to subnet file,
# build initial DRM entries, and place a valid /net/data and /net/cdf
# on the new server.

else # Make sure there is already an SCP current file.

     SCPPATH=//$node/usr/intel/scp/configurations
     SCPFILE=//$node/usr/intel/scp/configurations/current

     if [ ! -f $SCPFILE ]
     then echo "
Can not access the current system configuration file on node ${node}.

Configuration of node ${node}'s file systems, printers, terminal ports,
etc., must be performed before it can become a public server on the network.

If you have already performed this configuration, it is probable that the
'usr' file system on node $node is not mounted. Please check and try again.

The Public Server $node has not been added to the network."

           #  Delete all the entries created so far.
           sed -e "/^$node\//d" < $MASNODEP/net/data > $MASNODEP/tmp/netdata$$
           mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
           chmod 644 $MASNODEP/net/data

     else # Check for previous installation of iDIS software.

          # Start by assuming no previous installations.

          piDIS=n

          # Now look for iDIS R1.6

          if [ -d //$node/iDISbin ]
          then echo "
Previously installed iDIS software found in /iDISbin on node $node."
               piDIS=y
          fi

          # Look for overinstall of iDIS R2.0

          if [ -d //$node/usr/iDISbin ]
          then echo "
Previously installed iDIS software found in /usr/iDISbin on node $node."
               piDIS=y
          fi

          if [ -d //$node/iDISboot ]
          then echo "
Previously installed iDIS software found in /iDISboot on node $node."
               piDIS=y
          fi

          # See if OpenNET Configuration files are as per instructions.

	  if [ -f //$node/net/data ]
	  then # Check for improper entries.
               set A `sed -e "/^$node/d" //$node/net/data | wc`
               numentry=$2

               if [ $numentry -ne 0 ]
               then echo "
There are nodes improperly listed in the nameserver database on node $node."
                    piDIS=y
               fi
	  fi

	  if [ -f //$node/net/cdf ]
	  then # Check for improper entries.
               set A `wc //$node/net/cdf`
               numentry=$2

               if [ $numentry -gt 1 ]
               then echo "
There are nodes improperly listed in the consumer database on node $node."
                    piDIS=y
               else if [ $numentry -lt 1 ]
                    then echo "
This node's entry to the consumer database is missing on node $node."
                         piDIS=y
                    else numentry=`grep -c \* //$node/net/cdf`
                         if [ $numentry -eq 0 ]
                         then echo "
The consumer database entry is incorrect on node $node."
                              piDIS=y
                         fi
                    fi
               fi
          fi

          # Now see if we found anything and if so, abort.

          if [ "$piDIS" = "y" ]
          then echo "
This initialization cannot be completed for the above reasons.

Backing out initialization performed so far, please wait ..."

               #  Delete all the entries created so far.
               sed -e "/^$node\//d" < $MASNODEP/net/data \
		 > $MASNODEP/tmp/netdata$$
               mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
               chmod 644 $MASNODEP/net/data

               # Now make sure no duplicates in /net/data, /net/cdf, and
               # the finder.rsrc, finder.assign files on the master node.

               cat $MASNODEP/net/data | sort -u > $MASNODEP/net/data.tmp
               chmod 644 $MASNODEP/net/data.tmp
               chgrp root $MASNODEP/net/data.tmp
               chown root $MASNODEP/net/data.tmp
               mv $MASNODEP/net/data.tmp $MASNODEP/net/data
          
               cat $MASNODEP/net/cdf | sort -u > $MASNODEP/net/cdf.tmp
               chmod 644 $MASNODEP/net/cdf.tmp
               chgrp root $MASNODEP/net/cdf.tmp
               chown root $MASNODEP/net/cdf.tmp
               mv $MASNODEP/net/cdf.tmp $MASNODEP/net/cdf
          
               cat $MASNODEP/etc/drm/finder.rsrc | sort -u \
                 > $MASNODEP/etc/drm/rsrc.tmp
               chmod 664 $MASNODEP/etc/drm/rsrc.tmp
               chgrp 800 $MASNODEP/etc/drm/rsrc.tmp
               chown 800 $MASNODEP/etc/drm/rsrc.tmp
               mv $MASNODEP/etc/drm/rsrc.tmp $MASNODEP/etc/drm/finder.rsrc
          
               cat $MASNODEP/etc/drm/finder.assign | sort -u \
                 > $MASNODEP/etc/drm/assign.tmp
               chmod 664 $MASNODEP/etc/drm/assign.tmp
               chgrp 800 $MASNODEP/etc/drm/assign.tmp
               chown 800 $MASNODEP/etc/drm/assign.tmp
               mv $MASNODEP/etc/drm/assign.tmp $MASNODEP/etc/drm/finder.assign
          
               # Remove the temporary files we created.

               rm -f $MASNODEP/tmp/${node}.rsrc $MASNODEP/tmp/${node}.assign

               # Disconnect from the node

               $iDISBIN/Adisconnect.ss $node

	       echo -n "
Press RETURN to continue ..."
	       read resp

               exit 0
          fi

          echo "
Setting up Public Server $node ..."

          # Convert the current configuration into DRM entries.

          cat $SCPFILE | $iDISBIN/Ascp2drm "$node" \
          | tee $MASNODEP/tmp/${node}.rsrc     \
          | $iDISBIN/Adrmassign "*" > $MASNODEP/tmp/${node}.assign 

          # Add to master drm files, and place in netsynch/pending
          # and iBASE/usr/iDIS/include (so later additions will pick up)

          cat $MASNODEP/tmp/${node}.rsrc >> $MASNODEP/etc/drm/finder.rsrc
          cat $MASNODEP/tmp/${node}.rsrc >> $updates/newrsrc
          chmod 660 $updates/newrsrc
          chgrp 800 $updates/newrsrc
          chown 800 $updates/newrsrc
          cat $MASNODEP/tmp/${node}.rsrc  \
          >> $MASNODEP/$idisp/iBASE/usr/iDIS/include/finder.rsrc

          cat $MASNODEP/tmp/${node}.assign >> $MASNODEP/etc/drm/finder.assign
          cat $MASNODEP/tmp/${node}.assign >> $updates/newassign
          chmod 660 $updates/newassign
          chgrp 800 $updates/newassign
          chown 800 $updates/newassign
          cat $MASNODEP/tmp/${node}.assign  \
          >> $MASNODEP/$idisp/iBASE/usr/iDIS/include/finder.assign

	  # Make the nfc entry in /net/data (temporarily)
          /etc/mkns <<HERE >/dev/null
addname
$node/nfc
XENIX
y
8100
y
$address
done
HERE

          # Now make sure the new server has the nfs/nfc entries.
          grep "^$node/nf" $MASNODEP/net/data >> //$node/net/data

          # Get rid of duplicates in the servers /net/data file.
          cat //$node/net/data | sort -u >> //$node/net/data$$
          mv //$node/net/data$$ //$node/net/data

          # And get rid of the vtc entry on the master node.
          sed -e "/^$node\/nfc/d" $MASNODEP/net/data \
            > $MASNODEP/net/data$$
          mv $MASNODEP/net/data$$ $MASNODEP/net/data

          # Determine whether VT server is installed on the new node.

    	  count=`grep -c "VT" //$node/usr/intel/scp/configurations/current`

          if [ $count -gt 0 ]
          then
               #  Next make the vts entry in /net/data
               /etc/mkns <<HERE >/dev/null
addname
$node/vts
XVTSRV
y
4000
y
$address
done
HERE

	       # Make the vtc entry in /net/data (temporarily)
               /etc/mkns <<HERE >/dev/null
addname
$node/vtc
XVTCON
y
4100
y
$address
done
HERE

               # Now make sure the new server has the VT entries.
	       grep "^$node/vt" $MASNODEP/net/data >> //$node/net/data

	       # Get rid of duplicates in the servers /net/data file.
	       cat //$node/net/data | sort -u >> //$node/net/data$$
	       mv //$node/net/data$$ //$node/net/data

	       # And get rid of the vtc entry on the master node.
	       sed -e "/^$node\/vtc/d" $MASNODEP/net/data \
		> $MASNODEP/net/data$$
               mv $MASNODEP/net/data$$ $MASNODEP/net/data

          fi

          # Make an entry to the /etc/drm/subnet file on the master
          # and also in netsynch pending for the Sub-Networks

          echo "${node}:Public Server:::::$comment" \
          >> $MASNODEP/etc/drm/subnet

          echo "${node}:Public Server:::::$comment" \
          >> $updates/newsubnet

          # Construct a /net/cdf on the new server.

          echo "*:*:1" > //$node/net/cdf

          # Move the new servers /net/data entries to the netsynch/pending
          # for the other Public Servers and Sub-Networks.

          grep "^$node" //$node/net/data \
           >> $updates/newpsdata
          chmod 660 $updates/newpsdata
          chgrp 800 $updates/newpsdata
          chown 800 $updates/newpsdata

          grep "^$node" //$MASNODEP/net/data \
           >> $updates/newdata
          chmod 660 $updates/newdata
          chgrp 800 $updates/newdata
          chown 800 $updates/newdata

          # Construct a /net/data on the new server, AND update
          # the other public servers, if possible, at the same time

          for server in `$iDISBIN/Uselect -s : 0 1 "Public Server" \
           < $MASNODEP/etc/drm/subnet`
          do
             if [ "$server" != "$node" ]
             then # First get the /net/data entries for this server and
                  # place on the new server.

                  entry="`grep ${server}/nfs $MASNODEP/net/data`"
                  if [ "$entry" != "" ]
                  then echo "$entry" >> //$node/net/data
                       echo "$entry" | sed -e 's/\/nfs/\/nfc/
s/0X80/0X81/' >> //$node/net/data
                  fi

                  entry="`grep ${server}/vts $MASNODEP/net/data`"
                  if [ "$entry" != "" ]
                  then echo "$entry" >> //$node/net/data
                       echo "$entry" | sed -e 's/\/vts/\/vtc/
s/0X40/0X41/' >> //$node/net/data
                  fi

                  # Now try to update this servers net/data with the
                  # new servers entries

                  # Attempt to connect to this server

                  echo "
Passing knowledge of new Public Server $node to Public Server $server ..."

		  # The command below simply establishes whether or not
		  # connection is possible.  Net use is not necessary.

		  l //$server/boot 2> /dev/null > /dev/null

                  # If connection fails, save updates and notify ilna
                  # via mail.

                  if [ $? -ne 0 ]
                  then # Create a save area for the updates, if necessary
                       if [ ! -d $save/$server ]
                       then mkdir $save/$server
                       fi
                       chmod 700 $save/$server
                       chgrp 800 $save/$server
                       chown 800 $save/$server

                       # Copy the update to the save area

                       cat $updates/newpsdata >> $save/$server/newpsdata

                       # Notify logical network administrator of failure
                       # via mail
 
                       mail -s "Initialization of Public Server $node" ilna \
                       <<HERE 2>&1
OpenNET connection to Public Server $server could not be established.
Therefore, its network configuration files could not be updated to
include entries for the new Public Server $node.

This update has been saved under $save/$server, and you will have to apply
it manually.
HERE
                  else # Update this servers /net/data
                  
                       cat $updates/newpsdata >> //$server/net/data

                       # Get rid of duplicates, blanks, and sort

                       grep -v '^[ 	]*$' //$server/net/data | sort -u \
                        > //$server/net/data$$
                       mv //$server/net/data$$ //$server/net/data
                  fi
             fi

          done

          # Entries for the servers are no longer pending, so remove them

          rm -f $updates/newpsdata

          # Add the root password to the public server node.
          # (Just in case it was different)

          echo "`$iDISBIN/Uselect -s : 0+ 0 root < $MASNODEP/etc/passwd`" \
          >> /tmp/pwe1$$
          sed -e "/^root/d" //$node/etc/passwd >> /tmp/pwe2$$
          cat /tmp/pwe1$$ /tmp/pwe2$$ > //$node/etc/passwd

          # Copy the iDISboot software to the public server so
          # that printers, etc. will work

          umask 0

          if [ ! -d //$node/iDISboot ]
          then mkdir //$node/iDISboot
          fi

          chmod 777 //$node/iDISboot
          chgrp root //$node/iDISboot
          chown root //$node/iDISboot

          copy -rom $MASNODEP/$idisp/iBASE/iDISboot //$node/iDISboot

	  # Build iDISgw device on new node since XENIX does not.
	  # The 'env -' is required because the /dev/makefile is
	  # very large and will not fit into 'make's data segment
	  # otherwise.

	  a=`pwd`
	  cd //$node/dev
	  env - make iDISgw

	  # Tag the new public server's SCP current file to show iBASE.

	  cd $SCPPATH
	  cp current current.bidis
	  sed -e /iBASE/d current > current.new
	  mv current.new current
	  echo "iBASE,$idisvers,iDIS Public Server,`date`" >> current
	  cd $a

	  # Modify /etc/rc to invoke routine which holds down baud rates
	  # on disabled ports for serial printers.

	  if [ "`grep -c Apsetserial.ss //$node/etc/rc`" = "0" ]
	  then echo "/iDISboot/Apsetserial.ss &" >> //$node/etc/rc
	  fi

          # We assume we were 077 when we started since we're logged
          # in as ilna.

          umask 077

     fi

     # Now make sure no duplicates in /net/data, /net/cdf, and
     # the finder.rsrc, finder.assign files on the master node.

     cat $MASNODEP/net/data | sort -u > $MASNODEP/net/data.tmp
     chmod 644 $MASNODEP/net/data.tmp
     chgrp root $MASNODEP/net/data.tmp
     chown root $MASNODEP/net/data.tmp
     mv $MASNODEP/net/data.tmp $MASNODEP/net/data
          
     cat $MASNODEP/net/cdf | sort -u > $MASNODEP/net/cdf.tmp
     chmod 644 $MASNODEP/net/cdf.tmp
     chgrp root $MASNODEP/net/cdf.tmp
     chown root $MASNODEP/net/cdf.tmp
     mv $MASNODEP/net/cdf.tmp $MASNODEP/net/cdf
          
     cat $MASNODEP/etc/drm/finder.rsrc | sort -u \
      > $MASNODEP/etc/drm/rsrc.tmp
     chmod 664 $MASNODEP/etc/drm/rsrc.tmp
     chgrp 800 $MASNODEP/etc/drm/rsrc.tmp
     chown 800 $MASNODEP/etc/drm/rsrc.tmp
     mv $MASNODEP/etc/drm/rsrc.tmp $MASNODEP/etc/drm/finder.rsrc
          
     cat $MASNODEP/etc/drm/finder.assign | sort -u \
      > $MASNODEP/etc/drm/assign.tmp
     chmod 664 $MASNODEP/etc/drm/assign.tmp
     chgrp 800 $MASNODEP/etc/drm/assign.tmp
     chown 800 $MASNODEP/etc/drm/assign.tmp
     mv $MASNODEP/etc/drm/assign.tmp $MASNODEP/etc/drm/finder.assign
          
     # Remove the temporary files we created.

     rm -f $MASNODEP/tmp/${node}.rsrc $MASNODEP/tmp/${node}.assign

     # Disconnect from the new server

     $iDISBIN/Adisconnect.ss $node

     echo -n "
Press RETURN to continue ..."
     read resp

     exit 0

fi
