package sorcererII;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * TODO Check WavToTape works
 * TODO Fix Tool-tips being overwritten by main screen.
 * TODO Issue source code with version number
 * 
 */
public class SorcererFrame extends JFrame {

  private Sorcerer _sorcerer = null;
  private int refreshRate = 1;
  private int sleepHack = 1;
  private int scale = 1;
  
  class SorcererPanel extends JPanel {
    
    public SorcererPanel() {
      setPreferredSize(new Dimension(502, 480));
    }
    /** Refresh handling. */
    public void update( Graphics g ) {
      paint( g );
    }

    /** Paint sets a flag on the sorcerer to tell it to redraw the
        screen on the next Z80 interrupt. */
    public void paint( Graphics g )
    {
      super.paint(g);
      if ( _sorcerer != null ) {
        _sorcerer.repaint();
      }
    }
  }
  
  private Container _sorcererPanel = null;

  public void SwingSorcererFrame() throws IOException {

  }

  public void init() throws IOException {
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setFocusable(true);
    _sorcererPanel = new SorcererPanel();
    JPanel sorcererBorder = new JPanel();
    sorcererBorder.setLayout(new GridLayout(1, 1));
    sorcererBorder.add(_sorcererPanel, BorderLayout.CENTER);
    sorcererBorder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white), BorderFactory.createLineBorder(Color.black)));
    getContentPane().add(sorcererBorder, BorderLayout.CENTER);

    _sorcerer = new Sorcerer(_sorcererPanel, refreshRate, sleepHack, scale, 0,
        0);
    
    final Set<Integer> _keyDown = new HashSet<Integer>();
    addKeyListener( new KeyAdapter()
    {
      public void keyPressed( final KeyEvent e )
      {
        if(!_keyDown.contains(e.getKeyCode())) {
          _keyDown.add(e.getKeyCode());
          
          if( _sorcerer != null )
          {
            _sorcerer.doKey( true, e );
          }
        }
      }

      public void keyReleased( final KeyEvent e )
      {
        if( _sorcerer != null )
        {
          _sorcerer.doKey( false, e );
        }
        
        _keyDown.remove(e.getKeyCode());
      }
    });
    
    
    final JSorcererDiskDrive jDiskDriveA = new JSorcererDiskDrive(_sorcerer.getSorcererDiskDrive(0), 'A');
    final JSorcererDiskDrive jDiskDriveB = new JSorcererDiskDrive(_sorcerer.getSorcererDiskDrive(1), 'B');
    final JSorcererDiskDrive jDiskDriveC = new JSorcererDiskDrive(_sorcerer.getSorcererDiskDrive(2), 'C');
    final JSorcererDiskDrive jDiskDriveD = new JSorcererDiskDrive(_sorcerer.getSorcererDiskDrive(3), 'D');
    
    final JSorcererTapeDrive tape1 = new JSorcererTapeDrive(_sorcerer, 0);
    final JSorcererTapeDrive tape2 = new JSorcererTapeDrive(_sorcerer, 1);
    
    final JSorcererRomPack romPack = new JSorcererRomPack(_sorcerer);
   
    
    final JPanel mediaPanel = new JPanel();
    mediaPanel.setLayout(new GridLayout(7,1));
    mediaPanel.setBorder(BorderFactory.createEmptyBorder(0,2,0,3));
    mediaPanel.add(jDiskDriveA);
    mediaPanel.add(jDiskDriveB);
    mediaPanel.add(jDiskDriveC);
    mediaPanel.add(jDiskDriveD);
    mediaPanel.add(tape1);
    mediaPanel.add(tape2);
    mediaPanel.add(romPack);

    getContentPane().add(mediaPanel, BorderLayout.EAST);
    
    final JPanel controlPanel = new JPanel();
    controlPanel.setLayout(new GridLayout(7,1));
    controlPanel.setBorder(BorderFactory.createEmptyBorder(0,3,0,2));
    controlPanel.add(new JSorcererSpeedControl(_sorcerer));
    controlPanel.add(new JSorcererKeyMapControl(_sorcerer));
    controlPanel.add(new JSorcererFileOpener(_sorcerer));
    controlPanel.add(new JSorcererSnapshotControl(_sorcerer));
    controlPanel.add(new JSorcererResetControl(_sorcerer) {
      
      @Override
      protected void handleReset() {
        try {
          romPack.reload();     
        }
        catch(final IOException e) {
          _sorcerer.LOGGER.log(Level.SEVERE, "Could not read ROM files", e);
        }
      }
    });
    controlPanel.add(new JSorcererSaveScreen(_sorcerer));
    
    
    getContentPane().add(controlPanel, BorderLayout.WEST);
    pack();
    final JSorcererLoggerPanel logginPanel = new JSorcererLoggerPanel();
    logginPanel.setPreferredSize(new Dimension(getWidth(), 65));
    getContentPane().add(logginPanel, BorderLayout.SOUTH);
  }

  
  /** Start the applet creating a new thread which invokes run(). */
  public void start() {
      try {
         _sorcerer.loadROMs( new URL( "file:" ) );
      }
      catch(final IOException e) {
        e.printStackTrace();
      }
      _sorcerer.start();
  }

  public void stop() {
    _sorcerer.stop();
  }

  public static void main(String[] args) throws IOException {
    final SorcererFrame f = new SorcererFrame();
    f.init();
    f.pack();
    f.setResizable(false);
    f.setVisible(true);
    f.start();
  }
}
