/* IODCtrl.h - prototype DeviceControl () function for runtime library I/O support
 * Copyright  1997-1999 by Object Software Inc. - All Rights Reserved
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 */

#ifndef IODCTRL_H
#define	IODCTRL_H

#ifdef __cplusplus
extern "C" {
#endif

extern long DriverControl (int filedes, int function, ...);

// bit masks for Flags
#define	IODF_CRIN		1		// enables CR->LF translation on input
#define	IODF_NLOUT		2		// enables LF->CRLF translation on output
#define	IODF_EDIT		4		// enables line editing on input
#define	IODF_ECHO		8		// enables echo on input

// Function codes for DriverControl ()
#define	IODFN_GETFLAGS	0		// get current device flags
#define	IODFN_SETFLAGS	1		// changing device flags; second parameter is new flag value
#define	IODFN_SETALERT	2		// install 'data available' alert function
#define	IODFN_SETEMPTY	3		// install 'transmitter empty' alert function
#define	IODFN_GETAVAIL	4		// return number of chars available on input, or -1 if not implemented
#define	IODFN_GETBUFF	5		// return number of chars buffered on output, or -1 if not implemented
#define	IODFN_SETUSER	6		// set user parameter in device table
#define	IODFN_USER		10000	// first user-definable function code

#ifdef __cplusplus
}
#endif

#endif



