/* IODbf.h - define interface to buffered driver routines
 * Copyright  1997-1999 by Object Software Inc. - All Rights Reserved
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 */

#ifndef	IODBF_H
#define	IODBF_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/IODev.h>
#include <stdarg.h>
#include <sys/tFIFO.h>

/* define the tBufferedDevice structure which stores the required info about the device */
typedef struct sBufferedDevice
{
	tFIFO TransmitFIFO;				// FIFO for outgoing data
	tFIFO ReceiveFIFO;				// FIFO for incoming data
	void (*StartSend) (struct sBufferedDevice *Device);		// called to start transmission when chars put into empty transmit FIFO
	int (*Enable) (int NewState);	// function to enable/disable the device (for open/close)
	int ReferenceCount;				// count of the number of I/O channels using this device
	void (*DataReceived) (struct sBufferedDevice *Device);	// if non-null, called when char received
	void (*TXEmpty) (struct sBufferedDevice *Device);		// if non-null, called when output empty
	void *DeviceInfo;				// for device-specific info; not used by drivers
	void *AppInfo;					// for application-specific info; not used by drivers
} tBufferedDevice;

/* Function to open a buffered device. */
extern int Bopen (struct sIODev *Device, int filedes, int flags, va_list args);

/* ... and close it when we're through. */
extern int Bclose (struct sIODev *Device, int filedes);

/* Implement read () functionality for buffered devices.
 * CR->LF translation, line editing, and character echo are implemented.
 */
extern int Bread (struct sIODev *Device, int filedes, void *_buf, size_t _nbyte);

/* Implement write () function for buffered devices.
 * LF->CRLF translation is implemented.
 */
extern int Bwrite (struct sIODev *Device, int filedes, const void *_buf, size_t _nbyte);

/* Implement drivercontrol () functionality for buffered devices. */
long Bdrivercontrol (struct sIODev *Device, int filedes, int function, va_list args);

#ifdef __cplusplus
}
#endif

#endif

