title	'PRO-WTRF.ASM - PALANTIR Font Definition File -- 01/29/83'

*****************************************************************
*								*
*		C. ITOH PRO-WRITER Font				*
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

	page
;	Control/Extended Range

	db	0,0
	db	0,1
	db	0,2
	db	0,3
	db	0,4
	db	0,5
	db	0,6
	db	0,7
	db	0,8
	db	0,9
	db	0,10
	db	0,11
	db	0,12
	db	0,13
	db	0,14
	db	0,15
	db	0,16
	db	0,17
	db	0,18
	db	0,19
	db	0,20
	db	0,21
	db	0,22
	db	0,23
	db	0,24
	db	0,25
	db	0,26
	db	0,27
	db	0,28
	db	10,29
	db	12,30
	db	10,31

	page
;	Standard Ascii Character Set

	db	10,00 		;Blank
	db	07,'!' 		;Exclamation Point
	db	10,'"' 		;Double Quotes
	db	14,'#' 		;Pound (Number) Sign
	db	12,'$' 		;Dollar Sign
	db	16,'%' 		;Percent Sign
	db	13,'&'		;Ampersand
	db	07,''''		;Single Quote
	db	07,'(' 		;Left Parenthesis
	db	07,')' 		;Right Parenthesis
	db	12,'*' 		;Asterisk
	db	12,'+' 		;Plus Sign
	db	07,',' 		;Comma
	db	12,'-' 		;Hyphen (Minus Sign)
	db	07,'.' 		;Period
	db	12,'/' 		;Slash
	db	12,'0' 		;Digit Zero
	db	12,'1' 		;Digit One
	db	12,'2' 		;Digit Two
	db	12,'3' 		;Digit Three
	db	12,'4' 		;Digit Four
	db	12,'5' 		;Digit Five
	db	12,'6' 		;Digit Six
	db	12,'7' 		;Digit Seven
	db	12,'8' 		;Digit Eight
	db	12,'9' 		;Digit Nine
	db	07,':' 		;Colon
	db	07,';' 		;Semicolon
	db	12,'<' 		;Less Than
	db	12,'=' 		;Equal Sign
	db	12,'>' 		;Greater Than
	db	12,'?' 		;Question Mark
	db	14,'@' 		;At-Sign
	db	16,'A' 		;Capital A
	db	15,'B' 		;Capital B
	db	14,'C' 		;Capital C
	db	15,'D' 		;Capital D
	db	15,'E' 		;Capital E
	db	15,'F' 		;Capital F
	db	14,'G' 		;Capital G
	db	15,'H' 		;Capital H
	db	09,'I' 		;Capital I
	db	13,'J' 		;Capital J
	db	12,'K' 		;Capital K
	db	13,'L' 		;Capital L
	db	17,'M' 		;Capital M
	db	16,'N' 		;Capital N
	db	15,'O' 		;Capital O
	db	13,'P' 		;Capital P
	db	16,'Q' 		;Capital Q
	db	15,'R' 		;Capital R
	db	12,'S' 		;Capital S
	db	14,'T' 		;Capital T
	db	15,'U' 		;Capital U
	db	16,'V' 		;Capital V
	db	17,'W' 		;Capital W
	db	11,'X' 		;Capital X
	db	12,'Y' 		;Capital Y
	db	11,'Z' 		;Capital Z
	page
	db	12,'[' 		;Left Square Bracket (Open)
	db	12,'\' 		;Backslash
	db	12,']' 		;Right Square Bracket (Close)
	db	12,'^' 		;Carat
	db	12,'_' 		;Underscore
	db	07,60h 		;Accent
	db	12,'a' 		;Lowercase a
	db	12,'b' 		;Lowercase b
	db	10,'c' 		;Lowercase c
	db	12,'d' 		;Lowercase d
	db	12,'e' 		;Lowercase e
	db	10,'f' 		;Lowercase f
	db	12,'g' 		;Lowercase g
	db	12,'h' 		;Lowercase h
	db	08,'i' 		;Lowercase i
	db	07,'j' 		;Lowercase j
	db	10,'k' 		;Lowercase k
	db	08,'l' 		;Lowercase l
	db	16,'m' 		;Lowercase m
	db	12,'n' 		;Lowercase n
	db	12,'o' 		;Lowercase o
	db	12,'p' 		;Lowercase p
	db	12,'q' 		;Lowercase q
	db	10,'r' 		;Lowercase r
	db	12,'s' 		;Lowercase s
	db	10,'t' 		;Lowercase t
	db	12,'u' 		;Lowercase u
	db	12,'v' 		;Lowercase v
	db	16,'w' 		;Lowercase w
	db	12,'x' 		;Lowercase x
	db	12,'y' 		;Lowercase y
	db	10,'z' 		;Lowercase z
	db	10,'{' 		;Left Curly Brace (Open)
	db	07,'|' 		;Vertical Bar
	db	10,'}' 		;Right Curly Brace (Close)
	db	12,'~' 		;Tilde
	db	0,0		;Delete Code (Not Used)

	end
al Bar
	db	std,'}' 	;R