
#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/malloc.h>
#include <linux/ctype.h>
#include <linux/sysctl.h>
#include <linux/proc_fs.h>
#include <linux/ioport.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/smp.h>
#include <linux/kernel_stat.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#ifdef MODULE
extern int init_module(void);
extern int cleanup_module(void);
static int sysactled_cleanup(void);
#endif				/* MODULE */

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,13)
#define THIS_MODULE NULL
#endif

#define VERSION "$Revision: 1.1 $"

static int __init sysactled_init(void);
int proc_dobinary(ctl_table *table, int write, struct file *filp, void *buffer, size_t *lenp);

#define SYSACTLED_AMBER 
#define SYSACTLED_ENT 1
#define TIMER_BH 0
#define ALI_VENDORID    0x10b9
#define ALI_BRG_DEVID   0x1533
#define ALI_PMU_DEVID   0x7101


static char sysactled_readme[] = "You can check and modify mode of this driver\n"
"Try\n"
"echo 0 > mode  # cpu usage + once a second\n"
"echo 1 > mode  # blinking once a second\n"
"echo 2 > mode  # to 2Hz blinking mode, Node ID mode\n"
"echo 3 > mode  # to reflect cpu usage\n"
"\n"
"And Try\n"
"cp redled /tmp/\n"
"redled 2|0\n";

//static int sysactled_redled=0;
#include "redled.h"
static int sysactled_mode=0;

static ctl_table sysactled_proc_dev_entries[] = {
	{SYSACTLED_ENT, "README", sysactled_readme, 1024, 0444, NULL, &proc_dostring, &sysctl_string },
	{SYSACTLED_ENT+1, "redled", sysactled_redled, sizeof(sysactled_redled), 0500, NULL, &proc_dobinary, &sysctl_string},
	{SYSACTLED_ENT+2, "mode", &sysactled_mode, 4, 0644, NULL, &proc_dointvec, &sysctl_intvec},
	{0}
};

static ctl_table sysactled_proc_dev[] = {
	{DEV_HWMON, "sysactled", NULL, 0, 0555, sysactled_proc_dev_entries},
	{0},
};

static ctl_table sysactled_proc[] = {
	{CTL_DEV, "dev", NULL, 0, 0555, sysactled_proc_dev},
	{0}
};


static struct ctl_table_header *sysactled_proc_header;
static int sysactled_initialized;
extern unsigned long bh_mask, bh_active;
extern void (*bh_base[])(void);
static void (*org_timer_bh)(void);
static int led_stat=0;
static struct pci_dev *pmudev = NULL;

int proc_dobinary(ctl_table *table, int write, struct file *filp,
                  void *buffer, size_t *lenp)
{
        int len;
        
        if (!table->data || !table->maxlen || !*lenp ||
            (filp->f_pos && !write)) {
                *lenp = 0;
                return 0;
        }
        
	len = table->maxlen;
	if (len > table->maxlen)
		len = table->maxlen;
	if (len > *lenp)
		len = *lenp;
	if (len)
		if(copy_to_user(buffer, table->data, len))
			return -EFAULT;
	if (len < *lenp) {
		if(put_user('\n', ((char *) buffer) + len))
			return -EFAULT;
		len++;
	}
	*lenp = len;
	filp->f_pos += len;

        return 0;
}

void sysactled_actor(void)
{
	int stat = 0;
	unsigned char temp;

	switch(sysactled_mode) {
	default:
	case 0: //CPU
		if (current->pid) {	/* Let's assume pid 0 means idle and It's true */
			stat = 0x40;
			break;
		}
		if (jiffies % HZ < 50) {
			if (!led_stat)
				stat = 0x40;
		}
		break;
	case 1: //once a sec.
		if (jiffies % HZ < 50) {
			if (!led_stat)
				stat = 0x40;
		}
		break;
	case 2: //2HZ
		if (jiffies % HZ == 0) {
			if (!led_stat)
				stat = 0x40;
		}
		else stat = led_stat;
		break;
	case 3: //CPU
		if (current->pid) 	/* Let's assume pid 0 means idle */
			stat = 0x40;
		break;
#if 0  // Too much hack for interrupt counting
	case 4: //CPU
		{
		static int sum, i, prev;

		for (i = 0 ; i < NR_IRQS ; i++)
			sum += kstat_irqs(i);
		if (sum - prev > 10)
			stat = 0x40;
		prev = sum;
		break;
		}
#endif
	}

	if (stat != led_stat) {
		pci_read_config_byte(pmudev, 0x7f, &temp); /* GPIO input */
		if (stat)
			pci_write_config_byte(pmudev, 0x7e, temp & ~0x40); /* clear bit 6 */
		else
			pci_write_config_byte(pmudev, 0x7e, temp | 0x40); /* set bit 6 */
		led_stat = stat;
	}
		
	if (org_timer_bh)
		org_timer_bh();
}


int __init sysactled_init(void)
{
	unsigned char temp;

	printk("sysactled.o version %s\n", VERSION);

	sysactled_initialized = 0;

        pmudev = pci_find_device(ALI_VENDORID, ALI_PMU_DEVID, pmudev);

	if (!pmudev) {
		printk("Is this really a shark?\n");
		return 1;
	}

        pci_read_config_byte(pmudev, 0x7d, &temp); /* DCGPIO */
        pci_write_config_byte(pmudev, 0x7d, temp | 0x40); /* bit 6 is output */

        pci_read_config_byte(pmudev, 0x7f, &temp); /* GPIO input */
        pci_write_config_byte(pmudev, 0x7e, temp & ~0x40); /* set bit 6 */
	led_stat = 0x40;

	if (!(bh_mask & (1<<TIMER_BH))) {
		printk("Timer bh is not initialized, funny\nJust give up\n");
		return 1;
	}

	if (!(sysactled_proc_header = register_sysctl_table(sysactled_proc, 0))) 
		return -ENOMEM;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,1))
	sysactled_proc_header->ctl_table->child->de->owner = THIS_MODULE;
#else
//	sysactled_proc_header->ctl_table->child->de->fill_inode = &sysactled_fill_inode;
#endif	/* (LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,1)) */

	org_timer_bh = bh_base[TIMER_BH];
	bh_base[TIMER_BH] = sysactled_actor;

	sysactled_initialized++;
	return 0;
}

#ifdef MODULE

MODULE_AUTHOR("soohoon.lee@api-networks.com");
MODULE_DESCRIPTION("System Activity LED blinker");

int sysactled_cleanup(void)
{
	unsigned char temp;
	void (*tmp_timer_bh)(void);

	if (sysactled_initialized >= 1) {
		tmp_timer_bh = org_timer_bh;
		org_timer_bh = 0;
		bh_base[TIMER_BH] = tmp_timer_bh;
		pci_read_config_byte(pmudev, 0x7f, &temp); /* GPIO input */
		pci_write_config_byte(pmudev, 0x7e, temp | 0x40); /* set bit 6 */
		unregister_sysctl_table(sysactled_proc_header);
		sysactled_initialized--;
	}
	return 0;
}

int init_module(void)
{
	return sysactled_init();
}

int cleanup_module(void)
{
	return sysactled_cleanup();
}

#else

#error "Only workable as a module"

#endif
