#!/bin/sh
#
# hwmon         This shell script takes care of starting and stopping
#               the hardware monitor service.
#
# chkconfig: 345 85 15
# description: Hardware monitor monitors temperature of CPUs and many parts 
#	of the system, It needs many i2c drivers depends on system type.
#

# Source function library.
. /etc/rc.d/init.d/functions

[ -x /usr/sbin/hwmon ] || exit 0

# See how we were called.
case "$1" in
  start)
	# Start daemons.
	echo -n "Starting Hardware monitor service: "
	daemon hwmon -d
	echo
	;;
  stop)
	# Stop daemons.
	echo -n "Shutting down Hardware monitor service: "
	killproc hwmon
	echo
	;;
  status)
	status hwmon
	;;
  restart)
	echo -n "Restarting Hardware monitor service: "
	killproc hwmon
	daemon hwmon -d
	echo "done."
	;;
  *)
	echo "Usage: hwmon {start|stop|status|restart}"
	exit 1
esac

exit 0
