/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/

#include "lib.h"
#include "northbridge.h"
#include "smcc669.h"

static ui SMC669UltraBase;

static ui SMC669ConfigState( ui baseAddr )
{
    int devId;
    ui configPort;
    ui indexPort;
    ui dataPort;

    configPort = indexPort = baseAddr;
    dataPort = configPort + 1;

    outportb(configPort, CONFIG_ON_KEY);
    outportb(configPort, CONFIG_ON_KEY);
    outportb(indexPort, DEVICE_ID);
    devId = inportb(dataPort);
    if (devId != SMC37c669_DEVICE_ID) {
	SMC669UltraBase = 0;
    } else SMC669UltraBase = baseAddr;

    return (SMC669UltraBase);
}

static void SMC669detectUltraIO(void)
{
    if ( SMC669ConfigState( 0x3F0 ) == 0x3F0 ) {
	return;
    }
    if ( SMC669ConfigState( 0x370 ) == 0x370 ) {
	return;
    }
 
    SMC669UltraBase = 0;			/* failure case */
    printf_dbm("Warning: no SMSC669 found!\n");
}

static void SMC669runState(void)
{
    outportb(SMC669UltraBase, CONFIG_OFF_KEY);
}


static void SMC669EnableCOM1(void)
{
    ui indexPort;
    ui dataPort;
    ui irqData;

    indexPort = SMC669UltraBase;
    dataPort = SMC669UltraBase + 1;

    outportb(indexPort, SMC37c669_SERIAL_IRQ_INDEX);
    irqData = inportb(dataPort);
    irqData = (irqData & 0x0f) | 0x50;	/* need info from dan */
    outportb(dataPort, irqData);

    outportb(indexPort, SMC37c669_SERIAL0_BASE_ADDRESS_INDEX);
    outportb(dataPort, COM1_BASE >> 2);

}

static void SMC669EnableCOM2(void)
{
    ui indexPort;
    ui dataPort;
    ui irqData;

    indexPort = SMC669UltraBase;
    dataPort = SMC669UltraBase + 1;

    outportb(indexPort, SMC37c669_SERIAL_IRQ_INDEX);
    irqData = inportb(dataPort);
    irqData = (irqData & 0xf0) | 0x06;	/* need info from dan */
    outportb(dataPort, irqData);

    outportb(indexPort, SMC37c669_SERIAL1_BASE_ADDRESS_INDEX);
    outportb(dataPort, COM2_BASE >> 2);

}


void SMC669EnablePARP(void)
{
    ui indexPort;
    ui dataPort;
    ui dmaData;
    unsigned char irqData;

    indexPort = SMC669UltraBase;
    dataPort = SMC669UltraBase + 1;

    outportb(indexPort, SMC37c669_PARALLEL_FDC_DMA_INDEX);
    dmaData = inportb(dataPort);
    dmaData = (dmaData & 0xf0);

    /* was: dmaData = (dmaData & 0xf0) | 0x2;	need info from dan */

    outportb(dataPort, dmaData);	/* Select parallel port dma */

    outportb(indexPort, SMC37c669_PARALLEL_FDC_IRQ_INDEX);
    irqData = inportb(dataPort);
    irqData = (irqData & 0xf0) | 0x03;	/* need info from dan */
    outportb(dataPort, irqData);

    outportb(indexPort, SMC37c669_PARALLEL0_BASE_ADDRESS_INDEX);
    outportb(dataPort, PARP_BASE >> 2);

}

static void SMC669DisableIDE(void)
{
    ui indexPort;
    ui dataPort;

    indexPort = SMC669UltraBase;
    dataPort = SMC669UltraBase + 1;

    outportb(indexPort, SMC37c669_IDE_BASE_ADDRESS_INDEX);
    outportb(dataPort, 0);

    outportb(indexPort, SMC37c669_IDE_ALTERNATE_ADDRESS_INDEX);
    outportb(dataPort, 0);

}

static void SMC669EnableFDC(void)
{
    ui indexPort;
    ui dataPort;
    ui dmaData;
    unsigned char irqData;

    indexPort = SMC669UltraBase;
    dataPort = SMC669UltraBase + 1;

    outportb(indexPort, SMC37c669_PARALLEL_FDC_DMA_INDEX);
    dmaData = inportb(dataPort);
    dmaData = (dmaData & 0x0f) | 0x10;	/* need info from dan */
    outportb(dataPort, dmaData);	/* Select parallel port dma */

    outportb(indexPort, SMC37c669_PARALLEL_FDC_IRQ_INDEX);
    irqData = inportb(dataPort);
    irqData = (irqData & 0x0f) | 0x40;	/* need info from dan */
    outportb(dataPort, irqData);

    outportb(indexPort, SMC37c669_FDC_BASE_ADDRESS_INDEX);
    outportb(dataPort, FDC_BASE >> 2);

}

void SMC669Init(void)
{
    SMC669detectUltraIO();
    if (SMC669UltraBase != 0) {	/* SMC Super I/O chip was detected. */
	SMC669EnableFDC();
	SMC669EnablePARP();
	SMC669DisableIDE();	/* We're using on-board IDE */
	SMC669EnableCOM1();
	SMC669EnableCOM2();

	SMC669runState();	/* exit configuration mode */
    }
}
