/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Programmable interrupt controller (PIC) control */

#include "lib.h"
#include "specifics.h"
#include "northbridge.h"
#include "southbridge.h"
#include "platform.h"

#include "southbridge/pic.h"

#define PIC0	0x20
#define PIC1	0xA0

#define PICRB(pic,reg)		inportb( (pic) + (reg) )
#define PICWB(pic,reg, val)	outportb( (pic) + (reg), val )


#define ELCR0	0x4D0
#define ELCR1	0x4D1

#define ICMD	0
#define ISR	0
#define IMR	1

void pic_irq_ena( unsigned irq, unsigned ena )
{
    uint16 pic;
    uint8 val, mask;

    if ( irq >= IRQ8 )
    {
	pic = PIC1;
	irq -= 8;
    } else {
	pic = PIC0;
    }

    mask = 1<<irq;

    val = PICRB(pic,IMR);
    if ( ena )				/* enable IRQ by setting bit to 0 */
	val &= ~mask;
    else 				/* disable IRQ by setting bit to 1 */
	val |= mask;

    PICWB(pic,IMR,val);
}


void pic_irq_trig( unsigned irq, unsigned trig )
{
    uint16 elcr;
    uint8 val, mask;

    if ( irq >= IRQ8 )
    {
        elcr = ELCR1;
        irq -= 8;
    } else {
        elcr = ELCR0;
    }

    mask = 1<<irq;

    val = inportb( elcr );

    if ( trig == IRQ_EDGE )		/* Edge-trigger IRQ by setting to 0 */
        val &= ~mask;
    else				/* Level-trigger by setting to 1 */
        val |= mask;

    outportb( elcr, val );
}


