#ifndef DIAGS__PCF_H__LOADED
#define DIAGS__PCF_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/*
 *  $Id: 
 */


/* PCF8584 Register access mechanisms */
 
/* Base address in PCI memory-space */
#define PCF_BASE		0xE0000
#define PCF_ADDR( port )        (PCF_BASE + (port) )

/* PCF8584 Access Registers */
#define PCF_DATA	0	/* A0=0 (described in Philips doc) */
#define PCF_CTL		1	/* A0=1 (described in Philips doc) */

/* PCF8584 Data register (S0) definitions */

#define PCF_S0_RDRQ	(1<<0)	/* Make a bus read request */
#define PCF_RD( addr )	(addr | PCF_S0_RDRQ)
#define PCF_WR( addr )	(addr & ~PCF_S0_RDRQ)


/* PCF8584 Control register (S1 write) definitions */

#define PCF_S1_PIN	(1<<7)	/* Pending interrupt not */
#define PCF_S1_ESO	(1<<6)	/* Enable Serial Output */
#define PCF_S1_ES1	(1<<5)	/* Internal register addressing */
#define PCF_S1_ES2	(1<<4)	/* Internal register addressing */
#define PCF_S1_ENI	(1<<3)	/* Enable external interrupt */
#define PCF_S1_STA	(1<<2)	/* I2C bus start command */
#define PCF_S1_STO	(1<<1)	/* I2C bus stop command */
#define PCF_S1_ACK	(1<<0)	/* ACK / expecting further bytes from slave */

/* PCF8584 Status register (S1 read) definitions */

#define PCF_S1_INIT 	(1<<6)	/* 0 => init has been done */
#define PCF_S1_STS	(1<<5)	/* External stop detected (in slave rx mode) */
#define PCF_S1_BER	(1<<4)	/* Bus Error */
#define PCF_S1_AD0	(1<<3)	/* Last received bit (AAS=0) */
#define PCF_S1_LRB	(1<<3)	/* address 0 (general call) bit (AAS=1) */
#define PCF_S1_AAS	(1<<2)	/* Addressed as slave */
#define PCF_S1_LAB	(1<<1)	/* Lost arbitration bit (multi-master op) */
#define PCF_S1_BB	(1<<0)	/* 0 => Bus busy */


/* PCF8584 Clock register (S2) definitions */
/* S2 is accessed by setting control bit ES1 and reading/writing with A0=0 */

#define PCF_S2_SCL90	(0<<0)	/* 90 kHz serial clock */
#define PCF_S2_SCL45	(1<<0)	/* 45 kHz serial clock */
#define PCF_S2_SCL11	(2<<0)	/* 11 kHz serial clock */
#define PCF_S2_SCL15	(3<<0)	/* 1.5 kHz serial clock */

#define PCF_S2_CLK3	(0<<2)	/* 3 MHz internal clock */
#define PCF_S2_CLK443	(4<<2)	/* 4.43 MHz internal clock */
#define PCF_S2_CLK6	(5<<2)	/* 6 MHz internal clock */
#define PCF_S2_CLK8	(6<<2)	/* 8 MHz internal clock */
#define PCF_S2_CLK12	(7<<2)	/* 12 MHz internal clock */


#endif		/* DIAGS__PCF_H__LOADED */
