#ifndef	DIAGS__TABLEDRIVER_H_LOADED
#define	DIAGS__TABLEDRIVER_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* IO configuration table driver */
/* Theory of operation: this interface is for an encoding of a string of 
 * IO operations as a bytestream.  Everything is broken down into bytes
 * and a simple grammar, describing writes or other logical operations to
 * different regions of IO space, is then used to parse the resulting table.
 * 
 * Note: remember to terminate any tables with the OP_EOT command!
 */


/* fundamental definitions */

/* Encoding macros for writing words, longs as sequence of bytes */
#define ENC8( x )	((x) & 0xFFU )
#define ENC16( x )	ENC8( (x) >> 8 ), ENC8( x )
#define ENC32( x )	ENC16( (x) >> 16 ), ENC16( x )

enum io_opcodes {
	OP_IOW8, OP_IOW16, OP_IOW32,	/* IO space writes */
	OP_MEMW8, OP_MEMW16, OP_MEMW32,	/* PCI Memory space writes */
	OP_CFGW8, OP_CFGW16, OP_CFGW32,	/* PCI configuration space writes */
	OP_CFGS8, OP_CFGS16, OP_CFGS32,	/* PCI CSR set bits */
	OP_CFGC8,			/* PCI CSR clr bits */
	OP_EOT				/* End of table */
};



/* Definitions of commands intended for the user */

#define IOWB( a, d )	OP_IOW8, ENC16( a ), ENC8( d )
#define IOWW( a, d )	OP_IOW16, ENC16( a ), ENC16( d )
#define IOWL( a, d )	OP_IOW32, ENC16( a ), ENC32( d )

#define MEMWB( a, d )	OP_MEMW8, ENC32( a ), ENC8( d )
#define MEMWW( a, d )	OP_MEMW16, ENC32( a ), ENC16( d )
#define MEMWL( a, d )	OP_MEMW32, ENC32( a ), ENC32( d )

#define CFGWB( bus, dev, fun, reg, val )	OP_CFGW8, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC8( val )
#define CFGWW( bus, dev, fun, reg, val )	OP_CFGW16, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC16( val )
#define CFGWL( bus, dev, fun, reg, val )	OP_CFGW32, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC32( val )

#define CFGSETB( bus, dev, fun, reg, val )	OP_CFGS8, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC8( val )
#define CFGSETW( bus, dev, fun, reg, val )	OP_CFGS16, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC16( val )
#define CFGSETL( bus, dev, fun, reg, val )	OP_CFGS32, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC32( val )

#define CFGCLRB( bus, dev, fun, reg, val )	OP_CFGC8, \
	ENC8( bus ), ENC8( dev ), ENC8( fun ), ENC8( reg ), ENC8( val )

typedef unsigned char TblArray;

/* main function */

void TblWrite( const TblArray * );


#endif 		/* DIAGS__TABLEDRIVER_H_LOADED */
