#ifndef __MCHECK_H_LOADED
#define __MCHECK_H_LOADED
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/*
 *  $Id: mcheck.h,v 1.10 2000/09/25 23:08:50 stig Exp $;
 *
 *  $Log: mcheck.h,v $
 *  Revision 1.10  2000/09/25 23:08:50  stig
 *  update for Shark timer interrupt
 *
 *  Revision 1.9  2000/04/11 23:32:58  stig
 *  Release 1.3.3 source base
 *
 *  Revision 1.5  2000/01/12 17:15:21  stig
 *  Preparation work for version 1.2
 *  BUG(S) FIXED:
 *  BACKEND RELATED:
 *
 *  Revision 1.4  1999/09/08 16:33:40  stig
 *  pre-release-2 updates
 *
 *  Revision 1.3  1999/09/01 19:18:47  stig
 *  Completed first pass at integrated test.  Implemented changes required to
 *  make that possible.
 *
 *  Revision 1.2  1999/08/25 19:05:21  stig
 *  Implemented major re-work of console IO subsystem, also involving changes to
 *  include file organisation
 *
 *  Revision 1.1  1999/04/30 15:49:27  stig
 *  Transferred more header files from EBSDK
 *
 *  Revision 1.1.1.1  1998/12/29 21:36:07  paradis
 *  Initial CVS checkin
 *
 * Revision 1.3  1998/08/03  17:32:58  gries
 * mor better machine check
 *
 * Revision 1.2  1997/06/02  04:25:59  fdh
 * Moved more of the machine check declarations
 * into this file.
 *
 * Revision 1.1  1996/05/22  21:29:08  fdh
 * Initial revision
 *
 */

typedef struct {
  ui FrameSize;			/* Bytes, including this field */
  ui FrameFlags;		/* <31> = Retry, <30> = Second Error */
  ui CpuOffset;			/* Offset to CPU-specific into */
  ui SystemOffset;		/* Offset to system-specific info */
  ui MCHK_Code;
  ui MCHK_Frame_Rev;
  ul I_STAT;
  ul DC_STAT;
  ul C_ADDR;
  ul DC1_SYNDROME;
  ul DC0_SYNDROME;
  ul C_STAT;
  ul C_STS;
  ul RESERVED0;
  ul EXC_ADDR;
  ul IER_CM;
  ul ISUM;
  ul MM_STAT;
  ul PAL_BASE;
  ul I_CTL;
  ul PCTX;
} LogoutFrame_t;

extern unsigned char MachineCheckExpected;
extern unsigned char ExpectedMachineCheckTaken;

extern void UnexpectedInterruptHandler(unsigned int arg0, ui vector,
					LogoutFrame_t *arg2 );
extern void DumpLogout(LogoutFrame_t *LAF);


/* IRQ test driving details */

extern void (*IRQTestHandler)( int IRQTaken );
extern volatile uint8 IRQdivert;
extern volatile uint8 irq_include_timer;


extern void osf_mchkinterp( ui vector, LogoutFrame_t *Frame, String result );


/* Error collection statistics */

unsigned sys_crd;
unsigned sys_mchk;
unsigned proc_crd;
unsigned proc_mchk;

#endif /* __MCHECK_H_LOADED */
