/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* This file exists for quickly implementing one-off tests.  Thats it. */

#define TRACE_ENABLE

#include "lib.h"
#include "uilib.h"
#include "platform.h"
#include "cmos_rtc.h"
#include "i2c.h"

/*--------------------------------------------------------------------*/

DBM_STATUS test( int argc, char *argv[] )
{
    DBM_STATUS sval;
    int rval;
    uint8 addr, data;

    if ( argc != 2 )
    {
	mobo_alertf( "Usage", "%s hex-addr", argv[0] );
	return STATUS_FAILURE;
    }

    rval = sscanf( argv[1], "%x", &addr );
    mobo_logf( LOG_DBG "TEST: probing I2C address 0x%02X\n", addr );

    sval = i2cdev_init();
    if( sval != STATUS_SUCCESS )
    {
	mobo_logf( LOG_WARN "TEST: I2C did not initialise cleanly\n" );
    }

    data = 0xFF;			/* attempt to suggest bad data */
    sval = i2cdev_read( addr, -1, 1, &data );
    if( sval != STATUS_SUCCESS )
    {
	mobo_logf( LOG_WARN "TEST: I2C did not read cleanly\n" );
    }

    mobo_alertf( (sval == STATUS_SUCCESS)?"I2C Read OK" : "I2C Read FAILED",
	    	"I2C Address 0x%02X returned 0x%02X", addr, data );

    return STATUS_SUCCESS;
}

