
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "lib.h"
#include "uilib.h"
#include "sromport.h"
#include "northbridge.h"
#include "cserve.h"
#include "ledcodes.h"
#include "smp.h"


int SromCharav(void)
{
    return TRUE;
}

int SromGetChar(void)
{
#ifdef CONFIG_SHARK

   /* Shark platform shares COM port connectors with SROM connectors, so we 
    * need to be able to switch between them */

    shark_serial_select( SHARK_SROM );
#endif

    if (primary_impure->AUTOBAUD == 0)
	return 1;		/* don't want this blocking */

    return ((int)
	    cServe(0, 0, CSERVE_K_SROM_GETC, primary_impure->AUTOBAUD));
}

void SromPutChar(char c)
{
    if (primary_impure->AUTOBAUD == 0
	|| primary_impure->AUTOBAUD == SROM_NO_AUTOBAUD)

	return;			/* don't want this output */

#ifdef CONFIG_SHARK

   /* Shark platform shares COM port connectors with SROM connectors, so we 
    * need to be able to switch between them */

    shark_serial_select( SHARK_SROM );
#endif


#ifdef FANCY_ASCII
    /* special case characters for SROM */
    switch (c) {

	/* translate ASCII graphics characters to 7-bit ascii, since this stuff
	 * seems to fail in SROM UART transmission in current implementations
	 */

    case BC_BL:
    case BC_BR:
    case BC_TL:
    case BC_TR:
	c = '+';
	break;

    case BC_H:
	c = '-';
	break;

    case BC_V:
	c = '|';
	break;

    case BC_HALF:
    case BC_FULL:
	c = 'X';
	break;

    default:
	break;
    }
#endif	/* FANCY_ASCII */

    cServe(0, (ul) c, CSERVE_K_SROM_PUTC, primary_impure->AUTOBAUD);
}


DBM_STATUS SromPortInit(void)
{
    outled(led_k_autobaud);


    /* paranoia - have we setup primary impure yet? */
    if (primary_impure == NULL)
	return STATUS_FAILURE;

#if 0		/* now I believe in giving init a second chance... */
    /* has failed previously */
    if (primary_impure->AUTOBAUD == SROM_NO_AUTOBAUD)
	return STATUS_FAILURE;
#endif

    /* if we're a secondary CPU, we can borrow the autobaud from the primary -
     * assuming the clock speed is the same, which is pretty certain
     */

    if (!smp_primary()) {
	/* we copy the autobaud to our own impure region, but don't actaully
	 * refer to our private copy; this is for the benefit of others 
	 * for example SROM debug messages from PALcode
	 */
	impure[smp_phys_id()]->AUTOBAUD = primary_impure->AUTOBAUD;
	return STATUS_SUCCESS;
    }

    if (primary_impure->AUTOBAUD == 0 || 
	primary_impure->AUTOBAUD == SROM_NO_AUTOBAUD )
    {
	primary_impure->AUTOBAUD = cServe(0, 0, CSERVE_K_SROM_INIT);
    }

    outled(led_k_autobaud_done);

    if (primary_impure->AUTOBAUD == 0 ||
	primary_impure->AUTOBAUD == SROM_NO_AUTOBAUD )
    {
	return STATUS_FAILURE;
    }

    return STATUS_SUCCESS;
}
