/*	GKS Segment Structure
 *
 *	Copyright (C) 1983 by Chromatics, Inc.
 *
 *	wrf, 7 Oct 83
 */


/*	the pseudo storage classes
 */
#define INTERN	static
#define LOCAL	static

/*	the pseudo types
 */
typedef long LONG;
typedef unsigned char UTINY;
typedef unsigned long ULONG;

/*	hardware dependent types
 */
typedef long S32B;				/* signed 32 bit things */
typedef unsigned long U32B ;	/* unsigned 32 bit things */
typedef short S16B;				/* signed 16 bit things */
typedef unsigned short U16B;	/* signed 16 bit things */
typedef char S8B;
typedef unsigned char U8B;


/*	macros
 */
#define abs(x)		((x) < 0 ? -(x) : (x))
#define max(x, y)	(((x) > (y)) ? (x) : (y))
#define min(x, y)	(((x) < (y)) ? (x) : (y))
#define NEL(a)		(sizeof(a) / sizeof((a)[0]))

#define isvis(seg) ((seg)->sh.seg_attr & VISIBLE)
#define ishigh(seg) ((seg)->sh.seg_attr & HIGHLIGHT)
#define isdet(seg) ((seg)->sh.seg_attr & DETECTABLE)
#define isident(seg) ((seg)->sh.seg_attr & IDENTITY)
#define isfree( seg ) ((seg)->sh.seg_attr & FREE)
#define nextblock( seg ) ((char *)(seg) + (seg)->sh.size)

#define MAXSEGID 0x80000000			/* max seg id, all user segment		*/

#define bad_id(id) ((id) == 0 || (id) >= MAXSEGID)
#define coerce(x)  (((int)(x) + 1) & ~1)
#define dnbound(x) ((int)(x) & ~3)

#define NLSIZE 100		/* size of segment hash list */

#define BLKTYPE	1			/* mask for segment/free info */
#define SEG		0


/*	segment information
 */

typedef U32B	NAME;				/* segment names					*/
									/* names < MAXSEGID					*/
typedef REAL	PRIORITY;			/* segment priority					*/
typedef U32B	SIZE;				/* segment size						*/
typedef REAL	BBOX[4];			/* segment bounding box				*/
typedef struct
{
	NDC xll ;
	NDC xur ;
	NDC yll ;
	NDC yur ;
} RECT ;

typedef S32B	ATTR;				/* segment attributes				*/
#define VISIBLE		0x80000000
#define DETECTABLE	0x40000000
#define HIGHLIGHT	0x20000000
#define IDENTITY	0x10000000
#define FREE		0x00000001

#define EOSOP 99
#define SEGHEADR struct seginfo
#define SEGMENT struct segment

#define SEGHDRSIZ (sizeof(SEGHEADR))
#define SEGSIZE 20000

struct wslist
{
	WKID wsl_wkid ;
	WSCATEG wsl_wcat ;
	struct wslist *wsl_next ;
} ;

struct msglink
{
	MSGHDR *primitive ;
	struct msglink *next ;
} ;

typedef SEGHEADR
	{
	SEGMENT *prevnm;		/* ^previous segment in name list */
	SEGMENT *nextnm;		/* ^next segment in name list */
	SEGMENT *nextfree;		/* ^next element in free list */
	SIZE size;				/* # bytes allocated for segment */
	SIZE free;				/* # bytes remaining in segment */
	PRIORITY seg_pri;		/* segment priority */
	SEGMENT *prevpri;		/* ^previous segment in priority list */
	SEGMENT *nextpri;		/* ^next segment in priority list */
	ATTR seg_attr;			/* segment attributes */
	NAME seg_name;			/* segment name */
	TWODTRANS seg_mat;		/* transformation matrix */
	struct wslist *seg_wslist ;	/* list of workstations associated w/ seg */
	BOOL in_wiss ;			/* in Workstation Independent Seg Storage */
	struct msglink *firstprim ;	/* ^first message in WISS */
	struct msglink *lastprim ;	/* ^last message in WISS */
	};


/*	segment proper
 */
typedef SEGMENT
	{
	SEGHEADR sh;
	U32B sv[1];				/* variable length segment data */
	};


/* @(#)seg.h	1.2\t3/4/85" */
