/*
 *	Set Fill Area Pattern Size
 */
#include <gks/gks_types.h>
#include <gks/gks_structs.h>

#include <gks/trace.h>

extern struct gksstate Gksstate;

GKSERR s_fa_psz( sx, sy )
	REAL sx, sy;
	{

#ifdef TRACE
	if(Gksdebug & DB_ATTR)
		Gksout("s_fa_psz(%8.3f, %8.3f)\n", sx, sy);
#endif

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(8, "s_fa_psz"));

	if((sx <= 0.0) || (sy <= 0.0))
		return(err_hand(81, "s_fa_psz"));

	Gksstate.gs_fapwv.wc_x = sx;
	Gksstate.gs_fapwv.wc_y = 0.0;
	Gksstate.gs_faphv.wc_x = 0.0;
	Gksstate.gs_faphv.wc_y = sy;

	return(0);
	}
