#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>


/*
 *	request valuator
 */
GKSERR rq_val( wkid, devno, status, value )
	WKID wkid;
	int  devno;
	BOOL *status;
	REAL *value;
	{
	int res;
	struct rpinpreq *reply;
	static char *fname = "rq_val";

	res = _rq_all(fname, wkid, devno, VALUATOR, &reply);
	if (res == 0)
		{
		/*
		 *	report value and status
		 */
		*value = reply->reqrec.inpt_val;
		*status = reply->reqstat;
		_freemsg(reply);

#ifdef TRACE
		if(Gksdebug & DB_INPUT)
			Gksout("%s returns %8.3f\n", fname, *value);
#endif
		}
	
	return (res);

	}
