#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsinp.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire stroke device state
 */
VOID
q_ws_stk(wkid, devno, valtype, errno, mode, echo, 
			normtr, npts, pts, prmpt, echoll, echour, data)
WKID wkid ;
int devno ;
BOOL valtype ;
GKSERR *errno ;
INPUTMODE *mode ;
BOOL *echo ;
int *normtr ;
int *npts ;
WCPT pts[] ;
int *prmpt ;
DCPT *echoll ;
DCPT *echour ;
struct i_stkdata *data ;
{
	WSINFO ws ;
	struct msqinp *msg ;
	struct rpqinp *reply ;
	int i ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if((WsGetcat(ws) != WSC_OUTIN) && (WsGetcat(ws) != WSC_INPUT))
	{
		*errno = 38 ;
		return ;
	}
	msg = (struct msqinp *)_allocmsg(sizeof(struct msqinp)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wsinpmsg(msg, WsGetpid(ws), STROKE, devno) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqinp *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 140 ;
			break ;
	}
	*mode = reply -> ws_inp.wsi_mode ;
	*echo = reply -> ws_inp.wsi_echo ;
	*prmpt = reply -> ws_inp.wsi_prmpt ;
	*normtr = _stknorm((*npts = reply -> ws_inp.wsi_un.inpt_stk.stk_npts),
					  reply -> ws_inp.wsi_un.inpt_stk.stk_pts) ;
	for(i=0; i<*npts; i++)
		_ndc2wc(*normtr, &(reply -> ws_inp.wsi_un.inpt_stk.stk_pts[i]),
				&(pts[i])) ;
	echoll -> dc_x = reply -> ws_inp.wsi_xmin ;
	echoll -> dc_y = reply -> ws_inp.wsi_ymin ;
	echour -> dc_x = reply -> ws_inp.wsi_xmax ;
	echour -> dc_y = reply -> ws_inp.wsi_ymax ;
	cpybuf(data, reply -> ws_inp.wsi_data, sizeof(struct i_stkdata)) ;
	_freemsg(reply) ;
}

static char *SccsId = "@(#)q_ws_stk.c	1.6\t3/12/85" ;
